"use strict";
(self["webpackChunkpixfort_core"] = self["webpackChunkpixfort_core"] || []).push([["dev_builder_components_fields_color_js-node_modules_react-color-palette_lib_css_styles_css"],{

/***/ "./dev/builder/components/fields/color.js":
/*!************************************************!*\
  !*** ./dev/builder/components/fields/color.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
    value: true
}));

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = __webpack_require__(/*! react */ "./node_modules/react/index.js");

var _react2 = _interopRequireDefault(_react);

var _reactColor = __webpack_require__(/*! react-color */ "./node_modules/react-color/es/index.js");

__webpack_require__(/*! react-color-palette/lib/css/styles.css */ "./node_modules/react-color-palette/lib/css/styles.css");

__webpack_require__(/*! ../../scss/fields/color.scss */ "./dev/builder/scss/fields/color.scss");

var _help = __webpack_require__(/*! ../common/help */ "./dev/builder/components/common/help.js");

var _help2 = _interopRequireDefault(_help);

var _pixfortIconColorPalette = __webpack_require__(/*! ../../assets/icons/duotone/pixfort-icon-color-palette-1.svg */ "./dev/builder/assets/icons/duotone/pixfort-icon-color-palette-1.svg");

var _pixfortIconColorPalette2 = _interopRequireDefault(_pixfortIconColorPalette);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ColorField = function (_React$Component) {
    _inherits(ColorField, _React$Component);

    function ColorField(props) {
        _classCallCheck(this, ColorField);

        var _this = _possibleConstructorReturn(this, (ColorField.__proto__ || Object.getPrototypeOf(ColorField)).call(this, props));

        _initialiseProps.call(_this);

        var label = _this.props.label || 'Color Input';
        // let value = this.props.value || '#333';
        var value = '#333';
        if (_this.props.value && _this.props.value !== '') {
            value = _this.props.value;
        } else {
            if (_this.props.default) {
                value = _this.props.default;
            }
        }
        _this.props.onChange({
            value: value,
            id: _this.props.id
        });
        var disableAlpha = _this.props.disableAlpha;
        var wrapperRef = _react2.default.createRef();

        _this.state = {
            label: label,
            value: value,
            display: false,
            disableAlpha: disableAlpha,
            wrapperRef: wrapperRef
        };
        // console.log({ disableAlpha });
        return _this;
    }

    _createClass(ColorField, [{
        key: 'componentDidUpdate',
        value: function componentDidUpdate(prevProps, prevState) {
            // Bind the event listener
            document.addEventListener('mousedown', this.handleClickOutside);
        }
    }, {
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                'div',
                { className: 'flex items-center justify-between mx-6 py-6 ' + (this.props.hideBorderBottom === true ? '' : 'border-b border-gray-100') + ' ' + (this.props.showBorderTop === true ? 'border-t border-gray-100' : '') + ' dark:border-gray-700 ' },
                _react2.default.createElement(
                    'div',
                    { className: 'text-sm' },
                    _react2.default.createElement(
                        'label',
                        { className: 'font-semibold text-gray-900 dark:text-white' },
                        this.props.label,
                        this.props.tooltipImage || this.props.tooltipText ? _react2.default.createElement(_help2.default, { tooltipText: this.props.tooltipText, tooltipImage: this.props.tooltipImage, type: 'default' }) : null
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'mt-1 mb-2 text-gray-500' },
                        this.props.description
                    )
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'relative' },
                    _react2.default.createElement(
                        'a',
                        { className: 'flex items-center cursor-pointer bg-white dark:bg-gray-700 shadow-sm border border-gray-200 dark:border-gray-700 rounded-md overflow-hidden', onClick: this.handleClick },
                        _react2.default.createElement('span', { className: 'w-12 h-8 inline-block border-r border-gray-200 dark:border-r-0', style: this.getButtonStyle(this.state.value) }),
                        _react2.default.createElement(
                            'span',
                            { className: 'p-1 inline-block pb-0' },
                            _react2.default.createElement(_pixfortIconColorPalette2.default, { width: '20px', height: '20px', className: 'shrink-0 inline-block text-gray-500' })
                        )
                    ),
                    this.state.display ? _react2.default.createElement(
                        'div',
                        { style: this.popover, className: 'pix-color-picker-div right-0 z-10' },
                        _react2.default.createElement(
                            'div',
                            { ref: this.state.wrapperRef, className: 'absolute right-0 top-2' },
                            _react2.default.createElement(
                                'div',
                                { className: 'z-10' },
                                _react2.default.createElement(_reactColor.ChromePicker, { color: this.state.value, onChangeComplete: this.handleChangeComplete, onChange: this.handleChange, disableAlpha: this.state.disableAlpha })
                            )
                        )
                    ) : null
                )
            );
        }
    }]);

    return ColorField;
}(_react2.default.Component);

ColorField.defaultProps = {
    label: 'Color Input',
    value: '#333',
    disableAlpha: true,
    onChange: function onChange() {}
};

var _initialiseProps = function _initialiseProps() {
    var _this2 = this;

    this.popover = {
        position: 'absolute'
    };
    this.cover = {
        position: 'fixed',
        top: '0px',
        right: '0px',
        bottom: '0px',
        left: '0px',
        zIndex: '3'
    };

    this.useOutsideAlerter = function (ref, handleClose) {
        (0, _react.useEffect)(function () {
            /**
             * Alert if clicked on outside of element
             */
            function handleClickOutside(event) {
                if (ref.current && !ref.current.contains(event.target)) {
                    alert('You clicked outside of me!');
                    handleClose();
                }
            }
            // Bind the event listener
            document.addEventListener('mousedown', handleClickOutside);
            return function () {
                // Unbind the event listener on clean up
                document.removeEventListener('mousedown', handleClickOutside);
            };
        }, [ref]);
    };

    this.getButtonStyle = function (color) {
        return {
            background: color
        };
    };

    this.handleClick = function (e) {
        e.preventDefault();
        _this2.setState({ display: !_this2.state.display });
    };

    this.handleClose = function () {
        _this2.setState({ display: false });
    };

    this.handleChangeComplete = function (color) {};

    this.getRgbaColor = function (c) {
        return 'rgba(' + c.r + ', ' + c.g + ', ' + c.b + ', ' + c.a + ')';
    };

    this.handleChange = function (data) {
        var value = data.hex;
        if (!_this2.state.disableAlpha) {
            value = _this2.getRgbaColor(data.rgb);
        }
        if (_this2.props.onChange) {
            _this2.props.onChange({
                value: value,
                id: _this2.props.id
            });
        }
        // setColor(data.hex);
        _this2.setState({ value: value });
    };

    this.handleInputChange = function (e) {
        var newValue = e.target.value;
        _this2.setState({
            value: newValue
        });
        _this2.props.onChange({
            value: newValue,
            id: _this2.props.id
        });
    };

    this.handleClickOutside = function (event) {
        if (_this2.state.wrapperRef.current && !_this2.state.wrapperRef.current.contains(event.target)) {
            _this2.handleClose();
        }
    };

    this.componentWillUnmount = function () {
        // Unbind the event listener on clean up
        document.removeEventListener('mousedown', _this2.handleClickOutside);
    };
};

exports["default"] = ColorField;

/***/ }),

/***/ "./dev/builder/scss/fields/color.scss":
/*!********************************************!*\
  !*** ./dev/builder/scss/fields/color.scss ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ })

}]);
//# sourceMappingURL=dev_builder_components_fields_color_js-node_modules_react-color-palette_lib_css_styles_css.bundle.js.map