"use strict";
(self["webpackChunkpixfort_core"] = self["webpackChunkpixfort_core"] || []).push([["dev_builder_components_fields_code_js"],{

/***/ "./dev/builder/components/fields/code.js":
/*!***********************************************!*\
  !*** ./dev/builder/components/fields/code.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
    value: true
}));

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = __webpack_require__(/*! react */ "./node_modules/react/index.js");

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");

var _data = __webpack_require__(/*! ../../helpers/data */ "./dev/builder/helpers/data.js");

var _help = __webpack_require__(/*! ../common/help */ "./dev/builder/components/common/help.js");

var _help2 = _interopRequireDefault(_help);

var _reactAce = __webpack_require__(/*! react-ace */ "./node_modules/react-ace/lib/index.js");

var _reactAce2 = _interopRequireDefault(_reactAce);

__webpack_require__(/*! ace-builds/webpack-resolver */ "./node_modules/ace-builds/webpack-resolver.js");

__webpack_require__(/*! ace-builds/src-noconflict/mode-css */ "./node_modules/ace-builds/src-noconflict/mode-css.js");

__webpack_require__(/*! ace-builds/src-noconflict/theme-tomorrow_night_eighties */ "./node_modules/ace-builds/src-noconflict/theme-tomorrow_night_eighties.js");

__webpack_require__(/*! ace-builds/src-noconflict/theme-chrome */ "./node_modules/ace-builds/src-noconflict/theme-chrome.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var CodeField = function (_React$Component) {
    _inherits(CodeField, _React$Component);

    function CodeField(props) {
        _classCallCheck(this, CodeField);

        var _this = _possibleConstructorReturn(this, (CodeField.__proto__ || Object.getPrototypeOf(CodeField)).call(this, props));

        _this.handleInputChange = function (newValue) {
            _this.props.updateData(_this.props.id, newValue);
            _this.setState({ value: newValue });
            _this.props.onChange({
                value: newValue,
                id: _this.props.id
            });
        };

        var theme = 'chrome';
        if (_this.props.currentTheme === 'dark') {
            theme = 'monokai';
        }
        _this.state = {
            value: _this.props.value,
            appTheme: 'chrome',
            theme: theme
        };
        return _this;
    }

    _createClass(CodeField, [{
        key: 'componentDidMount',
        value: function componentDidMount() {}
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate() {
            if (this.state.appTheme !== this.props.currentTheme) {
                if (this.props.currentTheme === 'dark') {
                    this.setState({ theme: 'tomorrow_night_eighties', appTheme: this.props.currentTheme });
                } else {
                    this.setState({ theme: 'chrome', appTheme: this.props.currentTheme });
                }
            }
        }
    }, {
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                'div',
                { className: 'mx-6 pt-6 pb-4 ' + (this.props.hideBorderBottom === true ? '' : 'border-b border-gray-100') + ' ' + (this.props.showBorderTop === true ? 'border-t border-gray-100' : '') + ' dark:border-gray-700 ' },
                _react2.default.createElement(
                    'div',
                    { className: 'pr-2 pb-2 text-sm' },
                    _react2.default.createElement(
                        'label',
                        { className: 'mb-0 flex items-center cursor-auto' },
                        _react2.default.createElement(
                            'span',
                            { className: 'font-semibold text-gray-900 dark:text-white' },
                            this.props.label
                        ),
                        this.props.tooltipImage || this.props.tooltipText ? _react2.default.createElement(_help2.default, { tooltipText: this.props.tooltipText, tooltipImage: this.props.tooltipImage, type: 'default' }) : null
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'mt-1 mb-2 text-gray-500' },
                        this.props.description
                    )
                ),
                _react2.default.createElement(_reactAce2.default, {
                    value: this.state.value,
                    mode: 'css',
                    className: 'w-full rounded-md overflow-hidden h-[200px] border border-gray-200 dark:border-gray-700',
                    theme: this.state.theme,
                    onChange: this.handleInputChange,
                    name: 'UNIQUE_ID_OF_DIV'
                })
            );
        }
    }]);

    return CodeField;
}(_react2.default.Component);

CodeField.defaultProps = {
    label: 'Custom code',
    value: ''
};


var mapStateToProps = function mapStateToProps(state) {
    return {
        currentTheme: state.status.currentTheme
    };
};

var mapDispatchToProps = function mapDispatchToProps(dispatch) {
    return {
        updateData: function updateData(id, data) {
            dispatch((0, _data.updateData)(id, data));
        }
    };
};

exports["default"] = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(CodeField);

/***/ })

}]);
//# sourceMappingURL=dev_builder_components_fields_code_js.bundle.js.map