<?php
/**
 * Variable product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/variable.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 6.1.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// can access $isBoxed since it is a template argument
$attribute_keys  = array_keys( $attributes );
$variations_json = wp_json_encode( $available_variations );
$variations_attr = function_exists( 'wc_esc_json' ) ? wc_esc_json( $variations_json ) : _wp_specialchars( $variations_json, ENT_QUOTES, 'UTF-8', true );

// nothing is displayed here
do_action( 'woocommerce_before_add_to_cart_form' );
?>

<form class="variations_form cart"
      action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>"
      method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->get_id() ); ?>"
      data-product_variations="<?php echo $variations_attr; // WPCS: XSS ok. ?>">
    <input type="hidden" id="isBoxed_form_input" name="isBoxed" value="false"/>

	<?php do_action( 'woocommerce_before_variations_form' ); ?>

	<?php if ( empty( $available_variations ) && false !== $available_variations ) : ?>
        <p class="stock out-of-stock"><?php echo esc_html( apply_filters( 'woocommerce_out_of_stock_message', __( 'This product is currently out of stock and unavailable.', 'woocommerce' ) ) ); ?></p>
	<?php else : ?>
        <table class="variations" cellspacing="0" role="presentation">
            <tbody>
			<?php foreach ( $attributes as $attribute_name => $options ) : ?>
                <tr>
                    <th class="label" style="display: flex; margin-top: 10px;"><label
                                for="<?php echo esc_attr( sanitize_title( $attribute_name ) ); ?>"
                                style="color: black; font-size: 17px"><?php echo wc_attribute_label( $attribute_name ); // WPCS: XSS ok. ?></label>
                    </th>
                    <td class="value">
						<?php
						wc_dropdown_variation_attribute_options(
							array(
								'options'   => $options,
								'attribute' => $attribute_name,
								'product'   => $product,
							)
						);
						//						echo end( $attribute_keys ) === $attribute_name ? wp_kses_post( apply_filters( 'woocommerce_reset_variations_link', '<a class="reset_variations" href="#">' . esc_html__( 'Clear', 'woocommerce' ) . '</a>' ) ) : '';
						?>
                    </td>
                </tr>
			<?php endforeach;
			do_action( 'woocommerce_before_add_to_cart_quantity' );
			?>
            <style>
                .quantity-selector {
                    width: 100% !important;
                    text-align: left !important;
                }
            </style>
            <tr>
                <th class="label" style="display: flex; margin-top: 10px;"><label
                            for="<?php echo esc_attr( sanitize_title( $attribute_name ) ); ?>"
                            style="color: black; font-size: 17px">Quantity</label>
                </th>
                <td class="value">
					<?php
					// quantity picker
					woocommerce_quantity_input(
						array(
							'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
							'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
							'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( wp_unslash( $_POST['quantity'] ) ) : $product->get_min_purchase_quantity(),
							// WPCS: CSRF ok, input var ok.
						)
					);
					?>
                </td>
            </tr>
            </tbody>
        </table>
		<?php

		?>

		<?php do_action( 'woocommerce_after_variations_table' ); ?>

        <style>
            @media (min-width: 1200px) {
                .yes-calender {
                    height: 480px;
                }

                .no-calender {
                    height: auto;
                }

                .panel-heading {
                    cursor: pointer;
                }
            }
        </style>

        <div class="panel-group py-3" id="accordion" role="tablist" aria-multiselectable="true">
            <div class="panel panel-default no-calender" id="one-time-panel">
                <div class="panel-heading" role="tab" id="headingOne" data-toggle="collapse" data-parent="#accordion"
                     href="#collapseOne"
                     aria-expanded="true" aria-controls="collapseOne">
                    <h4 class="panel-title">
                        One-time rental
                    </h4>
                </div>
                <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
                    <div class="panel-body onetime-active" style="padding-top: 0px;">

						<?php
						$_GET['isBoxed'] = false;
						do_action( 'woocommerce_single_variation' );
						?>

                    </div>
                </div>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="headingTwo" data-toggle="collapse" data-parent="#accordion"
                     href="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                    <h4 class="panel-title">
                        Memberships
                    </h4>
                </div>
                <div id="collapseTwo" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingTwo">
					<?php if ( has_woocommerce_subscription( '', '', 'active' ) ) { ?>

						<?php
						$user_id = get_current_user_id();
						$boxes   = get_user_meta( $user_id, 'boxes', true );
						check_metadata_matches_cart( $user_id, $boxes );

						$subscription_id    = get_user_meta( $user_id, 'subscription_id', true );
						$subscription       = wcs_get_subscription( $subscription_id );
						$subscription_items = $subscription->get_items();

						$items_remaining = 0;
						foreach ( $boxes as $i => $box ) {
							$items_remaining = $items_remaining + $box->items_remaining();
						}
						$start_date = date( 'Y-m-d' );
						$end_date   = date( "Y-m-d", strtotime( "+5 days", strtotime( $start_date ) ) );
						if ( $items_remaining <= 0 ) {
							if ( count( $boxes ) == 2 ) { ?>
                                <div class="panel-body">
                                    <p>Please ensure that you have sufficient storage capacity in your boxes or consider
                                        returning an box before renting another one</p>
                                </div>
							<?php } else { ?>
                                <div class="panel-body">
                                    <table class="table" style="margin-bottom: 0px;">
                                        <thead>
                                        <tr>
                                            <th style="padding: 0px;">Subscription
                                                Plan: <?php echo reset( $subscription_items )->get_name() ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>
                                                <div class="row">
													<?php if ( count( $boxes ) >= 1 ) { ?>
                                                        <div class="col-md-6">
                                                            <p>Box
                                                                1: <?php echo ( $boxes[0]->box_status != 'present' ) ? '[' . strtoupper( $boxes[0]->box_status ) . ']' : $boxes[0]->items_in_box() . '/' . $boxes[0]->box_limit ?></p>
                                                        </div>
													<?php }
													if ( count( $boxes ) >= 2 ) { ?>
                                                        <div class="col-md-6">
                                                            <p>Box
                                                                2: <?php echo ( $boxes[1]->box_status == 'present' ) ? '[' . strtoupper( $boxes[0]->box_status ) . ']' : $boxes[1]->items_in_box() . '/' . $boxes[1]->box_limit ?></p>
                                                        </div>
													<?php } ?>
                                                </div>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                    <p>Your current subscription rent limit is exceeded. Please upgrade your
                                        subscription to
                                        rent more.</p>
                                    <a class="btn dtn-dark btn-primary btn-block" href="/how-it-works/">UPGRADE
                                        SUBSCRIPTION</a>
                                </div>
							<?php }

						} else { ?>
                            <div class="panel-body subscription-active">
                                <table class="table" style="margin-bottom: 0px;">
                                    <thead>
                                    <tr>
                                        <th style="padding: 0px;">Subscription
                                            Plan: <?php echo reset( $subscription_items )->get_name() ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>
                                            <div class="row">
												<?php if ( count( $boxes ) >= 1 ) { ?>
                                                    <div class="col-md-6">
                                                        <p>Box
                                                            1: <?php echo ( $boxes[0]->box_status == 'shipped' ) ? '[' . strtoupper( $boxes[0]->box_status ) . ']' : $boxes[0]->items_in_box() . '/' . $boxes[0]->box_limit ?></p>
                                                    </div>
												<?php }
												if ( count( $boxes ) >= 2 ) { ?>
                                                    <div class="col-md-6">
                                                        <p>Box
                                                            2: <?php echo ( $boxes[1]->box_status == 'shipped' ) ? '[' . strtoupper( $boxes[0]->box_status ) . ']' : $boxes[1]->items_in_box() . '/' . $boxes[1]->box_limit ?></p>
                                                    </div>
												<?php } ?>
                                            </div>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>

								<?php
								$_GET['isBoxed'] = true;
								?>
                                <button id="rent-with-membership-single-product"
                                        class="btn dtn-dark btn-primary btn-block"
                                        style="font-size: 16px;">Rent With Membership
                                </button>
                            </div>
						<?php } ?>
					<?php } else { ?>
                        <div class="panel-body">
                            <ul class="clobrary-list">
                                <li>Keep items for One month</li>
                                <li>Rent up to 6 items from our closet</li>
                                <li>2 boxes per month (up to 6 items)</li>
                                <li>Free Shipping and Return</li>
                            </ul>
                            <a class="btn dtn-dark btn-primary btn-block"
                               href="/how-it-works/#subscription">SUBSCRIBE</a>
                        </div>
					<?php } ?>
                </div>
				<?php do_action( 'woocommerce_after_variations_form' ); ?>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="headingThree" data-toggle="collapse" data-parent="#accordion"
                     href="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                    <h4 class="panel-title">
                        Buy Now
                    </h4>
                </div>
                <div id="collapseThree" class="panel-collapse collapse" role="tabpanel"
                     aria-labelledby="headingThree">
                    <div class="panel-body">
                        <div class="woocommerce-variation single_variation" style="display: none;">
                            <div class="woocommerce-variation-description-retail">{{{
                                data.variation.variation_description }}}
                            </div>
                            <div class="woocommerce-variation-price-retail">{{{ data.variation.price_html }}}</div>
                            <div class="woocommerce-variation-availability-retail">{{{
                                data.variation.availability_html
                                }}}
                            </div>
                            <p><?php esc_html_e( 'Sorry, this product is unavailable. Please choose a different combination.', 'woocommerce' ); ?></p>
                        </div>
                        <button type="button" id="retail-purchase-single-product"
                                class="btn dtn-dark btn-primary btn-block" style="font-size: 16px;margin-top: 10px;"
                        ">
                        Add to cart
                        </button>
                    </div>
                </div>
            </div>
        </div>
	<?php endif; ?>
</form>
