<?php

$rental_products = $wpdb->get_results(
	"SELECT ID, post_title FROM {$wpdb->prefix}posts AS posts INNER JOIN {$wpdb->prefix}postmeta AS postmeta ON posts.ID = postmeta.post_id WHERE posts.post_type = 'product' AND posts.post_status = 'publish' AND postmeta.meta_key = '_wcrp_rental_products_rental' AND postmeta.meta_value IN( 'yes', 'yes_purchase' )"
);

if ( !empty( $rental_products ) ) {

	$inventory_date = ( isset( $_GET['inventory_date'] ) ? sanitize_text_field( $_GET['inventory_date'] ) : gmdate( 'Y-m-d' ) );

	if ( strtotime( $inventory_date ) < time() ) { // Stops past dates being manually typed, datepicker restricted from selecting this but technically someone can manually amend the date and historic inventory wouldn't be possible anyway due to rental stock being a live value)
	
		$inventory_date = gmdate( 'Y-m-d' );

	}

	?>

	<div id="wcrp-rental-products-rentals-inventory-actions" class="wcrp-rental-products-rentals-actions">
		<div>
			<form id="wcrp-rental-products-rentals-inventory-date" method="get">
				<label>
					<?php esc_html_e( 'Date', 'wcrp-rental-products' ); ?>
					<input type="hidden" name="page" value="wcrp-rental-products-rentals">
					<input type="hidden" name="tab" value="inventory">
					<input type="text" name="inventory_date" class="wcrp-rental-products-single-date-picker" value="<?php echo esc_html( $inventory_date ); ?>" data-from="today">
				</label>
				<input type="submit" class="button button-primary" value="<?php esc_html_e( 'Set date', 'wcrp-rental-products' ); ?>">
			</form>
		</div>
		<div>
			<a href="javascript:location.reload();" class="button"><?php esc_html_e( 'Refresh inventory', 'wcrp-rental-products' ); ?></a>
		</div>
	</div>

	<table id="wcrp-rental-products-rentals-inventory" class="wcrp-rental-products-datatable widefat striped">
		<thead>
			<tr>
				<th><?php esc_html_e( 'Product', 'wcrp-rental-products' ); ?></th>
				<th><?php esc_html_e( 'ID', 'wcrp-rental-products' ); ?></th>
				<th><?php esc_html_e( 'Parent ID', 'wcrp-rental-products' ); ?></th>
				<th><?php esc_html_e( 'SKU', 'wcrp-rental-products' ); ?></th>
				<th><?php esc_html_e( 'Rental stock total', 'wcrp-rental-products' ); ?></th>
				<th><?php esc_html_e( 'Rental stock in', 'wcrp-rental-products' ); ?></th>
				<th><?php esc_html_e( 'Rental stock out', 'wcrp-rental-products' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach ( $rental_products as $rental_product ) {

				$rental_product_variations = $wpdb->get_results(
					$wpdb->prepare(
						"SELECT `ID`, `post_title` FROM `{$wpdb->prefix}posts` WHERE `post_parent` = %d AND `post_type` = 'product_variation'",
						$rental_product->ID
					)
				); // This has been checked for the scenario where a product might have been a variable and then changed to a simple product, the variations are deleted so this query wouldn't return any old variations as they would have been deleted

				$inventory_row_data = array();

				if ( empty( $rental_product_variations ) ) {

					$inventory_row_data[] = $this->inventory_row_data( $rental_product->ID, $inventory_date );

				} else {

					foreach ( $rental_product_variations as $rental_product_variation ) {

						$inventory_row_data[] = $this->inventory_row_data( $rental_product_variation->ID, $inventory_date );

					}

				}

				if ( !empty( $inventory_row_data ) ) {

					foreach ( $inventory_row_data as $inventory_row ) {

						?>

						<tr>
							<td><?php echo wp_kses_post( $inventory_row['product'] ); ?></td>
							<td><?php echo esc_html( $inventory_row['id'] ); ?></td>
							<td><?php echo esc_html( $inventory_row['parent_id'] ); ?></td>
							<td><?php echo wp_kses_post( $inventory_row['sku'] ); ?></td>
							<td><?php echo esc_html( $inventory_row['rental_stock_total'] ); ?></td>
							<td><?php echo esc_html( $inventory_row['rental_stock_in'] ); ?></td>
							<td><?php echo esc_html( $inventory_row['rental_stock_out'] ); ?></td>
						</tr>

						<?php

					}

				}

			}
			?>
		</tbody>
	</table>

	<?php

} else {

	?>

	<div class="notice notice-info inline">
		<p><?php esc_html_e( 'No rental products yet. Create or edit a product and set to a rental to see it here.', 'wcrp-rental-products' ); ?></p>
	</div>

	<?php

}
