<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'WCRP_Rental_Products_Upgrade' ) ) {

	class WCRP_Rental_Products_Upgrade {

		public function __construct() {

			add_action( 'wp_loaded', array( $this, 'upgrade' ) );

		}

		public static function upgrade() {

			$version = get_option( 'wcrp_rental_products_version' );

			if ( WCRP_RENTAL_PRODUCTS_VERSION !== $version ) {

				global $wpdb;

				if ( version_compare( $version, '1.0.0', '<' ) ) {

					// 1.0.0 - Populate options

					if ( get_option( 'wcrp_rental_products_date_format' ) === false ) {

						update_option( 'wcrp_rental_products_date_format', 'mm/dd/yy' );

					}

					if ( get_option( 'wcrp_rental_products_start_days_threshold' ) === false ) {

						update_option( 'wcrp_rental_products_start_days_threshold', '3' );

					}

					if ( get_option( 'wcrp_rental_products_return_days_threshold' ) === false ) {

						update_option( 'wcrp_rental_products_return_days_threshold', '3' );

					}

				}

				if ( version_compare( $version, '2.0.1', '<' ) ) {

					// 2.0.1 - Create rentals table

					$wpdb->query("
						CREATE TABLE IF NOT EXISTS {$wpdb->prefix}wcrp_rental_products_rentals (
						rental_id bigint(20) AUTO_INCREMENT,
						reserved_date date NOT NULL default '0000-00-00',
						order_id bigint(20) NOT NULL,
						order_item_id bigint(20) NOT NULL,
						product_id bigint(20) NOT NULL,
						quantity bigint(20) NOT NULL,
						PRIMARY KEY (rental_id)
					)");

					// 2.0.1 - Delete rental status metas as functionality removed

					$wpdb->query( "DELETE FROM {$wpdb->prefix}postmeta WHERE `meta_key` = '_wcrp_rental_products_rental_status';" );

					// 2.0.1 - Delete rental status metas as functionality removed

					$wpdb->query( "DELETE FROM {$wpdb->prefix}postmeta WHERE `meta_key` = '_wcrp_rental_products_start_days_threshold';" );
					$wpdb->query( "DELETE FROM {$wpdb->prefix}postmeta WHERE `meta_key` = '_wcrp_rental_products_return_days_threshold';" );

				}

				if ( version_compare( $version, '2.0.2', '<' ) ) {

					// 2.0.2 - Delete date format option as changed to saving in same format

					delete_option( 'wcrp_rental_products_date_format' );

					// 2.0.2 - Populate new options

					if ( get_option( 'wcrp_rental_products_minimum_days' ) === false ) {

						update_option( 'wcrp_rental_products_minimum_days', '0' );

					}

					if ( get_option( 'wcrp_rental_products_maximum_days' ) === false ) {

						update_option( 'wcrp_rental_products_maximum_days', '0' );

					}

					if ( get_option( 'wcrp_rental_products_months' ) === false ) {

						update_option( 'wcrp_rental_products_months', '1' );

					}

					if ( get_option( 'wcrp_rental_products_columns' ) === false ) {

						update_option( 'wcrp_rental_products_columns', '1' );

					}

					if ( get_option( 'wcrp_rental_products_inline' ) === false ) {

						update_option( 'wcrp_rental_products_inline', 'no' );

					}

					// 2.0.2 - Clear WooCommerce sessions/carts incase any carts with old date format

					self::woocommerce_sessions_carts_clear();

					// 2.0.2 - Change any old date formats in order item meta to Y-m-d

					$order_item_rent_dates = $wpdb->get_results(
						"SELECT * FROM `{$wpdb->prefix}woocommerce_order_itemmeta` WHERE `meta_key` IN( 'wcrp_rental_products_rent_from', 'wcrp_rental_products_rent_to' );"
					);

					if ( !empty( $order_item_rent_dates ) ) {

						foreach ( $order_item_rent_dates as $order_item_rent_date ) {

							if ( !empty( $order_item_rent_date->meta_value ) ) {

								$new_value = gmdate( 'Y-m-d', strtotime( $order_item_rent_date->meta_value ) );

								if ( !empty( $new_value ) ) {

									$wpdb->query(
										$wpdb->prepare(
											"UPDATE `{$wpdb->prefix}woocommerce_order_itemmeta` SET `meta_value` = %s WHERE `order_item_id` = %d AND `meta_key` = %s;",
											$new_value,
											$order_item_rent_date->order_item_id,
											$order_item_rent_date->meta_key
										)
									);

								}

							}

						}

					}

					// 2.0.2 - Clean up any old return days threshold order item meta to be number only (e.g. was 3 days in earlier versions)

					$order_item_return_day_thresholds = $wpdb->get_results(
						"SELECT * FROM `{$wpdb->prefix}woocommerce_order_itemmeta` WHERE `meta_key` = 'wcrp_rental_products_return_days_threshold' AND `meta_value` LIKE '% %';" // Like space as any values not numbers will be space then days or the days translation
					);

					if ( !empty( $order_item_return_day_thresholds ) ) {

						foreach ( $order_item_return_day_thresholds as $order_item_return_day_threshold ) {

							$new_value = explode( ' ', $order_item_return_day_threshold->meta_value )[0];

							if ( !empty( $new_value ) ) {

								$wpdb->query(
									$wpdb->prepare(
										"UPDATE `{$wpdb->prefix}woocommerce_order_itemmeta` SET `meta_value` = %s WHERE `order_item_id` = %d AND `meta_key` = %s;",
										$new_value,
										$order_item_return_day_threshold->order_item_id,
										$order_item_return_day_threshold->meta_key
									)
								);

							}

						}

					}

				}

				if ( version_compare( $version, '2.1.0', '<' ) ) {

					// 2.1.0 - Rental products now are always manage stock disabled, stock status in stock and backorders no

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_rental' AND meta_value IN( 'yes', 'yes_purchase' );" );

					if ( !empty( $rental_products ) ) {

						foreach ( $rental_products as $rental_product ) {

							update_post_meta( $rental_product->post_id, '_manage_stock', 'no' );
							update_post_meta( $rental_product->post_id, '_stock_status', 'instock' );
							update_post_meta( $rental_product->post_id, '_backorders', 'no' );

						}

					}

				}

				if ( version_compare( $version, '2.1.1', '<' ) ) {

					// 2.1.1 - Non day price display option

					if ( get_option( 'wcrp_rental_products_non_day_price_display' ) === false ) {

						update_option( 'wcrp_rental_products_non_day_price_display', 'no' );

					}

				}

				if ( version_compare( $version, '2.2.0', '<' ) ) {

					// 2.2.0 - Disable rental dates option

					if ( get_option( 'wcrp_rental_products_disable_rental_dates' ) === false ) {

						update_option( 'wcrp_rental_products_disable_rental_dates', '' );

					}

					// 2.2.0 - Rental information option

					if ( get_option( 'wcrp_rental_products_rental_information' ) === false ) {

						update_option( 'wcrp_rental_products_rental_information', '' );

					}

				}

				if ( version_compare( $version, '2.3.0', '<' ) ) {

					// 2.3.0 - Populate empty product fields with equivalent option from settings then delete settings, if options are empty for any reason they will end up with empty meta and therefore end up using the defaults

					if ( get_option( 'wcrp_rental_products_minimum_days' ) == '0' ) { // Min days used to have a tooltip stating to set 0 for unlimited minimum days which isn't really possible as you must have atleast 1 rental day, this now has a min of 1 so if 0 change to 1

						$wpdb->query( "UPDATE `{$wpdb->prefix}postmeta` SET `meta_value` = '1' WHERE `meta_key` = '_wcrp_rental_products_minimum_days' AND `meta_value` = '';" );

					} else {

						$wpdb->query(
							$wpdb->prepare(
								"UPDATE `{$wpdb->prefix}postmeta` SET `meta_value` = %s WHERE `meta_key` = '_wcrp_rental_products_minimum_days' AND `meta_value` = '';",
								get_option( 'wcrp_rental_products_minimum_days' )
							)
						);

					}

					$wpdb->query(
						$wpdb->prepare(
							"UPDATE `{$wpdb->prefix}postmeta` SET `meta_value` = %s WHERE `meta_key` = '_wcrp_rental_products_maximum_days' AND `meta_value` = '';",
							get_option( 'wcrp_rental_products_maximum_days' )
						)
					);

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_rental';" );

					if ( !empty( $rental_products ) ) {

						// Set pricing period from the min/max days above

						foreach ( $rental_products as $rental_product ) {

							$minimum_days = get_post_meta( $rental_product->post_id, '_wcrp_rental_products_minimum_days', true );
							$maximum_days = get_post_meta( $rental_product->post_id, '_wcrp_rental_products_maximum_days', true );

							if ( $minimum_days == $maximum_days ) { // If min/max are the same set pricing field accordingly

								update_post_meta( $rental_product->post_id, '_wcrp_rental_products_pricing_period', $minimum_days );

							} else {

								update_post_meta( $rental_product->post_id, '_wcrp_rental_products_pricing_period', '1' );

							}

						}

					}

					$wpdb->query(
						$wpdb->prepare(
							"UPDATE `{$wpdb->prefix}postmeta` SET `meta_value` = %s WHERE `meta_key` = '_wcrp_rental_products_start_days_threshold' AND `meta_value` = '';",
							get_option( 'wcrp_rental_products_start_days_threshold' )
						)
					);

					$wpdb->query(
						$wpdb->prepare(
							"UPDATE `{$wpdb->prefix}postmeta` SET `meta_value` = %s WHERE `meta_key` = '_wcrp_rental_products_return_days_threshold' AND `meta_value` = '';",
							get_option( 'wcrp_rental_products_return_days_threshold' )
						)
					);

					$wpdb->query(
						$wpdb->prepare(
							"UPDATE `{$wpdb->prefix}postmeta` SET `meta_value` = %s WHERE `meta_key` = '_wcrp_rental_products_months' AND `meta_value` = '';",
							get_option( 'wcrp_rental_products_months' )
						)
					);

					$wpdb->query(
						$wpdb->prepare(
							"UPDATE `{$wpdb->prefix}postmeta` SET `meta_value` = %s WHERE `meta_key` = '_wcrp_rental_products_columns' AND `meta_value` = '';",
							get_option( 'wcrp_rental_products_columns' )
						)
					);

					$wpdb->query(
						$wpdb->prepare(
							"UPDATE `{$wpdb->prefix}postmeta` SET `meta_value` = %s WHERE `meta_key` = '_wcrp_rental_products_inline' AND `meta_value` = '';",
							get_option( 'wcrp_rental_products_inline' )
						)
					);

					// 2.3.0 - Convert pricing from per day where non day price display was enabled on the product itself

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_non_day_price_display' AND `meta_value` = 'yes';" );

					if ( !empty( $rental_products ) ) {

						foreach ( $rental_products as $rental_product ) {

							$product = wc_get_product( $rental_product->post_id );
							$minimum_days = get_post_meta( $rental_product->post_id, '_wcrp_rental_products_minimum_days', true );
							$maximum_days = get_post_meta( $rental_product->post_id, '_wcrp_rental_products_maximum_days', true );

							if ( $minimum_days == $maximum_days ) { // If min/max are the same set price fields accordingly

								$rental_type = get_post_meta( $rental_product->post_id, '_wcrp_rental_products_rental', true );

								if ( 'yes' == $rental_type ) { // Rental only

									$regular_price = $product->get_regular_price();
									$sale_price = $product->get_sale_price();

									if ( !empty( $regular_price ) ) {

										$new_regular_price = (float) $regular_price * (int) $minimum_days; // Non day price display is yes and min/max days are the same so multiply the price to give a non per day price
										$product->set_regular_price( $new_regular_price );

									}

									if ( !empty( $sale_price ) ) {

										$new_sale_price = (float) $sale_price * (int) $minimum_days; // Non day price display is yes and min/max days are the same so multiply the price to give a non per day price
										$product->set_sale_price( $new_sale_price );

									}

									if ( $product->is_on_sale() ) {

										if ( !empty( $new_sale_price ) ) {

											$product->set_price( $new_sale_price );

										}

									} else {

										if ( !empty( $new_regular_price ) ) {

											$product->set_price( $new_regular_price );

										}

									}

									$product->save();

								} elseif ( 'yes_purchase' ) { // If rental purchase

									$price = get_post_meta( $rental_product->post_id, '_wcrp_rental_products_rental_purchase_price', true );

									if ( !empty( $price ) ) {

										$new_price = (float) $price * (int) $minimum_days; // Non day price display is yes and min/max days are the same so multiply the price to give a non per day price
										update_post_meta( $rental_product->post_id, '_wcrp_rental_products_rental_purchase_price', $new_price );

									}

								}

							}

						}

					}

					// 2.3.0 - Convert pricing from per day where non day price display was enabled as the default in settings and the product had non-day price display set to default

					if ( 'yes' == get_option( 'wcrp_rental_products_non_day_price_display' ) ) {

						$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_non_day_price_display' AND `meta_value` = '';" ); // Meta value empty would mean it's using the default of non day price display enabled

						if ( !empty( $rental_products ) ) {

							foreach ( $rental_products as $rental_product ) {

								$product = wc_get_product( $rental_product->post_id );
								$minimum_days = get_post_meta( $rental_product->post_id, '_wcrp_rental_products_minimum_days', true );
								$maximum_days = get_post_meta( $rental_product->post_id, '_wcrp_rental_products_maximum_days', true );

								if ( $minimum_days == $maximum_days ) { // If min/max are the same set pricing field accordingly

									$rental_type = get_post_meta( $rental_product->post_id, '_wcrp_rental_products_rental', true );

									if ( 'yes' == $rental_type ) { // Rental only

										$regular_price = $product->get_regular_price();
										$sale_price = $product->get_sale_price();

										if ( !empty( $regular_price ) ) {

											$new_regular_price = (float) $regular_price * (int) $minimum_days; // Non day price display is yes and min/max days are the same so multiply the price to give a non per day price
											$product->set_regular_price( $new_regular_price );

										}

										if ( !empty( $sale_price ) ) {

											$new_sale_price = (float) $sale_price * (int) $minimum_days; // Non day price display is yes and min/max days are the same so multiply the price to give a non per day price
											$product->set_sale_price( $new_sale_price );

										}

										if ( $product->is_on_sale() ) {

											if ( !empty( $new_sale_price ) ) {

												$product->set_price( $new_sale_price );

											}

										} else {

											if ( !empty( $new_regular_price ) ) {

												$product->set_price( $new_regular_price );

											}

										}

										$product->save();

									} elseif ( 'yes_purchase' ) { // If rental purchase

										$price = get_post_meta( $rental_product->post_id, '_wcrp_rental_products_rental_purchase_price', true );

										if ( !empty( $price ) ) {

											$new_price = (float) $price * (int) $minimum_days; // Non day price display is yes and min/max days are the same so multiply the price to give a non per day price
											update_post_meta( $rental_product->post_id, '_wcrp_rental_products_rental_purchase_price', $new_price );

										}

									}

								}

							}

						}

					}					

					// 2.3.0 - Delete non day price display metas as functionality removed now prices altered above

					$wpdb->query( "DELETE FROM {$wpdb->prefix}postmeta WHERE `meta_key` = '_wcrp_rental_products_non_day_price_display';" );

					// 2.3.0 - Delete options no longer required

					delete_option( 'wcrp_rental_products_minimum_days' );
					delete_option( 'wcrp_rental_products_maximum_days' );
					delete_option( 'wcrp_rental_products_start_days_threshold' );
					delete_option( 'wcrp_rental_products_return_days_threshold' );
					delete_option( 'wcrp_rental_products_months' );
					delete_option( 'wcrp_rental_products_columns' );
					delete_option( 'wcrp_rental_products_inline' );
					delete_option( 'wcrp_rental_products_non_day_price_display' );

					// 2.3.0 - Add rental date format option

					if ( get_option( 'wcrp_rental_products_rental_date_format' ) === false ) {

						add_option( 'wcrp_rental_products_rental_date_format', '' );

					}

					// 2.3.0 - Clear WooCommerce sessions/carts as cart items now have more meta, old sessions would not have this data

					self::woocommerce_sessions_carts_clear();

				}

				if ( version_compare( $version, '2.3.1', '<' ) ) {

					// 2.3.1 - Populate pricing type option on all rental products with period as all rental products were period based previously, new fixed option only exists from now

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_rental' AND meta_value != '';" );

					if ( !empty( $rental_products ) ) {

						foreach ( $rental_products as $rental_product ) {

							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_pricing_type', 'period' );

						}

					}

				}

				if ( version_compare( $version, '2.4.0', '<' ) ) {

					// 2.4.0 - Populate pricing tiers and pricing tiers data options on all rental products

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_rental' AND meta_value != '';" );

					if ( !empty( $rental_products ) ) {

						$pricing_tiers_data = array(
							'days' => array(
								'0' => '1'
							),
							'percent' => array(
								'0' => '0'
							),
						);

						foreach ( $rental_products as $rental_product ) {

							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_pricing_tiers', 'no' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_pricing_tiers_data', $pricing_tiers_data );

						}

					}

					// 2.4.0 - Clear WooCommerce sessions/carts as cart items now have less meta, old sessions would have this data, there is also new cart item meta for setting the price and timestamp which wouldn't have been there previously on items in carts

					self::woocommerce_sessions_carts_clear();

				}

				if ( version_compare( $version, '2.6.0', '<' ) ) {

					// 2.6.0 - Populate disable rental days option on all rental products

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_rental' AND meta_value != '';" );

					if ( !empty( $rental_products ) ) {

						foreach ( $rental_products as $rental_product ) {

							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_disable_rental_days', '' );

						}

					}

				}

				if ( version_compare( $version, '2.7.0', '<' ) ) {

					// 2.7.0 - Add rental form date format option

					if ( get_option( 'wcrp_rental_products_rental_form_date_format' ) === false ) {

						add_option( 'wcrp_rental_products_rental_form_date_format', '' );

					}

					// 2.7.0 - Add rental form after quantity option

					if ( get_option( 'wcrp_rental_products_rental_form_after_quantity' ) === false ) {

						add_option( 'wcrp_rental_products_rental_form_after_quantity', 'yes' );

					}

				}

				if ( version_compare( $version, '3.0.0', '<' ) ) {

					// 3.0.0 - Rental or purchase toggle position option

					if ( get_option( 'wcrp_rental_products_rental_purchase_toggle_position' ) === false ) {

						add_option( 'wcrp_rental_products_rental_or_purchase_toggle_position', 'low' ); // Found the option name here is incorrect, see 3.0.3 conditions below for where this is rectified

					}

					// 3.0.0 - Rental or purchase toggle type option

					if ( get_option( 'wcrp_rental_products_rental_purchase_toggle_type' ) === false ) {

						add_option( 'wcrp_rental_products_rental_purchase_toggle_type', 'link' );

					}

					// 3.0.0 - Rental price display prefix option

					if ( get_option( 'wcrp_rental_products_rental_price_display_prefix' ) === false ) {

						add_option( 'wcrp_rental_products_rental_price_display_prefix', '' );

					}

					// 3.0.0 - Rental price display suffix option

					if ( get_option( 'wcrp_rental_products_rental_price_display_suffix' ) === false ) {

						add_option( 'wcrp_rental_products_rental_price_display_suffix', '' );

					}

					// 3.0.0 - Rental price display rent text option

					if ( get_option( 'wcrp_rental_products_rental_price_display_rent_text' ) === false ) {

						add_option( 'wcrp_rental_products_rental_price_display_rent_text', 'yes' );

					}

					// 3.0.0 - Rental information title option

					if ( get_option( 'wcrp_rental_products_rental_information_title' ) === false ) {

						add_option( 'wcrp_rental_products_rental_information_title', __( 'Rental information', 'wcrp-rental-products' ) );

					}

					// 3.0.0 - Rental information heading option

					if ( get_option( 'wcrp_rental_products_rental_information_heading' ) === false ) {

						add_option( 'wcrp_rental_products_rental_information_heading', 'yes' );

					}

					// 3.0.0 - Select dates text option

					if ( get_option( 'wcrp_rental_products_text_select_dates' ) === false ) {

						add_option( 'wcrp_rental_products_text_select_dates', __( 'Select dates', 'wcrp-rental-products' ) );

					}

					// 3.0.0 - Rental dates text option

					if ( get_option( 'wcrp_rental_products_text_rental_dates' ) === false ) {

						add_option( 'wcrp_rental_products_text_rental_dates', __( 'Rental dates', 'wcrp-rental-products' ) );

					}

					// 3.0.0 - Rent from dates text option

					if ( get_option( 'wcrp_rental_products_text_rent_from' ) === false ) {

						add_option( 'wcrp_rental_products_text_rent_from', __( 'Rent from', 'wcrp-rental-products' ) );

					}

					// 3.0.0 - Rent to dates text option

					if ( get_option( 'wcrp_rental_products_text_rent_to' ) === false ) {

						add_option( 'wcrp_rental_products_text_rent_to', __( 'Rent to', 'wcrp-rental-products' ) );

					}

					// 3.0.0 - Rent for dates text option

					if ( get_option( 'wcrp_rental_products_text_rent_for' ) === false ) {

						add_option( 'wcrp_rental_products_text_rent_for', __( 'Rent for', 'wcrp-rental-products' ) );

					}

					// 3.0.0 - Rental return within text option

					if ( get_option( 'wcrp_rental_products_text_rental_return_within' ) === false ) {

						add_option( 'wcrp_rental_products_text_rental_return_within', __( 'Rental return within', 'wcrp-rental-products' ) );

					}

					// 3.0.0 - Rental returned text option

					if ( get_option( 'wcrp_rental_products_text_rental_returned' ) === false ) {

						add_option( 'wcrp_rental_products_text_rental_returned', __( 'Rental returned', 'wcrp-rental-products' ) );

					}

					// 3.0.0 - Rental cancelled text option

					if ( get_option( 'wcrp_rental_products_text_rental_cancelled' ) === false ) {

						add_option( 'wcrp_rental_products_text_rental_cancelled', __( 'Rental cancelled', 'wcrp-rental-products' ) );

					}

					// 3.0.0 - Populate pricing period multiples option on all rental products

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_rental' AND meta_value != '';" );

					if ( !empty( $rental_products ) ) {

						foreach ( $rental_products as $rental_product ) {

							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_pricing_period_multiples', 'no' );

						}

					}

					// 3.0.0 - Clear WooCommerce sessions/carts incase any carts have purchase and rental of same product (has to be one or the other)

					self::woocommerce_sessions_carts_clear();

				}

				if ( version_compare( $version, '3.0.3', '<' ) ) {

					// 3.0.3 - Deleting incorrectly named option "wcrp_rental_products_rental_or_purchase_toggle_position" (note the "or"), was added during 3.0.0 upgrade but this is incorrect

					delete_option( 'wcrp_rental_products_rental_or_purchase_toggle_position' );

					// 3.0.3 - Adding correctly named option "wcrp_rental_products_rental_purchase_toggle_position", see above comment

					if ( get_option( 'wcrp_rental_products_rental_purchase_toggle_position' ) === false ) {

						add_option( 'wcrp_rental_products_rental_purchase_toggle_position', 'low' );

					}

				}

				if ( version_compare( $version, '3.0.5', '<' ) ) {

					// 3.0.5 - Add rental form first day option

					if ( get_option( 'wcrp_rental_products_rental_form_first_day' ) === false ) {

						add_option( 'wcrp_rental_products_rental_form_first_day', '1' );

					}

				}

				if ( version_compare( $version, '3.1.0', '<' ) ) {

					// 3.1.0 - Add new rental product options to each rental product

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_rental' AND meta_value != '';" );

					if ( !empty( $rental_products ) ) {

						foreach ( $rental_products as $rental_product ) {

							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_pricing_period_multiples_maximum', '0' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_price_display_override', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_total_overrides', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_disable_rental_start_end_days', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_security_deposit_amount', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_security_deposit_calculation', 'quantity' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_security_deposit_tax_status', 'taxable' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_security_deposit_tax_class', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_security_deposit_non_refundable', 'no' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_rental_purchase_rental_tax_override', 'no' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_rental_purchase_rental_tax_override_status', 'taxable' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_rental_purchase_rental_tax_override_class', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_rental_purchase_rental_shipping_override', 'no' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_rental_purchase_rental_shipping_override_class', '' );

						}

					}

					// 3.1.0 - Availability checker applied text setting

					if ( get_option( 'wcrp_rental_products_text_availability_checker_applied' ) === false ) {

						add_option( 'wcrp_rental_products_text_availability_checker_applied', __( 'Rental products will now show availability for your selected dates.', 'wcrp-rental-products' ) );

					}

					// 3.1.0 - Availability checker status rental only setting

					if ( get_option( 'wcrp_rental_products_availability_checker_status_rental' ) === false ) {

						add_option( 'wcrp_rental_products_availability_checker_status_rental', 'yes' );

					}

					// 3.1.0 - Availability checker status rental or purchase setting

					if ( get_option( 'wcrp_rental_products_availability_checker_status_rental_purchase' ) === false ) {

						add_option( 'wcrp_rental_products_availability_checker_status_rental_purchase', 'no' );

					}

					// 3.1.0 - Check availablity text setting

					if ( get_option( 'wcrp_rental_products_text_check_availability' ) === false ) {

						add_option( 'wcrp_rental_products_text_check_availability', __( 'Check availability', 'wcrp-rental-products' ) );

					}

					// 3.1.0 - Disable rental start/end days notice text setting

					if ( get_option( 'wcrp_rental_products_text_disable_rental_start_end_days_notice_text' ) === false ) {

						add_option( 'wcrp_rental_products_text_disable_rental_start_end_days_notice_text', __( 'Rentals cannot start/end on', 'wcrp-rental-products' ) );

					}

					// 3.1.0 - Non-refundable text setting

					if ( get_option( 'wcrp_rental_products_text_non_refundable' ) === false ) {

						add_option( 'wcrp_rental_products_text_non_refundable', __( 'Non-refundable', 'wcrp-rental-products' ) );

					}

					// 3.1.0 - Refundable text setting

					if ( get_option( 'wcrp_rental_products_text_refundable' ) === false ) {

						add_option( 'wcrp_rental_products_text_refundable', __( 'Refundable', 'wcrp-rental-products' ) );

					}

					// 3.1.0 - Rental available text setting

					if ( get_option( 'wcrp_rental_products_text_rental_available' ) === false ) {

						add_option( 'wcrp_rental_products_text_rental_available', __( 'Rental available', 'wcrp-rental-products' ) );

					}

					// 3.1.0 - Rental or purchase toggle loops/blocks display setting

					if ( get_option( 'wcrp_rental_products_rental_purchase_toggle_loops_blocks_display' ) === false ) {

						add_option( 'wcrp_rental_products_rental_purchase_toggle_loops_blocks_display', 'yes' );

					}

					// 3.1.0 - Rental price display override prefix/suffix setting

					if ( get_option( 'wcrp_rental_products_rental_price_display_override_prefix_suffix' ) === false ) {

						add_option( 'wcrp_rental_products_rental_price_display_override_prefix_suffix', 'yes' );

					}

					// 3.1.0 - Rental unavailable text setting

					if ( get_option( 'wcrp_rental_products_text_rental_unavailable' ) === false ) {

						add_option( 'wcrp_rental_products_text_rental_unavailable', __( 'Rental unavailable', 'wcrp-rental-products' ) );

					}

					// 3.1.0 - Reset dates text setting

					if ( get_option( 'wcrp_rental_products_text_reset_dates' ) === false ) {

						add_option( 'wcrp_rental_products_text_reset_dates', __( 'Reset dates', 'wcrp-rental-products' ) );

					}

					// 3.1.0 - Security deposit text setting

					if ( get_option( 'wcrp_rental_products_text_security_deposit' ) === false ) {

						add_option( 'wcrp_rental_products_text_security_deposit', __( 'Security deposit', 'wcrp-rental-products' ) );

					}

					// 3.1.0 - View purchase options text setting

					if ( get_option( 'wcrp_rental_products_text_view_purchase_options' ) === false ) {

						add_option( 'wcrp_rental_products_text_view_purchase_options', __( 'View purchase options', 'wcrp-rental-products' ) );

					}

					// 3.1.0 - View rental options text setting

					if ( get_option( 'wcrp_rental_products_text_view_rental_options' ) === false ) {

						add_option( 'wcrp_rental_products_text_view_rental_options', __( 'View rental options', 'wcrp-rental-products' ) );

					}

				}

				if ( version_compare( $version, '3.1.1', '<' ) ) {

					// 3.1.1 - Return days display setting

					if ( get_option( 'wcrp_rental_products_return_days_display' ) === false ) {

						add_option( 'wcrp_rental_products_return_days_display', 'yes' );

					}

				}

				if ( version_compare( $version, '3.2.0', '<' ) ) {

					// 3.2.0 - Add new rental product options to each rental product

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_rental' AND meta_value != '';" );

					if ( !empty( $rental_products ) ) {

						foreach ( $rental_products as $rental_product ) {

							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_price_additional_periods_percent', 'no' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_price_additional_period_percent', '' );

						}

					}			

				}

				if ( version_compare( $version, '3.3.0', '<' ) ) {

					// 3.3.0 - Clear WooCommerce sessions/carts in case any cart/checkout pricing is incorrect prior to cart/checkout tax calculation changes in this version

					self::woocommerce_sessions_carts_clear();

				}

				if ( version_compare( $version, '3.5.0', '<' ) ) {

					// 3.5.0 - Add new rental product options to each rental product

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_rental' AND meta_value != '';" );

					if ( !empty( $rental_products ) ) {

						foreach ( $rental_products as $rental_product ) {

							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_disable_addons_rental_purchase_rental', 'no' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_disable_addons_rental_purchase_purchase', 'no' );

						}

					}	

				}

				if ( version_compare( $version, '4.0.0', '<' ) ) {

					// 4.0.0 - Add new rental product options to each rental product

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_rental' AND meta_value != '';" );

					if ( !empty( $rental_products ) ) {

						foreach ( $rental_products as $rental_product ) {

							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_disable_rental_start_end_dates', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_pricing_period_additional_selections', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_start_day', '' );

						}

					}

					// 4.0.0 - Advanced configuration setting

					if ( get_option( 'wcrp_rental_products_advanced_configuration' ) === false ) {

						add_option( 'wcrp_rental_products_advanced_configuration', '' );

					}

					// 4.0.0 - Availability checker minimum days setting

					if ( get_option( 'wcrp_rental_products_availability_checker_minimum_days' ) === false ) {

						add_option( 'wcrp_rental_products_availability_checker_minimum_days', '0' );

					}

					// 4.0.0 - Availability checker maximum days setting

					if ( get_option( 'wcrp_rental_products_availability_checker_maximum_days' ) === false ) {

						add_option( 'wcrp_rental_products_availability_checker_maximum_days', '0' );

					}

					// 4.0.0 - Availability checker period multiples setting

					if ( get_option( 'wcrp_rental_products_availability_checker_period_multiples' ) === false ) {

						add_option( 'wcrp_rental_products_availability_checker_period_multiples', 'no' );

					}

					// 4.0.0 - Availability checker quantity setting

					if ( get_option( 'wcrp_rental_products_availability_checker_quantity' ) === false ) {

						add_option( 'wcrp_rental_products_availability_checker_quantity', 'yes' );

					}

					// 4.0.0 - Cancel rentals in failed orders automatically setting

					if ( get_option( 'wcrp_rental_products_cancel_rentals_in_failed_orders' ) === false ) {

						add_option( 'wcrp_rental_products_cancel_rentals_in_failed_orders', 'no' );

					}

					// 4.0.0 - Disable rental start/end dates setting

					if ( get_option( 'wcrp_rental_products_disable_rental_start_end_dates' ) === false ) {

						add_option( 'wcrp_rental_products_disable_rental_start_end_dates', '' );

					}

					// 4.0.0 - Disable rental start/end dates text setting

					if ( get_option( 'wcrp_rental_products_text_disable_rental_start_end_dates' ) === false ) {

						add_option( 'wcrp_rental_products_text_disable_rental_start_end_dates', '' );

					}

					// 4.0.0 - Disable rental start/end dates notice text setting

					if ( get_option( 'wcrp_rental_products_text_disable_rental_start_end_dates_notice_text' ) === false ) {

						add_option( 'wcrp_rental_products_text_disable_rental_start_end_dates_notice_text', __( 'Rentals cannot start/end on highlighted days.', 'wcrp-rental-products' ) );

					}

					// 4.0.0 - Rental form auto apply setting

					if ( get_option( 'wcrp_rental_products_rental_form_auto_apply' ) === false ) {

						add_option( 'wcrp_rental_products_rental_form_auto_apply', 'yes' );

					}

					// 4.0.0 - Rental form maximum date days setting

					if ( get_option( 'wcrp_rental_products_rental_form_maximum_date_days' ) === false ) {

						add_option( 'wcrp_rental_products_rental_form_maximum_date_days', '730' );

					}

					// 4.0.0 - Rental form maximum date specific setting

					if ( get_option( 'wcrp_rental_products_rental_form_maximum_date_specific' ) === false ) {

						add_option( 'wcrp_rental_products_rental_form_maximum_date_specific', '' );

					}

					// 4.0.0 - Rental form period selection option labels setting

					if ( get_option( 'wcrp_rental_products_rental_form_period_selection_option_labels' ) === false ) {

						add_option( 'wcrp_rental_products_rental_form_period_selection_option_labels', 'days' );

					}

					// 4.0.0 - Rental form reset button setting

					if ( get_option( 'wcrp_rental_products_rental_form_reset_button' ) === false ) {

						add_option( 'wcrp_rental_products_rental_form_reset_button', 'no' );

					}

					// 4.0.0 - Rental form start/end notices setting

					if ( get_option( 'wcrp_rental_products_rental_form_start_end_notices' ) === false ) {

						add_option( 'wcrp_rental_products_rental_form_start_end_notices', 'yes' );

					}

					// 4.0.0 - Rental period text setting

					if ( get_option( 'wcrp_rental_products_text_rental_period' ) === false ) {

						add_option( 'wcrp_rental_products_text_rental_period', __( 'Rental period', 'wcrp-rental-products' ) );

					}

					// 4.0.0 - Same rental dates required setting

					if ( get_option( 'wcrp_rental_products_same_rental_dates_required' ) === false ) {

						add_option( 'wcrp_rental_products_same_rental_dates_required', 'no' );

					}

					// 4.0.0 - Clear WooCommerce sessions/carts as cart item data now requires validation, start days threshold

					self::woocommerce_sessions_carts_clear();

				}

				if ( version_compare( $version, '4.1.0', '<' ) ) {

					// 4.1.0 - New upload directories

					$new_uploads_root_dir = WP_CONTENT_DIR . '/uploads/wcrp-rental-products/';

					if ( !file_exists( $new_uploads_root_dir ) ) {

						wp_mkdir_p( $new_uploads_root_dir );

					}

					$new_uploads_feeds_dir = WP_CONTENT_DIR . '/uploads/wcrp-rental-products/feeds/';

					if ( !file_exists( $new_uploads_feeds_dir ) ) {

						wp_mkdir_p( $new_uploads_feeds_dir );

					}

					// 4.1.0 - Return rentals in completed orders setting

					if ( get_option( 'wcrp_rental_products_return_rentals_in_completed_orders' ) === false ) {

						add_option( 'wcrp_rental_products_return_rentals_in_completed_orders', 'yes' );

					}

					// 4.1.0 - Managing rental orders information setting

					if ( get_option( 'wcrp_rental_products_managing_rental_orders_information' ) === false ) {

						add_option( 'wcrp_rental_products_managing_rental_orders_information', 'yes' );

					}

					// 4.1.0 - Calendar feed setting

					if ( get_option( 'wcrp_rental_products_calendar_feed' ) === false ) {

						add_option( 'wcrp_rental_products_calendar_feed', 'no' );

					}

					// 4.1.0 - Calendar feed id setting

					if ( get_option( 'wcrp_rental_products_calendar_feed_id' ) === false ) {

						add_option( 'wcrp_rental_products_calendar_feed_id', wp_rand( 1000000 ) );

					}

				}

				if ( version_compare( $version, '4.2.0', '<' ) ) {

					// 4.2.0 - Immediate rental stock replenishment setting

					if ( get_option( 'wcrp_rental_products_immediate_rental_stock_replenishment' ) === false ) {

						add_option( 'wcrp_rental_products_immediate_rental_stock_replenishment', 'no' );

					}

				}

				if ( version_compare( $version, '4.3.0', '<' ) ) {

					// 4.3.0 - Create rentals archive table
				
					$wpdb->query( "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}wcrp_rental_products_rentals_archive LIKE {$wpdb->prefix}wcrp_rental_products_rentals;" );

					// 4.3.0 - Add new rental product options to each rental product

					$rental_products = $wpdb->get_results( "SELECT post_id FROM `{$wpdb->prefix}postmeta` WHERE `meta_key` = '_wcrp_rental_products_rental' AND meta_value != '';" );

					if ( !empty( $rental_products ) ) {

						foreach ( $rental_products as $rental_product ) {

							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_in_person_pick_up_return', 'no' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_in_person_return_date', 'default' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_in_person_pick_up_times_fees_same_day', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_in_person_pick_up_times_fees_single_day_same_day', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_in_person_return_times_fees_same_day', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_in_person_return_times_fees_single_day_same_day', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_in_person_pick_up_times_fees_next_day', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_in_person_return_times_fees_next_day', '' );
							update_post_meta( $rental_product->post_id, '_wcrp_rental_products_multiply_addons_total_by_number_of_days_selected', 'no' );

						}

					}

					// 4.3.0 - Rental time format setting

					if ( get_option( 'wcrp_rental_products_rental_time_format' ) === false ) {

						add_option( 'wcrp_rental_products_rental_time_format', '' );

					}

					// 4.3.0 - Rental form auto select end date setting

					if ( get_option( 'wcrp_rental_products_rental_form_auto_select_end_date' ) === false ) {

						add_option( 'wcrp_rental_products_rental_form_auto_select_end_date', 'no' );

					}

					// 4.3.0 - In person return date setting

					if ( get_option( 'wcrp_rental_products_in_person_return_date' ) === false ) {

						add_option( 'wcrp_rental_products_in_person_return_date', 'same_day' );

					}

					// 4.3.0 - In person pick up times/fees (same day) setting

					if ( get_option( 'wcrp_rental_products_in_person_pick_up_times_fees_same_day' ) === false ) {

						add_option( 'wcrp_rental_products_in_person_pick_up_times_fees_same_day', '' );

					}

					// 4.3.0 - In person return times/fees (single day, same day) setting

					if ( get_option( 'wcrp_rental_products_in_person_pick_up_times_fees_single_day_same_day' ) === false ) {

						add_option( 'wcrp_rental_products_in_person_pick_up_times_fees_single_day_same_day', '' );

					}

					// 4.3.0 - In person return times/fees (same day) setting

					if ( get_option( 'wcrp_rental_products_in_person_return_times_fees_same_day' ) === false ) {

						add_option( 'wcrp_rental_products_in_person_return_times_fees_same_day', '' );

					}

					// 4.3.0 - In person return times/fees (single day, same day) setting

					if ( get_option( 'wcrp_rental_products_in_person_return_times_fees_single_day_same_day' ) === false ) {

						add_option( 'wcrp_rental_products_in_person_return_times_fees_single_day_same_day', '' );

					}

					// 4.3.0 - In person pick up times/fees (next day) setting

					if ( get_option( 'wcrp_rental_products_in_person_pick_up_times_fees_next_day' ) === false ) {

						add_option( 'wcrp_rental_products_in_person_pick_up_times_fees_next_day', '' );

					}

					// 4.3.0 - In person return times/fees (next day) setting

					if ( get_option( 'wcrp_rental_products_in_person_return_times_fees_next_day' ) === false ) {

						add_option( 'wcrp_rental_products_in_person_return_times_fees_next_day', '' );

					}

					// 4.3.0 - Archive rentals setting

					if ( get_option( 'wcrp_rental_products_archive_rentals' ) === false ) {

						add_option( 'wcrp_rental_products_archive_rentals', '0' );

					}

					// 4.3.0 - In person pick up/return text setting

					if ( get_option( 'wcrp_rental_products_text_in_person_pick_up_return' ) === false ) {

						add_option( 'wcrp_rental_products_text_in_person_pick_up_return', __( 'In person pick up/return', 'wcrp-rental-products' ) );

					}

					// 4.3.0 - Pick up date text setting

					if ( get_option( 'wcrp_rental_products_text_pick_up_date' ) === false ) {

						add_option( 'wcrp_rental_products_text_pick_up_date', __( 'Pick up date', 'wcrp-rental-products' ) );

					}

					// 4.3.0 - Pick up time text setting

					if ( get_option( 'wcrp_rental_products_text_pick_up_time' ) === false ) {

						add_option( 'wcrp_rental_products_text_pick_up_time', __( 'Pick up time', 'wcrp-rental-products' ) );

					}

					// 4.3.0 - Return date text setting

					if ( get_option( 'wcrp_rental_products_text_return_date' ) === false ) {

						add_option( 'wcrp_rental_products_text_return_date', __( 'Return date', 'wcrp-rental-products' ) );

					}

					// 4.3.0 - Return time text setting

					if ( get_option( 'wcrp_rental_products_text_return_time' ) === false ) {

						add_option( 'wcrp_rental_products_text_return_time', __( 'Return time', 'wcrp-rental-products' ) );

					}

				}

				update_option( 'wcrp_rental_products_version', WCRP_RENTAL_PRODUCTS_VERSION );

			}

		}

		public static function woocommerce_sessions_carts_clear() {

			global $wpdb;

			$wpdb->query( "TRUNCATE {$wpdb->prefix}woocommerce_sessions;" );

			$wpdb->query(
				$wpdb->prepare(
					"DELETE FROM {$wpdb->usermeta} WHERE meta_key = '_woocommerce_persistent_cart_%d';",
					get_current_blog_id()
				)
			);

			wp_cache_flush();

		}

	}

}
