<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'WCRP_Rental_Products_Settings' ) ) {

	class WCRP_Rental_Products_Settings {

		public function __construct() {

			add_filter( 'woocommerce_get_sections_products', array( $this, 'section' ) );
			add_filter( 'woocommerce_get_settings_products', array( $this, 'fields' ), 10, 2 );

		}

		public function section( $sections ) {

			$sections['wcrp-rental-products'] = __( 'Rental products', 'wcrp-rental-products' );
			return $sections;

		}

		public function fields( $settings, $current_section ) {

			if ( 'wcrp-rental-products' == $current_section ) {

				global $wpdb;

				// Settings - note that the id set on the fields below (excluding of type title) becomes the meta option_name, hence why not hyphenated like usual ID naming conventions

				$thickbox = '<div id="wcrp-rental-products-settings-compatibility-issues-info">';
				$thickbox .= '<p><strong>' . esc_html__( 'The following is a list of known compatibility issues you should be aware of, if you are experiencing any issues related to the below try the fixes listed.', 'wcrp-rental-products' ) . '</strong></p>';
				$thickbox .= '<p><strong>' . esc_html__( 'Please note that this is a list of all known issues and is not specific to your store.', 'wcrp-rental-products' ) . '</strong></p>';
				$thickbox .= '<table class="widefat fixed striped">';
				$thickbox .= '<thead><tr><th>' . esc_html__( 'Issue', 'wcrp-rental-products' ) . '</th><th>' . esc_html__( 'Cause', 'wcrp-rental-products' ) . '</th><th>' . esc_html__( 'Reason', 'wcrp-rental-products' ) . '</th><th style="width: 35%;">' . esc_html__( 'Fix', 'wcrp-rental-products' ) . '</th></tr></thead>'; // Width on last column has to be inline CSS as wcrp-rental-products-settings-compatibility-issues-info is not used in final markup when opened
				$thickbox .= '<tbody>';
				// translators: %s: extension/plugin name
				$thickbox .= '<tr><td>' . esc_html__( 'Rental form on product pages and/or availability checker block/shortcode does not seem to be functioning correctly due to JavaScript errors.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Extension/plugin:', 'wcrp-rental-products' ) . '<br>SiteGround Optimizer</td><td>' . sprintf( esc_html__( '%s is configured to optimize and/or minify CSS/JS/HTML, but in doing so is causing JavaScript errors on the rental form and/or availability checker.', 'wcrp-rental-products' ), 'SiteGround Optimizer' ) . '</td><td>' . sprintf( esc_html__( 'Disable %s or configure it in way that ensures the rental form and/or availability checker works as expected.', 'wcrp-rental-products' ), 'SiteGround Optimizer' ) . '</td></tr>';
				$thickbox .= '<tr><td>' . esc_html__( 'Rental form on product pages is displayed oddly/does not fit well.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Theme/page builder', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Some themes/page builders either by default or through a setting attempt to display the rental form fields horizontally but as rental products have more fields than a non-rental product it does not fit well.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Use a different theme layout option for the product page or override the theme/page builder\'s CSS rules. For full details view the information linked in the rental form section within this page.', 'wcrp-rental-products' ) . '</td></tr>';
				$thickbox .= '<tr><td>' . esc_html__( 'Rental or purchase toggle does not display on rental or purchase based products.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Theme/page builder', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Some themes/page builders are missing a core WooCommerce hook on the product page.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Reinstate the missing hook or use the rental or purchase toggle shortcode to display it. For full details view the information linked in the rental or purchase toggle section within this page.', 'wcrp-rental-products' ) . '</td></tr>';
				// translators: %s: rental product body class
				$thickbox .= '<tr><td>' . esc_html__( 'Rental order item data (e.g. rent from/to) not being included on items in orders.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Extension/plugin', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Some payment method extensions/plugins have functionality to enable quick pay buttons or similar on your product pages. Some of these bypass the standard cart/checkout process where rental data is set against an order and therefore when a customer uses this functionality rental data may not be attached to items within the order, such as rent from/to dates.', 'wcrp-rental-products' ) . '</td><td>' . wp_kses_post( sprintf( __( 'Consider disabling the functionality entirely or alternatively disable this functionality only for rental products by hiding the quick pay methods on rental products with some custom CSS, to do this you can target the element based off the rental product body class of %s.', 'wcrp-rental-products' ), '<code>wcrp-rental-products-is-rental</code>' ) ) . '</td></tr>';
				$thickbox .= '<tr><td>' . esc_html__( 'Rental products cannot be added to cart, shows error code 1.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Theme/page builder or', 'wcrp-rental-products' ) . '<br>' . esc_html__( 'Extension/plugin or', 'wcrp-rental-products' ) . '<br>' . esc_html__( 'Custom development', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'This occurs upon adding to cart when all the expected rental data is not passed to the cart, it stops the product from being added to cart due to the missing data, this generally occurs when themes/page builders, extensions/plugins or custom development have a means of adding a product to cart that does not use the standard WooCommerce functionality.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'If the error occurs when adding to cart from a product page it is likely the standard WooCommerce add to cart form is not being used and therefore the rental form data required is missing (as this extension hooks into that form via its included hooks), this is likely to be a theme/page builder issue, ask your theme/page builder support for clarity on if you are using it, and if not how to reinstate it. If you find there are other means of adding rental products to cart outside the product page and these are causing the error it is likely your theme/page builder, extension/plugin or custom development is adding add to cart links/buttons that technically should not be there as rental products cannot be added to cart outside the product page. In this scenario discuss the issue with the party responsible to see if they can be conditionally hidden/removed if the product is a rental.', 'wcrp-rental-products' ) . '</td></tr>';
				// translators: %s: recommended link
				$thickbox .= '<tr><td>' . esc_html__( 'Rental products cannot be added to cart, shows error code 1, specifically when using an AJAX add to cart method.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Theme/page builder or', 'wcrp-rental-products' ) . '<br>' . esc_html__( 'Extension/plugin or', 'wcrp-rental-products' ) . '<br>' . esc_html__( 'Custom development', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Some themes/page builders, extensions/plugins or custom development attempt to include AJAX add to cart functionality without including any additional required data such as rental data and therefore it is not possible to add to cart via this method.', 'wcrp-rental-products' ) . '</td><td>' . wp_kses_post( sprintf( __( 'Disable this functionality, if you require AJAX based add to cart functionality consider using %s as an alternative which includes the additional required data when adding to cart via this method.', 'wcrp-rental-products' ), '<a href="' . esc_url( 'https://wordpress.org/plugins/woo-ajax-add-to-cart/' ) . '" target="_blank">AJAX Add to Cart for WooCommerce</a>' ) ) . '</td></tr>';
				$thickbox .= '<tr><td>' . esc_html__( 'Rental products cannot be added to cart, shows error code 2.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Data manipulation', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'This occurs upon adding to cart if the rental form data is manipulated before transit and therefore validation fails, this only occurs if someone is attempting to manipulate rental from data.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'None required, this error ensures rental form data being passed to the cart has not been manipulated.', 'wcrp-rental-products' ) . '</td></tr>';
				// translators: %1$s: completed order status name
				$thickbox .= '<tr><td>' . esc_html__( 'Shipping integration automatically sets orders to completed causing rentals to be marked as returned.', 'wcrp-rental-products' ) . '</td><td>' . esc_html__( 'Shipping integration', 'wcrp-rental-products' ) . '</td><td>' . sprintf( esc_html__( 'Some shipping integrations automatically set orders to the %1$s status upon dispatch. Due to the default workflow for managing rental based orders any rentals will automatically be marked as returned when the order is set to %1$s. This means rentals are getting marked as returned when they have not been.', 'wcrp-rental-products' ), strtolower( wc_get_order_status_name( 'wc-completed' ) ) ) . '</td><td>' . esc_html__( 'Consider disabling the return rentals in completed orders setting or disable the automated order status change in the shipping integration, if possible only for orders containing rentals.', 'wcrp-rental-products' ) . '</td></tr>';
				$thickbox .= '</tbody>';
				$thickbox .= '</table>';
				$thickbox .= '</div>';

				// The heading/button below used to be notice markup echoed out rather than part of the settings array but was changed because upon save the notice is duplicated and gets offset behind the menu, potentially due to how WooCommerce is trying to position it's saved notice under the tabs

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Experiencing an issue?', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-experiencing-an-issue', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> '<p><a href="#TB_inline?&width=1000&height=650&inlineId=wcrp-rental-products-settings-compatibility-issues-info" class="button button-primary button-small thickbox">' . esc_html__( 'View known compatibility issues', 'wcrp-rental-products' ) . '</a></p>' . wp_kses_post( $thickbox ),
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Rental date/time formats', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-rental-date-time-formats', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure the rental date/time formats.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'			=> esc_html__( 'Rental date format', 'wcrp-rental-products' ),
					'id'			=> 'wcrp_rental_products_rental_date_format',
					'type'			=> 'text',
					// translators: %s: PHP date/time formats URL
					'desc'			=> esc_html__( 'Format of rental dates used throughout the frontend of your store, emails and in this dashboard, excluding the rental form and availability checker (see rental form date format setting).', 'wcrp-rental-products' ) . '<br>' . wp_kses_post( sprintf( __( 'Use a <a href="%s" target="_blank">PHP date format</a>. Day, month and year must be included, if these are not included and/or if using incorrect formats then it is likely to cause issues with rental functionality.', 'wcrp-rental-products' ), 'https://www.php.net/manual/en/datetime.format.php' ) ),
					// translators: %s: default
					'placeholder'	=> sprintf( esc_html__( 'If empty defaults to %s', 'wcrp-rental-products' ), 'Y-m-d' ),
				);

				$rental_products_settings[] = array(
					'name'			=> esc_html__( 'Rental time format', 'wcrp-rental-products' ),
					'id'			=> 'wcrp_rental_products_rental_time_format',
					'type'			=> 'text',
					// translators: %s: PHP date/time formats URL
					'desc'			=> esc_html__( 'Format of rental times used throughout the frontend of your store, emails and in this dashboard.', 'wcrp-rental-products' ) . '<br>' . wp_kses_post( sprintf( __( 'Use a <a href="%s" target="_blank">PHP time format</a>. Hours and minutes must be be included, if these are not included and/or if using incorrect formats then it is likely to cause issues with rental functionality.', 'wcrp-rental-products' ), 'https://www.php.net/manual/en/datetime.format.php' ) ),
					// translators: %s: default
					'placeholder'	=> sprintf( esc_html__( 'If empty defaults to %s', 'wcrp-rental-products' ), 'H:i' ),
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$thickbox = '<div id="wcrp-rental-products-settings-litepicker-styling-info">';
				$thickbox .= '<p><strong>' . esc_html__( 'Using the default styling for the rental form and availability checker calendars is strongly recommended, however if you wish to customize the styling of these calendars then you can using this information.', 'wcrp-rental-products' ) . '</strong></p>';
				// translators: %s: root CSS variables prefix
				$thickbox .= '<p>' . wp_kses_post( sprintf( __( 'The calendars shown in the rental form and availability checker use several root CSS variables which you can override to customize the styling of the rental form, they are named with the %s prefix. You can view these variables and their values when inspecting the rental form styles using the development tools in your web browser.', 'wcrp-rental-products' ), '<code>--litepicker-</code>' ) ) . '</p>';
				$thickbox .= '<p>' . esc_html__( 'It is strongly recommended you only customize the root CSS variables and not add any additional styling rules as this may cause the calendar to operate incorrectly and/or display inconsistently.', 'wcrp-rental-products' ) . '</p>';
				$thickbox .= '<p>' . esc_html__( 'Use any of the variable names you wish to change and add these overrides to your theme stylesheet or using the additional CSS section within the theme customizer.', 'wcrp-rental-products' ) . '</p>';
				$thickbox .= '<p><strong>' . esc_html__( 'Example single rule root CSS variable override:', 'wcrp-rental-products' ) . '</strong></p>';
				$thickbox .= '<code>:root { --litepicker-is-locked-color: #ff0000 !important; }</code>';
				$thickbox .= '<p><strong>' . esc_html__( 'Example multiple rules CSS variable override:', 'wcrp-rental-products' ) . '</strong></p>';
				$thickbox .= '<code>:root { --litepicker-day-color: #000000 !important; --litepicker-day-color-hover: #333333 !important; }</code>';
				$thickbox .= '</div>';

				$thickbox2 = '<div id="wcrp-rental-products-settings-rental-form-flex-info">';
				$thickbox2 .= '<p><strong>' . esc_html__( 'On rental product pages if the rental form fields (e.g. quantity, rental dates, add to cart, etc) are displayed oddly then it is likely your theme includes some CSS styling causing this.', 'wcrp-rental-products' ) . '</strong></p>';
				// translators: %s: display flex CSS
				$thickbox2 .= '<p>' . wp_kses_post( sprintf( __( 'What you are likely seeing is that the rental form fields are trying to be fitted onto the screen horizontally. This occurs because the theme has a %s or similar rule on an outer container of these rental form fields, this results in the fields within that container to display horizontally. This is usually because the theme isn\'t accounting for any additional fields that extensions like this one add to the product page.', 'wcrp-rental-products' ), '<code>display: flex;</code>' ) ) . '</p>';
				// translators: %1$s: display flex CSS, %2$s: display block CSS, %3$s: is rental body class
				$thickbox2 .= '<p>' . wp_kses_post( sprintf( __( 'As this is a theme specific styling issue it requires either choosing a theme option for the product page display that does not include the %1$s rule or alternatively you can fix this by finding the outer container of the rental form fields which has a %1$s and override this to a %2$s or similar, this will stop the horizontal style layout of the form. If required you can target this to only rental products rather than all products using the %3$s body class.', 'wcrp-rental-products' ), '<code>display: flex;</code>', '<code>display: block;</code>', '<code>wcrp-rental-products-is-rental</code>' ) ) . '</p>';
				$thickbox2 .= '<p>' . esc_html__( 'The above is the most frequent cause of this type of issue, however it is not guaranteed this is the cause. It could be some other CSS rules, if you do not see rules like the above included within your theme then look out for other CSS rules which may be effecting the layout e.g. floats.', 'wcrp-rental-products' ) . '</p>';
				$thickbox2 .= '<p><strong>' . esc_html__( 'If in doubt contact your theme developer\'s support team and explain the issue, they should be able to guide you on how to get the layout displayed as required with minimal modification.', 'wcrp-rental-products' ) . '</strong></p>';
				$thickbox2 .= '</div>';

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Rental form', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-rental-form', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure the rental form shown on rental product pages.', 'wcrp-rental-products' ) . ' ' . esc_html__( 'For details on how to style the rental form calendar', 'wcrp-rental-products' ) . ' <a href="#TB_inline?&width=600&height=550&inlineId=wcrp-rental-products-settings-litepicker-styling-info" class="thickbox">' . esc_html__( 'click here', 'wcrp-rental-products' ) . '</a>' . esc_html__( ',', 'wcrp-rental-products' ) . ' ' . esc_html__( 'if your rental form display seems odd', 'wcrp-rental-products' ) . ' <a href="#TB_inline?&width=600&height=550&inlineId=wcrp-rental-products-settings-rental-form-flex-info" class="thickbox">' . esc_html__( 'click here', 'wcrp-rental-products' ) . '</a>' . esc_html__( '.', 'wcrp-rental-products' ) . $thickbox . $thickbox2,
				);

				$rental_products_settings[] = array(
					'name'			=> esc_html__( 'Rental form date format', 'wcrp-rental-products' ),
					'id'			=> 'wcrp_rental_products_rental_form_date_format',
					'type'			=> 'text',
					// translators: %s: allowed formats
					'desc'			=> esc_html__( 'Format of rental dates displayed when a customer selects dates using the rental form on product pages.', 'wcrp-rental-products' ) . '<br>' . sprintf( esc_html__( 'Allowed formats are %s. Day, month and year must be included, if these are not included and/or if using incorrect formats then it is likely to cause issues with rental functionality.', 'wcrp-rental-products' ), '<code>D' . esc_html__( ',', 'wcrp-rental-products' ) . ' DD' . esc_html__( ',', 'wcrp-rental-products' ) . ' M' . esc_html__( ',', 'wcrp-rental-products' ) . ' MM' . esc_html__( ',', 'wcrp-rental-products' ) . ' MMM' . esc_html__( ',', 'wcrp-rental-products' ) . ' MMMM' . esc_html__( ',', 'wcrp-rental-products' ) . ' YYYY</code>' ) . '<br>' . esc_html__( 'This setting is also used for the availability checker.', 'wcrp-rental-products' ),
					// translators: %s: default
					'placeholder'	=> sprintf( esc_html__( 'If empty defaults to %s', 'wcrp-rental-products' ), 'D MMM YYYY' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental form first day', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_form_first_day',
					'type'		=> 'select',
					'desc'		=> esc_html__( 'The first day of the week in the rental form.', 'wcrp-rental-products' ) . '<br>' . esc_html__( 'This setting is also used for the availability checker.', 'wcrp-rental-products' ),
					'options'	=> array(
						'1'	=> esc_html__( 'Monday', 'wcrp-rental-products' ),
						'2'	=> esc_html__( 'Tuesday', 'wcrp-rental-products' ),
						'3'	=> esc_html__( 'Wednesday', 'wcrp-rental-products' ),
						'4'	=> esc_html__( 'Thursday', 'wcrp-rental-products' ),
						'5'	=> esc_html__( 'Friday', 'wcrp-rental-products' ),
						'6'	=> esc_html__( 'Saturday', 'wcrp-rental-products' ),
						'0'	=> esc_html__( 'Sunday', 'wcrp-rental-products' ),
					),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental form period selection option labels', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_form_period_selection_option_labels',
					'type'		=> 'select',
					'desc'		=> esc_html__( 'Set how option labels are displayed when the product is using the period selection pricing type. If weeks used then the options display as weeks e.g. if period selections are 1, 7, 14 (entered in days) it will display these as 1 day, 1 week and 2 weeks. Day periods which do not divide into weeks remain in days.', 'wcrp-rental-products' ),
					'options'	=> array(
						'days'	=> esc_html__( 'Days', 'wcrp-rental-products' ),
						'weeks'	=> esc_html__( 'Weeks', 'wcrp-rental-products' ),
					),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental form after quantity', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_form_after_quantity',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable rental form after quantity', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Displays the rental form after the quantity field on product pages, if disabled this will display the rental form before the quantity field.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental form auto apply', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_form_auto_apply',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable rental form auto apply', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Automatically applys the dates selected in the rental form calendar. If disabled then cancel and apply buttons are shown and the apply button must be clicked to confirm the dates selected. Disabling this is useful if you have long date range periods that span multiple months to give a better visual indication that date selection is required as clicking the apply button without selecting the required dates instructs the customer why it cannot be applied.', 'wcrp-rental-products' ) . '<br>' . esc_html__( 'This setting is also used for the availability checker.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental form auto select end date (BETA)', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_form_auto_select_end_date',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable rental form auto select end date', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Automatically sets the end date when a start date is selected in the rental form calendar. This will only occur on rental products which allow selection of a singular range, e.g. does not occur if pricing type is period and pricing period multiplies is enabled as multiples of the minimum range can be selected.', 'wcrp-rental-products' ) . '<br><strong>' . esc_html__( 'This is a BETA feature, it is recommended to only use on a staging/development environment for testing until the BETA label is removed.', 'wcrp-rental-products' ) . '</strong>',
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental form reset button', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_form_reset_button',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable rental form reset button', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Displays a reset button within the rental form calendar used to reset previously selected dates. Disabled by default as a new date or range is easily selectable without the need to reset first.', 'wcrp-rental-products' ) . '<br>' . esc_html__( 'This setting is also used for the availability checker.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental form start/end notices', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_form_start_end_notices',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable rental form start/end notices', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Displays a notice instructing the customer that the dates selected cannot start/end on the highlighted days in the rental form calendar if a product has disabled start/end dates/days.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'				=> esc_html__( 'Rental form maximum date days', 'wcrp-rental-products' ),
					'id'				=> 'wcrp_rental_products_rental_form_maximum_date_days',
					'type'				=> 'number',
					// translators: %s: default days
					'desc'				=> sprintf( esc_html__( 'Set the maximum amount of days from today that the rental form will allow date selection up to. If empty defaults to %s.', 'wcrp-rental-products' ), '730' ) . '<br>' . esc_html__( 'This setting is also used for the availability checker.', 'wcrp-rental-products' ),
					'css'				=> 'width: 100px;',
					'custom_attributes'	=> array(
						'min'	=> 1,
						'max'	=> 7300, // 20 years
						'step'	=> 1,
					),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental form maximum date specific', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_form_maximum_date_specific',
					'type'		=> 'text',
					'desc'		=> esc_html__( 'Set the maximum date that the rental form will allow date selection up to, if populated this setting overrides rental form maximum date days.', 'wcrp-rental-products' ) . '<br>' . esc_html__( 'This setting is also used for the availability checker.', 'wcrp-rental-products' ),
					'class'		=> 'wcrp-rental-products-single-date-picker',
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$thickbox = '<div id="wcrp-rental-products-settings-availability-checker-info">';
				$thickbox .= '<p><strong>' . esc_html__( 'The availability checker is a form which allows customers to select their preferred rental dates and quantity, once these have been selected it will show an availability status on rental products in product category pages, search pages, most core WooCommerce product blocks, etc - excluding variable/grouped products as these require selection of options. Once the availability checker is set it also auto populates the rental dates and quantity on product pages if available. For period selection pricing type products the period selection where available is highlighted.', 'wcrp-rental-products' ) . '</strong></p>';
				// translators: %1$s block, %2$s: shortcode
				$thickbox .= '<p>' . wp_kses_post( sprintf( __( 'Use the %1$s block or %2$s shortcode to display the availability checker. We recommend including the availability checker throughout your customer journey e.g. in a sidebar so it is visible to customers as they browse products in your store and if they wish they can reset it. It is not recommended to include it on product pages as it may cause confusion with the rental form.', 'wcrp-rental-products' ), __( 'Availability Checker', 'wcrp-rental-products' ), '<code>[wcrp_rental_products_availability_checker]</code>' ) ) . '</p>';
				$thickbox .= '<p>' . __( 'The availability checker status is displayed on products in product category pages, search pages, most core WooCommerce product blocks, etc is added after the call to action button (add to cart, select options, read more, etc), therefore these buttons must not be disabled via a setting of your theme or an extension/plugin and/or custom development if you want the availability checker status to be displayed. The availability checker status is displayed automatically, it doesn\'t require a block/shortcode.', 'wcrp-rental-products' ) . '</p>';
				$thickbox .= '</div>';

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Availability checker', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-availability-checker', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure the availability checker shown by block or shortcode.', 'wcrp-rental-products' ) . ' ' . esc_html__( 'For details on how to use the availability checker', 'wcrp-rental-products' ) . ' <a href="#TB_inline?&width=600&height=550&inlineId=wcrp-rental-products-settings-availability-checker-info" class="thickbox">' . esc_html__( 'click here', 'wcrp-rental-products' ) . '</a>' . esc_html__( ',', 'wcrp-rental-products' ) . ' ' . esc_html__( 'for details on how to style the availability checker calendar', 'wcrp-rental-products' ) . ' <a href="#TB_inline?&width=600&height=550&inlineId=wcrp-rental-products-settings-litepicker-styling-info" class="thickbox">' . esc_html__( 'click here', 'wcrp-rental-products' ) . '</a>' . esc_html__( '.', 'wcrp-rental-products' ) . $thickbox,
				);

				$rental_products_settings[] = array(
					'name'				=> esc_html__( 'Availability checker minimum days', 'wcrp-rental-products' ),
					'id'				=> 'wcrp_rental_products_availability_checker_minimum_days',
					'type'				=> 'number',
					// translators: %s: no minimum value
					'desc'				=> sprintf( esc_html__( 'Set the minimum amount of days that can selected on the availability checker calendar. This field and the one below can be set to the same number (greater than 1) to force a period for selection. Set to %s for no minimum.', 'wcrp-rental-products' ), '0' ),
					'css'				=> 'width: 100px;',
					'custom_attributes'	=> array(
						'min'	=> 0,
						'step'	=> 1,
					),
				);

				$rental_products_settings[] = array(
					'name'				=> esc_html__( 'Availability checker maximum days', 'wcrp-rental-products' ),
					'id'				=> 'wcrp_rental_products_availability_checker_maximum_days',
					'type'				=> 'number',
					// translators: %s: no maximum value
					'desc'				=> sprintf( esc_html__( 'Set the maximum amount of days that can selected on the availability checker calendar. This field and the one above can be set to the same number (greater than 1) to force a period for selection. Set to %s for no maximum.', 'wcrp-rental-products' ), '0' ),
					'css'				=> 'width: 100px;',
					'custom_attributes' => array(
						'min'	=> 0,
						'step'	=> 1,
					),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Availability checker period multiples', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_availability_checker_period_multiples',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable availability checker period multiples', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'If the minimum/maximum days above are set to the same value (greater than 1) to force a period for selection then enabling this setting will allow selection of multiples of that period.', 'wcrp-rental-products' ) . '<br>' . esc_html__( 'e.g. if minimum/maximum days are set to 7 then enabling this setting will allow a period to be selected of 7, 14, 21 days, etc.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Availability checker quantity', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_availability_checker_quantity',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable availability checker quantity', 'wcrp-rental-products' ),
					// translators: %s: default availability checker quantity
					'desc_tip'	=> sprintf( esc_html__( 'Allows a customer to specify the quantity required for the rental dates selected in the availability checker. If disabled defaults quantity to %s and hides the quantity.', 'wcrp-rental-products' ), '1' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Availability checker status on rental only products', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_availability_checker_status_rental',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable availability checker status on rental only products', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Display availability checker status in loops/blocks on rental only products (if availability checker in use).', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Availability checker status on rental or purchase products', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_availability_checker_status_rental_purchase',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable availability checker status on rental or purchase products', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Display availability checker status in loops/blocks on rental or purchase products (if availability checker in use). It is recommended this is disabled as the price/add to cart of the purchasable part of a rental or purchase product is shown on loops/blocks, if availability checker status is displayed a customer may confuse the price/add to cart as being for the rental.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'In person pick up/return defaults', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-in-person-pick-up-return-defaults', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure the in person pick up/return defaults used if not set at product level.', 'wcrp-rental-products' ),
				);

				$in_person_pick_up_return_date_options = WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_date', 'options' );

				if ( !empty( $in_person_pick_up_return_date_options ) ) {

					if ( array_key_exists( 'default', $in_person_pick_up_return_date_options ) ) {

						unset( $in_person_pick_up_return_date_options['default'] );
	
					}

				} else {

					$in_person_pick_up_return_date_options = array();

				}

				$rental_products_settings[] = array(
					'name'		=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_date', 'label' ),
					'id'		=> 'wcrp_rental_products_in_person_return_date',
					'type'		=> 'select',
					'desc'		=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_date', 'description' ),
					'options'	=> $in_person_pick_up_return_date_options,
				);

				$rental_products_settings[] = array(
					'name'			=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_pick_up_times_fees_same_day', 'label' ),
					'id'			=> 'wcrp_rental_products_in_person_pick_up_times_fees_same_day',
					'type'			=> 'textarea',
					'desc_tip'		=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_pick_up_times_fees_same_day', 'description' ),
					'placeholder'	=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_pick_up_times_fees_same_day', 'placeholder' ),
					'css'			=> 'height: 100px;', // This is in shared field attributes, but we hardcode it as there are other textareas with hardcoded heights in settings, so if these ever change and are different to the product page heights we want them separate
				);

				$rental_products_settings[] = array(
					'name'			=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_pick_up_times_fees_single_day_same_day', 'label' ),
					'id'			=> 'wcrp_rental_products_in_person_pick_up_times_fees_single_day_same_day',
					'type'			=> 'textarea',
					'desc_tip'		=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_pick_up_times_fees_single_day_same_day', 'description' ),
					'placeholder'	=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_pick_up_times_fees_single_day_same_day', 'placeholder' ),
					'css'			=> 'height: 100px;', // This is in shared field attributes, but we hardcode it as there are other textareas with hardcoded heights in settings, so if these ever change and are different to the product page heights we want them separate
				);

				$rental_products_settings[] = array(
					'name'			=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_times_fees_same_day', 'label' ),
					'id'			=> 'wcrp_rental_products_in_person_return_times_fees_same_day',
					'type'			=> 'textarea',
					'desc_tip'		=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_times_fees_same_day', 'description' ),
					'placeholder'	=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_times_fees_same_day', 'placeholder' ),
					'css'			=> 'height: 100px;', // This is in shared field attributes, but we hardcode it as there are other textareas with hardcoded heights in settings, so if these ever change and are different to the product page heights we want them separate
				);

				$rental_products_settings[] = array(
					'name'			=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_times_fees_single_day_same_day', 'label' ),
					'id'			=> 'wcrp_rental_products_in_person_return_times_fees_single_day_same_day',
					'type'			=> 'textarea',
					'desc_tip'		=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_times_fees_single_day_same_day', 'description' ),
					'placeholder'	=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_times_fees_single_day_same_day', 'placeholder' ),
					'css'			=> 'height: 100px;', // This is in shared field attributes, but we hardcode it as there are other textareas with hardcoded heights in settings, so if these ever change and are different to the product page heights we want them separate
				);

				$rental_products_settings[] = array(
					'name'			=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_pick_up_times_fees_next_day', 'label' ),
					'id'			=> 'wcrp_rental_products_in_person_pick_up_times_fees_next_day',
					'type'			=> 'textarea',
					'desc_tip'		=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_pick_up_times_fees_next_day', 'description' ),
					'placeholder'	=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_pick_up_times_fees_next_day', 'placeholder' ),
					'css'			=> 'height: 100px;', // This is in shared field attributes, but we hardcode it as there are other textareas with hardcoded heights in settings, so if these ever change and are different to the product page heights we want them separate
				);

				$rental_products_settings[] = array(
					'name'			=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_times_fees_next_day', 'label' ),
					'id'			=> 'wcrp_rental_products_in_person_return_times_fees_next_day',
					'type'			=> 'textarea',
					'desc_tip'		=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_times_fees_next_day', 'description' ),
					'placeholder'	=> WCRP_Rental_Products_Product_Fields::shared_field_attributes( '_wcrp_rental_products_in_person_return_times_fees_next_day', 'placeholder' ),
					'css'			=> 'height: 100px;', // This is in shared field attributes, but we hardcode it as there are other textareas with hardcoded heights in settings, so if these ever change and are different to the product page heights we want them separate
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Disable rental dates', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-disable-rental-dates', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure specific dates to be disabled for rental, used in addition to any dates automatically disabled where no availability.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Disable rental dates', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_disable_rental_dates',
					'type'		=> 'text',
					'desc'		=> esc_html__( 'Disable rentals on specific dates. Used in addition to any disabled rental dates set at product level.', 'wcrp-rental-products' ),
					'class'		=> 'wcrp-rental-products-disable-dates-picker',
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Disable rental start/end dates', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_disable_rental_start_end_dates',
					'type'		=> 'text',
					'desc'		=> esc_html__( 'Disable rental start/end on specific dates. Used in addition to any disabled rental start/end dates set at product level.', 'wcrp-rental-products' ),
					'class'		=> 'wcrp-rental-products-disable-dates-picker',
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$thickbox = '<div id="wcrp-rental-products-settings-rental-purchase-toggle-info">';
				// translators: %s: action hook
				$thickbox .= '<p><strong>' . wp_kses_post( sprintf( __( 'The rental or purchase toggle is added automatically via the %s action hook, generally it is not removed as it is a core WooCommerce hook, however if the toggle is not displayed it is likely you are using a page builder/theme that has removed it.', 'wcrp-rental-products' ), '<code>woocommerce_single_product_summary</code>' ) ) . '</strong></p>';
				// translators: %s: shortcode
				$thickbox .= '<p>' . wp_kses_post( sprintf( __( 'In this scenario seek support from your page builder/theme support team on how to reinstate this hook or alternatively use the %s shortcode on your product page template, however this should only be used if the toggle is not added automatically due to the missing hook.', 'wcrp-rental-products' ), '<code>[wcrp_rental_products_rental_purchase_toggle]</code>' ) ) . '</p>';
				$thickbox .= '</div>';

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Rental or purchase toggle', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-rental-purchase-toggle', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure the rental or purchase toggle shown on products of a rental or purchase type.', 'wcrp-rental-products' ) . ' ' . esc_html__( 'Not appearing?', 'wcrp-rental-products' ) . ' <a href="#TB_inline?&width=600&height=550&inlineId=wcrp-rental-products-settings-rental-purchase-toggle-info" class="thickbox">' . esc_html__( 'click here', 'wcrp-rental-products' ) . '</a>' . esc_html__( '.', 'wcrp-rental-products' ) . $thickbox,

				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental or purchase toggle position', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_purchase_toggle_position',
					'type'		=> 'select',
					'desc'		=> esc_html__( 'The position of the toggle for rental or purchase based products. Low is in the position below the add to cart button and high is in the position below the price.', 'wcrp-rental-products' ),
					'options'	=> array(
						'low'	=> esc_html__( 'Low', 'wcrp-rental-products' ),
						'high'	=> esc_html__( 'High', 'wcrp-rental-products' ),
					),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental or purchase toggle type', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_purchase_toggle_type',
					'type'		=> 'select',
					// translators: %s: button class
					'desc'		=> sprintf( esc_html__( 'The toggle type for rental or purchase based products. The button type uses the %s CSS class, styling for this class is normally included in your theme but not guaranteed.', 'wcrp-rental-products' ), '<code>.button</code>' ),
					'options'	=> array(
						'link'		=> esc_html__( 'Link', 'wcrp-rental-products' ),
						'button'	=> esc_html__( 'Button', 'wcrp-rental-products' ),
					),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental or purchase toggle loops/blocks display', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_purchase_toggle_loops_blocks_display',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable rental or purchase toggle loops/blocks display', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Displays the view rental options toggle link/button on rental or purchase products within loops/blocks. View purchase options toggle link/button will not display as the purchasable part of a rental or purchase product is always shown on loops/blocks. Rental or purchase toggle position does not apply to this setting.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Rental price display', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-rental-price-display', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure the rental price display.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental price display prefix', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_price_display_prefix',
					'type'		=> 'text',
					// translators: %1$s: rental price including tax placeholder, %2$s: rental price excluding tax placeholder, %3$s: rental price display prefix filter hook
					'desc'		=> wp_kses_post( sprintf( __( 'Set text to appear before a rental product\'s price. You can also have rental prices substituted here using %1$s and/or %2$s. Note this can also be filtered via the %3$s filter.', 'wcrp-rental-products' ), '<code>{rental_price_including_tax}</code>', '<code>{rental_price_excluding_tax}</code>', '<code>wcrp_rental_products_rental_price_display_prefix</code>' ) ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental price display suffix', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_price_display_suffix',
					'type'		=> 'text',
					// translators: %1$s: rental price including tax placeholder, %2$s: rental price excluding tax placeholder, %3$s: rental price display suffix filter hook
					'desc'		=> wp_kses_post( sprintf( __( 'Set text to appear after a rental product\'s price. You can also have rental prices substituted here using %1$s and/or %2$s. Note this can also be filtered via the %3$s filter.', 'wcrp-rental-products' ), '<code>{rental_price_including_tax}</code>', '<code>{rental_price_excluding_tax}</code>', '<code>wcrp_rental_products_rental_price_display_suffix</code>' ) ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental price display override prefix/suffix', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_price_display_override_prefix_suffix',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable rental price display prefix/suffix when overriding rental price display', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Displays the rental price display prefix/suffix when rental price display is overridden on the product.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental price display rent text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_price_display_rent_text',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable rent from/to text in rental price display', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Displays rent from/to text in the rental price display.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Rental information', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-rental-information', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure the rental information display.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental information title', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_information_title',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Title used as the rental information tab and inner heading displayed on the product page. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<code>wcrp_rental_products_rental_information_title</code>', esc_html__( 'Rental information', 'wcrp-rental-products' ) ) ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental information heading', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_information_heading',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable rental information heading within the tab', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Displays the rental information title as a heading within the rental information tab.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental information', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_rental_information',
					'type'		=> 'textarea',
					'desc_tip'	=> esc_html__( 'Adds rental information to a tab on the product page. This will be used in addition to any rental information which has been set at product level.', 'wcrp-rental-products' ),
					'css'		=> 'height: 100px;',
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Cart and checkout', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-cart-checkout', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure cart and checkout related settings.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Same rental dates required', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_same_rental_dates_required',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable same rental dates required', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Ensures that all rental products in cart have the same rental dates, only enable this setting if you want to force all rental products in cart to have the same rental dates.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Order and rental management', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-order-rental-management', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure order and rental management related settings.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Immediate rental stock replenishment', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_immediate_rental_stock_replenishment',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable immediate rental stock replenishment', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'When enabled if rentals are marked as returned the quantity will be immediately available to rent again e.g. if a rental is returned before it is due then that quantity is immediately made available again. If disabled the quantity will remain unavailable until the date due to be returned. Note that if archive rentals is enabled and the returned rental being archived\'s rental dates have not yet past (earlier than expected return) then it will be immediately replenished regardless of this setting.', 'wcrp-rental-products' ), // This does not reference return days thershold intentionally because the return due could be either return days threshold based or in person return date based
				);

				$rental_products_settings[] = array(
					// translators: %s: failed order status name
					'name'		=> sprintf( esc_html__( 'Cancel rentals in %s orders', 'wcrp-rental-products' ), esc_html( strtolower( wc_get_order_status_name( 'wc-failed' ) ) ) ),
					'id'		=> 'wcrp_rental_products_cancel_rentals_in_failed_orders',
					'type'		=> 'checkbox',
					// translators: %s: failed order status name
					'desc'		=> sprintf( esc_html__( 'Enable cancel rentals in %s orders', 'wcrp-rental-products' ), esc_html( strtolower( wc_get_order_status_name( 'wc-failed' ) ) ) ),
					// translators: %1$s: failed order status name
					'desc_tip'	=> sprintf( esc_html__( 'When orders are set to %1$s then rental stock is still reserved as the order can still be accessed through the customer\'s account and they can make a payment at a later date. Enabling this setting means that when an order is set to %1$s then all the rentals within the order are cancelled, removing the reservation of the rental stock. The ability to make payment against a %1$s order with rental products included is disabled too.', 'wcrp-rental-products' ), esc_html( strtolower( wc_get_order_status_name( 'wc-failed' ) ) ) ),
				);

				$rental_products_settings[] = array(
					// translators: %s: completed order status name
					'name'		=> sprintf( esc_html__( 'Return rentals in %s orders', 'wcrp-rental-products' ), esc_html( strtolower( wc_get_order_status_name( 'wc-completed' ) ) ) ),
					'id'		=> 'wcrp_rental_products_return_rentals_in_completed_orders',
					'type'		=> 'checkbox',
					// translators: %s: completed order status name
					'desc'		=> sprintf( esc_html__( 'Enable return rentals in %s orders', 'wcrp-rental-products' ), esc_html( strtolower( wc_get_order_status_name( 'wc-completed' ) ) ) ),
					// translators: %1%s: completed order status name, %2%s: processing order status name
					'desc_tip'	=> sprintf( esc_html__( 'When enabled if an order is set to %1$s then all rentals within the order are automatically marked as returned, this is recommended, however you can disable this setting if you want to set an order to %1$s and manually mark each order item as returned. This is useful in some limited scenarios, such as if you are using an automated shipping integration which sets dispatched orders to %1$s. If this setting is disabled then rental return email reminders will not be sent as this finds all non-returned items in orders set to %2$s.', 'wcrp-rental-products' ), esc_html( strtolower( wc_get_order_status_name( 'wc-completed' ) ) ), esc_html( strtolower( wc_get_order_status_name( 'wc-processing' ) ) ) ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Managing rental orders information', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_managing_rental_orders_information',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable managing rental orders information', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Shows information on rental order management when viewing order details in the dashboard. When enabled the user has the choice of toggling this on or off via the screen options, if disabled it is removed for all users with no screen option available.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Calendar feed', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_calendar_feed',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable calendar feed', 'wcrp-rental-products' ),
					'desc_tip'	=> esc_html__( 'Generates a calendar feed hourly in ICS format which can be used in a calendar application which allows subscription to calendars via URL. This allows you to view events from the rentals dashboard calendar in your chosen calendar application. The calendar is not navigable from the frontend of your store and the calendar URL includes a unique ID, however it is possible that someone could access this URL and therefore only non-identifiable information is included in the calendar feed. Note that although the calendar feed is regenerated hourly the refresh frequency is controlled by your calendar application. After enabling this setting it can take up to one hour for the feed to generate on the URL below, until then the URL will 404.', 'wcrp-rental-products' ) . '<br><code>' . esc_url( WCRP_Rental_Products_Feeds::feed_url_calendar() ) . '</code>',
				);

				$database_table_info_rentals = $wpdb->get_results( "SELECT ROUND( ( DATA_LENGTH + INDEX_LENGTH ) / 1024 ) AS `size`, `TABLE_ROWS` as `rows` FROM `information_schema`.`TABLES` WHERE `TABLE_SCHEMA` = '{$wpdb->dbname}' AND `TABLE_NAME` = '{$wpdb->prefix}wcrp_rental_products_rentals';" );
				$database_table_info_rentals_archive = $wpdb->get_results( "SELECT ROUND( ( DATA_LENGTH + INDEX_LENGTH ) / 1024 ) AS `size`, `TABLE_ROWS` as `rows` FROM `information_schema`.`TABLES` WHERE `TABLE_SCHEMA` = '{$wpdb->dbname}' AND `TABLE_NAME` = '{$wpdb->prefix}wcrp_rental_products_rentals_archive';" );

				$archive_rentals_database_table_info = '';
				$archive_rentals_database_table_info .= esc_html__( 'Rentals database table size: ', 'wcrp-rental-products' ) . esc_html( $database_table_info_rentals[0]->size ) . esc_html__( 'KB', 'wcrp-rental-products' ) . ' ' . esc_html__( '(', 'wcrp-rental-products' ) . esc_html( $database_table_info_rentals[0]->rows ) . ' ' . esc_html__( 'rows', 'wcrp-rental-products' ) . esc_html__( ')', 'wcrp-rental-products' );
				$archive_rentals_database_table_info .= esc_html__( ',', 'wcrp-rental-products' ) . ' ';
				$archive_rentals_database_table_info .= esc_html__( 'rentals archive database table size: ', 'wcrp-rental-products' ) . esc_html( $database_table_info_rentals_archive[0]->size ) . esc_html__( 'KB', 'wcrp-rental-products' ) . ' ' . esc_html__( '(', 'wcrp-rental-products' ) . esc_html( $database_table_info_rentals_archive[0]->rows ) . ' ' . esc_html__( 'rows', 'wcrp-rental-products' ) . esc_html__( ')', 'wcrp-rental-products' );
				$archive_rentals_database_table_info .= esc_html__( '.', 'wcrp-rental-products' );

				$rental_products_settings[] = array(
					'name'				=> esc_html__( 'Archive rentals (BETA)', 'wcrp-rental-products' ),
					'id'				=> 'wcrp_rental_products_archive_rentals',
					'type'				=> 'number',
					// translators: %s: no maximum value
					'desc'				=> sprintf( esc_html__( 'Orders which are older than the amount of days set (based on date order created) will have any rentals marked as returned archived. Set to %s to disable, any rentals already archived will remain so.', 'wcrp-rental-products' ), '0' ) . '<br>' . esc_html__( 'When orders are created each rental within the order has associated database data which is queried to check availability, display the rentals dashboard calendar, etc. By archiving the data no longer needed for querying (e.g. rentals marked as returned) it can increase performance. Other than potential performance improvements, the only noticable difference is that archived rentals will no longer appear in the rentals dashboard calendar, but can be shown by clicking the include archived rentals button.', 'wcrp-rental-products' ) . '<br>' . esc_html( $archive_rentals_database_table_info ) . '<br><strong>' . esc_html__( 'This is a BETA feature, it is recommended to only use on a staging/development environment for testing until the BETA label is removed.', 'wcrp-rental-products' ) . '</strong>',
					'css'				=> 'width: 100px;',
					'custom_attributes' => array(
						'min'	=> 0,
						'step'	=> 1,
					),
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Misc', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-misc', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure miscellaneous settings.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Advanced configuration', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_advanced_configuration',
					'type'		=> 'text',
					'desc'		=> esc_html__( 'Only populate when instructed by the developers of this extension to diagnose an issue or for very specific server configurations.', 'wcrp-rental-products' ),
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Return days display', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_return_days_display',
					'type'		=> 'checkbox',
					'desc'		=> esc_html__( 'Enable return days display', 'wcrp-rental-products' ),
					// translators: %s: zero return days threshold
					'desc_tip'	=> esc_html__( 'Displays return days in customer facing areas such as the product rental form, cart, checkout and emails. Return days threshold is still used for availability but does not display. This is useful if you wish to instruct the customer to return a product within x days but need to set the return days higher. An example of this would be if you had a rental that needs to be returned within 3 days but allow an additional 3 days to service the product before it is available for rental again. You would set the return days threshold to 6 but instruct the customer to return it within 3 days. In this scenario if this setting was enabled it would instruct the user to return within 6 days and therefore would not allow for the service period.', 'wcrp-rental-products' ) . '<br>' . sprintf( esc_html__( 'Note that return days is not displayed in any scenario if the product has a return days threshold of %s or if the product is an in person pick up/return.', 'wcrp-rental-products' ), '0' ),
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Emails', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-emails', // ID of div not an input
					'type'	=> 'title',
					// translators: %s: email notifications link
					'desc'	=> wp_kses_post( sprintf( __( 'Configure the rental return reminder email sent to customers via %s.', 'wcrp-rental-products' ), '<a href="' . esc_url( get_admin_url() . 'admin.php?page=wc-settings&tab=email' ) . '" target="_blank">' . esc_html__( 'email notifications', 'wcrp-rental-products' ) . '</a>' ) ),
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				$thickbox = '<div id="wcrp-rental-products-settings-translation-info">';
				$thickbox .= '<p><strong>' . esc_html__( 'Important notice on use of translation plugins:', 'wcrp-rental-products' ) . '</strong></p>';
				$thickbox .= '<p>' . esc_html__( 'Some translation plugins create multiple product instances by cloning or duplicating products to allow you to translate for each language (sometimes in the background without you knowing), in doing this they then attempt to sync price, stock, etc between the instances, however due to the complex nature of rental price and stock data using translation plugins which do this are extremely likely to give unexpected results or not work at all - so do not use a translation plugin which does this, if you are unsure if your translation plugin does this reach out to the support team of the translation plugin.', 'wcrp-rental-products' ) . '</p>';
				$thickbox .= '<p><strong>' . esc_html__( 'Automatically translate from English to other languages:', 'wcrp-rental-products' ) . '</strong></p>';
				$thickbox .= '<p>' . esc_html__( 'If you wish to automatically translate the text in this extension from English to other languages then use an automatic translation plugin.', 'wcrp-rental-products' ) . '</p>';
				$thickbox .= '<p>' . esc_html__( 'There are various plugins available which offer automatic translation, we do not recommend a specific one.', 'wcrp-rental-products' ) . '</p>';
				$thickbox .= '<p><strong>' . esc_html__( 'Manually translate from English to a different language:', 'wcrp-rental-products' ) . '</strong></p>';
				$thickbox .= '<p>' . esc_html__( 'If you wish to manually translate the text in this extension from English to a different language you can do this by modifying the text settings shown within this page, these are the most commonly used text references, then modify any other text references you wish to translate using a translation plugin.', 'wcrp-rental-products' ) . '</p>';
				// translators: %s: recommended plugin link
				$thickbox .= '<p>' . wp_kses_post( sprintf( __( 'The %s plugin is the current recommendation at time of writing.', 'wcrp-rental-products' ), '<a href="' . esc_url( 'https://wordpress.org/plugins/loco-translate/' ) . '" target="_blank">' . __( 'Loco Translate', 'wcrp-rental-products' ) . '</a>' ) ) . '</p>';
				$thickbox .= '<p><strong>' . esc_html__( 'Manually translate from English to multiple languages with language selection:', 'wcrp-rental-products' ) . '</strong></p>';
				// translators: %s: option name prefix
				$thickbox .= '<p>' . wp_kses_post( sprintf( __( 'If you wish to manually translate the text in this extension and you have a multilingual store where a user can select a language to show manually added translations you will need to use a translation plugin. The translation plugin used will need to have functionality to not only translate the text included within extensions/plugins but also WordPress options stored in the database. This is because the most commonly used text references in this extension are stored as settings (WordPress options stored in the database) and therefore the translation plugin used needs to be able to translate these too. The option names for the text have the %s prefix. Some translation plugins allow you to modify any visible text, this effectively achieves the same result without translating the options directly.', 'wcrp-rental-products' ), '<code>wcrp_rental_products_text_</code>' ) ) . '</p>';
				// translators: %s: recommended plugin link
				$thickbox .= '<p>' . wp_kses_post( sprintf( __( 'The %s plugin is the current recommendation at time of writing.', 'wcrp-rental-products' ), '<a href="' . esc_url( 'https://wordpress.org/plugins/translatepress-multilingual/' ) . '" target="_blank">' . __( 'TranslatePress', 'wcrp-rental-products' ) . '</a>' ) ) . '</p>';
				$thickbox .= '</div>';

				$rental_products_settings[] = array(
					'name'	=> esc_html__( 'Text', 'wcrp-rental-products' ),
					'id'	=> 'wcrp-rental-products-settings-title-text', // ID of div not an input
					'type'	=> 'title',
					'desc'	=> esc_html__( 'Configure the most commonly used text references.', 'wcrp-rental-products' ) . ' ' . esc_html__( 'Want to translate text?', 'wcrp-rental-products' ) . ' <a href="#TB_inline?&width=600&height=550&inlineId=wcrp-rental-products-settings-translation-info" class="thickbox">' . esc_html__( 'click here', 'wcrp-rental-products' ) . '</a>' . esc_html__( '.', 'wcrp-rental-products' ) . $thickbox,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Availability checker applied text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_availability_checker_applied',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used when availability checker applied. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_availability_checker_applied</span>', __( 'Rental products will now show availability for your selected dates.', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Check availability text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_check_availability',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to check availability. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_check_availability</span>', __( 'Check availability', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Disable rental start/end dates notice text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_disable_rental_start_end_dates_notice_text',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for disable rental start/end dates notice. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_disable_rental_start_end_dates_notice</span>', __( 'Rentals cannot start/end on highlighted days.', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Disable rental start/end days notice text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_disable_rental_start_end_days_notice_text',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for disable rental start/end days notice. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_disable_rental_start_end_days_notice</span>', __( 'Rentals cannot start/end on', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'In person pick up/return text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_in_person_pick_up_return',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to in person pick up/return. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_in_person_pick_up_return</span>', __( 'In person pick up/return', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Non-refundable text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_non_refundable',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to non-refundable. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_non_refundable</span>', __( 'Non-refundable', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Pick up date text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_pick_up_date',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to pick up date. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_pick_up_date</span>', __( 'Pick up date', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Pick up time text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_pick_up_time',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to pick up time. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_pick_up_time</span>', __( 'Pick up time', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Refundable text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_refundable',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to refundable. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_refundable</span>', __( 'Refundable', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rent for text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_rent_for',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to rent for. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_rent_for</span>', __( 'Rent for', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rent from text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_rent_from',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to rent from. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_rent_from</span>', __( 'Rent from', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rent to text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_rent_to',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to rent to. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_rent_to</span>', __( 'Rent to', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental available text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_rental_available',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to rental available. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_rental_available</span>', __( 'Rental available', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental cancelled text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_rental_cancelled',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to rental cancelled. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_rental_cancelled</span>', __( 'Rental cancelled', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental dates text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_rental_dates',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to rental dates. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_rental_dates</span>', __( 'Rental dates', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental period text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_rental_period',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to rental period. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_rental_period</span>', __( 'Rental period', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental return within text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_rental_return_within',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to rental return within. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_rental_return_within</span>', __( 'Rental return within', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental returned text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_rental_returned',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to rental returned. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_rental_returned</span>', __( 'Rental returned', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Rental unavailable text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_rental_unavailable',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to rental unavailable. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_rental_unavailable</span>', __( 'Rental unavailable', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Reset dates text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_reset_dates',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to reset dates. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_reset_dates</span>', __( 'Reset dates', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Return date text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_return_date',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to return date. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_return_date</span>', __( 'Return date', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Return time text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_return_time',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to return time. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_return_time</span>', __( 'Return time', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Security deposit text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_security_deposit',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to security deposit. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_security_deposit</span>', __( 'Security deposit', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'Select dates text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_select_dates',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to select dates. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_select_dates</span>', __( 'Select dates', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'View purchase options text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_view_purchase_options',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to view purchase options. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_view_purchase_options</span>', __( 'View purchase options', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'name'		=> esc_html__( 'View rental options text', 'wcrp-rental-products' ),
					'id'		=> 'wcrp_rental_products_text_view_rental_options',
					'type'		=> 'text',
					// translators: %1$s: filter, %2$s: recommended filter value
					'desc'		=> wp_kses_post( sprintf( __( 'Text used for references to view rental options. Note this can also be filtered via the %1$s filter. Recommended is "%2$s".', 'wcrp-rental-products' ), '<span class="wcrp-rental-products-tooltip-word-break">wcrp_rental_products_text_view_rental_options</span>', __( 'View rental options', 'wcrp-rental-products' ) ) ),
					'desc_tip'	=> true,
				);

				$rental_products_settings[] = array(
					'type'	=> 'sectionend',
				);

				return $rental_products_settings;

			} else {

				return $settings;

			}

		}

	}

}
