<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'WCRP_Rental_Products_Rentals_Dashboard' ) ) {

	class WCRP_Rental_Products_Rentals_Dashboard {

		public function __construct() {

			add_action( 'admin_menu', array( $this, 'menu_page' ) );

		}

		public function menu_page() {

			global $wpdb;

			// Count is each rental order item from and including the current date unless returned, excludes rentals which have been removed from rentals table e.g. refunded

			$count = $wpdb->get_var(
				$wpdb->prepare(
					"SELECT COUNT( DISTINCT( order_item_id ) ) FROM `{$wpdb->prefix}wcrp_rental_products_rentals` AS rentals WHERE NOT EXISTS( SELECT 1 FROM `{$wpdb->prefix}woocommerce_order_itemmeta` WHERE `meta_key` = 'wcrp_rental_products_returned' AND `meta_value` = 'yes' AND `order_item_id` = rentals.`order_item_id` ) AND `reserved_date` >= %s ORDER BY `reserved_date` ASC",
					gmdate( 'Y-m-d' )
				)
			);

			$count = ( $count > 0 ? ' <span class="awaiting-mod">' . number_format_i18n( $count ) . '</span>' : '' ); // Uses WordPress classes for update number pip

			add_submenu_page(
				'woocommerce',
				__( 'Rentals Dashboard', 'wcrp-rental-products' ),
				__( 'Rentals', 'wcrp-rental-products' ) . $count,
				'manage_woocommerce',
				'wcrp-rental-products-rentals',
				array( $this, 'render' ),
				2 // Under orders menu item
			);

		}

		public function render() {

			// Globals

			global $wpdb;

			// Tab

			if ( isset( $_GET['tab'] ) ) {

				$tab = sanitize_text_field( $_GET['tab'] );

				if ( empty( $tab ) ) {

					$tab = 'calendar';

				}

			} else {

				$tab = 'calendar';

			}

			// Colors

			$colors = self::colors();
					
			?>

			<div id="wcrp-rental-products-rentals" class="wrap">
				<h1 class="wp-heading-inline"><?php esc_html_e( 'Rentals Dashboard', 'wcrp-rental-products' ); ?></h1>
				<hr class="wp-header-end">
				<nav class="nav-tab-wrapper woo-nav-tab-wrapper">
					<a href="<?php echo esc_url_raw( remove_query_arg( 'calendar_archive', remove_query_arg( 'inventory_date', add_query_arg( 'tab', 'calendar' ) ) ) ); ?>" class="nav-tab<?php echo ( 'calendar' == $tab ? ' nav-tab-active' : '' ); ?>" title="<?php esc_html_e( 'Calendar', 'wcrp-rental-products' ); ?>"><span class="dashicons dashicons-calendar-alt"></span><?php esc_html_e( 'Calendar', 'wcrp-rental-products' ); ?></a>
					<a href="<?php echo esc_url_raw( remove_query_arg( 'calendar_archive', remove_query_arg( 'inventory_date', add_query_arg( 'tab', 'inventory' ) ) ) ); ?>" class="nav-tab<?php echo ( 'inventory' == $tab ? ' nav-tab-active' : '' ); ?>" title="<?php esc_html_e( 'Inventory', 'wcrp-rental-products' ); ?>"><span class="dashicons dashicons-screenoptions"></span><?php esc_html_e( 'Inventory', 'wcrp-rental-products' ); ?></a>
					<a href="<?php echo esc_url_raw( remove_query_arg( 'calendar_archive', remove_query_arg( 'inventory_date', add_query_arg( 'tab', 'tools' ) ) ) ); ?>" class="nav-tab<?php echo ( 'tools' == $tab ? ' nav-tab-active' : '' ); ?>" title="<?php esc_html_e( 'Tools', 'wcrp-rental-products' ); ?>"><span class="dashicons dashicons-admin-tools"></span><?php esc_html_e( 'Tools', 'wcrp-rental-products' ); ?></a>
					<a href="<?php echo esc_url( get_admin_url() . 'edit.php?s&post_status=all&post_type=shop_order&action=-1&wcrp_rental_products_rentals_filter=inc' ); ?>" class="nav-tab" target="_blank" title="<?php esc_html_e( 'Orders (opens in a new tab)', 'wcrp-rental-products' ); ?>"><span class="dashicons dashicons-cart"></span><?php esc_html_e( 'Orders*', 'wcrp-rental-products' ); ?></a>
					<a href="<?php echo esc_url( get_admin_url() . 'edit.php?s&post_status=all&post_type=product&action=-1&wcrp_rental_products_rentals_filter=all' ); ?>" class="nav-tab" target="_blank" title="<?php esc_html_e( 'Products (opens in a new tab)', 'wcrp-rental-products' ); ?>"><span class="dashicons dashicons-archive"></span><?php esc_html_e( 'Products*', 'wcrp-rental-products' ); ?></a>
					<a href="<?php echo esc_url( get_admin_url() . 'admin.php?page=wc-settings&tab=products&section=wcrp-rental-products' ); ?>" class="nav-tab" target="_blank" title="<?php esc_html_e( 'Settings (opens in a new tab)', 'wcrp-rental-products' ); ?>"><span class="dashicons dashicons-admin-settings"></span><?php esc_html_e( 'Settings*', 'wcrp-rental-products' ); ?></a>
					<?php if ( 'calendar' == $tab ) { ?>
						<div id="wcrp-rental-products-rentals-color-key" class="wcrp-rental-products-rentals-tab-info">
							<span><?php esc_html_e( 'Calendar of rentals. Color key (hover for info):', 'wcrp-rental-products' ); ?></span>
							<div style="background-color: <?php echo esc_html( $colors['blue_dark'] ); ?>" title="<?php esc_html_e( 'Rentals that span the current date except if they have been returned or are due to be returned and have not been', 'wcrp-rental-products' ); ?>"><?php esc_html_e( 'Current', 'wcrp-rental-products' ); ?></div>
							<div style="background-color: <?php echo esc_html( $colors['blue'] ); ?>" title="<?php esc_html_e( 'Rentals that occur on future dates', 'wcrp-rental-products' ); ?>"><?php esc_html_e( 'Future', 'wcrp-rental-products' ); ?></div>
							<div style="background-color: <?php echo esc_html( $colors['green'] ); ?>" title="<?php esc_html_e( 'Rentals that have been returned', 'wcrp-rental-products' ); ?>"><?php esc_html_e( 'Returned', 'wcrp-rental-products' ); ?></div>
							<div style="background-color: <?php echo esc_html( $colors['red'] ); ?>" title="<?php esc_html_e( 'Rentals that have not been returned and are due', 'wcrp-rental-products' ); ?>"><?php esc_html_e( 'Not returned', 'wcrp-rental-products' ); ?></div>
						</div>
					<?php } elseif ( 'inventory' == $tab ) { ?>
						<div id="wcrp-rental-products-rentals-inventory-info">
							<p><strong><?php esc_html_e( 'The inventory shows the rental stock totals of all published rental products based on the inventory date specified.', 'wcrp-rental-products' ); ?></strong></p>
							<p><strong><?php esc_html_e( 'How are they calculated?', 'wcrp-rental-products' ); ?></strong></p>
							<p><?php esc_html_e( 'The rental stock total is as set on the product, the rental stock in/out totals are calculated by getting all rentals for that product on the inventory date and querying whether they are out with a customer or have been marked as returned.', 'wcrp-rental-products' ); ?></p>
							<p><?php esc_html_e( 'As the inventory can be used to view rental stock totals for dates in the future the rental stock totals shown are estimated based on the assumption that rentals prior have been returned.', 'wcrp-rental-products' ); ?></p>
							<p><?php esc_html_e( 'For example, if a product has rental stock of 1, a customer rents the product on January 1st and another customer rents the product on February 1st then if the inventory date is set to February 1st it will assume the January 1st rental has been returned and will show rental stock total: 1, rental stock in: 0, rental stock out: 1.', 'wcrp-rental-products' ); ?></p>
							<p><?php esc_html_e( 'Due to this the rental stock totals in the inventory should be considered estimates.', 'wcrp-rental-products' ); ?></p>
							<p><strong><?php esc_html_e( 'What about in person pick up/return?', 'wcrp-rental-products' ); ?></strong></p>
							<p><?php esc_html_e( 'The same calculations as described above apply to rental products which have in person pick up/return enabled.', 'wcrp-rental-products' ); ?></p>
							<p><?php esc_html_e( 'Where an in person return is due to be returned this is considered as not out.', 'wcrp-rental-products' ); ?></p>
							<p><?php esc_html_e( 'For example, if a product has in person pick up/return enabled, in person return date is same day and has rental stock of 1, a customer rents the product on 1st-2nd January and another customer rents the product on 2nd January then if the inventory date is set to 2nd January it will assume the 1st-2nd January rental has been returned and the 2nd January rental is out and will show rental stock total: 1, rental stock in: 0, rental stock out 1.', 'wcrp-rental-products' ); ?></p>
							<p><strong><?php esc_html_e( 'Why do I have negative rental stock totals?', 'wcrp-rental-products' ); ?></strong></p>
							<p><?php esc_html_e( 'Rental stock totals in the inventory may display negative temporarily if the product has been edited to reduce rental stock and more than the new rental stock set was already reserved on the inventory date set.', 'wcrp-rental-products' ); ?></p>
						</div>
						<div class="wcrp-rental-products-rentals-tab-info">
							<?php
							// translators: %s: inventory info link
							echo wp_kses_post( sprintf( __( 'Inventory of all published rental products. %s on rental stock totals calculation.', 'wcrp-rental-products' ), '<a href="#TB_inline?&width=600&height=550&inlineId=wcrp-rental-products-rentals-inventory-info" class="thickbox">' . esc_html__( 'Click here for details', 'wcrp-rental-products' ) . '</a>' ) );
							?>
						</div>
					<?php } elseif ( 'tools' == $tab ) { ?>
						<div class="wcrp-rental-products-rentals-tab-info">
							<?php esc_html_e( 'Various tools which can be used for rental product management purposes.', 'wcrp-rental-products' ); ?>
						</div>
					<?php } ?>
				</nav>

				<?php

				if ( 'calendar' == $tab ) {

					require_once __DIR__ . '/partials/rentals-dashboard/calendar.php';

				} elseif ( 'inventory' == $tab ) {

					require_once __DIR__ . '/partials/rentals-dashboard/inventory.php';

				} elseif ( 'tools' == $tab ) {

					require_once __DIR__ . '/partials/rentals-dashboard/tools.php';

				}

				?>

				<div class="wcrp-rental-products-rentals-footer">
					<div><a href="#" class="button button-small"><?php esc_html_e( 'Back to top', 'wcrp-rental-products' ); ?></a></div>
					<div>
						<?php
						// translators: %s version number
						echo sprintf ( esc_html__( 'You are using Rental Products v%s', 'wcrp-rental-products' ), esc_html( WCRP_RENTAL_PRODUCTS_VERSION ) );
						?>
					</div>
					<div><a href="#" class="button button-small"><?php esc_html_e( 'Back to top', 'wcrp-rental-products' ); ?></a></div>
				</div>

			</div>

			<?php

		}

		public static function colors() {

			return array(
				'blue'				=> '#2271b1',
				'blue_dark'			=> '#103656',
				'green'				=> '#00a32a',
				'red'				=> '#d63638',
			);

		}

		public static function calendar_events() {

			global $wpdb;

			$events = array();
			$colors = self::colors();
			$order_item_ids = $wpdb->get_results( "SELECT DISTINCT( order_item_id ) FROM `{$wpdb->prefix}wcrp_rental_products_rentals`;" );

			if ( isset( $_GET['calendar_archive'] ) ) {

				if ( 'include' == $_GET['calendar_archive'] ) {

					$order_item_ids_archived = $wpdb->get_results( "SELECT DISTINCT( order_item_id ) FROM `{$wpdb->prefix}wcrp_rental_products_rentals_archive`;" );

					if ( !empty( $order_item_ids_archived ) ) {

						$order_item_ids = (object) array_merge( (array) $order_item_ids, (array) $order_item_ids_archived );

					}

				}

			}

			foreach ( $order_item_ids as $order_item_id ) {
			
				$order_item_id = $order_item_id->order_item_id;

				$event_data = $wpdb->get_results(
					$wpdb->prepare(
						"SELECT MIN(`reserved_date`) as min_date, MAX(`reserved_date`) as max_date, order_id, product_id, quantity FROM `{$wpdb->prefix}wcrp_rental_products_rentals` WHERE order_item_id = %d;",
						$order_item_id
					)
				);

				if ( isset( $_GET['calendar_archive'] ) ) {

					if ( 'include' == $_GET['calendar_archive'] ) {
	
						if ( empty( $event_data[0]->min_date ) ) { // If no event data in rentals event data, it is in the archive event data

							$event_data = $wpdb->get_results(
								$wpdb->prepare(
									"SELECT MIN(`reserved_date`) as min_date, MAX(`reserved_date`) as max_date, order_id, product_id, quantity FROM `{$wpdb->prefix}wcrp_rental_products_rentals_archive` WHERE order_item_id = %d;",
									$order_item_id
								)
							);

						}
	
					}
	
				}

				if ( !empty( $event_data ) ) {

					$order_item_in_person_pick_up_return = wc_get_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_pick_up_return', true );
					$order_item_in_person_pick_up_time = wc_get_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_pick_up_time', true );
					$order_item_in_person_return_date = wc_get_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_return_date', true );
					$order_item_in_person_return_time = wc_get_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_return_time', true );
					$order_item_return_days = wc_get_order_item_meta( $order_item_id, 'wcrp_rental_products_return_days_threshold', true );
					$order_item_returned = wc_get_order_item_meta( $order_item_id, 'wcrp_rental_products_returned', true );

					$pa_meta = $wpdb->get_results(
						$wpdb->prepare(
							"SELECT meta_key, meta_value FROM `{$wpdb->prefix}woocommerce_order_itemmeta` WHERE `order_item_id` = %d AND `meta_key` LIKE %s;",
							$order_item_id,
							$wpdb->esc_like( 'pa_' ) . '%'
						)
					);
			
					if ( !empty( $pa_meta ) ) {
			
						$pa_meta_string = '';
			
						foreach ( $pa_meta as $pm ) {
			
							$pa_meta_string .= ucwords( str_replace( '_', ' ', str_replace( 'pa_', '', $pm->meta_key ) ) ) . ': ' . ucwords( $pm->meta_value ) . ', ';
			
						}
			
						$pa_meta_string = rtrim( $pa_meta_string, ', ' );
			
					} else {
			
						$pa_meta_string = '';
			
					}

					if ( 'yes' !== $order_item_in_person_pick_up_return ) {

						// If not an in person pick up/return - set rental start/end date variables

						$rental_start_date = esc_html( $event_data[0]->min_date );
						$rental_end_date = gmdate( 'Y-m-d', strtotime( esc_html( $event_data[0]->max_date ) . ' -' . $order_item_return_days . ' days' ) );
						$rental_end_date = gmdate( 'Y-m-d', strtotime( $rental_end_date . ' +1 day' ) ); // Adds a day to the date as if 2020-01-05 this is at 00:00 and FullCalendar would stop the event row on 2020-01-04, this would also occur with calendar applications via the calendar feed if not done

						// If not an in person pick up/return - set return start/end date variables

						$return_start_date = $rental_end_date;
						$return_end_date = esc_html( $event_data[0]->max_date );
						$return_end_date = gmdate( 'Y-m-d', strtotime( $return_end_date . ' +1 day' ) ); // Adds a day to the date as if 2020-01-05 this is at 00:00 and FullCalendar would stop the event row on 2020-01-04, this would also occur with calendar applications via the calendar feed if not done

					} else {

						// If an in person pick up/return - set rental start/end date variables

						$rental_start_date = esc_html( $event_data[0]->min_date ); 
						$rental_end_date = esc_html( $event_data[0]->max_date );// No $order_item_return_days to be subtracted as an in person pick up/returns have 0 return days

						if ( $event_data[0]->max_date !== $order_item_in_person_return_date ) { // Without this condition in person pick up/return rentals with an in person return date of next day would not span the correct number of days

							$rental_end_date = gmdate( 'Y-m-d', strtotime( $rental_end_date . ' +1 day' ) ); // Adds a day to the date as if 2020-01-05 this is at 00:00 and FullCalendar would stop the event row on 2020-01-04, this would also occur with calendar applications via the calendar feed if not done

						}

						// If an in person pick up/return - set return start/end date variables

						$return_start_date = $order_item_in_person_return_date;
						$return_end_date = $order_item_in_person_return_date; // No extra day added like the above because in person return dates are singular, they do not span multiple days

					}
			
					$product_title = ( empty( wp_get_post_parent_id( esc_html( $event_data[0]->product_id ) ) ) ? get_the_title( esc_html( $event_data[0]->product_id ) ) : get_the_title( wp_get_post_parent_id( esc_html( $event_data[0]->product_id ) ) ) ); // If a variation use the parent product title (as get_the_title for variations includes for example Product Name - Blue), also see getting the meta later in the foreach

					$order_id = esc_html( $event_data[0]->order_id );
					$product_id = esc_html( $event_data[0]->product_id );
					$order_status = get_post_status( $order_id );
					$order_status_name = wc_get_order_status_name( $order_status );
					$order_status_no_prefix = str_replace( 'wc-', '', $order_status );
					$quantity = esc_html( $event_data[0]->quantity );
			
					$customer_name = '';
					$customer_first_name = get_post_meta( $order_id, '_billing_first_name', true );
					$customer_last_name = get_post_meta( $order_id, '_billing_last_name', true );
					$customer_company = get_post_meta( $order_id, '_billing_company', true );
			
					if ( !empty( $customer_first_name ) || !empty( $customer_last_name ) ) {
			
						if ( !empty( $customer_first_name ) ) {
			
							$customer_name .= $customer_first_name;
			
						}

						if ( !empty( $customer_last_name ) ) {
			
							$customer_name .= ' ' . $customer_last_name;

						}

					} elseif ( !empty( $customer_company ) ) {

						$customer_name .= $customer_company;

					}

					// Set color/key class

					if ( 'yes' == $order_item_returned ) {

						$color = esc_html( $colors['green'] );
						$color_class = 'wcrp-rental-products-rentals-fc-event-key-returned';

					} elseif ( 'yes' !== $order_item_in_person_pick_up_return && time() > strtotime( gmdate( 'Y-m-d', strtotime( $return_end_date . ' -1 day' ) ) ) ) { // Comparison has to be -1 day to ensure comparison correct due to the extra day added to $return_end_date earlier, see comments where $return_end_date set above

						$color = esc_html( $colors['red'] );
						$color_class = 'wcrp-rental-products-rentals-fc-event-key-not-returned';

					} elseif ( 'yes' == $order_item_in_person_pick_up_return && time() > strtotime( $order_item_in_person_return_date ) ) {

						$color = esc_html( $colors['red'] );
						$color_class = 'wcrp-rental-products-rentals-fc-event-key-not-returned';

					} elseif ( 'yes' !== $order_item_in_person_pick_up_return && time() > strtotime( $rental_start_date ) && time() < strtotime( gmdate( 'Y-m-d', strtotime( $return_end_date . ' -1 day' ) ) ) ) { // Comparison has to be -1 day to ensure comparison correct due to the extra day added to $return_end_date earlier, see comments where $return_end_date set above

						$color = esc_html( $colors['blue_dark'] );
						$color_class = 'wcrp-rental-products-rentals-fc-event-key-current';

					} elseif ( 'yes' == $order_item_in_person_pick_up_return && time() > strtotime( $rental_start_date ) && time() < strtotime( $return_end_date ) ) { // Comparison does not have to be -1 day because a day not subtracted for in person pick up return, see comments where $return_end_date set above

						$color = esc_html( $colors['blue_dark'] );
						$color_class = 'wcrp-rental-products-rentals-fc-event-key-current';
						
					} else {

						$color = esc_html( $colors['blue'] );
						$color_class = 'wcrp-rental-products-rentals-fc-event-key-future';

					}
			
					// Event - rental
			
					$events[] = array(
						'class'				=> 'wcrp-rental-products-rentals-fc-event wcrp-rental-products-rentals-fc-event-type-rental ' . $color_class . ' wcrp-rental-products-rentals-fc-event-order-status-' . $order_status_no_prefix,
						'color'				=> $color,
						'customer_name'		=> $customer_name,
						'end'				=> $rental_end_date,
						'order_id'			=> $order_id,
						'order_status'		=> $order_status,
						'order_status_name'	=> $order_status_name,
						'pa_meta'			=> $pa_meta_string,
						'product_id'		=> $product_id,
						'product_title'		=> $product_title,
						'quantity'			=> $quantity,
						'start'				=> $rental_start_date . ( 'yes' == $order_item_in_person_pick_up_return ? WCRP_Rental_Products_Misc::four_digit_time_convert_to_iso_string( $order_item_in_person_pick_up_time ) : '' ),
						'type'				=> 'rental'
					);
			
					if ( $order_item_return_days > 0 || 'yes' == $order_item_in_person_pick_up_return ) {
			
						// Event - return

						$events[] = array(
							'class'				=> 'wcrp-rental-products-rentals-fc-event wcrp-rental-products-rentals-fc-event-type-return ' . $color_class . ' wcrp-rental-products-rentals-fc-event-order-status-' . $order_status_no_prefix,
							'color'				=> $color,
							'customer_name'		=> $customer_name,
							'end'				=> $return_end_date . ( 'yes' == $order_item_in_person_pick_up_return ? WCRP_Rental_Products_Misc::four_digit_time_convert_to_iso_string( $order_item_in_person_return_time ) : '' ),
							'order_id'			=> $order_id,
							'order_status'		=> $order_status,
							'order_status_name'	=> $order_status_name,
							'pa_meta'			=> $pa_meta_string,
							'product_id'		=> $product_id,
							'product_title'		=> $product_title,
							'quantity'			=> $quantity,
							'start'				=> $return_start_date . ( 'yes' == $order_item_in_person_pick_up_return ? WCRP_Rental_Products_Misc::four_digit_time_convert_to_iso_string( $order_item_in_person_return_time ) : '' ),
							'type'				=> 'return'
						);
			
					}
			
				}
			
			}

			return $events;

		}

		public static function calendar_event_name( $event, $public ) {

			$name = '';

			if ( !empty( $event ) ) {

				$name = $event['quantity'] . ' ' . esc_html__( 'x', 'wcrp-rental-products' ) . ' ' . esc_html( $event['product_title'] ) . ( !empty( $event['pa_meta'] ) ? ' ' . esc_html__( '(', 'wcrp-rental-products' ) . esc_html( $event['pa_meta'] ) . esc_html__( ')', 'wcrp-rental-products' ) : '' ) . ' ' . esc_html__( '#', 'wcrp-rental-products' ) . esc_html( $event['product_id'] ) . ' ' . esc_html__( '/', 'wcrp-rental-products' ) . ' ' . esc_html__( 'Order #', 'wcrp-rental-products' ) . esc_html( $event['order_id'] ) . ' ' . ( false == $public ? wp_kses_post( !empty( $event['customer_name'] ) ? ' ' . $event['customer_name'] . ' ' : ' ' ) : '' ) . esc_html__( '(', 'wcrp-rental-products' ) . esc_html( $event['order_status_name'] ) . esc_html__( ')', 'wcrp-rental-products' ) . ( 'return' == $event['type'] ? ' ' . esc_html__( '-', 'wcrp-rental-products' ) . ' ' . esc_html__( 'Return expected', 'wcrp-rental-products' ) : '' );

			}

			return $name;

		}

		public function inventory_row_data( $product_id, $inventory_date ) {

			global $wpdb;

			$rental_stock = get_post_meta( $product_id, '_wcrp_rental_products_rental_stock', true );
			$rental_stock_total = ( '' == $rental_stock ? esc_html__( 'Unlimited', 'wcrp-rental-products' ) : (int) $rental_stock );
			$rental_stock_out = 0;
			$rental_stock_returned = 0;

			// Get rentals on inventory date from rentals database table, note that there is no need to also query and combine the rentals archive database table data as already returned (e.g. effectively no rental on that date), it is no longer in the rentals database table so is not taken into account in the rental stock out, returned, etc totals (returned total not getting added to does not matter as the rental is not in the rentals database table anymore)

			$rentals_on_date = $wpdb->get_results(
				$wpdb->prepare(
					"SELECT * FROM `{$wpdb->prefix}wcrp_rental_products_rentals` WHERE `product_id` = %d AND `reserved_date` = %s;",
					$product_id,
					$inventory_date
				)
			);

			foreach ( $rentals_on_date as $rental_on_date ) {

				// Add the quantity reserved in the date to the rental stock out total

				$rental_stock_out = (int) $rental_stock_out + (int) $rental_on_date->quantity;

				// If the rental was returned add the quantity to the rental stock returned total (to be subtracted later)

				if ( 'yes' == wc_get_order_item_meta( $rental_on_date->order_item_id, 'wcrp_rental_products_returned', true ) ) {

					$rental_stock_returned = (int) $rental_stock_returned + (int) $rental_on_date->quantity;

				}

				// If the rental is an in person pick up/return with an in person return date of same day then this should not be considered that the rental stock is out and therefore the quantity is removed from the rental stock out total, this is because in this scenario the rent to date is a reserved date for the quantity, but it's being returned on that date, without this if a in person return date same day rental has 1 stock, 1 is rented 2023-01-01 to 2023-01-03, on 2023-01-03 the inventory would show total 1, in 0 and out 1, but on 2023-01-03 it is being returned and available again to other customers after the return time, details of this a displayed in the inventory info

				if ( 'yes' == wc_get_order_item_meta( $rental_on_date->order_item_id, 'wcrp_rental_products_in_person_pick_up_return', true ) ) {

					$in_person_return_date = wc_get_order_item_meta( $rental_on_date->order_item_id, 'wcrp_rental_products_in_person_return_date', true );

					if ( wc_get_order_item_meta( $rental_on_date->order_item_id, 'wcrp_rental_products_rent_to', true ) == $in_person_return_date ) {

						if ( $in_person_return_date == $rental_on_date->reserved_date ) {

							$rental_stock_out = (int) $rental_stock_out - (int) $rental_on_date->quantity;

						}

					}

				}

			}

			$rental_stock_out = (int) $rental_stock_out - (int) $rental_stock_returned;
			$rental_stock_in = ( is_int( $rental_stock_total ) ? $rental_stock_total - $rental_stock_out : $rental_stock_total ); // Is int condition is because it can either be int or unlimited string

			$product_title = get_the_title( $product_id );

			if ( 'product_variation' == get_post_type( $product_id ) ) {

				$product_title .= ' ' . esc_html__( '-', 'wcrp-rental-products' ) . ' ' . get_the_excerpt( $product_id );

			}

			$parent_id = wp_get_post_parent_id( $product_id );

			$sku = get_post_meta( $product_id, '_sku', true );
			$sku = ( !empty( $sku ) ? $sku : esc_html__( '-', 'wcrp-rental-products' ) );

			$row_data = array(
				'product'				=> $product_title,
				'id'					=> $product_id,
				'parent_id'				=> $parent_id,
				'sku'					=> $sku,
				'rental_stock_total'	=> $rental_stock_total,
				'rental_stock_in'		=> $rental_stock_in,
				'rental_stock_out'		=> $rental_stock_out,
			);

			return $row_data;

		}

	}

}
