<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'WCRP_Rental_Products_Product_Rental_Form' ) ) {

	class WCRP_Rental_Products_Product_Rental_Form {

		public function __construct() {

			add_action( 'woocommerce_before_add_to_cart_form', array( $this, 'rental_form_wrap_start' ), 0 );
			add_action( 'woocommerce_after_add_to_cart_form', array( $this, 'rental_form_wrap_end' ), PHP_INT_MAX );
			add_action( 'woocommerce_before_add_to_cart_button', array( $this, 'rental_form' ) ); // This is used rather than woocommerce_before_add_to_cart_quantity as Product Add-ons uses woocommerce_before_add_to_cart_button too and someone may wish to filter the priority on this to reposition the rental form before/after add-ons or for other extensions
			add_action( 'woocommerce_after_add_to_cart_quantity', array( $this, 'rental_form' ) );
			add_action( 'wp_ajax_wcrp_rental_products_rental_form_update', array( $this, 'rental_form_update' ) );
			add_action( 'wp_ajax_nopriv_wcrp_rental_products_rental_form_update', array( $this, 'rental_form_update' ) );
			add_action( 'wp_ajax_wcrp_rental_products_rental_form_add_to_order', array( $this, 'rental_form_add_to_order' ) );
			add_action( 'wp_ajax_nopriv_wcrp_rental_products_rental_form_add_to_order', array( $this, 'rental_form_add_to_order' ) );
			add_filter( 'woocommerce_ajax_variation_threshold', array( $this, 'ajax_variation_threshold' ), PHP_INT_MAX, 2 );
			add_filter( 'run_wptexturize', '__return_false' ); // Temporary fix to an issue found with (assumedly) block themes such as Twenty Twenty Three, it was found that the URLs dynamically generated via inline JS for the pricing period selection option values get the &example=1 to #038;example=1, this appears to be a core bug and occurs when there are certain characters in inline <script> tags and potentially something to do with block themes running all the code output through wptexturize, see: https://core.trac.wordpress.org/ticket/45387#comment:11, returning false for run_wptexturize stops this occuring, however this filter removed if this core issue gets resolved in future, non-block themes seem to be unaffected hence why it wasn't picked up until recently

			$this->rental_form_id = uniqid(); // Ensures if multiple rental forms on page (e.g. quick view of other products) the elements within are targeted instead of the other instances - form names do not matter as submitted
            $_POST['rental_form_id'] = $this->rental_form_id;
		}

		public function rental_form_wrap_start() {

			global $post;

			if ( wcrp_rental_products_is_rental_only( $post->ID ) || wcrp_rental_products_is_rental_purchase( $post->ID ) ) {

				// This is used around the cart form so when targetting elements like .cart input[name="quantity"] within it then it is based on this parent wrap, if the cart form is included in the page multiple times (e.g. for quick view functionality) the fields for this specific form are targetted not others. Input fields within the form also include this ID, we target off these individually not from this wrap for leaner code and to ensure those elements have an ID alongside a less specific class so they can potentially be styled (can't style an element using a unique ID that changes)

				echo '<div id="wcrp-rental-products-rental-form-wrap-' . esc_html( $this->rental_form_id ) . '" class="wcrp-rental-products-rental-form-wrap">';

			}

		}

		public function rental_form_wrap_end() {

			global $post;

			if ( wcrp_rental_products_is_rental_only( $post->ID ) || wcrp_rental_products_is_rental_purchase( $post->ID ) ) {

				echo '</div>';

			}

		}

		public function rental_form() {
			global $post;

			$product = wc_get_product( $post );
			$product_id = $product->get_id();
			$product_price = wc_get_price_to_display( $product ); // This is the WooCommerce standard price inc or exc tax depending on tax settings, if a rental only product this is the rental price, if this is a rental or purchase product this is the purchasable price
			$product_sold_individually = $product->get_sold_individually();
			$product_tax_class = $product->get_tax_class(); // May have been overridden earlier via cart_item_rental_purchase_overrides()
			$product_tax_status = $product->get_tax_status();
			$product_type = $product->get_type();
			$product_url = $product->get_permalink();
			$product_url_preview = get_preview_post_link( $product_id );

			if ( 'simple' == $product_type || 'variable' == $product_type ) {

				$display_after_quantity = get_option( 'wcrp_rental_products_rental_form_after_quantity' );

				if ( 'yes' == $display_after_quantity ) {
	
					if ( 'woocommerce_after_add_to_cart_quantity' !== current_action() ) {
	
						return;
	
					}
	
				} else {
	
					if ( 'woocommerce_after_add_to_cart_quantity' == current_action() ) {
	
						return;
	
					}
	
				}
	
				$advanced_configuration = wcrp_rental_products_advanced_configuration();
				$auto_apply = get_option( 'wcrp_rental_products_rental_form_auto_apply' );
				$auto_select_end_date = get_option( 'wcrp_rental_products_rental_form_auto_select_end_date' );
				$currency_position = get_option( 'woocommerce_currency_pos' );
				$currency_symbol = get_woocommerce_currency_symbol();
				$default_rental_options = wcrp_rental_products_default_rental_options();
				$period_selection_option_labels = get_option( 'wcrp_rental_products_rental_form_period_selection_option_labels' );
				$prices_include_tax = get_option( 'woocommerce_prices_include_tax' );
				$price_decimals = wc_get_price_decimals();
				$price_decimal_separator = wc_get_price_decimal_separator();
				$reset_button = get_option( 'wcrp_rental_products_rental_form_reset_button' );
				$return_days_display = get_option( 'wcrp_rental_products_return_days_display' );
				$start_end_notices = get_option( 'wcrp_rental_products_rental_form_start_end_notices' );
				$taxes_enabled = get_option( 'woocommerce_calc_taxes' );
				$tax_display_shop = get_option( 'woocommerce_tax_display_shop' );

				$product_taxes = WC_Tax::get_rates( $product_tax_class );

				if ( !empty( $product_taxes ) ) { // This ensures array_shift does not cause fatal error if empty, WooCommerce Tax extension can return this empty when the automated taxes option is enabled
	
					$product_tax_rates = array_shift( $product_taxes );
					$product_tax_rate = array_shift( $product_tax_rates );

				} else {

					$product_tax_rate = 0;

				}

				// Rent - this flags if the rent=1 query var exists, used for rental or purchase products, it's not a means of flagging if a product is a rental, it simply flags that the rent=1 query var is present on the current page to help with conditions differentiating between the rental or pruchase part of a rental or purchase product

				$rent = false;

				if ( isset( $_GET['rent'] ) ) {

					if ( '1' == $_GET['rent'] ) {

						$rent = true;

					}

				}

				// Rent period - this flags if the rent_period=x query var exists and sets it to the value

				$rent_period = false;

				if ( isset( $_GET['rent_period'] ) ) {

					$rent_period = sanitize_text_field( $_GET['rent_period'] );

				}

				// Rent period qty - this flags if the rent_period_qty=x query var exists and sets it to the value

				$rent_period_qty = false;

				if ( isset( $_GET['rent_period_qty'] ) ) {

					$rent_period_qty = sanitize_text_field( $_GET['rent_period_qty'] );

				}

				// Disable add-ons conditionally for either part of rental or purchase products if disabled

				require_once ABSPATH . 'wp-admin/includes/plugin.php';

				if ( is_plugin_active( 'woocommerce-product-addons/woocommerce-product-addons.php' ) ) {

					if ( wcrp_rental_products_is_rental_purchase( $product_id ) ) { ?>

						<style>
								
							<?php

							$disable_addons_rental_purchase_rental = get_post_meta( $product_id, '_wcrp_rental_products_disable_addons_rental_purchase_rental', true );
							$disable_addons_rental_purchase_rental = ( '' !== $disable_addons_rental_purchase_rental ? $disable_addons_rental_purchase_rental : $default_rental_options['_wcrp_rental_products_disable_addons_rental_purchase_rental'] );

							$disable_addons_rental_purchase_purchase = get_post_meta( $product_id, '_wcrp_rental_products_disable_addons_rental_purchase_purchase', true );
							$disable_addons_rental_purchase_purchase = ( '' !== $disable_addons_rental_purchase_purchase ? $disable_addons_rental_purchase_purchase : $default_rental_options['_wcrp_rental_products_disable_addons_rental_purchase_purchase'] );

							if ( 'yes' == $disable_addons_rental_purchase_rental ) {

								if ( true == $rent ) {

									?>

									.wc-pao-addons-container {
										display: none !important;
									}

									<?php

								}

							}

							if ( 'yes' == $disable_addons_rental_purchase_purchase ) {

								if ( false == $rent ) {

									?>

									.wc-pao-addons-container {
										display: none !important;
									}

									<?php

								}

							}

							?>

						</style>

						<?php

					}
				
				}

				// Hide stock level and add-ons totals for rental products (simple products and variation price/availability for variations) as overriden by rental stock/price, this occurs if the rental form is showing or if the rental form nonce is set, the latter is used because on adding a rental or purchase rental to cart the page gets reloaded and is the initial page before the rental form (as if the rental option has not been clicked previously)

				if ( wcrp_rental_products_is_rental_only( $product_id ) || ( wcrp_rental_products_is_rental_purchase( $product_id ) && true == $rent ) || ( isset( $_POST['wcrp_rental_products_rental_form_nonce'] ) && wp_verify_nonce( sanitize_key( $_POST['wcrp_rental_products_rental_form_nonce'] ), 'wcrp_rental_products_rental_form' ) ) ) {
					?>

					<style>

						<?php // Hide stock level for simple products and variation price/availability for variations as overriden by rental stock/price ?>
                        #collapseOne .stock,
                        #collapseOne .woocommerce-variation-price,
                        #collapseOne .woocommerce-variation-availability {
                            display: none !important;
                        }

						<?php

						require_once ABSPATH . 'wp-admin/includes/plugin.php';

						if ( is_plugin_active( 'woocommerce-product-addons/woocommerce-product-addons.php' ) ) {

							// Hide the product add-ons total as it displays the product price as a non rental price as it isn't aware of the rental pricing

							?>

							#product-addons-total {
								display: none !important;
							}

						<?php } ?>

					</style>

					<?php 

				}

				if ( wcrp_rental_products_is_rental_only( $product_id ) || ( wcrp_rental_products_is_rental_purchase( $product_id ) && true == $rent ) ) {

					// Checked against '' as a meta value could potentially be 0 which would trigger an empty condition and use the default instead of 0 (e.g. start days can be 0), if get_post_meta is empty or does not exist it returns ''

					$pricing_type = get_post_meta( $product_id, '_wcrp_rental_products_pricing_type', true );
					$pricing_type = ( '' !== $pricing_type ? $pricing_type : $default_rental_options['_wcrp_rental_products_pricing_type'] );

					$pricing_period = get_post_meta( $product_id, '_wcrp_rental_products_pricing_period', true );
					$pricing_period = ( '' !== $pricing_period ? $pricing_period : $default_rental_options['_wcrp_rental_products_pricing_period'] );

					$pricing_period_multiples = get_post_meta( $product_id, '_wcrp_rental_products_pricing_period_multiples', true );
					$pricing_period_multiples = ( '' !== $pricing_period_multiples ? $pricing_period_multiples : $default_rental_options['_wcrp_rental_products_pricing_period_multiples'] );

					$pricing_period_multiples_maximum = get_post_meta( $product_id, '_wcrp_rental_products_pricing_period_multiples_maximum', true );
					$pricing_period_multiples_maximum = ( '' !== $pricing_period_multiples_maximum ? $pricing_period_multiples_maximum : $default_rental_options['_wcrp_rental_products_pricing_period_multiples_maximum'] );

					$pricing_period_additional_selections = get_post_meta( $product_id, '_wcrp_rental_products_pricing_period_additional_selections', true );
					$pricing_period_additional_selections = ( '' !== $pricing_period_additional_selections ? $pricing_period_additional_selections : $default_rental_options['_wcrp_rental_products_pricing_period_additional_selections'] );
					$pricing_period_additional_selections_array = WCRP_Rental_Products_Misc::value_colon_price_pipe_explode( $pricing_period_additional_selections, false );

					$pricing_tiers = get_post_meta( $product_id, '_wcrp_rental_products_pricing_tiers', true );
					$pricing_tiers = ( '' !== $pricing_tiers ? $pricing_tiers : $default_rental_options['_wcrp_rental_products_pricing_tiers'] );

					$pricing_tiers_data = get_post_meta( $product_id, '_wcrp_rental_products_pricing_tiers_data', true );
					$pricing_tiers_data = ( '' !== $pricing_tiers_data ? $pricing_tiers_data : $default_rental_options['_wcrp_rental_products_pricing_tiers_data'] );

					$price_additional_periods_percent = get_post_meta( $product_id, '_wcrp_rental_products_price_additional_periods_percent', true );
					$price_additional_periods_percent = ( '' !== $price_additional_periods_percent ? $price_additional_periods_percent : $default_rental_options['_wcrp_rental_products_price_additional_periods_percent'] );

					$price_additional_period_percent = get_post_meta( $product_id, '_wcrp_rental_products_price_additional_period_percent', true );
					$price_additional_period_percent = ( '' !== $price_additional_period_percent ? $price_additional_period_percent : $default_rental_options['_wcrp_rental_products_price_additional_period_percent'] );

					if ( 'period_selection' == $pricing_type ) {

						// Total overrides are not used for the period selection pricing type, this is condition exists because the meta may still exist containing total overrides when product was previously a different pricing type

						$total_overrides = '';
						$total_overrides_json = '[]';

					} else {

						$total_overrides = get_post_meta( $product_id, '_wcrp_rental_products_total_overrides', true );
						$total_overrides = ( '' !== $total_overrides ? $total_overrides : $default_rental_options['_wcrp_rental_products_total_overrides'] );
						$total_overrides_json = WCRP_Rental_Products_Misc::value_colon_price_pipe_explode( $total_overrides, true );

					}

					$in_person_pick_up_return = get_post_meta( $product_id, '_wcrp_rental_products_in_person_pick_up_return', true );
					$in_person_pick_up_return = ( '' !== $in_person_pick_up_return ? $in_person_pick_up_return : $default_rental_options['_wcrp_rental_products_in_person_pick_up_return'] );

					$in_person_return_date = get_post_meta( $product_id, '_wcrp_rental_products_in_person_return_date', true );
					$in_person_return_date = ( ( '' !== $in_person_return_date && 'default' !== $in_person_return_date ) ? $in_person_return_date : $default_rental_options['_wcrp_rental_products_in_person_return_date'] );

					$in_person_pick_up_times_fees_same_day = get_post_meta( $product_id, '_wcrp_rental_products_in_person_pick_up_times_fees_same_day', true );
					$in_person_pick_up_times_fees_same_day = ( '' !== $in_person_pick_up_times_fees_same_day ? $in_person_pick_up_times_fees_same_day : $default_rental_options['_wcrp_rental_products_in_person_pick_up_times_fees_same_day'] );
					$in_person_pick_up_times_fees_same_day_array = WCRP_Rental_Products_Misc::value_colon_price_pipe_explode( $in_person_pick_up_times_fees_same_day, false );

					$in_person_pick_up_times_fees_single_day_same_day = get_post_meta( $product_id, '_wcrp_rental_products_in_person_pick_up_times_fees_single_day_same_day', true );
					$in_person_pick_up_times_fees_single_day_same_day = ( '' !== $in_person_pick_up_times_fees_single_day_same_day ? $in_person_pick_up_times_fees_single_day_same_day : $default_rental_options['_wcrp_rental_products_in_person_pick_up_times_fees_single_day_same_day'] );
					$in_person_pick_up_times_fees_single_day_same_day_array = WCRP_Rental_Products_Misc::value_colon_price_pipe_explode( $in_person_pick_up_times_fees_single_day_same_day, false );

					$in_person_pick_up_times_fees_single_day_same_day_default_selection = false;

					foreach ( $in_person_pick_up_times_fees_single_day_same_day_array as $in_person_pick_up_time => $in_person_pick_up_fee ) {

						$in_person_pick_up_times_fees_single_day_same_day_default_selection = $in_person_pick_up_time;
						break;

					}

					ksort( $in_person_pick_up_times_fees_single_day_same_day_array ); // Sorts array earliest to latest times so select field options will be in time order regardless of how data entered, this must occur after the default selection (first time entered) is set

					$in_person_return_times_fees_same_day = get_post_meta( $product_id, '_wcrp_rental_products_in_person_return_times_fees_same_day', true );
					$in_person_return_times_fees_same_day = ( '' !== $in_person_return_times_fees_same_day ? $in_person_return_times_fees_same_day : $default_rental_options['_wcrp_rental_products_in_person_return_times_fees_same_day'] );
					$in_person_return_times_fees_same_day_array = WCRP_Rental_Products_Misc::value_colon_price_pipe_explode( $in_person_return_times_fees_same_day, false );

					$in_person_return_times_fees_single_day_same_day = get_post_meta( $product_id, '_wcrp_rental_products_in_person_return_times_fees_single_day_same_day', true );
					$in_person_return_times_fees_single_day_same_day = ( '' !== $in_person_return_times_fees_single_day_same_day ? $in_person_return_times_fees_single_day_same_day : $default_rental_options['_wcrp_rental_products_in_person_return_times_fees_single_day_same_day'] );
					$in_person_return_times_fees_single_day_same_day_array = WCRP_Rental_Products_Misc::value_colon_price_pipe_explode( $in_person_return_times_fees_single_day_same_day, false );

					$in_person_return_times_fees_single_day_same_day_default_selection = false;

					foreach ( $in_person_return_times_fees_single_day_same_day_array as $in_person_return_time => $in_person_return_fee ) {

						$in_person_return_times_fees_single_day_same_day_default_selection = $in_person_return_time;
						break;

					}

					ksort( $in_person_return_times_fees_single_day_same_day_array ); // Sorts array earliest to latest times so select field options will be in time order regardless of how data entered, this must occur after the default selection (first time entered) is set

					$in_person_pick_up_times_fees_next_day = get_post_meta( $product_id, '_wcrp_rental_products_in_person_pick_up_times_fees_next_day', true );
					$in_person_pick_up_times_fees_next_day = ( '' !== $in_person_pick_up_times_fees_next_day ? $in_person_pick_up_times_fees_next_day : $default_rental_options['_wcrp_rental_products_in_person_pick_up_times_fees_next_day'] );
					$in_person_pick_up_times_fees_next_day_array = WCRP_Rental_Products_Misc::value_colon_price_pipe_explode( $in_person_pick_up_times_fees_next_day, false );

					$in_person_pick_up_times_fees_array = ( 'same_day' == $in_person_return_date ? $in_person_pick_up_times_fees_same_day_array : $in_person_pick_up_times_fees_next_day_array );

					$in_person_pick_up_times_fees_default_selection = false;

					foreach ( $in_person_pick_up_times_fees_array as $in_person_pick_up_time => $in_person_pick_up_fee ) {

						$in_person_pick_up_times_fees_default_selection = $in_person_pick_up_time;
						break;

					}

					ksort( $in_person_pick_up_times_fees_array ); // Sorts array earliest to latest times so select field options will be in time order regardless of how data entered, this must occur after the default selection (first time entered) is set

					$in_person_return_times_fees_next_day = get_post_meta( $product_id, '_wcrp_rental_products_in_person_return_times_fees_next_day', true );
					$in_person_return_times_fees_next_day = ( '' !== $in_person_return_times_fees_next_day ? $in_person_return_times_fees_next_day : $default_rental_options['_wcrp_rental_products_in_person_return_times_fees_next_day'] );
					$in_person_return_times_fees_next_day_array = WCRP_Rental_Products_Misc::value_colon_price_pipe_explode( $in_person_return_times_fees_next_day, false );

					$in_person_return_times_fees_array = ( 'same_day' == $in_person_return_date ? $in_person_return_times_fees_same_day_array : $in_person_return_times_fees_next_day_array );

					$in_person_return_times_fees_default_selection = false;

					foreach ( $in_person_return_times_fees_array as $in_person_return_time => $in_person_return_fee ) {

						$in_person_return_times_fees_default_selection = $in_person_return_time;
						break;

					}

					ksort( $in_person_return_times_fees_array ); // Sorts array earliest to latest times so select field options will be in time order regardless of how data entered, this must occur after the default selection (first time entered) is set

					$minimum_days = get_post_meta( $product_id, '_wcrp_rental_products_minimum_days', true );
					$minimum_days = ( '' !== $minimum_days ? $minimum_days : $default_rental_options['_wcrp_rental_products_minimum_days'] );

					$maximum_days = get_post_meta( $product_id, '_wcrp_rental_products_maximum_days', true );
					$maximum_days = ( '' !== $maximum_days ? $maximum_days : $default_rental_options['_wcrp_rental_products_maximum_days'] );

					if ( 'period_selection' == $pricing_type ) {

						$minimum_days = $pricing_period;
						$maximum_days = $pricing_period;

						if ( false !== $rent_period ) {

							if ( array_key_exists( $rent_period, $pricing_period_additional_selections_array ) ) {

								$minimum_days = $rent_period;
								$maximum_days = $rent_period;

							}

						}

					}

					$start_day = get_post_meta( $product_id, '_wcrp_rental_products_start_day', true );
					$start_day = ( '' !== $start_day ? $start_day : $default_rental_options['_wcrp_rental_products_start_day'] );

					$start_days_threshold = get_post_meta( $product_id, '_wcrp_rental_products_start_days_threshold', true );
					$start_days_threshold = ( '' !== $start_days_threshold ? $start_days_threshold : $default_rental_options['_wcrp_rental_products_start_days_threshold'] );

					$return_days_threshold = get_post_meta( $product_id, '_wcrp_rental_products_return_days_threshold', true );
					$return_days_threshold = ( '' !== $return_days_threshold ? $return_days_threshold : $default_rental_options['_wcrp_rental_products_return_days_threshold'] );

					$disable_rental_start_end_dates_global = get_option( 'wcrp_rental_products_disable_rental_start_end_dates' );
					$disable_rental_start_end_dates_product = get_post_meta( $product_id, '_wcrp_rental_products_disable_rental_start_end_dates', true );
					$disable_rental_start_end_dates_product = ( '' !== $disable_rental_start_end_dates_product ? $disable_rental_start_end_dates_product : $default_rental_options['_wcrp_rental_products_disable_rental_start_end_dates'] );
					$disable_rental_start_end_dates_combined_string = '';

					if ( !empty( $disable_rental_start_end_dates_global ) || !empty( $disable_rental_start_end_dates_product ) ) {

						$disable_rental_start_end_dates_global_array = explode( ',', $disable_rental_start_end_dates_global );
						$disable_rental_start_end_dates_product_array = explode( ',', $disable_rental_start_end_dates_product );
						$disable_rental_start_end_dates_combined_array = array_merge( $disable_rental_start_end_dates_global_array, $disable_rental_start_end_dates_product_array );

						if ( !empty( $disable_rental_start_end_dates_combined_array ) ) {

							foreach ( $disable_rental_start_end_dates_combined_array as $disable_rental_start_end_dates_combined_array_date ) {

								$disable_rental_start_end_dates_combined_string .= "'" . $disable_rental_start_end_dates_combined_array_date . "',";

							}

							$disable_rental_start_end_dates_combined_string = rtrim( $disable_rental_start_end_dates_combined_string, ',' );

						}

					}

					$disable_rental_start_end_days = get_post_meta( $product_id, '_wcrp_rental_products_disable_rental_start_end_days', true );
					$disable_rental_start_end_days = ( '' !== $disable_rental_start_end_days ? $disable_rental_start_end_days : $default_rental_options['_wcrp_rental_products_disable_rental_start_end_days'] );

					$months = get_post_meta( $product_id, '_wcrp_rental_products_months', true );
					$months = ( '' !== $months ? $months : $default_rental_options['_wcrp_rental_products_months'] );

					$columns = get_post_meta( $product_id, '_wcrp_rental_products_columns', true );
					$columns = ( '' !== $columns ? $columns : $default_rental_options['_wcrp_rental_products_columns'] );

					$inline = get_post_meta( $product_id, '_wcrp_rental_products_inline', true );
					$inline = ( '' !== $inline ? $inline : $default_rental_options['_wcrp_rental_products_inline'] );
					$inline = ( 'yes' == $inline ? 'true' : 'false' ); // Note the true and false are strings as they end up in the inline js

					$multiply_addons_total_by_number_of_days_selected = get_post_meta( $product_id, '_wcrp_rental_products_multiply_addons_total_by_number_of_days_selected', true );
					$multiply_addons_total_by_number_of_days_selected = ( '' !== $multiply_addons_total_by_number_of_days_selected ? $multiply_addons_total_by_number_of_days_selected : $default_rental_options['_wcrp_rental_products_multiply_addons_total_by_number_of_days_selected'] );

					$minimum_date = gmdate( 'Y-m-d', strtotime( '+' . $start_days_threshold . ' day', time() ) );

					if ( '' !== $start_day ) {

						if ( '0' == $start_day ) {

							$start_day_name = 'sunday';

						} elseif ( '1' == $start_day ) {

							$start_day_name = 'monday';

						} elseif ( '2' == $start_day ) {

							$start_day_name = 'tuesday';

						} elseif ( '3' == $start_day ) {

							$start_day_name = 'wednesday';

						} elseif ( '4' == $start_day ) {

							$start_day_name = 'thursday';

						} elseif ( '5' == $start_day ) {

							$start_day_name = 'friday';

						} elseif ( '6' == $start_day ) {

							$start_day_name = 'saturday';

						}

						$minimum_date = gmdate( 'Y-m-d', strtotime( 'next ' . $start_day_name, strtotime( $minimum_date ) ) );

					}

					if ( 'yes' == $in_person_pick_up_return ) {

						$in_person_pick_up_return_allowed = true;
						$in_person_invalid_times_fees_checks = false;
						$in_person_invalid_times_fees_single_day_same_day_checks = false;

						if ( 'same_day' == $in_person_return_date ) {

							if ( 'period_selection' == $pricing_type ) {

								if ( '1' == $pricing_period ) {

									$in_person_invalid_times_fees_checks = true; // For pricing period additional selections which will be higher than 1
									$in_person_invalid_times_fees_single_day_same_day_checks = true; // For the pricing period of 1

								} else {

									$in_person_invalid_times_fees_checks = true;

								}

							} else {

								if ( '1' == $minimum_days ) {

									$in_person_invalid_times_fees_single_day_same_day_checks = true;

								}

								if ( '1' !== $maximum_days ) {

									$in_person_invalid_times_fees_checks = true;

								}

							}

						} else {

							$in_person_invalid_times_fees_checks = true;

						}

						if ( true == $in_person_invalid_times_fees_checks ) {

							if ( !empty( $in_person_pick_up_times_fees_array ) && !empty( $in_person_return_times_fees_array ) ) {

								$in_person_invalid_times_fees_count = 0;

								foreach ( $in_person_return_times_fees_array as $in_person_return_time => $in_person_return_fee ) {

									foreach ( $in_person_pick_up_times_fees_array as $in_person_pick_up_time => $in_person_pick_up_fee ) {

										if ( (int) $in_person_return_time > (int) $in_person_pick_up_time ) {

											++$in_person_invalid_times_fees_count;

										}

									}

								}

								if ( $in_person_invalid_times_fees_count > 0 ) {

									$in_person_pick_up_return_allowed = false;

								}

							} else {

								$in_person_pick_up_return_allowed = false;

							}

						}

						if ( true == $in_person_invalid_times_fees_single_day_same_day_checks ) { // Specifically not an elseif as scenarios where both $in_person_invalid_times_fees_checks and $in_person_invalid_times_fees_single_day_same_day_checks occur

							if ( !empty( $in_person_pick_up_times_fees_single_day_same_day_array ) && !empty( $in_person_return_times_fees_single_day_same_day_array ) ) {

								$in_person_invalid_times_fees_count = 0;

								foreach ( $in_person_return_times_fees_single_day_same_day_array as $in_person_return_time => $in_person_return_fee ) {

									foreach ( $in_person_pick_up_times_fees_single_day_same_day_array as $in_person_pick_up_time => $in_person_pick_up_fee ) {

										if ( (int) $in_person_return_time < (int) $in_person_pick_up_time ) {

											++$in_person_invalid_times_fees_count;

										}

									}

								}

								if ( $in_person_invalid_times_fees_count > 0 ) {

									$in_person_pick_up_return_allowed = false;

								}

							} else {

								$in_person_pick_up_return_allowed = false;

							}

						}

					} else {

						$in_person_pick_up_return_allowed = false;

					}

					?>

					<div id="wcrp-rental-products-rental-form-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-rental-form<?php echo ( 'yes' == $display_after_quantity ? ' wcrp-rental-products-rental-form-after-quantity' : '' ); ?>">
                        <?php if ( 'period_selection' == $pricing_type ) { ?>
							<div id="wcrp-rental-products-rental-period-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-rental-period">
								<label for="wcrp-rental-products-rental-period-select-<?php echo esc_html( $this->rental_form_id ); ?>">
									<?php echo esc_html( apply_filters( 'wcrp_rental_products_text_rental_period', get_option( 'wcrp_rental_products_text_rental_period' ) ) ); ?>
								</label>
								<select id="wcrp-rental-products-rental-period-select-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-rental-period-select">
									<option value="" data-period="default">
										<?php
										$rental_period_selection_option_name_default_price = wc_price( ( wcrp_rental_products_is_rental_purchase( $product_id ) && true == $rent ? wc_get_price_to_display( $product, array( 'price' => str_replace( $price_decimal_separator, '.', get_post_meta( $product_id, '_wcrp_rental_products_rental_purchase_price', true ) ) ) ) : $product_price ) );
										$rental_period_selection_option_name_default = $pricing_period . ' ' . ( $pricing_period > 1 ? __( 'days', 'wcrp-rental-products' ) : __( 'day', 'wcrp-rental-products' ) ) . ( 'simple' == $product_type ? ' ' . __( '(', 'wcrp-rental-products' ) . $rental_period_selection_option_name_default_price . __( ')', 'wcrp-rental-products' ) : '' );
										if ( 'weeks' == $period_selection_option_labels ) {
											$period_to_week = $pricing_period / 7;
											if ( floor( $period_to_week ) == $period_to_week ) {
												$rental_period_selection_option_name_default = $period_to_week . ' ' . ( $period_to_week > 1 ? __( 'weeks', 'wcrp-rental-products' ) : __( 'week', 'wcrp-rental-products' ) ) . ( 'simple' == $product_type ? ' ' . __( '(', 'wcrp-rental-products' ) . $rental_period_selection_option_name_default_price . __( ')', 'wcrp-rental-products' ) : '' );
											}
										}
										echo wp_kses_post( $rental_period_selection_option_name_default );
										?>
									</option>
									<?php
									if ( !empty( $pricing_period_additional_selections_array ) ) {
										foreach ( $pricing_period_additional_selections_array as $rental_period_days => $rental_period_price ) {
											$rental_period_price = str_replace( $price_decimal_separator, '.', $rental_period_price );
											if ( 'simple' == $product_type && 'yes' == $taxes_enabled ) {
												if ( 'taxable' == $product_tax_status ) {
													if ( 'no' == $prices_include_tax && 'incl' == $tax_display_shop ) {
														$rental_period_price = $rental_period_price * ( 1 + ( $product_tax_rate / 100 ) );
													} elseif ( 'yes' == $prices_include_tax && 'excl' == $tax_display_shop ) {
														$rental_period_price = $rental_period_price / ( 1 + ( $product_tax_rate / 100 ) );
													}
												}
											}
											?>
											<option value="" data-period="<?php echo esc_html( $rental_period_days ); ?>"<?php echo esc_html( ( false !== $rent_period ? ( $rent_period == $rental_period_days ? ' selected' : '' ) : '' ) ); ?>>
												<?php
												$rental_period_selection_option_name = $rental_period_days . ' ' . ( $rental_period_days > 1 ? __( 'days', 'wcrp-rental-products' ) : __( 'day', 'wcrp-rental-products' ) ) . ( 'simple' == $product_type ? ' ' . __( '(', 'wcrp-rental-products' ) . wc_price( $rental_period_price ) . __( ')', 'wcrp-rental-products' ) : '' );
												if ( 'weeks' == $period_selection_option_labels ) {
													$period_to_week = $rental_period_days / 7;
													if ( floor( $period_to_week ) == $period_to_week ) {
														$rental_period_selection_option_name = $period_to_week . ' ' . ( $period_to_week > 1 ? __( 'weeks', 'wcrp-rental-products' ) : __( 'week', 'wcrp-rental-products' ) ) . ( 'simple' == $product_type ? ' ' . __( '(', 'wcrp-rental-products' ) . wc_price( $rental_period_price ) . __( ')', 'wcrp-rental-products' ) : '' );
													}
												}
												echo wp_kses_post( $rental_period_selection_option_name );
												?>
											</option>
											<?php
										}
									}
									?>
								</select>
							</div>
						<?php } ?>
						<div id="wcrp-rental-products-rental-dates-wrap-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-rental-dates-wrap single-product-rental-calender"  style="margin-top: -5px;">
							<label for="wcrp-rental-products-rental-dates-<?php echo esc_html( $this->rental_form_id ); ?>">
								<?php echo esc_html( apply_filters( 'wcrp_rental_products_text_rental_dates', get_option( 'wcrp_rental_products_text_rental_dates' ) ) ); ?>
							</label>
							<div id="wcrp-rental-products-rental-dates-parent-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-rental-dates-parent">
								<input type="text" id="wcrp-rental-products-rental-dates-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-rental-dates" name="wcrp_rental_products_rental_dates" placeholder="<?php echo esc_html( apply_filters( 'wcrp_rental_products_text_select_dates', get_option( 'wcrp_rental_products_text_select_dates' ) ) ); ?>" readonly="readonly" required>
							</div>
						</div>
						<?php
						if ( 'yes' == $start_end_notices ) {
							if ( !empty( $disable_rental_start_end_dates_combined_string ) ) {
								?>
								<div id="wcrp-rental-products-disable-rental-start-end-dates-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-disable-rental-start-end-dates wcrp-rental-products-notice woocommerce-info">
									<?php echo esc_html( apply_filters( 'wcrp_rental_products_text_disable_rental_start_end_dates_notice', get_option( 'wcrp_rental_products_text_disable_rental_start_end_dates_notice_text' ) ) ); ?>
								</div>
								<?php
							} else {
								if ( !empty( $disable_rental_start_end_days ) || '0' == $disable_rental_start_end_days ) {
									$disable_rental_start_end_days_explode = explode( ',', $disable_rental_start_end_days );
									?>
									<div id="wcrp-rental-products-disable-rental-start-end-days-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-disable-rental-start-end-days wcrp-rental-products-notice woocommerce-info">
										<?php
										$disable_rental_start_end_days_notice = esc_html( apply_filters( 'wcrp_rental_products_text_disable_rental_start_end_days_notice', get_option( 'wcrp_rental_products_text_disable_rental_start_end_days_notice_text' ) ) ) . ' ';
										$disable_rental_start_end_days_explode_last = end( $disable_rental_start_end_days_explode );
										foreach ( $disable_rental_start_end_days_explode as $disable_rental_start_end_days_explode_day ) {
											$disable_rental_start_end_days_explode_day_name = date_i18n( 'l', strtotime( 'Sunday +' . $disable_rental_start_end_days_explode_day . ' days' ) );
											if ( $disable_rental_start_end_days_explode_day !== $disable_rental_start_end_days_explode_last ) {
												$disable_rental_start_end_days_notice .= $disable_rental_start_end_days_explode_day_name . ', ';
											} else {
												$disable_rental_start_end_days_notice = rtrim( $disable_rental_start_end_days_notice, ', ' );
												$disable_rental_start_end_days_notice .= ( count( $disable_rental_start_end_days_explode ) > 1 ? ' ' . esc_html__( 'or', 'wcrp-rental-products' ) . ' ' : ' ' );
												$disable_rental_start_end_days_notice .= $disable_rental_start_end_days_explode_day_name;
												$disable_rental_start_end_days_notice .= ' ' . esc_html__( '(', 'wcrp-rental-products' ) . esc_html__( 'highlighted', 'wcrp-rental-products' ) . esc_html__( ')', 'wcrp-rental-products' ) . esc_html__( '.', 'wcrp-rental-products' );
											}
										} 
										echo esc_html( $disable_rental_start_end_days_notice );
										?>
									</div>
									<?php
								}
							}
						}
						if ( true == $in_person_pick_up_return_allowed ) {
							?>
							<div id="wcrp-rental-products-in-person-pick-up-return-wrap-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-in-person-pick-up-return-wrap">
								<div id="wcrp-rental-products-in-person-pick-up-time-fee-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-in-person-pick-up-time-fee">
									<label for="wcrp-rental-products-in-person-pick-up-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>">
										<?php echo esc_html( apply_filters( 'wcrp_rental_products_text_pick_up_time', get_option( 'wcrp_rental_products_text_pick_up_time' ) ) ) . ' ' . esc_html__( 'on', 'wcrp-rental-products' ); ?> <span id="wcrp-rental-products-in-person-pick-up-time-fee-date-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-in-person-pick-up-time-fee-date"></span>
									</label>
									<select id="wcrp-rental-products-in-person-pick-up-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-in-person-pick-up-time-fee-select">
										<?php
										if ( !empty( $in_person_pick_up_times_fees_array ) ) {
											// Similar to code in next select
											foreach ( $in_person_pick_up_times_fees_array as $in_person_pick_up_time => $in_person_pick_up_fee ) {
												$in_person_pick_up_fee = str_replace( $price_decimal_separator, '.', $in_person_pick_up_fee );
												if ( 'yes' == $taxes_enabled ) {
													if ( 'taxable' == $product_tax_status ) {
														if ( 'no' == $prices_include_tax && 'incl' == $tax_display_shop ) {
															$in_person_pick_up_fee = $in_person_pick_up_fee * ( 1 + ( $product_tax_rate / 100 ) );
														} elseif ( 'yes' == $prices_include_tax && 'excl' == $tax_display_shop ) {
															$in_person_pick_up_fee = $in_person_pick_up_fee / ( 1 + ( $product_tax_rate / 100 ) );
														}
													}
												}
												?>
												<option value="<?php echo esc_html( $in_person_pick_up_time ); ?>" data-fee="<?php echo esc_html( $in_person_pick_up_fee ); ?>"<?php echo ( false !== $in_person_pick_up_times_fees_default_selection && $in_person_pick_up_time == $in_person_pick_up_times_fees_default_selection ? ' selected' : '' ); ?>>
													<?php echo esc_html( WCRP_Rental_Products_Misc::four_digit_time_formatted( $in_person_pick_up_time ) ) . ( (float) $in_person_pick_up_fee > 0 ? ' ' . esc_html__( '(', 'wcrp-rental-products' ) . esc_html__( '+', 'wcrp-rental-products' ) . wp_kses_post( wc_price( $in_person_pick_up_fee ) ) . esc_html__( ')', 'wcrp-rental-products' ) : '' ); ?>
												</option>
												<?php
											}
										}
										?>
									</select>
									<?php
									if ( 'same_day' == $in_person_return_date && !empty( $in_person_pick_up_times_fees_single_day_same_day_array ) ) {
										// The select below is just here for JS to get the options and insert into the select above if only a single day selected when in person return date is same day
										?>
										<select id="wcrp-rental-products-in-person-pick-up-time-fee-single-day-select-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-in-person-pick-up-time-fee-single-day-select">
											<?php
											// Similar to code in previous select
											foreach ( $in_person_pick_up_times_fees_single_day_same_day_array as $in_person_pick_up_time => $in_person_pick_up_fee ) {
												$in_person_pick_up_fee = str_replace( $price_decimal_separator, '.', $in_person_pick_up_fee );
												if ( 'yes' == $taxes_enabled ) {
													if ( 'taxable' == $product_tax_status ) {
														if ( 'no' == $prices_include_tax && 'incl' == $tax_display_shop ) {
															$in_person_pick_up_fee = $in_person_pick_up_fee * ( 1 + ( $product_tax_rate / 100 ) );
														} elseif ( 'yes' == $prices_include_tax && 'excl' == $tax_display_shop ) {
															$in_person_pick_up_fee = $in_person_pick_up_fee / ( 1 + ( $product_tax_rate / 100 ) );
														}
													}
												}
												?>
												<option value="<?php echo esc_html( $in_person_pick_up_time ); ?>" data-fee="<?php echo esc_html( $in_person_pick_up_fee ); ?>"<?php echo ( false !== $in_person_pick_up_times_fees_single_day_same_day_default_selection && $in_person_pick_up_time == $in_person_pick_up_times_fees_single_day_same_day_default_selection ? ' selected' : '' ); ?>>
													<?php echo esc_html( WCRP_Rental_Products_Misc::four_digit_time_formatted( $in_person_pick_up_time ) ) . ( (float) $in_person_pick_up_fee > 0 ? ' ' . esc_html__( '(', 'wcrp-rental-products' ) . esc_html__( '+', 'wcrp-rental-products' ) . wp_kses_post( wc_price( $in_person_pick_up_fee ) ) . esc_html__( ')', 'wcrp-rental-products' ) : '' ); ?>
												</option>
												<?php
											}
											?>
										</select>
										<?php
									}
									?>
								</div>
								<div id="wcrp-rental-products-in-person-return-time-fee-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-in-person-return-time-fee">
									<label for="wcrp-rental-products-in-person-return-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>">
										<?php echo esc_html( apply_filters( 'wcrp_rental_products_text_return_time', get_option( 'wcrp_rental_products_text_return_time' ) ) ) . ' ' . esc_html__( 'on', 'wcrp-rental-products' ); ?> <span id="wcrp-rental-products-in-person-return-time-fee-date-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-in-person-return-time-fee-date"></span>
									</label>
									<select id="wcrp-rental-products-in-person-return-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-in-person-return-time-fee-select">
										<?php
										if ( !empty( $in_person_return_times_fees_array ) ) {
											// Similar to code in next select
											foreach ( $in_person_return_times_fees_array as $in_person_return_time => $in_person_return_fee ) {
												$in_person_return_fee = str_replace( $price_decimal_separator, '.', $in_person_return_fee );
												if ( 'yes' == $taxes_enabled ) {
													if ( 'taxable' == $product_tax_status ) {
														if ( 'no' == $prices_include_tax && 'incl' == $tax_display_shop ) {
															$in_person_return_fee = $in_person_return_fee * ( 1 + ( $product_tax_rate / 100 ) );
														} elseif ( 'yes' == $prices_include_tax && 'excl' == $tax_display_shop ) {
															$in_person_return_fee = $in_person_return_fee / ( 1 + ( $product_tax_rate / 100 ) );
														}
													}
												}
												?>
												<option value="<?php echo esc_html( $in_person_return_time ); ?>" data-fee="<?php echo esc_html( $in_person_return_fee ); ?>"<?php echo ( false !== $in_person_return_times_fees_default_selection && $in_person_return_time == $in_person_return_times_fees_default_selection ? ' selected' : '' ); ?>>
													<?php echo esc_html( WCRP_Rental_Products_Misc::four_digit_time_formatted( $in_person_return_time ) ) . ( (float) $in_person_return_fee > 0 ? ' ' . esc_html__( '(', 'wcrp-rental-products' ) . esc_html__( '+', 'wcrp-rental-products' ) . wp_kses_post( wc_price( $in_person_return_fee ) ) . esc_html__( ')', 'wcrp-rental-products' ) : '' ); ?>
												</option>
												<?php
											}
										}
										?>
									</select>
									<?php
									if ( 'same_day' == $in_person_return_date && !empty( $in_person_return_times_fees_single_day_same_day_array ) ) {
										// The select below is just here for JS to get the options and insert into the select above if only a single day selected when in person return date is same day
										?>
										<select id="wcrp-rental-products-in-person-return-time-fee-single-day-select-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-in-person-return-time-fee-single-day-select">
											<?php
											// Similar to code in previous select
											foreach ( $in_person_return_times_fees_single_day_same_day_array as $in_person_return_time => $in_person_return_fee ) {
												$in_person_return_fee = str_replace( $price_decimal_separator, '.', $in_person_return_fee );
												if ( 'yes' == $taxes_enabled ) {
													if ( 'taxable' == $product_tax_status ) {
														if ( 'no' == $prices_include_tax && 'incl' == $tax_display_shop ) {
															$in_person_return_fee = $in_person_return_fee * ( 1 + ( $product_tax_rate / 100 ) );
														} elseif ( 'yes' == $prices_include_tax && 'excl' == $tax_display_shop ) {
															$in_person_return_fee = $in_person_return_fee / ( 1 + ( $product_tax_rate / 100 ) );
														}
													}
												}
												?>
												<option value="<?php echo esc_html( $in_person_return_time ); ?>" data-fee="<?php echo esc_html( $in_person_return_fee ); ?>"<?php echo ( false !== $in_person_return_times_fees_single_day_same_day_default_selection && $in_person_return_time == $in_person_return_times_fees_single_day_same_day_default_selection ? ' selected' : '' ); ?>>
													<?php echo esc_html( WCRP_Rental_Products_Misc::four_digit_time_formatted( $in_person_return_time ) ) . ( (float) $in_person_return_fee > 0 ? ' ' . esc_html__( '(', 'wcrp-rental-products' ) . esc_html__( '+', 'wcrp-rental-products' ) . wp_kses_post( wc_price( $in_person_return_fee ) ) . esc_html__( ')', 'wcrp-rental-products' ) : '' ); ?>
												</option>
												<?php
											}
											?>
										</select>
										<?php
									}
									?>
								</div>
							</div>
							<?php
						}
						if ( false == $in_person_pick_up_return_allowed && 'yes' == $in_person_pick_up_return ) { // Displays an unavailable message if the product is an in person pick up/return but is not allowed e.g. if no return dates lower than pick up dates
							?>
							<div id="wcrp-rental-products-in-person-pick-up-return-unavailable-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-in-person-pick-up-return-unavailable wcrp-rental-products-notice woocommerce-info">
								<?php echo esc_html( apply_filters( 'wcrp_rental_products_text_in_person_pick_up_return', get_option( 'wcrp_rental_products_text_in_person_pick_up_return' ) ) ) . ' ' . esc_html__( 'is unavailable', 'wcrp-rental-products' ) . esc_html__( '.', 'wcrp-rental-products' ); ?>
							</div>
							<?php
						}
						?>
						<div id="wcrp-rental-products-spinner-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-spinner "></div>
						<div id="wcrp-rental-products-rental-totals-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-rental-totals wcrp-rental-products-notice woocommerce-info">
							<?php
							// Below is coded to all be output on one line otherwise browsers can add a visual space between currency symbols that should not have spaces even though there isn't a space in the code
							echo '<strong>';
							echo esc_html__( 'Total:', 'wcrp-rental-products' ) . ' ' . ( in_array( $currency_position, array( 'left', 'left_space' ) ) ? wp_kses_post( ( 'left' == $currency_position ? $currency_symbol : $currency_symbol . ' ' ) ) : '' ) . '<span id="wcrp-rental-products-total-price-' . esc_html( $this->rental_form_id ) . '" class="wcrp-rental-products-total-price"></span>' . ( in_array( $currency_position, array( 'right', 'right_space' ) ) ? wp_kses_post( ( 'right' == $currency_position ? $currency_symbol : ' ' . $currency_symbol ) ) : '' );
							if ( 'period_selection' !== $pricing_type ) {
								// If period selection the days isn't shown as they have already been selected them and visible on the product page + if was used would require further conditions/calculations to show as weeks if the rental form period selection option labels setting is weeks, etc, etc
								echo ' ';
								esc_html_e( '(', 'wcrp-rental-products' );
								echo '<span id="wcrp-rental-products-total-days-' . esc_html( $this->rental_form_id ) . '" class="wcrp-rental-products-total-days"></span>';
								esc_html_e( ')', 'wcrp-rental-products' );
							}
							echo '</strong>';
							require_once ABSPATH . 'wp-admin/includes/plugin.php';
							if ( is_plugin_active( 'woocommerce-product-addons/woocommerce-product-addons.php' ) ) {
								echo '<div id="wcrp-rental-products-excludes-addons-' . esc_html( $this->rental_form_id ) . '" class="wcrp-rental-products-excludes-addons">' . esc_html__( 'Excluding any selected add-ons', 'wcrp-rental-products' ) . esc_html( ( 'yes' == $multiply_addons_total_by_number_of_days_selected ? ' ' . __( '(', 'wcrp-rental-products' ) . __( 'priced per day', 'wcrp-rental-products' ) . __( ')', 'wcrp-rental-products' ) : '' ) ) . '</div>';
							}
							if ( true == $in_person_pick_up_return_allowed ) {
								echo '<div id="wcrp-rental-products-excludes-in-person-pick-up-return-fees-' . esc_html( $this->rental_form_id ) . '" class="wcrp-rental-products-excludes-in-person-pick-up-return-fees">' . esc_html__( 'Excluding any selected pick up/return fees', 'wcrp-rental-products' ) . '</div>';
							}
							if ( 'yes' == $return_days_display ) {
								echo '<div id="wcrp-rental-products-rental-return-within-' . esc_html( $this->rental_form_id ) . '" class="wcrp-rental-products-rental-return-within">' . esc_html( apply_filters( 'wcrp_rental_products_text_rental_return_within', get_option( 'wcrp_rental_products_text_rental_return_within' ) ) ) . ' <span id="wcrp-rental-products-rental-return-within-days-' . esc_html( $this->rental_form_id ) . '" class="wcrp-rental-products-rental-return-within-days"></span> ' . esc_html__( 'days', 'wcrp-rental-products' ) . '</div>';
							}
							?>
						</div>
					</div>
					<input type="hidden" id="wcrp-rental-products-cart-item-validation-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_cart_item_validation">
					<input type="hidden" id="wcrp-rental-products-cart-item-timestamp-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_cart_item_timestamp" value="<?php echo esc_html( current_time( 'timestamp', false ) ); // current_time() used instead of time() to ensure the timestamp takes into account the timezone settings set in WordPress, otherwise this could be lower than the timestamp got later in the cart check condition for the last updated date of the product, false parameter is used to get the timestamp based off the timezone settings ?>">
					<input type="hidden" id="wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_cart_item_price"><?php // When value populated via JS this can be any number of decimal places, cart deals with any rounding required ?>
					<input type="hidden" id="wcrp-rental-products-rent-from-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_rent_from">
					<input type="hidden" id="wcrp-rental-products-rent-to-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_rent_to">
					<input type="hidden" id="wcrp-rental-products-start-days-threshold-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_start_days_threshold" value="<?php echo esc_html( $start_days_threshold ); ?>">
					<input type="hidden" id="wcrp-rental-products-return-days-threshold-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_return_days_threshold" value="<?php echo esc_html( $return_days_threshold ); ?>">
					<?php
					if ( true == $in_person_pick_up_return_allowed ) {
						?>
						<input type="hidden" id="wcrp-rental-products-in-person-pick-up-return-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_in_person_pick_up_return" value="yes">
						<input type="hidden" id="wcrp-rental-products-in-person-pick-up-date-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_in_person_pick_up_date">
						<input type="hidden" id="wcrp-rental-products-in-person-pick-up-time-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_in_person_pick_up_time">
						<input type="hidden" id="wcrp-rental-products-in-person-pick-up-fee-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_in_person_pick_up_fee"><?php // When value populated via JS this can be any number of decimal places, cart deals with any rounding required ?>
						<input type="hidden" id="wcrp-rental-products-in-person-return-date-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_in_person_return_date">
						<input type="hidden" id="wcrp-rental-products-in-person-return-date-type-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_in_person_return_date_type" value="<?php echo esc_html( $in_person_return_date ); ?>">
						<input type="hidden" id="wcrp-rental-products-in-person-return-time-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_in_person_return_time">
						<input type="hidden" id="wcrp-rental-products-in-person-return-fee-<?php echo esc_html( $this->rental_form_id ); ?>" name="wcrp_rental_products_in_person_return_fee"><?php // When value populated via JS this can be any number of decimal places, cart deals with any rounding required ?>
						<?php
					}
					wp_nonce_field( 'wcrp_rental_products_rental_form', 'wcrp_rental_products_rental_form_nonce' );
					?>

					<script>
						jQuery( document ).ready( function( $ ) {

							let addRentalProductsPopup = false;
							let rentalFormUpdateAjaxRequestTimeout;
							let rentalFormUpdateAjaxRequestDelay = 1000;

							if ( window.name.startsWith( 'wcrp-rental-products-add-rental-products-popup-' ) ) {

								addRentalProductsPopup = true;
								addRentalProductsPopupOrderId = window.name.slice( window.name.lastIndexOf( '-' ) + 1 );

							}

							function rentalFormAddToStatus( status ) {

								<?php // If adding to cart ?>

								if ( addRentalProductsPopup == false ) {

									<?php // Opacity gets added/removed below as when choosing different variations standard woo functionality adds an opacity 0.2 with a disabled class but that style is not present for add to cart buttons on simple products so we just set here ?>

									if ( 'enable' == status ) {

										<?php if ( in_array( 'rental_form_add_to_status_enable_delay', $advanced_configuration ) ) { ?>

											setTimeout( () => {
												$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart button[type="submit"]' ).css( 'opacity', '1' ).prop( 'disabled', false );
											}, '1000' );

										<?php } else { ?>

											$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart button[type="submit"]' ).css( 'opacity', '1' ).prop( 'disabled', false );

										<?php } ?>

									} else {

										if ( 'disable' == status ) {

											$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart button[type="submit"]' ).css( 'opacity', '0.2' ).prop( 'disabled', true );

										}

									}

								} else {

									<?php // If adding to order ?>

									$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart button[type="submit"]' ).hide();
									$( '#wcrp-rental-products-add-to-order-<?php echo esc_html( $this->rental_form_id ); ?>' ).remove();

									if ( 'enable' == status ) {

										$( '<a href="#" id="wcrp-rental-products-add-to-order-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-add-to-order single_add_to_cart_button button alt"><?php esc_html_e( 'Add to order', 'wcrp-rental-products' ); ?> <?php esc_html_e( '#', 'wcrp-rental-products' ); ?>' + addRentalProductsPopupOrderId + '</a>' ).insertBefore( $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart button[type="submit"]' ) );

									}

								}

							}

							function rentalFormReset() {
								<?php // Disable add to cart ?>

								rentalFormAddToStatus( 'disable' );

								<?php // Message/notices to hide on reset ?>

								$( '#wcrp-rental-products-availability-checker-auto-population-information-<?php echo esc_html( $this->rental_form_id ); ?>' ).hide();
								$( '#wcrp-rental-products-rental-totals-<?php echo esc_html( $this->rental_form_id ); ?>' ).attr( 'style', 'display: none !important;' ); <?php // Not .hide() as !important required (see related public CSS for info) ?>

								<?php // Hidden fields, just the dynamic ones e.g. hidden fields in above HTML markup with static values aren't needed to be reset as always the same value ?>

								$( '#wcrp-rental-products-cart-item-validation-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( '' );
								$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( '' );
								$( '#wcrp-rental-products-rent-from-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( '' );
								$( '#wcrp-rental-products-rent-to-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( '' );
								<?php if ( true == $in_person_pick_up_return_allowed ) { ?>
									$( '#wcrp-rental-products-in-person-pick-up-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( '' );
									$( '#wcrp-rental-products-in-person-pick-up-time-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( '' );
									$( '#wcrp-rental-products-in-person-pick-up-fee-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( '' );
									$( '#wcrp-rental-products-in-person-return-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( '' );
									$( '#wcrp-rental-products-in-person-return-time-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( '' );
									$( '#wcrp-rental-products-in-person-return-fee-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( '' );
								<?php } ?>

								<?php if ( 'period_selection' == $pricing_type ) { ?>

									rentalFormUpdateRentalPeriodOptions();

								<?php } ?>

							}

							<?php if ( 'period_selection' == $pricing_type ) { ?> 

								function rentalFormUpdateRentalPeriodOptions() {

									<?php // This runs on page load as rentalFormUpdate() is called which in turn calls rentalFormReset() which calls this, this is also called upon variation selection ?>

									$( '#wcrp-rental-products-rental-period-select-<?php echo esc_html( $this->rental_form_id ); ?> option' ).each( function() {

										<?php

										if ( false == is_preview() ) {

											?>

											var rentalPeriodOptionUrl = '<?php echo esc_url( $product_url ) . ( WCRP_Rental_Products_Misc::string_contains( $product_url, '?' ) ? '&' : '?' ); ?>';

											<?php

										} else {

											?>

											var rentalPeriodOptionUrl = '<?php echo esc_url( $product_url_preview ); ?>&';

											<?php

										}

										?>

										if ( 'default' == $( this ).attr( 'data-period' ) ) {

											rentalPeriodOptionUrl += '<?php echo ( true == $rent ? 'rent=1&' : '' ); ?>rent_period_qty=' + $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).val();

										} else {

											rentalPeriodOptionUrl += '<?php echo ( true == $rent ? 'rent=1&' : '' ); ?>rent_period=' + $( this ).attr( 'data-period' );
											rentalPeriodOptionUrl += '&rent_period_qty=' + $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).val();

										}

										<?php if ( 'variable' == $product_type ) { ?>

											$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?> .variations .value select' ).each( function() {

												if ( $( this ).val() !== '' ) {

													rentalPeriodOptionUrl += '&' + $( this ).attr( 'data-attribute_name' ) + '=' + $( this ).val();

												}

											});

										<?php } ?>

										$( this ).val( rentalPeriodOptionUrl );

									});

								}

								$( '.variations_form' ).on( 'woocommerce_variation_select_change', function() { <?php // woocommerce_variation_select_change not show_variation as ensures it can be reset if not a bonafide variation e.g. if variation option not selected ?>

									rentalFormUpdateRentalPeriodOptions();

								});

								<?php if ( false !== $rent_period_qty ) { ?>

									$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).val( '<?php echo esc_html( $rent_period_qty ); ?>' );

								<?php
								
								}

							}

							?>

							function rentalFormUpdate() {

								<?php // This function runs on page load and when other actions are triggered such as quantity field change, variation selection, etc ?>

								<?php // Show spinner ?>
								$( '#wcrp-rental-products-spinner-<?php echo esc_html( $this->rental_form_id ); ?>' ).fadeIn();

								<?php // Reset rental form ?>

								rentalFormReset();

								<?php

								// Set/remove qty field max attribute conditionally

								if ( 'simple' == $product_type ) {

									// If a simple product, note there is no check if product is sold individually as in this scenario the qty field is hidden and while the max will have been updated by the below it cannot be changed from 1 anyway

									$qty_max_set_rental_stock_simple_product = get_post_meta( $product_id, '_wcrp_rental_products_rental_stock', true );
									$qty_max_set_rental_stock_simple_product = ( '' !== $qty_max_set_rental_stock_simple_product ? $qty_max_set_rental_stock_simple_product : PHP_INT_MAX );

									if ( PHP_INT_MAX == $qty_max_set_rental_stock_simple_product ) {

										?>

										$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).removeAttr( 'max' );

										<?php

									} else {

										?>

										$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).attr( 'max', '<?php echo esc_html( $qty_max_set_rental_stock_simple_product ); ?>' );

										<?php

									}

								} else {

									// If not a simple product then max qty is removed, this is because on page load WooCommerce sets it to the purchasable stock level, for variables the rental stock level isn't available to set it as this is determined based on the variation rental stock meta which is got after the options, dates, etc selected via the rental form update AJAX

									?>

									$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).removeAttr( 'max' );

									<?php

								}

								// On initial page load the rentalFormCalendar won't be instantiated yet so we don't attempt to use it or will cause JS errors, for availability checker auto population on page load these end up populated as the dates get set on rentalFormCalendar render and then the rentalFormCalendar select function triggers this rentalFormUpdate() and at that point rentalFormCalendar is instantiated and these get set
								
								?>

								if ( undefined !== rentalFormCalendar ) { 

									<?php

									// Format dates in hidden fields

									if ( '1' == $minimum_days && '1' == $maximum_days ) {

										// Note that rentalFormCalendar.getEndDate() note available in this scenario as singular date, hence rentalFormCalendar.getStartDate() used for both

										?>

										if ( null !== rentalFormCalendar.getStartDate() ) {

											$( '#wcrp-rental-products-rent-from-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalFormCalendar.getStartDate().format( 'YYYY-MM-DD' ) );
											$( '#wcrp-rental-products-rent-to-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalFormCalendar.getStartDate().format( 'YYYY-MM-DD' ) );

											<?php
											
											if ( true == $in_person_pick_up_return_allowed ) {

												?>

												$( '#wcrp-rental-products-in-person-pick-up-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalFormCalendar.getStartDate().format( 'YYYY-MM-DD' ) );

												<?php

												if ( 'same_day' == $in_person_return_date ) {

													?>

													$( '#wcrp-rental-products-in-person-return-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalFormCalendar.getStartDate().format( 'YYYY-MM-DD' ) );

													<?php

												} else {

													?>

													$( '#wcrp-rental-products-in-person-return-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( addDayToIsoDate( rentalFormCalendar.getStartDate().format( 'YYYY-MM-DD' ) ) );

													<?php

												}

											}

											?>

										}

										<?php

									} else {
										
										// The 2 null !== conditions below were previously 1 line as if ( null !== rentalFormCalendar.getStartDate() && null !== rentalFormCalendar.getEndDate() ) { however on some server setups the markup would change && to &#038;&#038; so we've split out the conditions

										?>

										if ( null !== rentalFormCalendar.getStartDate() ) {

											if ( null !== rentalFormCalendar.getEndDate() ) {

												$( '#wcrp-rental-products-rent-from-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalFormCalendar.getStartDate().format( 'YYYY-MM-DD' ) );
												$( '#wcrp-rental-products-rent-to-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalFormCalendar.getEndDate().format( 'YYYY-MM-DD' ) );

												<?php
											
												if ( true == $in_person_pick_up_return_allowed ) {

													?>

													$( '#wcrp-rental-products-in-person-pick-up-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalFormCalendar.getStartDate().format( 'YYYY-MM-DD' ) );

													<?php

													if ( 'same_day' == $in_person_return_date ) {

														?>

														$( '#wcrp-rental-products-in-person-return-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalFormCalendar.getEndDate().format( 'YYYY-MM-DD' ) );

														<?php

													} else {

														?>

														$( '#wcrp-rental-products-in-person-return-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( addDayToIsoDate( rentalFormCalendar.getEndDate().format( 'YYYY-MM-DD' ) ) );

														<?php

													}

												}

												?>

											}

										}

										<?php
									
									}

									if ( true == $in_person_pick_up_return_allowed ) {

										?>

										if ( null !== rentalFormCalendar.getStartDate() ) {
											
											$( '#wcrp-rental-products-in-person-pick-up-time-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( $( '#wcrp-rental-products-in-person-pick-up-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?> option:selected' ).val() );
											$( '#wcrp-rental-products-in-person-pick-up-fee-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( $( '#wcrp-rental-products-in-person-pick-up-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?> option:selected' ).attr( 'data-fee' ) );
											$( '#wcrp-rental-products-in-person-return-time-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( $( '#wcrp-rental-products-in-person-return-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?> option:selected' ).val() );
											$( '#wcrp-rental-products-in-person-return-fee-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( $( '#wcrp-rental-products-in-person-return-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?> option:selected' ).attr( 'data-fee' ) );

										}
	
										<?php
									
									}

									?>

								}

								function rentalFormUpdateAjaxRequest() {

									var rentalFormUpdateAjaxRequestData = {
										'action': 'wcrp_rental_products_rental_form_update',
										'nonce': '<?php echo esc_html( wp_create_nonce( 'wcrp_rental_products_rental_form_update' ) ); ?>',
										'qty': $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).val(),
										<?php if ( 'variable' == $product_type ) { ?>
											'product_id': $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="product_id"]' ).val(),
											'variation_id': $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="variation_id"]' ).val(),
										<?php } else { ?>
											'product_id': $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart button[name="add-to-cart"]' ).val(),
										<?php } ?>
										'return_days_threshold': $( '#wcrp-rental-products-return-days-threshold-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
									};

									var rentalFormUpdateAjaxRequest = jQuery.ajax({
										'url':		'<?php echo esc_html( admin_url( 'admin-ajax.php' ) ); ?>',
										'method':	'POST',
										'data':		rentalFormUpdateAjaxRequestData,
									});
 
									rentalFormUpdateAjaxRequest.done( function( response ) {

										$( '#wcrp-rental-products-spinner-<?php echo esc_html( $this->rental_form_id ); ?>' ).hide(); <?php // Hide immediately no fade out so not jumpy ?>

										if ( 'no_product_options_selected' !== response ) {

											if ( response.startsWith( 'unavailable_stock_' ) ) {

												var maxQtyAvailable = response.replace( 'unavailable_stock_', '' );

												if ( '0' == maxQtyAvailable ) {

													var maxQtyAlert = "<?php esc_html_e( 'Sorry, this product is out of stock for rental with the dates, quantities and/or options selected.', 'wcrp-rental-products' ); ?>";

												} else {

													var maxQtyAlert = "<?php esc_html_e( 'Sorry, the maximum quantity available for rental is', 'wcrp-rental-products' ); ?> " + maxQtyAvailable + "<?php esc_html_e( '.', 'wcrp-rental-products' ); ?> <?php esc_html_e( 'Quantity previously entered has been reduced to', 'wcrp-rental-products' ); ?> " + maxQtyAvailable + "<?php esc_html_e( '.', 'wcrp-rental-products' ); ?>";

													$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).val( maxQtyAvailable ).trigger( 'change' );
 
												}

												alert( maxQtyAlert );

											} else {

												if ( isNaN( rentalPrice ) ) { <?php // If no price, this isn't a '' !== condition because rentalPrice already parsed as a float, if empty is NaN, this also ensures that if a price is entered as 0.00 it is still let through to not trigger this no price notice ?>

													alert( '<?php esc_html_e( 'Sorry, this product is unavailable for rental due to a pricing issue, contact us for further information.', 'wcrp-rental-products' ); ?>' ); <?php // Specifically states a pricing issue and not no price set, this is because if pricing period selection and rental or purchase, if additional pricing periods price is set but the overall rental price field used for the default selection is empty then the price in the rental period default selection option name falls back to display the purchasable price assumedly due to how it runs through wc_get_price_to_display (it doesn't let you purchase it due to this alert but if this alert said no price it might be confusing to the customer as it is showing a price, but it is incorrect) ?>

												} else {

													rentalFormCalendar.setOptions({
														lockDays: JSON.parse( response ),
													});

													var rentFromDate = $( '#wcrp-rental-products-rent-from-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
													var rentToDate = $( '#wcrp-rental-products-rent-to-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();

													<?php // Lock days check, this is needed to check that the dates currently selected do not include any lockDays (unavailable days), this is because a user could select a date range that is available then change the quantity or an option, etc, the dates remain selected but they could now include lockDays and therefore we need to stop the product being allowed to be added to cart and display a notice if the previously selected dates now include the lockDays ?>

													let lockDaysCheckPassed = true;

													if ( rentFromDate !== '' && rentToDate !== '' ) {

														const lockDaysCheckRentFromDate = rentFromDate;
														const lockDaysCheckRentToDate = rentToDate;
														const lockDaysCheckRentDateMove = new Date( lockDaysCheckRentFromDate );
														let lockDaysCheckRentDate = lockDaysCheckRentFromDate;

														if ( lockDaysCheckRentDate == lockDaysCheckRentToDate ) {

															<?php // If a single day rental ?>

															lockDaysCheckRentDate = lockDaysCheckRentDateMove.toISOString().slice( 0, 10 );

															$.map( JSON.parse( response ), function( value, index ) {

																if ( lockDaysCheckRentDate == JSON.parse( response )[ index ] ) {

																	lockDaysCheckPassed = false;

																}

															});

														} else {

															<?php // If a multiple day rental loop all dates to check each date, note the single day rental condition above cannot be removed and the below condition replaced with a <=, as with a <= condition this would include an extra date that gets checked when shouldn't on lockDaysCheckRentDate ?>

															while ( lockDaysCheckRentDate < lockDaysCheckRentToDate ) {

																lockDaysCheckRentDate = lockDaysCheckRentDateMove.toISOString().slice( 0, 10 );

																$.map( JSON.parse( response ), function( value, index ) {

																	if ( lockDaysCheckRentDate == JSON.parse( response )[ index ] ) {

																		lockDaysCheckPassed = false;

																	}

																});

																if ( lockDaysCheckPassed == false ) {

																	break;

																}

																lockDaysCheckRentDateMove.setDate( lockDaysCheckRentDateMove.getDate() + 1 );

															}

														}

														if ( false == lockDaysCheckPassed ) {

															alert( '<?php esc_html_e( 'Sorry, this product is unavailable for rental with the dates, quantities and/or options selected.', 'wcrp-rental-products' ); ?>' );

														}

													}

													<?php // If lock days check passed ?>

													if ( true == lockDaysCheckPassed ) {

														<?php // If a rental price, rent from and rent to date set ?>

														if ( !isNaN( rentalPrice ) && '' !== rentFromDate && '' !== rentToDate ) {

															qty = parseInt( $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).val() ); <?php // This field is always in the markup, even if the product is set to sold individually - the field is just hidden and it's value is set to 1 by WooCommerce, so a check to see if it exists and set it to 1 is not required here ?>

															<?php // Date related variables below use timestamps based off 12 noon to ensure calculated correctly when daylight savings time changes during dates ?>

															var rentFromDateSplit = rentFromDate.split( '-' );
															var rentFromDateTimestamp = new Date( rentFromDateSplit[ 0 ], rentFromDateSplit[1] - 1, rentFromDateSplit[ 2 ] , 12, 0, 0, 0 ).getTime(); <?php // -1 as months argument start from 0 ?>

															var rentToDateSplit = rentToDate.split( '-' );
															var rentToDateTimestamp = new Date( rentToDateSplit[ 0 ], rentToDateSplit[1] - 1, rentToDateSplit[ 2 ] , 12, 0, 0, 0 ).getTime(); <?php // -1 as months argument start from 0 ?>

															rentedDays = Math.round( Math.abs( ( rentFromDateTimestamp - rentToDateTimestamp ) / ( 24 * 60 * 60 * 1000 ) ) ) + 1;
															pricingPeriod = <?php echo esc_html( $pricing_period ); ?>;
															pricingTiersData = '<?php echo wp_json_encode( $pricing_tiers_data ); ?>';
															pricingTiersData = JSON.parse( pricingTiersData );
															pricingTierPercent = 0; <?php // If there aren't any matching days greater than the rental days then % is 0 (no change) ?>
															pricingTierHighest = 0;
															priceAdditionalPeriodPercent = <?php echo ( !empty( $price_additional_period_percent ) ? esc_html( $price_additional_period_percent ) : 0 ); ?>;

															<?php if ( !empty( $pricing_tiers_data ) ) { // Stops JS .length undefined if pricing tiers data is empty for any reason, it shouldn't be due to upgrade function but some installs may not ?>

																for ( var i = 0; i < pricingTiersData.days.length; i++ ) {

																	<?php // Highest used as days maybe unordered e.g. 1 is 10%, 5 is 20%, 3 is 15% so we want to use the highest ?>

																	if ( parseInt( pricingTiersData.days[i] ) > pricingTierHighest ) { <?php // parseInt as days ?>

																		if ( rentedDays > parseInt( pricingTiersData.days[i] ) ) {

																			pricingTierHighest = parseInt( pricingTiersData.days[i] ); <?php // parseInt as days ?>
																			pricingTierPercent = parseFloat( pricingTiersData.percent[i] ); <?php // parseFloat as can be multiple decimal places ?>

																		}

																	}

																}

															<?php } ?>

															if ( Math.sign( pricingTierPercent ) == 1 ) { <?php // If positive ?>

																percentMultiplier = 1 + ( pricingTierPercent / 100 );

															} else { // If negative

																percentMultiplier = 1 - ( Math.abs( pricingTierPercent ) / 100 );

															}

															<?php // Set total/cart item price ?>

															if ( totalOverrides.hasOwnProperty( rentedDays ) ) {

																totalOverridesPrice = totalOverrides[rentedDays];

																<?php

																// totalOverridesPrice is amended below as not come through a wc_get_price_to_display

																if ( 'yes' == $taxes_enabled ) {

																	if ( 'taxable' == $product_tax_status ) {

																		if ( 'no' == $prices_include_tax && 'incl' == $tax_display_shop ) {

																			?>

																			totalOverridesPrice = totalOverridesPrice * ( 1 + ( <?php echo esc_html( $product_tax_rate ); ?> / 100 ) );

																			<?php

																		} elseif ( 'yes' == $prices_include_tax && 'excl' == $tax_display_shop ) {

																			?>

																			totalOverridesPrice = totalOverridesPrice / ( 1 + ( <?php echo esc_html( $product_tax_rate ); ?> / 100 ) );

																			<?php

																		}

																	}

																}

																?>

																$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( ( parseFloat( totalOverridesPrice ) * qty ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( totalOverridesPrice );

															} else {

																<?php

																if ( 'fixed' == $pricing_type ) {

																	if ( 'yes' == $pricing_tiers && !empty( $pricing_tiers_data ) ) {

																		?>

																		$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( ( ( rentalPrice ) * qty ) * percentMultiplier ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																		$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalPrice * percentMultiplier );
																	
																	<?php } else { ?>

																		$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( rentalPrice * qty ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																		$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalPrice );

																		<?php

																	}

																} elseif ( 'period' == $pricing_type ) {

																	if ( '1' !== $pricing_period ) {

																		if ( 'yes' == $pricing_period_multiples ) {

																			if ( 'yes' == $pricing_tiers && !empty( $pricing_tiers_data ) ) {

																				if ( 'yes' == $price_additional_periods_percent && (float) $price_additional_period_percent > 0 ) {

																					?>

																					$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( ( rentalPrice + ( ( ( rentalPrice * priceAdditionalPeriodPercent ) / 100 ) * ( ( rentedDays / pricingPeriod ) - 1 ) ) ) * qty * percentMultiplier ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																					$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( ( rentalPrice + ( ( ( rentalPrice * priceAdditionalPeriodPercent ) / 100 ) * ( ( rentedDays / pricingPeriod ) - 1 ) ) ) * percentMultiplier );																																						

																				<?php } else { ?>

																					$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( rentalPrice * ( rentedDays / pricingPeriod ) * qty * percentMultiplier ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																					$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalPrice * ( rentedDays / pricingPeriod ) * percentMultiplier );

																					<?php

																				}

																			} else {

																				if ( 'yes' == $price_additional_periods_percent && (float) $price_additional_period_percent > 0 ) {

																					?>

																					$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( ( rentalPrice + ( ( ( rentalPrice * priceAdditionalPeriodPercent ) / 100 ) * ( ( rentedDays / pricingPeriod ) - 1 ) ) ) * qty ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																					$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalPrice + ( ( ( rentalPrice * priceAdditionalPeriodPercent ) / 100 ) * ( ( rentedDays / pricingPeriod ) - 1 ) ) );																																						

																				<?php } else { ?>

																					$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( rentalPrice * ( rentedDays / pricingPeriod ) * qty ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																					$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalPrice * ( rentedDays / pricingPeriod ) );

																					<?php

																				}

																			}

																		} else {

																			?>

																			$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( rentalPrice * qty ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																			$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalPrice );

																			<?php

																		}

																	} else {

																		if ( 'yes' == $pricing_tiers && !empty( $pricing_tiers_data ) ) {

																			if ( 'yes' == $price_additional_periods_percent && (float) $price_additional_period_percent > 0 ) {

																				?>

																				$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( ( rentalPrice + ( ( ( rentalPrice * priceAdditionalPeriodPercent ) / 100 ) * ( rentedDays - 1 ) ) ) * qty * percentMultiplier ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																				$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( ( rentalPrice + ( ( ( rentalPrice * priceAdditionalPeriodPercent ) / 100 ) * ( rentedDays - 1 ) ) ) * percentMultiplier );

																			<?php } else { ?>

																				$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( rentalPrice * rentedDays * qty * percentMultiplier ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																				$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalPrice * rentedDays * percentMultiplier );

																				<?php

																			}

																		} else {

																			if ( 'yes' == $price_additional_periods_percent && (float) $price_additional_period_percent > 0 ) {
																				
																				?>

																				$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( ( rentalPrice + ( ( ( rentalPrice * priceAdditionalPeriodPercent ) / 100 ) * ( rentedDays - 1 ) ) ) * qty ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																				$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalPrice + ( ( ( rentalPrice * priceAdditionalPeriodPercent ) / 100 ) * ( rentedDays - 1 ) ) );

																			<?php } else { ?>

																				$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( rentalPrice * rentedDays * qty ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																				$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( rentalPrice * rentedDays );

																				<?php
																			
																			}

																		}

																	}

																} elseif ( 'period_selection' == $pricing_type ) {

																	?>

																	periodSelectionPrice = rentalPrice;

																	<?php

																	// periodSelectionPrice is amended below, depending on whether rentalPrice has come through a wc_get_price_to_display or not

																	if ( 'variable' == $product_type && isset( $_GET['rent_period'] ) ) {

																		if ( 'yes' == $taxes_enabled ) {

																			if ( 'taxable' == $product_tax_status ) {

																				if ( 'no' == $prices_include_tax && 'incl' == $tax_display_shop ) {

																					?>

																					periodSelectionPrice = periodSelectionPrice * ( 1 + ( <?php echo esc_html( $product_tax_rate ); ?> / 100 ) );

																					<?php

																				} elseif ( 'yes' == $prices_include_tax && 'excl' == $tax_display_shop ) {

																					?>

																					periodSelectionPrice = periodSelectionPrice / ( 1 + ( <?php echo esc_html( $product_tax_rate ); ?> / 100 ) );

																					<?php

																				}

																			}

																		}

																	}

																	?>

																	$( '#wcrp-rental-products-total-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( parseFloat( periodSelectionPrice * qty ).toFixed( <?php echo esc_html( $price_decimals ); ?> ).replace( '.', '<?php echo wp_kses_post( $price_decimal_separator ); ?>' ) );
																	$( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( periodSelectionPrice );

																	<?php

																}

																?>

															}

															<?php
															
															// Total days, return within, addons, etc
															
															if ( 'period_selection' !== $pricing_type ) {

																// Total days element isn't there for period selection, so not needed if that pricing type

																?>

																$( '#wcrp-rental-products-total-days-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( rentedDays + ' ' + ( rentedDays > 1 ? "<?php esc_html_e( 'days', 'wcrp-rental-products' ); ?>" : "<?php esc_html_e( 'day', 'wcrp-rental-products' ); ?>" ) );

																<?php

															}

															if ( $return_days_threshold > 0 ) {

																?>

																$( '#wcrp-rental-products-rental-return-within-<?php echo esc_html( $this->rental_form_id ); ?>' ).show();

																<?php

															} else {

																?>

																$( '#wcrp-rental-products-rental-return-within-<?php echo esc_html( $this->rental_form_id ); ?>' ).hide();

																<?php

															}

															?>

															$( '#wcrp-rental-products-rental-return-within-days-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( <?php echo esc_html( $return_days_threshold ); ?> );
															$( '#wcrp-rental-products-rental-totals-<?php echo esc_html( $this->rental_form_id ); ?>' ).attr( 'style', 'display: block !important;' ) <?php // Not .show() as !important required (see related public CSS for info) ?>

															<?php // If WooCommerce Product Add-Ons totals element is on page then we know add-ons could be used so we show the excludes info ?>

															if ( $( '#product-addons-total' ).length !== 0 ) { 

																$( '#wcrp-rental-products-excludes-addons-<?php echo esc_html( $this->rental_form_id ); ?>' ).show();

															}

															<?php
															
															// If in person pick up/return allowed and times chosen which incur a fee we show the excludes info

															if ( true == $in_person_pick_up_return_allowed ) {

																?>

																if ( $( '#wcrp-rental-products-in-person-pick-up-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?> option:selected' ).attr( 'data-fee' ) > 0 || $( '#wcrp-rental-products-in-person-return-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?> option:selected' ).attr( 'data-fee' ) > 0 ) {

																	$( '#wcrp-rental-products-excludes-in-person-pick-up-return-fees-<?php echo esc_html( $this->rental_form_id ); ?>' ).show();

																} else {

																	$( '#wcrp-rental-products-excludes-in-person-pick-up-return-fees-<?php echo esc_html( $this->rental_form_id ); ?>' ).hide();

																}

																<?php

															}

															?>

															<?php // Enable add to cart ?>

															rentalFormAddToStatus( 'enable' );

														}

													}

												}

											}

										} else {
											
											if ( $( '#wcrp-rental-products-rental-dates-<?php echo esc_html( $this->rental_form_id ); ?>' ).val() !== '' ) {

												alert( '<?php esc_html_e( 'Please select all required product option(s).', 'wcrp-rental-products' ); ?>' );

											}

										}

										<?php // Validation to reduce risk of hidden field modification, see related functionality in WCRP_Rental_Products_Cart_Checks::add_to_cart_validation() ?>

 										cartItemValidationString = $( '#wcrp-rental-products-cart-item-timestamp-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
										cartItemValidationString += $( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
										cartItemValidationString += $( '#wcrp-rental-products-rent-from-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
										cartItemValidationString += $( '#wcrp-rental-products-rent-to-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
										cartItemValidationString += $( '#wcrp-rental-products-start-days-threshold-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
										cartItemValidationString += $( '#wcrp-rental-products-return-days-threshold-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();

										<?php
										
										if ( true == $in_person_pick_up_return_allowed ) {

											?>

											cartItemValidationString += $( '#wcrp-rental-products-in-person-pick-up-return-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
											cartItemValidationString += $( '#wcrp-rental-products-in-person-pick-up-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
											cartItemValidationString += $( '#wcrp-rental-products-in-person-pick-up-time-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
											cartItemValidationString += $( '#wcrp-rental-products-in-person-pick-up-fee-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
											cartItemValidationString += $( '#wcrp-rental-products-in-person-return-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
											cartItemValidationString += $( '#wcrp-rental-products-in-person-return-date-type-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
											cartItemValidationString += $( '#wcrp-rental-products-in-person-return-time-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();
											cartItemValidationString += $( '#wcrp-rental-products-in-person-return-fee-<?php echo esc_html( $this->rental_form_id ); ?>' ).val();

											<?php

										}
										
										?>

										cartItemValidationString = btoa( cartItemValidationString );

										$( '#wcrp-rental-products-cart-item-validation-<?php echo esc_html( $this->rental_form_id ); ?>' ).val( cartItemValidationString );

									});

								}

								<?php // Ensure rentalFormUpdateAjaxRequest only gets run after the set timeouts, this effectively makes multiple rentalFormUpdate() calls run one by one without stopping the user interacting with the elements (e.g. fields) within the page (the alternative of setting the ajax requests to async: false would cause this). Without the timeout if changes occur to quantity/options, etc quickly the rentalFormUpdateAjaxRequest would fire immediately and the slower requests (e.g. ones that conditionally check lockDays) would end up loading and setting notices/add to cart button status last, so if for example, a user has the quantity set to 1 and could see a total price/add to cart button but then clicked the up arrow on the quantity field multiple times to get to a quantity of 10 and the product was unavailable at that stock level, the previous 9 requests would show the rental totals/add to cart button enabled for a brief period until the rentalFormUpdateAjaxRequest with the 10 qty (which would return unavailable) catches up and therefore in that period of time it would possible for a user to add 10 to cart (this would be caught on the cart/checkout pages by the cart checks, but it's best to catch this within the product page with the below) ?>

								if ( rentalFormUpdateAjaxRequestTimeout ) {

									clearTimeout( rentalFormUpdateAjaxRequestTimeout );

								}

								rentalFormUpdateAjaxRequestTimeout = setTimeout( rentalFormUpdateAjaxRequest, rentalFormUpdateAjaxRequestDelay );

							}

							function addDayToIsoDate( isoDate ) {

								var isoDate = new Date( isoDate );
								isoDate = new Date( isoDate.setDate( isoDate.getDate() + 1 ) );
								isoDate = new Date( isoDate.getTime() - ( isoDate.getTimezoneOffset() * 60 * 1000 ) );
								return isoDate.toISOString().split('T')[0];

							}

							$( document ).on( 'click', '#wcrp-rental-products-add-to-order-<?php echo esc_html( $this->rental_form_id ); ?>', function( e ) {

								e.preventDefault();

								if ( addRentalProductsPopup == true ) {

									var addToOrderAjaxRequestData = {
										'action': 'wcrp_rental_products_rental_form_add_to_order',
										'nonce': '<?php echo esc_html( wp_create_nonce( 'wcrp_rental_products_rental_form_add_to_order' ) ); ?>',
										'qty': $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).val(),
										'order_id': addRentalProductsPopupOrderId,
										<?php if ( 'variable' == $product_type ) { ?>
											'product_id': $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="product_id"]' ).val(),
											'variation_id': $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="variation_id"]' ).val(),
										<?php } else { ?>
											'product_id': $( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart button[name="add-to-cart"]' ).val(),
										<?php } ?>
										'cart_item_price': $( '#wcrp-rental-products-cart-item-price-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
										'rent_from': $( '#wcrp-rental-products-rent-from-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
										'rent_to': $( '#wcrp-rental-products-rent-to-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
										'return_days_threshold': $( '#wcrp-rental-products-return-days-threshold-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
										<?php if ( true == $in_person_pick_up_return_allowed ) { ?>
											'in_person_pick_up_return': $( '#wcrp-rental-products-in-person-pick-up-return-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
											'in_person_pick_up_date': $( '#wcrp-rental-products-in-person-pick-up-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
											'in_person_pick_up_time': $( '#wcrp-rental-products-in-person-pick-up-time-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
											'in_person_pick_up_fee': $( '#wcrp-rental-products-in-person-pick-up-fee-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
											'in_person_return_date': $( '#wcrp-rental-products-in-person-return-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
											'in_person_return_date_type': $( '#wcrp-rental-products-in-person-return-date-type-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
											'in_person_return_time': $( '#wcrp-rental-products-in-person-return-time-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
											'in_person_return_fee': $( '#wcrp-rental-products-in-person-return-fee-<?php echo esc_html( $this->rental_form_id ); ?>' ).val(),
										<?php } ?>
									};

									var addToOrderAjaxRequest = jQuery.ajax({
										'url':		'<?php echo esc_html( admin_url( 'admin-ajax.php' ) ); ?>',
										'method':	'POST',
										'data':		addToOrderAjaxRequestData,
									});

									addToOrderAjaxRequest.done( function( response ) {	
										
										alert( response );

									});

								}

							});

							<?php

							$maybe_use_pricing_period_additional_selections_price = false;

							if ( wcrp_rental_products_is_rental_purchase( $product_id ) && true == $rent ) {

								if ( '' !== get_post_meta( $product_id, '_wcrp_rental_products_rental_purchase_price', true ) ) {

									// wc_get_price_to_display with passed rental purchase price means its converted to inc/exc tax as per settings, str_replace happens incase the store uses a different decimal seperator, sets it to . character, otherwise the calculations for the rental total would be NaN, also this occurs in JS upon variation change, see later in JS

									?>

									let rentalPrice = parseFloat( "<?php echo esc_html( wc_get_price_to_display( $product, array( 'price' => str_replace( $price_decimal_separator, '.', get_post_meta( $product_id, '_wcrp_rental_products_rental_purchase_price', true ) ) ) ) ); ?>" );
									
									<?php 

									if ( 'period_selection' == $pricing_type ) {

										$maybe_use_pricing_period_additional_selections_price = true;

									}

								} else {

									?>

									let rentalPrice = NaN; <?php // No price set, will show as unavailable, see related isNaN conditions, rentalPrice also gets set to this where else rentalPrice is being defined if empty due to the parseFloats ?>

								<?php } ?>

							<?php } else { ?>

								let rentalPrice = parseFloat( "<?php echo esc_html( $product_price ); ?>" ); <?php // Doesn't matter that this is converted to a float, as if price is empty the rental form (inc this code) doesn't get used (no price set) ?>

								<?php 
								
								if ( 'period_selection' == $pricing_type ) {

									$maybe_use_pricing_period_additional_selections_price = true;

								}

							}
							
							if ( true == $maybe_use_pricing_period_additional_selections_price ) {

								if ( false !== $rent_period ) {

									if ( array_key_exists( $rent_period, $pricing_period_additional_selections_array ) ) {

										?>

										rentalPrice = parseFloat( "<?php echo esc_html( wc_get_price_to_display( $product, array( 'price' => str_replace( $price_decimal_separator, '.', $pricing_period_additional_selections_array[$rent_period] ) ) ) ); ?>" );

										<?php

									}

								}

							}

							?>

							let totalOverrides = JSON.parse( '<?php echo wp_kses_post( $total_overrides_json ); ?>' );

							$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).on( 'change', function() {

								rentalFormUpdate();

							});

							<?php

							if ( true == $in_person_pick_up_return_allowed ) {
								
								?>

								$( document ).on( 'change', '#wcrp-rental-products-in-person-pick-up-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>, #wcrp-rental-products-in-person-return-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>', function( e ) {

									rentalFormUpdate();

								});

								<?php

							}

							?>

							$( document ).on( 'change', '#wcrp-rental-products-rental-period-select-<?php echo esc_html( $this->rental_form_id ); ?>', function( e ) {

								window.location = $( this ).val();

							});

							<?php

							if ( 'variable' == $product_type ) {

								?>

								let rentalProductVariations = JSON.parse( $( '.variations_form' ).attr( 'data-product_variations' ) );

								<?php // On page load (covers default varitation options) ?>

								updateVariablesToVariationData();

								$( '.variations_form' ).on( 'show_variation', function() { <?php // show_variation as when a combination of options selected which triggers the variation id to be populated ?>

									updateVariablesToVariationData();

								});

								$( '.variations .reset_variations' ).on( 'click', function() {

									rentalFormReset();

								});

								function updateVariablesToVariationData() {

									Object.keys( rentalProductVariations ).forEach( function( k ) {

										if ( $( '.variations_form input[name="variation_id"]' ).val() == rentalProductVariations[k]['variation_id'] ) {

											<?php
											
											// Rental price

											if ( wcrp_rental_products_is_rental_purchase( $product_id ) && true == $rent ) {

												?>

												rentalPrice = parseFloat( rentalProductVariations[k]['wcrp_rental_products_rental_purchase_price'].replace( '<?php echo wp_kses_post( $price_decimal_separator ); ?>', '.' ) ); <?php // Change the price entered with store decimal separator to use . as needed for calculations (display is changed to use the price decimal separator on display) ?>

											<?php } else { ?>

												rentalPrice = parseFloat( rentalProductVariations[k]['display_price'] ); <?php // Replace not required here as display price returns in normal format not using the decimal separator ?>

												<?php
											
											}

											if ( false !== $rent_period ) {

												// If it is a pricing period additional selection

												?>

												if ( rentalProductVariations[k]['wcrp_rental_products_pricing_period_additional_selections'] !== '[]' ) {

													rentalProductVariationsPricingPeriodAdditionalSelections = JSON.parse( rentalProductVariations[k]['wcrp_rental_products_pricing_period_additional_selections'] );

													if ( rentalProductVariationsPricingPeriodAdditionalSelections.hasOwnProperty( '<?php echo esc_html( $rent_period ); ?>' ) ) {

														rentalPrice = parseFloat( rentalProductVariationsPricingPeriodAdditionalSelections[<?php echo esc_html( $rent_period ); ?>].replace( '<?php echo wp_kses_post( $price_decimal_separator ); ?>', '.' ) ); <?php // Change the price entered with store decimal separator to use . as needed for calculations (display is changed to use the price decimal separator on display) ?>

													}

												}

												<?php
											
											}

											// Total overrides

											if ( 'period_selection' !== $pricing_type ) {

												?>

												if ( rentalProductVariations[k]['wcrp_rental_products_total_overrides'] !== '[]' ) {

													totalOverrides = JSON.parse( rentalProductVariations[k]['wcrp_rental_products_total_overrides'] );

												}

												<?php

											}

											?>

										}

									});

									rentalFormUpdate();

								}

								<?php

							}

							// Rental form calendar
							
							?>

							var availabilityCheckerPopulationInitial = true;

							<?php

							if ( true == $in_person_pick_up_return_allowed ) {
								// Set variables containing the initial pick up/return time/fee select field options, these are then used to revert the options back to initials later if the options have been changed since page load by selecting single day and need reverting back if then multiple days selected
								?>
								var inPersonPickUpTimeFeeSelectOptionsInitial = $( '#wcrp-rental-products-in-person-pick-up-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>' ).html();
								var inPersonReturnTimeFeeSelectOptionsInitial = $( '#wcrp-rental-products-in-person-return-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>' ).html();
								<?php

							}

							?>

							var rentalFormCalendar = new Litepicker({
								element: document.getElementById( 'wcrp-rental-products-rental-dates-<?php echo esc_html( $this->rental_form_id ); ?>' ),
								parentEl: '#wcrp-rental-products-rental-dates-parent-<?php echo esc_html( $this->rental_form_id ); ?>', <?php // Fixes issue with total days tooltip not positioned correctly with inlineMode enabled ?>
								autoApply: <?php echo ( 'yes' == $auto_apply ? 'true' : 'false' ); ?>,
								autoRefresh: true,
								disallowLockDaysInRange: true,
								firstDay: <?php echo esc_html( wcrp_rental_products_rental_form_first_day() ); ?>,
								format: '<?php echo esc_html( wcrp_rental_products_rental_form_date_format() ); ?>',
								inlineMode: <?php echo esc_html( $inline ); ?>,
								lang: '<?php echo esc_html( str_replace( '_', '-', get_locale() ) ); ?>',
								minDate: ( addRentalProductsPopup == false ? '<?php echo esc_html( $minimum_date ); ?>' : null ),
								maxDate: '<?php echo esc_html( wcrp_rental_products_rental_form_maximum_date( 'date' ) ); ?>',
								<?php
								if ( 'yes' !== $pricing_period_multiples ) {
									?>
									minDays: <?php echo esc_html( $minimum_days ); ?>,
									maxDays: <?php echo esc_html( $maximum_days ); ?>,
									<?php
								} else {
									if ( (int) $pricing_period_multiples_maximum > 0 ) {
										?>
										maxDays: <?php echo (int) $pricing_period * (int) $pricing_period_multiples_maximum; ?>,
										<?php
									}
								}
								?>
								numberOfColumns: <?php echo esc_html( $columns ); ?>,
								numberOfMonths: <?php echo esc_html( $months ); ?>,
								plugins: [ 'mobilefriendly' ],
								resetButton: <?php echo ( 'yes' == $reset_button ? 'true' : 'false' ); ?>,
								singleMode: <?php echo ( '1' == $minimum_days && '1' == $maximum_days ? 'true' : 'false' ); ?>,
								selectForward: <?php echo ( '' !== $start_day ? 'true' : 'false' ); ?>,
								tooltipText: {
									one: '<?php esc_html_e( 'day', 'wcrp-rental-products' ); ?>',
									other: '<?php esc_html_e( 'days', 'wcrp-rental-products' ); ?>',
								},
								setup: ( rentalFormCalendar ) => {

									<?php

									// If start day set

									if ( '' !== $start_day ) {

										// Populate rental form start day lock styles

										?>

										var rentalFormStartDayLockStyles = '<style>#wcrp-rental-products-rental-form-<?php echo esc_html( $this->rental_form_id ); ?> .day-item:not( .day-item-weekday-number-<?php echo esc_html( $start_day ); ?> ) { color: var( --litepicker-is-locked-color ) !important; pointer-events: none !important; }</style>';
									
										$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).append( '<div id="wcrp-rental-products-rental-form-start-day-lock-styles-<?php echo esc_html( $this->rental_form_id ); ?>">' + rentalFormStartDayLockStyles + '</div>' );
									
										<?php

									}

									// On render ui

									?>
                                    rentalFormCalendar.on('show', () => {
                                        const panel = document.getElementById("one-time-panel");
                                        panel.classList.remove('no-calender')
                                        panel.classList.add('yes-calender')
                                    })

                                    rentalFormCalendar.on('hide', () => {
                                        const panel = document.getElementById("one-time-panel");
                                        panel.classList.remove('yes-calender')
                                        panel.classList.add('no-calender')
                                    })

									rentalFormCalendar.on( 'render', ( ui ) => {
										<?php // Cancel and apply buttons need to be changed so they are translation based strings, otherwise cannot not be translated (these are not changed as per Litepicker's lang setting) ?>

										$( '#wcrp-rental-products-rental-form-<?php echo esc_html( $this->rental_form_id ); ?> .litepicker .button-apply' ).text( '<?php esc_html_e( 'Apply', 'wcrp-rental-products' ); ?>' );
										$( '#wcrp-rental-products-rental-form-<?php echo esc_html( $this->rental_form_id ); ?> .litepicker .button-cancel' ).text( '<?php esc_html_e( 'Cancel', 'wcrp-rental-products' ); ?>' );

										<?php
											
										// Populate dates using availability checker dates if simple product type (cannot work on other types)
										
										if ( 'simple' == $product_type ) {

											?>

											if ( availabilityCheckerPopulationInitial == true ) { <?php // Ensures only runs once not on every render ?>

												availabilityCheckerPopulationInitial = false;
												availabilityCheckerPopulationDo = true;

												<?php

												$availability_checker_data = wcrp_rental_products_availability_checker_data();

												if ( !empty( $availability_checker_data ) ) {

													if ( !WCRP_Rental_Products_Misc::string_starts_with( wcrp_rental_products_check_availability( $product_id, $availability_checker_data['rent_from'], $availability_checker_data['rent_to'], $availability_checker_data['quantity'], array() ), 'unavailable' ) ) {

														if ( 'period_selection' == $pricing_type ) {

															// If the available rental is a valid period but isn't the selection on the current page then append which is available to the rental period select option text and do not do the population

															$availability_checker_days_total = (string) WCRP_Rental_Products_Misc::days_total_from_dates( $availability_checker_data['rent_from'], $availability_checker_data['rent_to'] );

															if ( ( isset( $pricing_period_additional_selections_array[$availability_checker_days_total] ) || $availability_checker_days_total == $pricing_period ) && $_GET['rent_period'] !== $availability_checker_days_total && $minimum_days !== $availability_checker_days_total && $maximum_days !== $availability_checker_days_total ) {

																?>

																$( '#wcrp-rental-products-rental-period-select-<?php echo esc_html( $this->rental_form_id ); ?> option[data-period="<?php echo esc_html( $availability_checker_days_total ); ?>"]' ).append( "<?php echo ' ' . esc_html__( '-', 'wcrp-rental-products' ) . ' ' . esc_html( apply_filters( 'wcrp_rental_products_text_rental_available', get_option( 'wcrp_rental_products_text_rental_available' ) ) ) . ' ' . esc_html__( 'on previously selected dates', 'wcrp-rental-products' ); ?>" );

																availabilityCheckerPopulationDo = false;

																<?php

															}

														}

														?>

														if ( availabilityCheckerPopulationDo == true ) {

															<?php // Auto populate quantity from availability checker ?>

															$( '#wcrp-rental-products-rental-form-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).find( '.cart input[name="quantity"]' ).val( '<?php echo esc_html( $availability_checker_data['quantity'] ); ?>' );

															<?php // Auto populate dates from availability checker, setDateRange requires the dates to be JS date objects or unix timestamps in milliseconds, if they are just strings they are required to be in the same date format as the litepicker format (which could be any format defined by the user), so here we convert the rent from/to dates to date objects in milliseconds (milliseconds required) - hence strtotime and * 1000 ?>

															rentalFormCalendar.setDateRange( rentalFormCalendar.DateTime( new Date( '<?php echo esc_html( $availability_checker_data['rent_from'] ); ?>' ).toISOString() ).format( '<?php echo esc_html( wcrp_rental_products_rental_form_date_format() ); ?>' ), rentalFormCalendar.DateTime( new Date( '<?php echo esc_html( $availability_checker_data['rent_to'] ); ?>' ).toISOString() ).format( '<?php echo esc_html( wcrp_rental_products_rental_form_date_format() ); ?>' ) );

															<?php // No need for rentalFormUpdate() here as setDateRange triggers a selection of dates which in turn triggers rentalFormUpdate() ?>

															<?php

															// Show auto populate message, this must come after the auto populate dates above, as that triggers a selection of dates which in turn triggers rentalFormUpdate() which triggers rentalFormReset(), where this message gets removed, by this coming after it ensures it remains on page load, then if the rental form is updated, e.g. user changes quantity, options, dates, etc it disappears as no longer relevant

															$availability_checker_quantity = get_option( 'wcrp_rental_products_availability_checker_quantity' );
															
															if ( 'no' == $availability_checker_quantity || true == $product_sold_individually ) {

																?>

																$( '<div id="wcrp-rental-products-availability-checker-auto-population-information-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-availability-checker-auto-population-information wcrp-rental-products-information"><?php esc_html_e( 'The dates above have been automatically populated as this product is available for your previously selected dates.', 'wcrp-rental-products' ); ?> <a href="<?php echo esc_url( add_query_arg( 'wcrp_rental_products_availability_checker_reset', '1' ) ); ?>"><?php esc_html_e( 'Reset?', 'wcrp-rental-products' ); ?></a></div>' ).insertAfter( $( '#wcrp-rental-products-rental-dates-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ) );

																<?php

															} else {

																?>

																$( '<div id="wcrp-rental-products-availability-checker-auto-population-information-<?php echo esc_html( $this->rental_form_id ); ?>" class="wcrp-rental-products-availability-checker-auto-population-information wcrp-rental-products-information"><?php esc_html_e( 'The quantity and dates above have been automatically populated as this product is available for your previously selected quantity and dates.', 'wcrp-rental-products' ); ?> <a href="<?php echo esc_url( add_query_arg( 'wcrp_rental_products_availability_checker_reset', '1' ) ); ?>"><?php esc_html_e( 'Reset?', 'wcrp-rental-products' ); ?></a></div>' ).insertAfter( $( '#wcrp-rental-products-rental-dates-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ) );

																<?php

															}

															?>

														}

														<?php

													}

												}

												?>

											}

											<?php

										} 
										
										?>

									});

									<?php // On render day ?>

									rentalFormCalendar.on( 'render:day', ( day, date ) => {

										<?php // Add weekday number class ?>

										$( day ).addClass( 'day-item-weekday-number-' + date.getDay() );

										<?php

										// Highlight disable start/end dates

										if ( !empty( $disable_rental_start_end_dates_combined_string ) ) {

											?>

											disableRentalStartEndDates = [<?php echo wp_kses_post( $disable_rental_start_end_dates_combined_string ); ?>];

											dateFormatted = new Date( date.dateInstance );
											dateFormatted = new Date( dateFormatted.getTime() - ( dateFormatted.getTimezoneOffset() * 60 * 1000 ) );
											dateFormatted = dateFormatted.toISOString().split( 'T' )[0];

											if ( disableRentalStartEndDates.includes( dateFormatted ) ) {

												$( day ).addClass( 'is-highlighted' );
												$( day ).css( 'pointer-events', 'none' );

											}

											<?php

										}
										
										// Highlight disable start/end days
										
										if ( !empty( $disable_rental_start_end_days ) || '0' == $disable_rental_start_end_days ) {

											?>

											disableRentalStartEndDays = [<?php echo esc_html( $disable_rental_start_end_days ); ?>];

											if ( disableRentalStartEndDays.includes( date.getDay() ) ) {

												$( day ).addClass( 'is-highlighted' );
												$( day ).css( 'pointer-events', 'none' );

											}

											<?php

										}

										?>

									});

									<?php // On date pre select ?>

									rentalFormCalendar.on( 'preselect', ( date1, date2 ) => {

										<?php

										if ( 'yes' == $auto_select_end_date && $minimum_days == $maximum_days ) {

											if ( 'period' == $pricing_type && 'yes' == $pricing_period_multiples ) {

												?>

												var doAutoSelectEndDate = false;

												<?php

											} else {

												?>

												var doAutoSelectEndDate = true;

												<?php

											}

										} else {

											?>

											var doAutoSelectEndDate = false;

											<?php

										}
										
										?>

										if ( doAutoSelectEndDate == true ) {

											<?php // New variables required as date1.add() effects date1, cannot be set to another variable before the days added and then used as date1 still ends up with the added days ?>

											var newDate1 = new Date( date1.getTime() );
											var newDate2 = date1.add( <?php echo esc_html( $minimum_days ); ?> - 1, 'days' ); <?php // -1 ensures end date correct ?>

											rentalFormCalendar.clearSelection();
											rentalFormCalendar.setDateRange( newDate1, newDate2 );
											rentalFormCalendar.hide();

										}

									});

									<?php // On date selection ?>

									rentalFormCalendar.on( 'selected', ( date1, date2 ) => {

										<?php // If singleMode is enabled then only one date is passed and date2 will be undefined so its set to date1 here otherwise the .getDay() calls later will cause an error ?>

										if ( rentalFormCalendar.options.singleMode == true ) {

											date2 = date1;

										}

										<?php

										// If in person pick up/return, a single date is selected and if the single day pick up/return times/fees options available

										if ( true == $in_person_pick_up_return_allowed && !empty( $in_person_pick_up_times_fees_single_day_same_day_array ) && !empty( $in_person_return_times_fees_single_day_same_day_array ) ) {

											// If a single day selected, note this won't work if condition below was date1 == date2 as these are objects which cannot be determined to be the same

											?>

											if ( date1.getTime() == date2.getTime() ) { <?php // Not .getDate() as this is just the day number, so if used that would cause 13th June to 13th July to be matched as one day ?>

												<?php // Change in person pick up time/fee and return time/fee options to single day options ?>

												$( '#wcrp-rental-products-in-person-pick-up-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>' ).html( $( '#wcrp-rental-products-in-person-pick-up-time-fee-single-day-select-<?php echo esc_html( $this->rental_form_id ); ?>' ).html() );

												$( '#wcrp-rental-products-in-person-return-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>' ).html( $( '#wcrp-rental-products-in-person-return-time-fee-single-day-select-<?php echo esc_html( $this->rental_form_id ); ?>' ).html() );

											} else {

												<?php // Change in person pick up time/fee and return time/fee to non-single day options ?>

												$( '#wcrp-rental-products-in-person-pick-up-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>' ).html( inPersonPickUpTimeFeeSelectOptionsInitial );
												$( '#wcrp-rental-products-in-person-return-time-fee-select-<?php echo esc_html( $this->rental_form_id ); ?>' ).html( inPersonReturnTimeFeeSelectOptionsInitial );

											}

											<?php

										}

										// Show in person pick up/return fields if allowed including setting the pick up/return time/fee field label dates based on rental dates selected

										if ( true == $in_person_pick_up_return_allowed ) {

											?>

											$( '#wcrp-rental-products-in-person-pick-up-time-fee-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( date1.format( rentalFormCalendar.options.format ) );

											<?php

											if ( 'same_day' == $in_person_return_date ) {

												?>

												$( '#wcrp-rental-products-in-person-return-time-fee-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( date2.format( rentalFormCalendar.options.format ) );

												<?php

											} else {

												?>

												$( '#wcrp-rental-products-in-person-return-time-fee-date-<?php echo esc_html( $this->rental_form_id ); ?>' ).text( rentalFormCalendar.DateTime( addDayToIsoDate( date2.format( 'YYYY-MM-DD' ) ) ).format( rentalFormCalendar.options.format ) );

												<?php

											}

											?>
											
											$( '#wcrp-rental-products-in-person-pick-up-return-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).fadeIn();

											<?php

										}

										// Start day catch if browser does not support pointer-events: none is not included here as the form is cleared before selection on day click if a user manages to get through the pointer-events: none

										// Disable rental start/end dates catch if browser does not support pointer-events: none

										if ( !empty( $disable_rental_start_end_dates_combined_string ) ) {

											?>

											disableRentalStartEndDates = [<?php echo wp_kses_post( $disable_rental_start_end_dates_combined_string ); ?>];

											if ( disableRentalStartEndDates.includes( date1.format( 'YYYY-MM-DD' ) ) || disableRentalStartEndDates.includes( date2.format( 'YYYY-MM-DD' ) ) ) {

												alert( '<?php esc_html_e( 'Sorry, these dates can not be selected as they start or end on the highlighted days.', 'wcrp-rental-products' ); ?>' );
												rentalFormCalendar.clearSelection();

											}
											
											<?php

										}

										// Disable rental start/end days catch if browser does not support pointer-events: none

										if ( !empty( $disable_rental_start_end_days ) || '0' == $disable_rental_start_end_days ) {

											?>

											disableRentalStartEndDays = [<?php echo esc_html( $disable_rental_start_end_days ); ?>];

											if ( disableRentalStartEndDays.includes( date1.getDay() ) || disableRentalStartEndDays.includes( date2.getDay() ) ) {

												alert( '<?php esc_html_e( 'Sorry, these dates can not be selected as they start or end on the highlighted days.', 'wcrp-rental-products' ); ?>' );
												rentalFormCalendar.clearSelection();

											}

											<?php

										}

										?>

										rentalFormUpdate();

									});

									<?php // On clear date selection e.g. when reset button used if enabled or where rentalFormCalendar.clearSelection() called ?>

									rentalFormCalendar.on( 'clear:selection', () => {
                                        console.log('clear:selection');
										rentalFormReset(); <?php // Form is reset as add to cart button may have been enabled, without this resetting it's possible to add to cart using the previously selected dates even though the rental dates field is empty ?>

										<?php

										// Hide in person pick up/return fields if allowed

										if ( true == $in_person_pick_up_return_allowed ) {

											?>

											$( '#wcrp-rental-products-in-person-pick-up-return-wrap-<?php echo esc_html( $this->rental_form_id ); ?>' ).fadeOut();

											<?php

										}

										?>

									});

									<?php // On range error ?>

									rentalFormCalendar.on( 'error:range', () => {

										<?php // Show alert if dates selected include unavailable days, when this occurs the dates revert to the previously selected available dates or if no dates were selected previously has no date selected yet ?>

										alert( '<?php esc_html_e( 'Sorry, these dates can not be selected as they include unavailable days.', 'wcrp-rental-products' ); ?>' );

										<?php // No need to clear selection as it is an error so no selection was made ?>

										<?php
										
										// If start day set and dates selected result in a range error reset the start day lock styles

										if ( '' !== $start_day ) {
											
											?>

											$( '#wcrp-rental-products-rental-form-start-day-lock-styles-<?php echo esc_html( $this->rental_form_id ); ?>' ).html( rentalFormStartDayLockStyles );

											<?php

										}

										?>

									});

									<?php // On day click, this is not on before:click as additional classes e.g. is-end-date not yet available when before:click triggered, note that the selector of .day-item is intentional, the rental form parent element IDs are not used with this as they are not yet available for the on click method when this is called, therefore if making any changes to the calendar within this function those changes should target the specific rental form incase there are more than rental forms on the page e.g. plugins that show a product page within a product page such as quick view ?>

									$( document ).on( 'click', '.day-item', function() {

										<?php

										// If a set start day and the clicked day is not this then clear selection and reset the start day lock styles

										if ( '' !== $start_day ) {

											?>

											$( '#wcrp-rental-products-rental-form-start-day-lock-styles-<?php echo esc_html( $this->rental_form_id ); ?>' ).html( '' );

											clickedDayItemDate = parseInt( $( this ).attr( 'data-time' ) );
											clickedDayItemDate = new Date( clickedDayItemDate );

											if ( clickedDayItemDate.getDay() !== <?php echo esc_html( $start_day ); ?> ) {

												if ( !$( this ).hasClass( 'is-end-date' ) ) {

													rentalFormCalendar.clearSelection();
													$( '#wcrp-rental-products-rental-form-start-day-lock-styles-<?php echo esc_html( $this->rental_form_id ); ?>' ).html( rentalFormStartDayLockStyles );

												}

											}

											<?php

										}

										?>

									});

								},

								lockDaysFilter: ( pickedDateFrom, pickedDateTo, pickedDates ) => {

									<?php

									// Set lock days based on pricing period multiples
										
									if ( 'yes' == $pricing_period_multiples ) {

										?>

										let pricingPeriod = <?php echo esc_html( $pricing_period ); ?>;

										if ( pickedDates.length === 1 ) {
										
											const pickedDatesClone = pickedDates[0].clone();
											let diff = Math.abs( pickedDatesClone.diff( pickedDateFrom, 'day' ) ) + 1;
											return diff % pricingPeriod !== 0;
										
										}

										<?php

									}

									?>

									return false;

								},

							});

							<?php // Initial rental form update to ensure specific disabled dates, availability checker population, etc is taken into account ?>

							rentalFormUpdate();

						} );

					</script>

					<?php

				}

			}

		}

		public function rental_form_update() {

			global $wpdb;

			$return = '[]';

			if ( isset( $_POST['nonce'] ) ) {

				if ( wp_verify_nonce( sanitize_key( $_POST['nonce'] ), 'wcrp_rental_products_rental_form_update' ) ) {

					if ( isset( $_POST['qty'] ) && isset( $_POST['product_id'] ) && isset( $_POST['return_days_threshold'] ) ) {

						$default_rental_options = wcrp_rental_products_default_rental_options();
						$product_id = sanitize_text_field( $_POST['product_id'] );
						$product_id_is_variation = false;

						$in_person_return_date = get_post_meta( $product_id, '_wcrp_rental_products_in_person_return_date', true ); // $product_id at this point hasn't been changed if product is a variation so it can be used for any type as _wcrp_rental_products_in_person_return_date is only set on the product not variations
						$in_person_return_date = ( ( '' !== $in_person_return_date && 'default' !== $in_person_return_date ) ? $in_person_return_date : $default_rental_options['_wcrp_rental_products_in_person_return_date'] );

						if ( isset( $_POST['variation_id'] ) ) {

							$product_id_is_variation = true;

							if ( !empty( $_POST['variation_id'] ) ) {

								$product_id = sanitize_text_field( $_POST['variation_id'] );

							} else {

								// If it's a variable and options not yet selected

								echo 'no_product_options_selected';
								exit;

							}

						}

						$product = wc_get_product( $product_id );

						// Check availability

						$quantity_needed = (int) sanitize_text_field( $_POST['qty'] );

						if ( isset( $quantity_needed ) ) {

							$rental_stock = get_post_meta( $product_id, '_wcrp_rental_products_rental_stock', true );

							if ( '' == $rental_stock ) {

								// No need to find out if variation and get parent rental stock as parent stock field not used for the parent variable product (it gets hidden on inventory tab if variable like core WooCommerce)

								$stock_available = PHP_INT_MAX; // Unlimited rental stock

							} else {

								$stock_available = (int) $rental_stock;

							}

							// If not unlimited rental stock

							if ( PHP_INT_MAX !== $stock_available ) {

								if ( $quantity_needed > $stock_available ) {

									$return = 'unavailable_stock_' . $stock_available;

								} else {

									// Note that parts of this code block are similar but not identical to code in wcrp_rental_products_check_availability(), it is recommended when updating to consider both

									// Disable dates where not enough stock on dates, we don't run every possible future date selectable in the rental form calendar through wcrp_rental_products_check_availability() as this could potentially be a huge amount of dates depending on the rental form maximum date setting, instead we get the reserved dates from the rentals database table matching the product

									// The query below returns every rental row in the rentals table that has not been removed (e.g. cancelled, refunded, etc) and gets the date and total quantity rented for that date, it includes rentals that have been marked as returned, we deal with if it has been returned and if so whether those dates should remain disabled later depending on immediate rental stock replenishment setting

									// Archive database table data not included as this has all been returned and therefore available

									$disabled_dates = $wpdb->get_results(
										$wpdb->prepare(
											"SELECT reserved_date, SUM( quantity ) AS quantity FROM `{$wpdb->prefix}wcrp_rental_products_rentals` WHERE `product_id` = %d GROUP BY reserved_date;",
											$product_id
										)
									); 

									$return = array();

									if ( !empty( $disabled_dates ) ) {

										$immediate_rental_stock_replenishment = get_option( 'wcrp_rental_products_immediate_rental_stock_replenishment' );

										foreach ( $disabled_dates as $disabled_date ) {

											if ( 'yes' == $immediate_rental_stock_replenishment ) {

												// When immediate rental stock replenishment is enabled we need to know whether the order items related to the $disabled_dates rows have been marked as returned, this can not be done directly in the earlier $disabled_dates query as we need order_item_id to look up the return and if order_item_id is selected in that query it wouldn't be accurate as it would only return the first one not all of them due to the group by

												// Get date, quantity and order_item_id for all rental rows where product id matches and current iteration of disabled date matches, we can then check if the individual order_item_id has been returned and allow the quantity to be made available

												$immediate_rental_stock_replenishment_returned_checks = $wpdb->get_results(
													$wpdb->prepare(
														"SELECT reserved_date, quantity, order_item_id FROM `{$wpdb->prefix}wcrp_rental_products_rentals` WHERE `product_id` = %d AND `reserved_date` = %s;",
														$product_id,
														$disabled_date->reserved_date
													)
												); // It is not possible to join the order item meta table and get the returned meta as this only exists if it has been returned, so rows without this wouldn't be returned, also due to HPOS it is best practice to not use wpdb queries on WooCommerce core database data, so instead we loop through the data returned and use wc_get_order_item_meta() to determine if marked as returned

												if ( !empty( $immediate_rental_stock_replenishment_returned_checks ) ) {

													// Loop through each returned check, this is an array of rows where the date matched and gives us the reserved date, quantity and order item id

													foreach ( $immediate_rental_stock_replenishment_returned_checks as $immediate_rental_stock_replenishment_returned_check ) {

														// Subtract the quantity from $disabled_date->quantity if rental not yet returned to ensure when that is used later to calculate if the date should be disabled the availability is correct to the enabled immediate rental stock replenishment setting

														if ( 'yes' == wc_get_order_item_meta( $immediate_rental_stock_replenishment_returned_check->order_item_id, 'wcrp_rental_products_returned', true ) ) {

															$disabled_date->quantity = (int) $disabled_date->quantity - (int) $immediate_rental_stock_replenishment_returned_check->quantity;

														}

													}

												}

											}

											// Subtract quantity if certain in person pick up/return conditions are met, for details on why these occur see the equivalent conditions and comments in wcrp_rental_products_check_availability()

											if ( false == $product_id_is_variation ) {

												$in_person_return_on_date_checks = $wpdb->get_results(
													$wpdb->prepare(
														"SELECT `oim`.`order_item_id` FROM `{$wpdb->prefix}woocommerce_order_itemmeta` AS `oim` WHERE `meta_key` = 'wcrp_rental_products_in_person_return_date' AND `meta_value` = %s AND EXISTS ( SELECT 1 FROM `{$wpdb->prefix}woocommerce_order_itemmeta` WHERE `order_item_id` = `oim`.`order_item_id` AND `meta_key` = '_product_id' AND `meta_value` = %s );",
														$disabled_date->reserved_date,
														$product_id
													)
												);
							
											} else {
							
												$in_person_return_on_date_checks = $wpdb->get_results(
													$wpdb->prepare(
														"SELECT `oim`.`order_item_id` FROM `{$wpdb->prefix}woocommerce_order_itemmeta` AS `oim` WHERE `meta_key` = 'wcrp_rental_products_in_person_return_date' AND `meta_value` = %s AND EXISTS ( SELECT 1 FROM `{$wpdb->prefix}woocommerce_order_itemmeta` WHERE `order_item_id` = `oim`.`order_item_id` AND `meta_key` = '_variation_id' AND `meta_value` = %s );",
														$disabled_date->reserved_date,
														$product_id
													)
												);
							
											}

											if ( !empty( $in_person_return_on_date_checks ) ) {

												foreach ( $in_person_return_on_date_checks as $in_person_return_on_date_check ) {

													if ( 'same_day' == wc_get_order_item_meta( $in_person_return_on_date_check->order_item_id, 'wcrp_rental_products_in_person_return_date_type', true ) && ( wc_get_order_item_meta( $in_person_return_on_date_check->order_item_id, 'wcrp_rental_products_in_person_pick_up_date', true ) !== wc_get_order_item_meta( $in_person_return_on_date_check->order_item_id, 'wcrp_rental_products_in_person_return_date', true ) ) ) {

														$disabled_date->quantity = (int) $disabled_date->quantity - (int) wc_get_order_item_meta( $in_person_return_on_date_check->order_item_id, '_qty', true );

													}
							
												}
							
											}

											if ( $quantity_needed > ( $stock_available - (int) $disabled_date->quantity ) ) {

												$return[] = $disabled_date->reserved_date;

												// Ensure dates are disabled prior to the disabled date based off the return days threshold so someone can't rent a product which can't be returned in time, this is all the dates between the disabled date and the same disabled date minus the return days

												$current = strtotime( '-' . sanitize_text_field( $_POST['return_days_threshold'] ) . ' days', strtotime( $disabled_date->reserved_date ) );
												$last = strtotime( $disabled_date->reserved_date );

												while ( $current <= $last ) {

													$return[] = gmdate( 'Y-m-d', $current );
													$current = strtotime( '+1 day', $current );

												}

											}

										}

									}

									// Add the manually disabled rental dates and days too

									$return = $this->rental_form_update_add_manually_disabled_dates_days( $return, $product );

								}

							} else { // If is unlimited rental stock

								// Add the manually disabled rental dates and days too (return is empty array as no disable dates where not enough stock on dates as unlimited rental stock)

								$return = $this->rental_form_update_add_manually_disabled_dates_days( array(), $product );

							}

						}

					}

				}

			}

			if ( is_array( $return ) ) {

				$return = map_deep( $return, 'wp_kses_post' );

			}

			echo ( is_array( $return ) ? wp_json_encode( $return ) : esc_html( $return ) );

			exit;

		}

		public function rental_form_add_to_order() {

			$return = __( 'Product could not be added to order due to a general error.', 'wcrp-rental-products' );

			if ( isset( $_POST['nonce'] ) ) {

				if ( wp_verify_nonce( sanitize_key( $_POST['nonce'] ), 'wcrp_rental_products_rental_form_add_to_order' ) ) {

					if ( isset( $_POST['qty'] ) && isset( $_POST['order_id'] ) && isset( $_POST['product_id'] ) && isset( $_POST['cart_item_price'] ) && isset( $_POST['rent_from'] ) && isset( $_POST['rent_to'] ) && isset( $_POST['return_days_threshold'] ) ) {

						if ( !current_user_can( 'manage_woocommerce' ) ) {

							// This condition was added to ensure the user has the correct permissions to be able to add a product to an order (e.g. stopping non-logged in users from manipulating the AJAX code or logged in users logging out via the popup and logging in as a different user), if the user logs out of the dashboard within the popup they get the general error message above (unsure exactly why they don't get this far but it's okay), if the user is logged in but doesn't have the correct permissions it shows this message (e.g. if they try to log out via the popup and log back in as a user without manage_woocommerce capabilities), guests in any scenario cannot add products to the order

							$return = __( 'Product could not be added to order due to insufficient permissions.', 'wcrp-rental-products' );

						} else {

							// Initial data

							$qty = sanitize_text_field( $_POST['qty'] );
							$order_id = sanitize_text_field( $_POST['order_id'] );
							$product_id = sanitize_text_field( $_POST['product_id'] );
							$cart_item_price = sanitize_text_field( $_POST['cart_item_price'] );
							$rent_from = sanitize_text_field( $_POST['rent_from'] );
							$rent_to = sanitize_text_field( $_POST['rent_to'] );
							$return_days_threshold = sanitize_text_field( $_POST['return_days_threshold'] );
							$in_person_pick_up_return = ( isset( $_POST['in_person_pick_up_return'] ) ? sanitize_text_field( $_POST['in_person_pick_up_return'] ) : 'no' );
							$in_person_pick_up_date = ( 'yes' == $in_person_pick_up_return && isset( $_POST['in_person_pick_up_date'] ) ? sanitize_text_field( $_POST['in_person_pick_up_date'] ) : false );
							$in_person_pick_up_time = ( 'yes' == $in_person_pick_up_return && isset( $_POST['in_person_pick_up_time'] ) ? sanitize_text_field( $_POST['in_person_pick_up_time'] ) : false );
							$in_person_pick_up_fee = ( 'yes' == $in_person_pick_up_return && isset( $_POST['in_person_pick_up_fee'] ) ? sanitize_text_field( $_POST['in_person_pick_up_fee'] ) : false );
							$in_person_return_date = ( 'yes' == $in_person_pick_up_return && isset( $_POST['in_person_return_date'] ) ? sanitize_text_field( $_POST['in_person_return_date'] ) : false );
							$in_person_return_date_type = ( isset( $_POST['in_person_return_date_type'] ) ? sanitize_text_field( $_POST['in_person_return_date_type'] ) : false );
							$in_person_return_time = ( 'yes' == $in_person_pick_up_return && isset( $_POST['in_person_return_time'] ) ? sanitize_text_field( $_POST['in_person_return_time'] ) : false );
							$in_person_return_fee = ( 'yes' == $in_person_pick_up_return && isset( $_POST['in_person_return_fee'] ) ? sanitize_text_field( $_POST['in_person_return_fee'] ) : false );
							$taxes_enabled = get_option( 'woocommerce_calc_taxes' );

							$order = wc_get_order( $order_id );

							if ( isset( $_POST['variation_id'] ) ) {

								if ( !empty( sanitize_text_field( $_POST['variation_id'] ) ) ) {

									$product_id = sanitize_text_field( $_POST['variation_id'] ); // Product ID gets set to the variation ID if a variation

								}

							}

							$product = wc_get_product( $product_id );
							$product_name = $product->get_name();
							$product_sku = $product->get_sku();

							// Check availability

							if ( 'available' == wcrp_rental_products_check_availability( $product_id, $rent_from, $rent_to, $qty, array( 'rental_form_add_to_order_checks' => array( 'rent_from_past_date' ) ) ) ) {

								// If in person pick up/return add fees

								if ( 'yes' == $in_person_pick_up_return ) {

									$cart_item_price = $cart_item_price + (float) $in_person_pick_up_fee + (float) $in_person_return_fee;

								}

								// Manipulate cart item price depending on tax settings
	
								if ( 'yes' == $taxes_enabled ) {

									$tax_status = $product->get_tax_status();

									if ( 'taxable' == $tax_status ) {

										$tax_class = $product->get_tax_class();
										$tax_display_shop = get_option( 'woocommerce_tax_display_shop' );

										$taxes = WC_Tax::get_rates( $tax_class );

										if ( !empty( $taxes ) ) { // This ensures array_shift does not cause fatal error if empty, WooCommerce Tax extension can return this empty when the automated taxes option is enabled

											$tax_rates = array_shift( $taxes );
											$tax_rate = array_shift( $tax_rates );

											if ( 'incl' == $tax_display_shop ) {

												$cart_item_price = (float) $cart_item_price / ( 1 + ( $tax_rate / 100 ) ); // Remove the tax as the price used is before tax and tax calculated in tax column separately

											}

										}

									}

								}

								// Add product to order
	
								$total = (float) $cart_item_price * (int) $qty;
								$order_item_id = $order->add_product( $product, $qty, array( 'subtotal' => $total, 'total' => $total ) ); // Sub total and total same

								$order->add_order_note(
									esc_html__( 'Line item added:', 'wcrp-rental-products' ) . ' ' . $product_name . ( !empty( $product_sku ) ? ' ' . esc_html__( '(', 'wcrp-rental-products' ) . $product_sku . esc_html__( ')', 'wcrp-rental-products' ) : '' ) . esc_html__( '.', 'wcrp-rental-products' ), // Line item added is consistent messaging to WooCommerce add purchasable product messaging
									false,
									true
								); 
	
								if ( !empty( $order_item_id ) ) {

									// Add order item meta
	
									wc_add_order_item_meta( $order_item_id, 'wcrp_rental_products_rent_from', $rent_from, true );
									wc_add_order_item_meta( $order_item_id, 'wcrp_rental_products_rent_to', $rent_to, true );
									wc_add_order_item_meta( $order_item_id, 'wcrp_rental_products_return_days_threshold', $return_days_threshold, true );

									// Add in person pick up/return order item meta

									if ( 'yes' == $in_person_pick_up_return ) {

										wc_add_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_pick_up_return', $in_person_pick_up_return, true );
										wc_add_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_pick_up_date', $in_person_pick_up_date, true );
										wc_add_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_pick_up_time', $in_person_pick_up_time, true );
										wc_add_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_pick_up_fee', $in_person_pick_up_fee, true );
										wc_add_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_return_date', $in_person_return_date, true );
										wc_add_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_return_date_type', $in_person_return_date_type, true );
										wc_add_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_return_time', $in_person_return_time, true );
										wc_add_order_item_meta( $order_item_id, 'wcrp_rental_products_in_person_return_fee', $in_person_return_fee, true );

									}

									// Update rentals table

									WCRP_Rental_Products_Order_Save::rentals_add_update( $order_id );

									// Add security deposits

									$security_deposit = WCRP_Rental_Products_Cart_Fees::prepare_security_deposits_array( array(), $qty, sanitize_text_field( $_POST['product_id'] ), ( isset( $_POST['variation_id'] ) ? sanitize_text_field( $_POST['variation_id'] ) : false ) ); // IMPORTANT - this specifically does not use the $product_id variable as this can be either the product or variation id, so the original $_POST data for both IDs is used here instead, variation might not be passed as part of the AJAX data if not variation hence the ternary condition here

									if ( !empty( $security_deposit ) ) {

										// The array will always contain only 1 value in the add product to order context

										$fee = new WC_Order_Item_Fee();
										$fee->set_name( $security_deposit[0]['name'] );
										$fee->set_amount( $security_deposit[0]['amount'] );
										$fee->set_tax_class( $security_deposit[0]['tax_class'] );
										$fee->set_tax_status( $security_deposit[0]['tax_status'] );
										$fee->set_total( $security_deposit[0]['amount'] );
			
										$order->add_item( $fee );
										$order->save();
			
									}
	
									$return = __( 'Product added to order, continue adding other rental products or close this popup to refresh the order screen.', 'wcrp-rental-products' );
	
								}
	
							} else {
	
								$return = __( 'Product could not be added to order due to availability, it may have become unavailable recently prior to the add to order request.', 'wcrp-rental-products' );
	
							}

						}

					}

				}

			}

			echo esc_html( $return );

			exit;

		}

		public function rental_form_update_add_manually_disabled_dates_days( $return, $product ) {

			// This adds the manually disabled dates and days (not rental start/end dates/days as these do not end up as lockDays), parts of this functionality below is similar to code in wcrp_rental_products_check_availability(), updates here may need to be reflected there

			$product_type = $product->get_type();
			$default_rental_options = wcrp_rental_products_default_rental_options();

			// Manually disabled dates

			$manually_disabled_dates_global = get_option( 'wcrp_rental_products_disable_rental_dates' );

			if ( 'variation' == $product_type ) {

				$manually_disabled_dates_product = get_post_meta( $product->get_parent_id(), '_wcrp_rental_products_disable_rental_dates', true );
				$manually_disabled_dates_product = ( '' !== $manually_disabled_dates_product ? $manually_disabled_dates_product : $default_rental_options['_wcrp_rental_products_disable_rental_dates'] );

			} else {

				$manually_disabled_dates_product = get_post_meta( $product->get_id(), '_wcrp_rental_products_disable_rental_dates', true );
				$manually_disabled_dates_product = ( '' !== $manually_disabled_dates_product ? $manually_disabled_dates_product : $default_rental_options['_wcrp_rental_products_disable_rental_dates'] );

			}

			if ( !empty( $manually_disabled_dates_global ) ) {

				$manually_disabled_dates_global = explode( ',', $manually_disabled_dates_global );

				if ( !empty( $manually_disabled_dates_global ) ) {

					foreach ( $manually_disabled_dates_global as $manually_disabled_date_global ) {

						$return[] = $manually_disabled_date_global;
	
					}

				}

			}

			if ( !empty( $manually_disabled_dates_product ) ) {

				$manually_disabled_dates_product = explode( ',', $manually_disabled_dates_product );

				if ( !empty( $manually_disabled_dates_product ) ) {

					foreach ( $manually_disabled_dates_product as $manually_disabled_date_product ) {

						$return[] = $manually_disabled_date_product;
	
					}

				}

			}

			// Manually disabled days

			if ( 'variation' == $product_type ) {

				$manually_disabled_days = get_post_meta( $product->get_parent_id(), '_wcrp_rental_products_disable_rental_days', true );
				$manually_disabled_days = ( '' !== $manually_disabled_days ? $manually_disabled_days : $default_rental_options['_wcrp_rental_products_disable_rental_days'] );

			} else {

				$manually_disabled_days = get_post_meta( $product->get_id(), '_wcrp_rental_products_disable_rental_days', true );
				$manually_disabled_days = ( '' !== $manually_disabled_days ? $manually_disabled_days : $default_rental_options['_wcrp_rental_products_disable_rental_days'] );

			}

			$manually_disabled_days = explode( ',', $manually_disabled_days );

			if ( !empty( $manually_disabled_days ) ) {

				foreach ( $manually_disabled_days as $manually_disabled_day ) {

					$now = strtotime( 'now' );

					while ( gmdate( 'Y-m-d', $now ) !== wcrp_rental_products_rental_form_maximum_date( 'date' ) ) {

						$day_index = gmdate( 'w', $now );

						if ( $day_index == $manually_disabled_day ) {

							$return[] = gmdate( 'Y-m-d', $now );

						}
	
						$now = strtotime( gmdate( 'Y-m-d', $now ) . '+1 day' );

					}

				}

			}

			// Return array

			return $return;

		}

		public function ajax_variation_threshold( $qty, $product ) {

			$product_id = $product->get_id();

			if ( wcrp_rental_products_is_rental_only( $product_id ) || wcrp_rental_products_is_rental_purchase( $product_id ) ) {

				$return = PHP_INT_MAX; // If a variable product has more than a specific number of variations ($qty) then it uses ajax to load the variation data instead of outputting them in the .variations_form element's data-product_variations attribute, this must not occur for rentals as the data-product_variations data is used (if this limit is not lifted data-product_variations is set to false)

			} else {

				$return = $qty;

			}

			return $return;

		}

	}

}
