<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'WCRP_Rental_Products_Order_Filters' ) ) {

	class WCRP_Rental_Products_Order_Filters {

		public function __construct() {

			add_action( 'restrict_manage_posts', array( $this, 'rentals_filter_field' ) );
			add_action( 'posts_where', array( $this, 'rentals_filter_clause' ) );

		}

		public function rentals_filter_field() {

			global $typenow;
			
			if ( 'shop_order' !== $typenow ) {

				return;

			}

			$filter = '';

			if ( isset( $_GET[ 'wcrp_rental_products_rentals_filter' ] ) && !empty( $_GET[ 'wcrp_rental_products_rentals_filter' ] ) ) {

				$filter = sanitize_text_field( $_GET[ 'wcrp_rental_products_rentals_filter' ] );

			}

			?>

			<select name="wcrp_rental_products_rentals_filter">
				<option value=""><?php esc_html_e( 'Rentals filter', 'wcrp-rental-products' ); ?></option>
				<option value="inc"<?php echo ( 'inc' == $filter ? ' selected' : '' ); ?>><?php esc_html_e( 'Orders including rentals', 'wcrp-rental-products' ); ?></option>
				<option value="exc"<?php echo ( 'exc' == $filter ? ' selected' : '' ); ?>><?php esc_html_e( 'Orders excluding rentals', 'wcrp-rental-products' ); ?></option>
			</select>
		
			<?php

		}

		public function rentals_filter_clause( $where ) {

			global $typenow;
			global $wpdb;

			if ( is_search() && 'shop_order' == $typenow ) {

				if ( isset( $_GET[ 'wcrp_rental_products_rentals_filter' ] ) && !empty( $_GET[ 'wcrp_rental_products_rentals_filter' ] ) ) {

					$filter = trim( sanitize_text_field( $_GET[ 'wcrp_rental_products_rentals_filter' ] ) );
					$filter = $wpdb->_escape( $filter );

					// Note that wcrp_rental_products_rent_from is used in the query as every rental will have this, except for cancelled which removes rent from/to meta, hence wcrp_rental_products_cancelled also included in the query

					if ( 'inc' == $filter ) {

						$where .= " AND ($wpdb->posts.ID IN(
						SELECT order_id
						FROM `{$wpdb->prefix}woocommerce_order_items` as oi
						INNER JOIN `{$wpdb->prefix}woocommerce_order_itemmeta` as oim
						ON oi.order_item_id = oim.order_item_id
						WHERE meta_key IN ( 'wcrp_rental_products_rent_from', 'wcrp_rental_products_cancelled' )
						AND oi.order_id = $wpdb->posts.ID ) )";

					} elseif ( 'exc' == $filter ) {

						$where .= " AND ($wpdb->posts.ID NOT IN(
						SELECT order_id
						FROM `{$wpdb->prefix}woocommerce_order_items` as oi
						INNER JOIN `{$wpdb->prefix}woocommerce_order_itemmeta` as oim
						ON oi.order_item_id = oim.order_item_id
						WHERE meta_key IN ( 'wcrp_rental_products_rent_from', 'wcrp_rental_products_cancelled' )
						AND oi.order_id = $wpdb->posts.ID ) )";

					}

				}

			}

			return $where;

		}

	}

}
