<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'WCRP_Rental_Products_Availability_Checker' ) ) {

	class WCRP_Rental_Products_Availability_Checker {

		public function __construct() {

			add_action( 'wp_loaded', array( $this, 'cookies' ) );

		}

		public function cookies() {

			$set_cookies = false;
			$unset_cookies = false;

			if ( isset( $_POST['wcrp_rental_products_availability_checker_nonce'] ) && wp_verify_nonce( sanitize_key( $_POST['wcrp_rental_products_availability_checker_nonce'] ), 'wcrp_rental_products_availability_checker' ) ) {

				if ( isset( $_POST['wcrp_rental_products_availability_checker_rent_from'] ) && isset( $_POST['wcrp_rental_products_availability_checker_rent_to'] ) && isset( $_POST['wcrp_rental_products_availability_checker_quantity'] ) ) {

					// If setting from availability checker unapplied form

					$set_cookies = true;

				} elseif ( isset( $_POST['wcrp_rental_products_availability_checker_reset'] ) ) {

					// If resetting from availability checker applied form
	
					$unset_cookies = true;
	
				}

			} else {

				// If resetting from rental form auto population reset link

				if ( isset( $_GET['wcrp_rental_products_availability_checker_reset'] ) ) {

					$unset_cookies = true;

				}

			}

			if ( true == $set_cookies ) {

				// Set cookies for 30 days

				setcookie( 'wcrp_rental_products_availability_checker_rent_from', sanitize_text_field( $_POST['wcrp_rental_products_availability_checker_rent_from'] ), time() + 60 * 60 * 24 * 30, '/' );
				setcookie( 'wcrp_rental_products_availability_checker_rent_to', sanitize_text_field( $_POST['wcrp_rental_products_availability_checker_rent_to'] ), time() + 60 * 60 * 24 * 30, '/' );
				setcookie( 'wcrp_rental_products_availability_checker_quantity', sanitize_text_field( $_POST['wcrp_rental_products_availability_checker_quantity'] ), time() + 60 * 60 * 24 * 30, '/' );

			} else {

				if ( true == $unset_cookies ) {

					// Unset cookies

					unset( $_COOKIE['wcrp_rental_products_availability_checker_rent_from'] ); // PHP cookie
					setcookie( 'wcrp_rental_products_availability_checker_rent_from', null, time() - 3600, '/' ); // Browser cookie

					unset( $_COOKIE['wcrp_rental_products_availability_checker_rent_to'] ); // PHP cookie
					setcookie( 'wcrp_rental_products_availability_checker_rent_to', null, time() - 3600, '/' ); // Browser cookie

					unset( $_COOKIE['wcrp_rental_products_availability_checker_quantity'] ); // PHP cookie
					setcookie( 'wcrp_rental_products_availability_checker_quantity', null, time() - 3600, '/' ); // Browser cookie

				}

			}

		}

		public static function display( $atts ) {

			if ( is_cart() || is_checkout() ) { // Availability checker is not shown on products in the cart as products have already been selected at this point and it also uses the WooCommerce notice CSS classes and WooCommerce moves notices with these to the top of the page on cart when emptied.  We have also included the checkout condition here incase any themes/custom dev work include availability checker there

				return '';

			}

			ob_start();

			$availability_checker_id = uniqid(); // Ensures if multiple availability checkers on page the elements within are targeted instead of the other instances - form names do not matter as submitted
			$availability_checker_data = wcrp_rental_products_availability_checker_data();
			$availability_checker_auto_apply = get_option( 'wcrp_rental_products_rental_form_auto_apply' );
			$availability_checker_minimum_days = get_option( 'wcrp_rental_products_availability_checker_minimum_days' );
			$availability_checker_maximum_days = get_option( 'wcrp_rental_products_availability_checker_maximum_days' );
			$availability_checker_period_multiples = get_option( 'wcrp_rental_products_availability_checker_period_multiples' );
			$availability_checker_quantity = get_option( 'wcrp_rental_products_availability_checker_quantity' );
			$availability_checker_reset_button = get_option( 'wcrp_rental_products_rental_form_reset_button' );

			// Availability checker start

			echo '<div id="wcrp-rental-products-availability-checker-' . esc_html( $availability_checker_id ) . '" class="wcrp-rental-products-availability-checker">';

			if ( !empty( $availability_checker_data ) ) {

				// Availability checker applied start

				echo '<div class="wcrp-rental-products-availability-checker-applied">';

				// Notice

				echo '<div class="wcrp-rental-products-availability-checker-applied-notice woocommerce-message">' . esc_html( apply_filters( 'wcrp_rental_products_text_availability_checker_applied', get_option( 'wcrp_rental_products_text_availability_checker_applied' ) ) ) . '</div>';

				// Availability checker applied info start

				echo '<div class="wcrp-rental-products-availability-checker-applied-info">';

				// Availability checker applied info row rent from

				echo '<div class="wcrp-rental-products-availability-checker-applied-info-row wcrp-rental-products-availability-checker-status-applied-info-row-rent-from">';
				echo '<span class="wcrp-rental-products-availability-checker-applied-info-row-heading wcrp-rental-products-availability-checker-applied-info-row-heading-rent-from">';
				echo esc_html( apply_filters( 'wcrp_rental_products_text_rent_from', get_option( 'wcrp_rental_products_text_rent_from' ) ) );
				echo '</span>';
				echo '<span class="wcrp-rental-products-availability-checker-applied-info-row-value wcrp-rental-products-availability-checker-applied-info-row-value-rent-from">';
				echo esc_html( date_i18n( wcrp_rental_products_rental_date_format(), strtotime( $availability_checker_data['rent_from'] ) ) );
				echo '</span>';
				echo '</div>';

				// Availability checker applied info row rent to

				echo '<div class="wcrp-rental-products-availability-checker-applied-info-row wcrp-rental-products-availability-checker-status-applied-info-row-rent-to">';
				echo '<span class="wcrp-rental-products-availability-checker-applied-info-row-heading wcrp-rental-products-availability-checker-applied-info-row-heading-rent-to">';
				echo esc_html( apply_filters( 'wcrp_rental_products_text_rent_to', get_option( 'wcrp_rental_products_text_rent_to' ) ) );
				echo '</span>';
				echo '<span class="wcrp-rental-products-availability-checker-applied-info-row-value wcrp-rental-products-availability-checker-applied-info-row-value-rent-to">';
				echo esc_html( date_i18n( wcrp_rental_products_rental_date_format(), strtotime( $availability_checker_data['rent_to'] ) ) );
				echo '</span>';
				echo '</div>';

				// Availability checker applied info row quantity

				if ( 'yes' == $availability_checker_quantity ) {

					echo '<div class="wcrp-rental-products-availability-checker-applied-info-row wcrp-rental-products-availability-checker-status-applied-info-row-quantity">';
					echo '<span class="wcrp-rental-products-availability-checker-applied-info-row-heading wcrp-rental-products-availability-checker-applied-info-row-heading-quantity">';
					echo esc_html__( 'Quantity', 'wcrp-rental-products' );
					echo '</span>';
					echo '<span class="wcrp-rental-products-availability-checker-applied-info-row-value wcrp-rental-products-availability-checker-applied-info-row-value-quantity">';
					echo esc_html( $availability_checker_data['quantity'] );
					echo '</span>';
					echo '</div>';

				}

				// Availability checker applied info end

				echo '</div>';

				// Availability checker applied form start

				echo '<form id="wcrp-rental-products-availability-checker-applied-form-' . esc_html( $availability_checker_id ) . '" class="wcrp-rental-products-availability-checker-applied-form" method="post">';

				// Availability checker applied form hidden fields

				wp_nonce_field( 'wcrp_rental_products_availability_checker', 'wcrp_rental_products_availability_checker_nonce' );

				// Availability checker applied form submit

				echo '<button type="submit" id="wcrp-rental-products-availability-checker-reset-' . esc_html( $availability_checker_id ) . '" class="wcrp-rental-products-availability-checker-button button" name="wcrp_rental_products_availability_checker_reset" value="1">' . esc_html( apply_filters( 'wcrp_rental_products_text_reset_dates', get_option( 'wcrp_rental_products_text_reset_dates' ) ) ) . '</button>';
				
				// Availability checker applied form end
				
				echo '</form>';

				// Availability checker applied end

				echo '</div>';

			} else {

				// Availability checker unapplied start

				echo '<div class="wcrp-rental-products-availability-checker-unapplied">';

				// Availability checker unapplied form start

				echo '<form id="wcrp-rental-products-availability-checker-unapplied-form-' . esc_html( $availability_checker_id ) . '" class="wcrp-rental-products-availability-checker-unapplied-form" method="post">';

				// Availability checker unapplied form hidden fields

				wp_nonce_field( 'wcrp_rental_products_availability_checker', 'wcrp_rental_products_availability_checker_nonce' );
				echo '<input type="hidden" id="wcrp-rental-products-availability-checker-rent-from-' . esc_html( $availability_checker_id ) . '" class="wcrp-rental-products-availability-checker-rent-from" name="wcrp_rental_products_availability_checker_rent_from" readonly="readonly">';
				echo '<input type="hidden" id="wcrp-rental-products-availability-checker-rent-to-' . esc_html( $availability_checker_id ) . '" class="wcrp-rental-products-availability-checker-rent-to" name="wcrp_rental_products_availability_checker_rent_to" readonly="readonly">';
				
				// Availability checker unapplied form dates
				
				echo '<div class="wcrp-rental-products-availability-checker-unapplied-form-field wcrp-rental-products-availability-checker-unapplied-form-field-dates">';
				echo '<label class="wcrp-rental-products-availability-checker-unapplied-form-field-label wcrp-rental-products-availability-checker-unapplied-form-field-label-dates" for="wcrp-rental-products-availability-checker-dates-' . esc_html( $availability_checker_id ) . '">' . esc_html__( 'Dates', 'wcrp-rental-products' ) . '</label>';
				echo '<div id="wcrp-rental-products-availability-checker-parent-' . esc_html( $availability_checker_id ) . '" class="wcrp-rental-products-availability-checker-parent">';
				echo '<input type="text" id="wcrp-rental-products-availability-checker-dates-' . esc_html( $availability_checker_id ) . '" class="wcrp-rental-products-availability-checker-dates" name="wcrp_rental_products_availability_checker_dates" placeholder="' . esc_html( apply_filters( 'wcrp_rental_products_text_select_dates', get_option( 'wcrp_rental_products_text_select_dates' ) ) ) . '" readonly="readonly" required>';
				echo '</div>';
				echo '</div>';

				// Availability checker unapplied form quantity, this is hidden not removed if availability checker quantity is disabled as the field is still required to be submitted to allow the availability checker to work, quantity must be set, for disabled quantity this defaults to 1
				
				echo '<div class="wcrp-rental-products-availability-checker-unapplied-form-field wcrp-rental-products-availability-checker-unapplied-form-field-quantity' . ( 'no' == $availability_checker_quantity ? ' wcrp-rental-products-availability-checker-unapplied-form-field-hidden' : '' ) . '">';
				echo '<label class="wcrp-rental-products-availability-checker-unapplied-form-field-label wcrp-rental-products-availability-checker-unapplied-form-field-label-quantity" for="wcrp-rental-products-availability-checker-quantity-' . esc_html( $availability_checker_id ) . '">' . esc_html__( 'Quantity', 'wcrp-rental-products' ) . '</label>';
				echo '<input type="number" id="wcrp-rental-products-availability-checker-quantity-' . esc_html( $availability_checker_id ) . '" class="wcrp-rental-products-availability-checker-quantity" name="wcrp_rental_products_availability_checker_quantity" min="1" value="1">';
				echo '</div>';

				// Availability checker unapplied form submit

				echo '<button type="submit" id="wcrp-rental-products-availability-checker-submit-' . esc_html( $availability_checker_id ) . '" class="wcrp-rental-products-availability-checker-button button" name="wcrp_rental_products_availability_checker_submit">' . esc_html( apply_filters( 'wcrp_rental_products_text_check_availability', get_option( 'wcrp_rental_products_text_check_availability' ) ) ) . '</button>';

				// Availability checker unapplied form end

				echo '</form>';

				// Availability checker unapplied scripts ?>

				<script>

					jQuery( document ).ready( function( $ ) {

						function availabilityCheckerCalendarFormatSelectedDate( date ) {

							var d = new Date( date.dateInstance ),
							month = '' + ( d.getMonth() + 1 ),
							day = '' + d.getDate(),
							year = d.getFullYear();

							if ( month.length < 2 ) {

								month = '0' + month;

							}

							if ( day.length < 2 ) {

								day = '0' + day;

							}

							return [ year, month, day ].join( '-' );

						}

						var availabilityCheckerCalendar = new Litepicker({
							element: document.getElementById( 'wcrp-rental-products-availability-checker-dates-<?php echo esc_html( $availability_checker_id ); ?>' ),
							parentEl: '#wcrp-rental-products-availability-checker-parent-<?php echo esc_html( $availability_checker_id ); ?>', <?php // Fixes issue with total days tooltip not positioned correctly with inlineMode enabled ?>
							autoApply: <?php echo ( 'yes' == $availability_checker_auto_apply ? 'true' : 'false' ); ?>,
							autoRefresh: true,
							firstDay: <?php echo esc_html( wcrp_rental_products_rental_form_first_day() ); ?>,
							format: '<?php echo esc_html( wcrp_rental_products_rental_form_date_format() ); ?>',
							lang: '<?php echo esc_html( str_replace( '_', '-', get_locale() ) ); ?>',
							<?php if ( 'no' == $availability_checker_period_multiples || 'yes' == $availability_checker_period_multiples && ( $availability_checker_minimum_days !== $availability_checker_maximum_days ) ) { ?>
								minDays: <?php echo ( (int) $availability_checker_minimum_days > 0 ? esc_html( $availability_checker_minimum_days ) : 'null' ); ?>,
								maxDays: <?php echo ( (int) $availability_checker_maximum_days > 0 ? esc_html( $availability_checker_maximum_days ) : 'null' ); ?>,
							<?php } ?>
							minDate: '<?php echo esc_html( gmdate( 'Y-m-d' ) ); ?>',
							maxDate: '<?php echo esc_html( wcrp_rental_products_rental_form_maximum_date( 'date' ) ); ?>',
							plugins: ['mobilefriendly'],
							singleMode: <?php echo ( '1' == $availability_checker_minimum_days && '1' == $availability_checker_maximum_days ? 'true' : 'false' ); ?>,
							resetButton: <?php echo ( 'yes' == $availability_checker_reset_button ? 'true' : 'false' ); ?>,
							tooltipText: {
								one: '<?php esc_html_e( 'day', 'wcrp-rental-products' ); ?>',
								other: '<?php esc_html_e( 'days', 'wcrp-rental-products' ); ?>',
							},
							setup: ( availabilityCheckerCalendar ) => {

								<?php // On render ui ?>

								availabilityCheckerCalendar.on( 'render', ( ui ) => {

									<?php // Cancel and apply buttons need to be changed so they are translation based strings, otherwise cannot not be translated (these are not changed as per Litepicker's lang setting) ?>

									$( '#wcrp-rental-products-availability-checker-unapplied-form-<?php echo esc_html( $availability_checker_id ); ?> .litepicker .button-apply' ).text( '<?php esc_html_e( 'Apply', 'wcrp-rental-products' ); ?>' );
									$( '#wcrp-rental-products-availability-checker-unapplied-form-<?php echo esc_html( $availability_checker_id ); ?> .litepicker .button-cancel' ).text( '<?php esc_html_e( 'Cancel', 'wcrp-rental-products' ); ?>' );

								});

								<?php // On selected ?>

								availabilityCheckerCalendar.on( 'selected', ( date1, date2 ) => {
									<?php // If singleMode is enabled then only one date is passed and date2 will be undefined so its set to date1 here otherwise availabilityCheckerCalendarFormatSelectedDate() calls will cause an error ?>
									if ( availabilityCheckerCalendar.options.singleMode == true ) {
										date2 = date1;
									}
									$( '#wcrp-rental-products-availability-checker-rent-from-<?php echo esc_html( $availability_checker_id ); ?>' ).val( availabilityCheckerCalendarFormatSelectedDate( date1 ) ); // As date2 wouldn't exist with singleMode true
									$( '#wcrp-rental-products-availability-checker-rent-to-<?php echo esc_html( $availability_checker_id ); ?>' ).val( availabilityCheckerCalendarFormatSelectedDate( date2 ) );
								});

							},
							lockDaysFilter: ( pickedDateFrom, pickedDateTo, pickedDates ) => {
								<?php
								if ( 'yes' == $availability_checker_period_multiples && (int) $availability_checker_minimum_days > 0 && (int) $availability_checker_maximum_days > 0 && ( $availability_checker_minimum_days == $availability_checker_maximum_days ) ) {
									?>
									let pricingPeriod = <?php echo esc_html( $availability_checker_minimum_days ); ?>; <?php // Minimum used, but min/max are the same, it's just setting the period ?>
									if ( pickedDates.length === 1 ) {
										const pickedDatesClone = pickedDates[0].clone();
										let diff = Math.abs( pickedDatesClone.diff( pickedDateFrom, 'day' ) ) + 1;
										return diff % pricingPeriod !== 0;
									}
									<?php
								}
								?>
								return false;
							},
						});

						$( '#wcrp-rental-products-availability-checker-unapplied-form-<?php echo esc_html( $availability_checker_id ); ?>' ).submit( function( e ) {

							if ( '' == $( '#wcrp-rental-products-availability-checker-rent-from-<?php echo esc_html( $availability_checker_id ); ?>' ).val() || '' == $( '#wcrp-rental-products-availability-checker-rent-to-<?php echo esc_html( $availability_checker_id ); ?>' ).val() || '' == $( '#wcrp-rental-products-availability-checker-quantity-<?php echo esc_html( $availability_checker_id ); ?>' ).val() ) {

								e.preventDefault();
								<?php // translators: %s: select dates text ?>
								alert( '<?php echo sprintf( esc_html__( 'Please %s and quantity to check availability', 'wcrp-rental-products' ), esc_html( strtolower( apply_filters( 'wcrp_rental_products_text_select_dates', get_option( 'wcrp_rental_products_text_select_dates' ) ) ) ) ); ?>' );

							}

						});

					});

				</script>

				<?php

				// Availability checker unapplied end

				echo '</div>';
			
			}

			// Availability checker end

			echo '</div>';

			return ob_get_clean();

		}

		public static function status( $product ) {

			if ( is_cart() || is_checkout() ) { // Availability checker status is not shown on products in the cart as products have already been selected at this point and it also uses the WooCommerce notice CSS classes and WooCommerce moves notices with these to the top of the page on cart when emptied, so without this the availability checker status on products in the cross sells section (or if the theme/custom dev work has added them elsewhere) would all be at the top of the page. We have also included the checkout condition here incase any themes/custom dev work include products with availability checker statuses there

				return '';

			}

			$status = '';

			$availability_checker_data = wcrp_rental_products_availability_checker_data();
			$availability_checker_quantity = get_option( 'wcrp_rental_products_availability_checker_quantity' );

			if ( !empty( $availability_checker_data ) ) {

				$product_id = $product->get_id();
				$product_type = $product->get_type();

				if ( 'grouped' == $product_type ) {

					if ( true == WCRP_Rental_Products_Product_Display::grouped_product_check_all_products_rental_only( $product ) ) { // Show select options if grouped product only contains rental only products (if rental or purchase/other then no status as select options text may not be relevant)

						$status .= self::status_select_options();

					}

				} else {

					if ( wcrp_rental_products_is_rental_only( $product_id ) || wcrp_rental_products_is_rental_purchase( $product_id ) ) {

						if ( 'simple' == $product_type ) {

							$availability = wcrp_rental_products_check_availability( $product_id, $availability_checker_data['rent_from'], $availability_checker_data['rent_to'], $availability_checker_data['quantity'], array() );

							if ( 'unavailable_non_rental' !== $availability ) {

								// Availability checker status start

								$status .= '<div class="wcrp-rental-products-availability-checker-status' . ( WCRP_Rental_Products_Misc::string_starts_with( $availability, 'unavailable' ) ? ' wcrp-rental-products-availability-checker-status-unavailable woocommerce-error' : ' wcrp-rental-products-availability-checker-status-available woocommerce-message' ) . '">';

								// Availability checker status title

								$status .= '<div class="wcrp-rental-products-availability-checker-status-title">';

								if ( WCRP_Rental_Products_Misc::string_starts_with( $availability, 'unavailable' ) ) {

									$status .= esc_html( apply_filters( 'wcrp_rental_products_text_rental_unavailable', get_option( 'wcrp_rental_products_text_rental_unavailable' ) ) );

								} else {

									$status .= esc_html( apply_filters( 'wcrp_rental_products_text_rental_available', get_option( 'wcrp_rental_products_text_rental_available' ) ) );

								}

								$status .= '</div>';

								// Availability checker status info start

								$status .= '<div class="wcrp-rental-products-availability-checker-status-info">';

								// Availability checker status info row rent from

								$status .= '<div class="wcrp-rental-products-availability-checker-status-info-row wcrp-rental-products-availability-checker-status-info-row-rent-from">';
								$status .= '<span class="wcrp-rental-products-availability-checker-status-info-row-heading wcrp-rental-products-availability-checker-status-info-row-heading-rent-from">';
								$status .= apply_filters( 'wcrp_rental_products_text_rent_from', get_option( 'wcrp_rental_products_text_rent_from' ) ) . __( ':', 'wcrp-rental-products' );
								$status .= '</span>';
								$status .= '<span class="wcrp-rental-products-availability-checker-status-info-row-value wcrp-rental-products-availability-checker-status-info-row-value-rent-from">';
								$status .= date_i18n( wcrp_rental_products_rental_date_format(), strtotime( $availability_checker_data['rent_from'] ) );
								$status .= '</span>';
								$status .= '</div>';

								// Availability checker status info row rent to

								$status .= '<div class="wcrp-rental-products-availability-checker-status-info-row wcrp-rental-products-availability-checker-status-info-row-rent-to">';
								$status .= '<span class="wcrp-rental-products-availability-checker-status-info-row-heading wcrp-rental-products-availability-checker-status-info-row-heading-rent-to">';
								$status .= apply_filters( 'wcrp_rental_products_text_rent_to', get_option( 'wcrp_rental_products_text_rent_to' ) ) . __( ':', 'wcrp-rental-products' );
								$status .= '</span>';
								$status .= '<span class="wcrp-rental-products-availability-checker-status-info-row-value wcrp-rental-products-availability-checker-status-info-row-value-rent-to">';
								$status .= date_i18n( wcrp_rental_products_rental_date_format(), strtotime( $availability_checker_data['rent_to'] ) );
								$status .= '</span>';
								$status .= '</div>';

								// Availability checker status info row quantity

								if ( 'yes' == $availability_checker_quantity ) {

									$status .= '<div class="wcrp-rental-products-availability-checker-status-info-row wcrp-rental-products-availability-checker-status-info-row-quantity">';
									$status .= '<span class="wcrp-rental-products-availability-checker-status-info-row-heading wcrp-rental-products-availability-checker-status-info-row-heading-quantity">';
									$status .= esc_html__( 'Quantity:', 'wcrp-rental-products' );
									$status .= '</span>';
									$status .= '<span class="wcrp-rental-products-availability-checker-status-info-row-value wcrp-rental-products-availability-checker-status-info-row-value-quantity">';
									$status .= $availability_checker_data['quantity'];
									$status .= '</span>';
									$status .= '</div>';

								}

								// Availability checker status info end

								$status .= '</div>';

								// Availability checker status end
								
								$status .= '</div>';

							}

						} else {

							$status .= self::status_select_options();

						}

					}

				}

			}

			return $status;

		}

		public static function status_select_options() {

			if ( is_cart() || is_checkout() ) { // Availability checker status select options is not shown on products in the cart as products have already been selected at this point and it also uses the WooCommerce notice CSS classes and WooCommerce moves notices with these to the top of the page on cart when emptied, so without this the availability checker status select options on products in the cross sells section (or if the theme/custom dev work has added them elsewhere) would all be at the top of the page. We have also included the checkout condition here incase any themes/custom dev work include products with availability checker status select options there

				return '';

			}

			$status = '<div class="wcrp-rental-products-availability-checker-status-select-options woocommerce-info"><strong>' . __( 'Select dates/options', 'wcrp-rental-products' ) . ' ' . __( 'to', 'wcrp-rental-products' ) . ' ' . strtolower( esc_html( apply_filters( 'wcrp_rental_products_text_check_availability', get_option( 'wcrp_rental_products_text_check_availability' ) ) ) ) . '</strong></div>';

			return $status;

		}

	}

}
