"use strict";
/*!
 * Accordion v3.1.1
 * Simple accordion created in pure Javascript.
 * https://github.com/michu2k/Accordion
 *
 * Copyright (c) Michał Strumpf
 * Published under MIT License
 */(function(e){"use strict";var t=0;var n=function e(n,r){var s=this;var i=this;var a=false;if(Array.isArray(n)){if(n.length){return n.map((function(t){return new e(t,r)}))}return false}var o={init:function e(){var s=this;var a={duration:600,ariaEnabled:true,collapse:true,showMultiple:false,openOnInit:[],elementClass:"usk-accordion",triggerClass:"usk-accordion-trigger",panelClass:"usk-item-box",activeClass:"usk-active",beforeOpen:function e(){},onOpen:function e(){},beforeClose:function e(){},onClose:function e(){}};this.options=Object.assign(a,r);var o=this.options,l=o.elementClass,c=o.openOnInit;var u=typeof n==="string";this.container=u?document.querySelector(n):n;this.elements=Array.from(this.container.childNodes).filter((function(e){return e.classList&&e.classList.contains(l)}));this.firstElement=this.elements[0];this.lastElement=this.elements[this.elements.length-1];this.currFocusedIdx=0;this.elements.map((function(e,n){e.classList.add("js-enabled");s.generateIDs(e);s.setARIA(e);s.setTransition(e);t++;return c.includes(n)?s.showElement(e,false):s.closeElement(e,false)}));i.attachEvents()},setTransition:function e(t){var n=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var r=this.options,s=r.duration,i=r.panelClass;var a=t.querySelector(".".concat(i));var o=l("transitionDuration");a.style[o]=n?null:"".concat(s,"ms")},generateIDs:function e(n){var r=this.options,s=r.triggerClass,i=r.panelClass;var a=n.querySelector(".".concat(s));var o=n.querySelector(".".concat(i));n.setAttribute("id","usk-accordion-".concat(t));a.setAttribute("id","usk-accordion-trigger-".concat(t));o.setAttribute("id","usk-item-box-".concat(t))},removeIDs:function e(t){var n=this.options,r=n.triggerClass,s=n.panelClass;var i=t.querySelector(".".concat(r));var a=t.querySelector(".".concat(s));t.removeAttribute("id");i.removeAttribute("id");a.removeAttribute("id")},setARIA:function e(n){var r=this.options,s=r.ariaEnabled,i=r.triggerClass,a=r.panelClass;if(!s)return;var o=n.querySelector(".".concat(i));var l=n.querySelector(".".concat(a));o.setAttribute("role","button");o.setAttribute("aria-controls","usk-item-box-".concat(t));o.setAttribute("aria-disabled",false);o.setAttribute("aria-expanded",false);l.setAttribute("role","region");l.setAttribute("aria-labelledby","usk-accordion-trigger-".concat(t))},updateARIA:function e(t,n){var r=n.ariaExpanded,s=n.ariaDisabled;var i=this.options,a=i.ariaEnabled,o=i.triggerClass;if(!a)return;var l=t.querySelector(".".concat(o));l.setAttribute("aria-expanded",r);l.setAttribute("aria-disabled",s)},removeARIA:function e(t){var n=this.options,r=n.ariaEnabled,s=n.triggerClass,i=n.panelClass;if(!r)return;var a=t.querySelector(".".concat(s));var o=t.querySelector(".".concat(i));a.removeAttribute("role");a.removeAttribute("aria-controls");a.removeAttribute("aria-disabled");a.removeAttribute("aria-expanded");o.removeAttribute("role");o.removeAttribute("aria-labelledby")},focus:function e(t,n){t.preventDefault();var r=this.options.triggerClass;var s=n.querySelector(".".concat(r));s.focus()},focusFirstElement:function e(t){this.focus(t,this.firstElement);this.currFocusedIdx=0},focusLastElement:function e(t){this.focus(t,this.lastElement);this.currFocusedIdx=this.elements.length-1},focusNextElement:function e(t){var n=this.currFocusedIdx+1;if(n>this.elements.length-1)return this.focusFirstElement(t);this.focus(t,this.elements[n]);this.currFocusedIdx=n},focusPrevElement:function e(t){var n=this.currFocusedIdx-1;if(n<0)return this.focusLastElement(t);this.focus(t,this.elements[n]);this.currFocusedIdx=n},showElement:function e(t){var n=arguments.length>1&&arguments[1]!==undefined?arguments[1]:true;var r=this.options,s=r.panelClass,i=r.activeClass,a=r.collapse,o=r.beforeOpen;var l=t.querySelector(".".concat(s));var c=l.scrollHeight;t.classList.add(i);if(n)o(t);requestAnimationFrame((function(){requestAnimationFrame((function(){l.style.height=n?"".concat(c,"px"):"auto"}))}));this.updateARIA(t,{ariaExpanded:true,ariaDisabled:a?false:true})},closeElement:function e(t){var n=arguments.length>1&&arguments[1]!==undefined?arguments[1]:true;var r=this.options,s=r.panelClass,i=r.activeClass,a=r.beforeClose;var o=t.querySelector(".".concat(s));var l=o.scrollHeight;t.classList.remove(i);if(n){a(t);requestAnimationFrame((function(){o.style.height="".concat(l,"px");requestAnimationFrame((function(){o.style.height=0}))}));this.updateARIA(t,{ariaExpanded:false,ariaDisabled:false})}else{o.style.height=0}},toggleElement:function e(t){var n=this.options,r=n.activeClass,s=n.collapse;var i=t.classList.contains(r);if(i&&!s)return;return i?this.closeElement(t):this.showElement(t)},closeElements:function e(){var t=this;var n=this.options,r=n.activeClass,s=n.showMultiple;if(s)return;this.elements.map((function(e,n){var s=e.classList.contains(r);if(s&&n!=t.currFocusedIdx){t.closeElement(e)}}))},handleClick:function e(t){var n=this;var r=t.currentTarget;this.elements.map((function(e,s){if(e.contains(r)&&t.target.nodeName!=="A"){n.currFocusedIdx=s;n.closeElements();n.focus(t,e);n.toggleElement(e)}}))},handleKeydown:function e(t){var n={ARROW_UP:38,ARROW_DOWN:40,HOME:36,END:35};switch(t.keyCode){case n.ARROW_UP:return this.focusPrevElement(t);case n.ARROW_DOWN:return this.focusNextElement(t);case n.HOME:return this.focusFirstElement(t);case n.END:return this.focusLastElement(t);default:return null}},handleTransitionEnd:function e(t){if(t.propertyName!=="height")return;var n=this.options,r=n.onOpen,s=n.onClose;var i=t.currentTarget;var a=parseInt(i.style.height);var o=this.elements.find((function(e){return e.contains(i)}));if(a>0){i.style.height="auto";r(o)}else{s(o)}}};this.attachEvents=function(){if(a)return;var e=o.options,t=e.triggerClass,n=e.panelClass;o.handleClick=o.handleClick.bind(o);o.handleKeydown=o.handleKeydown.bind(o);o.handleTransitionEnd=o.handleTransitionEnd.bind(o);o.elements.map((function(e){var r=e.querySelector(".".concat(t));var s=e.querySelector(".".concat(n));r.addEventListener("click",o.handleClick);r.addEventListener("keydown",o.handleKeydown);s.addEventListener("webkitTransitionEnd",o.handleTransitionEnd);s.addEventListener("transitionend",o.handleTransitionEnd)}));a=true};this.detachEvents=function(){if(!a)return;var e=o.options,t=e.triggerClass,n=e.panelClass;o.elements.map((function(e){var r=e.querySelector(".".concat(t));var s=e.querySelector(".".concat(n));r.removeEventListener("click",o.handleClick);r.removeEventListener("keydown",o.handleKeydown);s.removeEventListener("webkitTransitionEnd",o.handleTransitionEnd);s.removeEventListener("transitionend",o.handleTransitionEnd)}));a=false};this.toggle=function(e){var t=o.elements.find((function(t,n){return n===e}));if(t)o.toggleElement(t)};this.open=function(e){var t=o.elements.find((function(t,n){return n===e}));if(t)o.showElement(t)};this.openAll=function(){o.elements.map((function(e){return o.showElement(e,false)}))};this.close=function(e){var t=o.elements.find((function(t,n){return n===e}));if(t)o.closeElement(t)};this.closeAll=function(){o.elements.map((function(e){return o.closeElement(e,false)}))};this.destroy=function(){s.detachEvents();s.openAll();o.elements.map((function(e){o.removeIDs(e);o.removeARIA(e);o.setTransition(e,true)}));a=true};var l=function e(t){if(typeof document.documentElement.style[t]==="string"){return t}t=c(t);t="webkit".concat(t);return t};var c=function e(t){return t.charAt(0).toUpperCase()+t.slice(1)};o.init()};if(typeof module!=="undefined"&&typeof module.exports!=="undefined"){module.exports=n}else{e.Accordion=n}})(window);