<?php

namespace UltimateStoreKit\Admin;



if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

if (!function_exists('is_plugin_active')) {
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');
}

class ModuleService {



    public static function get_widget_settings($callable) {
        $settings_fields = [
            'ultimate_store_kit_active_modules' => [
                [
                    'name'         => 'add-to-cart',
                    'label'        => esc_html__('Add to Cart (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'widget_type'  => 'pro',
                    'content_type' => 'woocommerce single',
                    'demo_url'     => 'https://storekit.pro/demo/add-to-cart/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'additional-information',
                    'label'        => esc_html__('Additional Information (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'widget_type'  => 'pro',
                    'content_type' => 'woocommerce single new',
                    'demo_url'     => 'https://storekit.pro/demo/additional-information/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'account-address',
                    'label'        => esc_html__('Account Address', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce account new',
                    'demo_url'     => 'https://storekit.pro/demo/account-address/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'account-dashboard',
                    'label'        => esc_html__('Account Dashboard', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce account new',
                    'demo_url'     => 'https://storekit.pro/demo/account-dashboard/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'account-details',
                    'label'        => esc_html__('Account Details', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce account new',
                    'demo_url'     => 'https://storekit.pro/demo/account-details/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'account-downloads',
                    'label'        => esc_html__('Account Download', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce account new',
                    'demo_url'     => 'https://storekit.pro/demo/account-downloads/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'account-login-form',
                    'label'        => esc_html__('Account Login Form', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce account new',
                    'demo_url'     => 'https://storekit.pro/demo/account-login-form/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'account-logout',
                    'label'        => esc_html__('Account Logout', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce account new',
                    'demo_url'     => 'https://storekit.pro/demo/account-logout/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'account-navigation',
                    'label'        => esc_html__('Account Navigation', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce account new',
                    'demo_url'     => 'https://storekit.pro/demo/account-navigation/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'account-order-details',
                    'label'        => esc_html__('Account Order Details', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce account new',
                    'demo_url'     => 'https://storekit.pro/demo/account-order-details/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'account-orders',
                    'label'        => esc_html__('Account Orders', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce account new',
                    'demo_url'     => 'https://storekit.pro/demo/account-orders/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'account-registration-form',
                    'label'        => esc_html__('Account Registration Form', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce account new',
                    'demo_url'     => 'https://storekit.pro/demo/account-registration-form/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'breadcrumbs',
                    'label'        => esc_html__('Breadcrumbs (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'single new',
                    'demo_url'     => 'https://storekit.pro/demo/breadcrumbs/',
                    'video_url'    => '',
                ],
                // CHECKOUT
                [
                    'name'         => 'checkout-additional-info',
                    'label'        => esc_html__('Checkout Additional Info', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'checkout new',
                    'demo_url'     => 'https://storekit.pro/demo/checkout-additional-info/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'checkout-billing-address',
                    'label'        => esc_html__('Checkout Billing Address', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'checkout new',
                    'demo_url'     => 'https://storekit.pro/demo/checkout-billing-address/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'checkout-coupon-form',
                    'label'        => esc_html__('Checkout Coupon Form', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'checkout new',
                    'demo_url'     => 'https://storekit.pro/demo/checkout-coupon-form/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'checkout-login-form',
                    'label'        => esc_html__('Checkout Login Form', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'checkout new',
                    'demo_url'     => 'https://storekit.pro/demo/checkout-login-form/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'checkout-order-review',
                    'label'        => esc_html__('Checkout Order Review', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'checkout new',
                    'demo_url'     => 'https://storekit.pro/demo/checkout-order-review/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'checkout-payment',
                    'label'        => esc_html__('Checkout Payment', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'checkout new',
                    'demo_url'     => 'https://storekit.pro/demo/checkout-payment/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'checkout-shipping-methods',
                    'label'        => esc_html__('Checkout Shipping Methods', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'checkout new',
                    'demo_url'     => 'https://storekit.pro/demo/checkout-shipping-methods/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'checkout-shipping-form',
                    'label'        => esc_html__('Checkout Shipping Form', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'checkout new',
                    'demo_url'     => 'https://storekit.pro/demo/checkout-shipping-form/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'compare-button',
                    'label'        => esc_html__('Compare Button', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'others new',
                    'demo_url'     => 'https://storekit.pro/demo/compare-button/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'compare-products',
                    'label'        => esc_html__('Compare Products', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'others new',
                    'demo_url'     => 'https://storekit.pro/demo/compare-products/',
                    'video_url'    => '',
                ],

                [
                    'name'         => 'florence-grid',
                    'label'        => esc_html__('Florence Grid', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce grid',
                    'demo_url'     => 'https://storekit.pro/demo/florence-grid/',
                    'video_url'    => 'https://youtu.be/5UDpy3MqFbU',
                ],
                [
                    'name'         => 'florence-carousel',
                    'label'        => esc_html__('Florence Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce carousel',
                    'demo_url'     => 'https://storekit.pro/demo/florence-carousel/',
                    'video_url'    => 'https://youtu.be/eqAsEwqcKdM',
                ],
                [
                    'name'         => 'glossy-grid',
                    'label'        => esc_html__('Glossy Grid', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce grid',
                    'demo_url'     => 'https://storekit.pro/demo/glossy-grid/',
                    'video_url'    => 'https://youtu.be/H-EwEpbeXFA',
                ],
                [
                    'name'         => 'glossy-carousel',
                    'label'        => esc_html__('Glossy Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce carousel',
                    'demo_url'     => 'https://storekit.pro/demo/glossy-carousel/',
                    'video_url'    => 'https://youtu.be/P9proLYapgQ',
                ],
                [
                    'name'         => 'heaven-slider',
                    'label'        => esc_html__('Heaven Slider', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce slider',
                    'demo_url'     => 'https://storekit.pro/demo/heaven-slider/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'info-list',
                    'label'        => esc_html__('Info List', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'others',
                    'demo_url'     => 'https://storekit.pro/demo/info-list/',
                    'video_url'    => '',
                ],

                [
                    'name'         => 'mentor-slider',
                    'label'        => esc_html__('Mentor Slider', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce slider',
                    'demo_url'     => 'https://storekit.pro/demo/mentor-slider/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'mini-cart',
                    'label'        => esc_html__('Mini Cart', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce others',
                    'demo_url'     => 'https://storekit.pro/demo/mini-cart/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'page-cart',
                    'label'        => esc_html__('Cart (Page)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce cart new',
                    'demo_url'     => 'https://storekit.pro/demo/page-cart/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'page-checkout',
                    'label'        => esc_html__('Checkout (Page)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce checkout new',
                    'demo_url'     => 'https://storekit.pro/demo/page-checkout/',
                    'video_url'    => '',
                ],
                // [
                //     'name'         => 'page-my-account',
                //     'label'        => esc_html__('My Account (Page)', 'ultimate-store-kit'),
                //     'type'         => 'checkbox',
                //     'default'      => "off",
                //     'widget_type'  => 'free',
                //     'plugin_name'  => 'woocommerce',
                //     'plugin_path'  => 'woocommerce/woocommerce.php',
                //     'content_type' => 'woocommerce account new',
                //     'demo_url'     => 'https://storekit.pro/demo/page-my-account/',
                //     'video_url'    => '',
                // ],
                [
                    'name'         => 'page-order',
                    'label'        => esc_html__('Order (Page)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce order thankyou new',
                    'demo_url'     => 'https://storekit.pro/demo/page-order/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'page-single',
                    'label'        => esc_html__('Single Product (Page)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce single new',
                    'demo_url'     => 'https://storekit.pro/demo/page-single/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-accordion',
                    'label'        => esc_html__('Product Accordion', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce others',
                    'demo_url'     => 'https://storekit.pro/demo/product-accordion/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-category',
                    'label'        => esc_html__('Product Category', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce others',
                    'demo_url'     => 'https://storekit.pro/demo/product-category/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-category-carousel',
                    'label'        => esc_html__('Product Category Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce others new',
                    'demo_url'     => 'https://storekit.pro/demo/product-category-carousel/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-description',
                    'label'        => esc_html__('Product Description (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce new',
                    'demo_url'     => 'https://storekit.pro/demo/product-description/',
                    'video_url'    => '',
                ],
                // [
                //     'name'         => 'product-filter',
                //     'label'        => esc_html__('Product Filter', 'ultimate-store-kit'),
                //     'type'         => 'checkbox',
                //     'default'      => "on",
                //     'widget_type'  => 'free',
                //     'plugin_name'  => 'woocommerce',
                //     'plugin_path'  => 'woocommerce/woocommerce.php',
                //     'content_type' => 'archive new',
                //     'demo_url'     => 'https://storekit.pro/demo/product-filter/',
                //     'video_url'    => '',
                // ],
                [
                    'name'         => 'product-image',
                    'label'        => esc_html__('Product Image (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce single new',
                    'demo_url'     => 'https://storekit.pro/demo/product-image/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-image-accordion',
                    'label'        => esc_html__('Product Image Accordion', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce others',
                    'demo_url'     => 'https://storekit.pro/demo/product-image-accordion/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-list',
                    'label'        => esc_html__('Product List', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce others',
                    'demo_url'     => 'https://storekit.pro/demo/product-list/',
                    'video_url'    => 'https://youtu.be/qJQ9wfdoMKg',
                ],
                [
                    'name'         => 'product-meta',
                    'label'        => esc_html__('Product Meta (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'single new',
                    'demo_url'     => 'https://storekit.pro/demo/product-meta/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-price',
                    'label'        => esc_html__('Product Price (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'single new',
                    'demo_url'     => 'https://storekit.pro/demo/product-price/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-rating',
                    'label'        => esc_html__('Product Rating (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce single new',
                    'demo_url'     => 'https://storekit.pro/demo/product-rating/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-related',
                    'label'        => esc_html__('Product Related (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce new',
                    'demo_url'     => 'https://storekit.pro/demo/product-related/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-reviews',
                    'label'        => esc_html__('Product Reviews', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce others',
                    'demo_url'     => 'https://storekit.pro/demo/product-reviews/',
                    'video_url'    => 'https://youtu.be/cjpkFVWBmH4',
                ],
                [
                    'name'         => 'product-review-carousel',
                    'label'        => esc_html__('Product Review Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce others carousel',
                    'demo_url'     => 'https://storekit.pro/demo/product-review-carousel/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-stock',
                    'label'        => esc_html__('Product Stock (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce new',
                    'demo_url'     => 'https://storekit.pro/demo/product-stock/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-table',
                    'label'        => esc_html__('Product Table', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce others',
                    'demo_url'     => 'https://storekit.pro/demo/product-table/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-tabs',
                    'label'        => esc_html__('Product Tabs (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce new',
                    'demo_url'     => 'https://storekit.pro/demo/product-tabs/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'product-title',
                    'label'        => esc_html__('Product Title (Single)', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce single new',
                    'demo_url'     => 'https://storekit.pro/demo/product-title/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'shiny-grid',
                    'label'        => esc_html__('Shiny Grid', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce grid',
                    'demo_url'     => 'https://storekit.pro/demo/shiny-grid/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'shiny-carousel',
                    'label'        => esc_html__('Shiny Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce carousel',
                    'demo_url'     => 'https://storekit.pro/demo/shiny-carousel/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'showcase-slider',
                    'label'        => esc_html__('Showcase Slider', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce slider',
                    'demo_url'     => 'https://storekit.pro/demo/showcase-slider/',
                    'video_url'    => '',
                ],

                [
                    'name'         => 'sub-category',
                    'label'        => esc_html__('Sub Category', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce grid',
                    'demo_url'     => 'https://storekit.pro/demo/sub-category/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'sub-category-carousel',
                    'label'        => esc_html__('Sub Category Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce carousel',
                    'demo_url'     => 'https://storekit.pro/demo/sub-category-carousel/',
                    'video_url'    => '',
                ],

                [
                    'name'         => 'thankyou-order',
                    'label'        => esc_html__('Thank You Order', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce thank-you order new',
                    'demo_url'     => 'https://storekit.pro/demo/thankyou-order/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'thankyou-order-details',
                    'label'        => esc_html__('Thank You Order Details', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce thank-you order new',
                    'demo_url'     => 'https://storekit.pro/demo/thankyou-order-details/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'thankyou-order-customer-address',
                    'label'        => esc_html__('Thank You Order Customer Address', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce thank-you order new',
                    'demo_url'     => 'https://storekit.pro/demo/thankyou-order-customer-address/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'thankyou-order-confirmation',
                    'label'        => esc_html__('Thank You Order Confirmation', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'widget_type'  => 'pro',
                    'plugin_name'  => 'woocommerce',
                    'plugin_path'  => 'woocommerce/woocommerce.php',
                    'content_type' => 'woocommerce thank-you order new',
                    'demo_url'     => 'https://storekit.pro/demo/thankyou-order-confirmation/',
                    'video_url'    => '',
                ],

            ],
            'ultimate_store_kit_edd_modules' => [
                [
                    'name'         => 'edd-category-grid',
                    'label'        => esc_html__('EDD Category Grid', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'free',
                    'content_type' => 'edd grid',
                    'demo_url'     => 'https://storekit.pro/demo/edd-category-grid/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'edd-category-carousel',
                    'label'        => esc_html__('EDD Category Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'free',
                    'content_type' => 'edd carousel',
                    'demo_url'     => 'https://storekit.pro/demo/edd-category-carousel/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'edd-beauty-grid',
                    'label'        => esc_html__('EDD Beauty Grid', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'free',
                    'content_type' => 'edd grid',
                    'demo_url'     => 'https://storekit.pro/demo/edd-beauty-grid/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'edd-beauty-carousel',
                    'label'        => esc_html__('EDD Beauty Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'free',
                    'content_type' => 'edd carousel',
                    'demo_url'     => 'https://storekit.pro/demo/edd-beauty-carousel/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'edd-classic-grid',
                    'label'        => esc_html__('EDD Classic Grid', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'free',
                    'content_type' => 'edd grid',
                    'demo_url'     => 'https://storekit.pro/demo/edd-classic-grid/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'edd-classic-carousel',
                    'label'        => esc_html__('EDD Classic Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'free',
                    'content_type' => 'edd carousel',
                    'demo_url'     => 'https://storekit.pro/demo/edd-classic-carousel/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'edd-product-reviews',
                    'label'        => esc_html__('EDD Product Review', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'pro',
                    'content_type' => 'edd new',
                    'demo_url'     => 'https://storekit.pro/demo/edd-product-reviews/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'edd-product-review-carousel',
                    'label'        => esc_html__('EDD Product Review Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "off",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'pro',
                    'content_type' => 'edd new',
                    'demo_url'     => 'https://storekit.pro/demo/edd-product-review-carousel/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'edd-standard-grid',
                    'label'        => esc_html__('EDD Standard Grid', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'free',
                    'content_type' => 'edd grid',
                    'demo_url'     => 'https://storekit.pro/demo/edd-standard-grid/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'edd-standard-carousel',
                    'label'        => esc_html__('EDD Standard Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'free',
                    'content_type' => 'edd carousel',
                    'demo_url'     => 'https://storekit.pro/demo/edd-standard-carousel/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'edd-trendy-grid',
                    'label'        => esc_html__('EDD Trendy Grid', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'free',
                    'content_type' => 'edd grid',
                    'demo_url'     => 'https://storekit.pro/demo/edd-trendy-grid/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'edd-trendy-carousel',
                    'label'        => esc_html__('EDD Trendy Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'plugin_name'  => 'easy-digital-downloads',
                    'plugin_path'  => 'easy-digital-downloads/easy-digital-downloads.php',
                    'widget_type'  => 'free',
                    'content_type' => 'edd carousel',
                    'demo_url'     => 'https://storekit.pro/demo/edd-trendy-carousel/',
                    'video_url'    => '',
                ]
            ],
            'ultimate_store_kit_general_modules' => [
                [
                    'name'         => 'brand-grid',
                    'label'        => esc_html__('Brand Grid', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'content_type' => 'grid',
                    'demo_url'     => 'https://storekit.pro/demo/brand-grid/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'brand-carousel',
                    'label'        => esc_html__('Brand Carousel', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'content_type' => 'carousel',
                    'demo_url'     => 'https://storekit.pro/demo/brand-carousel/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'featured-box',
                    'label'        => esc_html__('Featured Box', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'free',
                    'content_type' => 'others',
                    'demo_url'     => 'https://storekit.pro/demo/featured-box/',
                    'video_url'    => '',
                ],
                [
                    'name'         => 'qr-code',
                    'label'        => esc_html__('QR Code', 'ultimate-store-kit'),
                    'type'         => 'checkbox',
                    'default'      => "on",
                    'widget_type'  => 'pro',
                    'content_type' => 'woocommerce others new',
                    'demo_url'     => 'https://storekit.pro/demo/qr-code/',
                    'video_url'    => '',
                ],
            ],
        ];

        $settings                    = [];
        $settings['settings_fields'] = $settings_fields;

        return $callable($settings);
    }

    private static function _is_plugin_installed($plugin, $plugin_path) {
        $installed_plugins = get_plugins();
        return isset($installed_plugins[$plugin_path]);
    }

    public static function is_module_active($module_id, $options, $module_path = BDTUSK_MODULES_PATH) {
        if (!isset($options[$module_id])) {
            if (file_exists($module_path . $module_id . '/module.info.php')) {
                $module_data = require $module_path . $module_id . '/module.info.php';
                return $module_data['default_activation'];
            }
        } else {
            return $options[$module_id] == 'on';
        }
    }

    public static function is_plugin_active($plugin_path) {
        if ($plugin_path) {
            return is_plugin_active($plugin_path);
        }
    }

    public static function has_module_style($module_id, $module_path = BDTUSK_MODULES_PATH) {
        if (file_exists($module_path . $module_id . '/module.info.php')) {
            $module_data = require $module_path . $module_id . '/module.info.php';

            if (isset($module_data['has_style'])) {
                return $module_data['has_style'];
            }
        }
    }

    public static function has_module_script($module_id, $module_path = BDTUSK_MODULES_PATH) {
        if (file_exists($module_path . $module_id . '/module.info.php')) {
            $module_data = require $module_path . $module_id . '/module.info.php';

            if (isset($module_data['has_script'])) {
                return $module_data['has_script'];
            }
        }
    }
}
