import {
    Icon
} from '@wordpress/components';

//lock 
export const lockIcon = ( color = '#606060') => (
	<Icon
		icon={ () => (
			<svg className="gf-lock-svg" width="11" height="12" viewBox="0 0 11 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M8.57143 4H9.71428C10.0299 4 10.2857 4.25584 10.2857 4.57143V11.4286C10.2857 11.7442 10.0299 12 9.71428 12H0.571429C0.25584 12 0 11.7442 0 11.4286V4.57143C0 4.25584 0.25584 4 0.571429 4H1.71429V3.42857C1.71429 1.53502 3.24931 0 5.14286 0C7.0364 0 8.57143 1.53502 8.57143 3.42857V4ZM4.57143 8.41851V9.71429H5.71429V8.41851C6.05589 8.22091 6.28571 7.8516 6.28571 7.42857C6.28571 6.79737 5.77406 6.28571 5.14286 6.28571C4.51166 6.28571 4 6.79737 4 7.42857C4 7.8516 4.22983 8.22091 4.57143 8.41851ZM7.42857 4V3.42857C7.42857 2.16621 6.4052 1.14286 5.14286 1.14286C3.88049 1.14286 2.85714 2.16621 2.85714 3.42857V4H7.42857Z" fill={ color } />
			</svg>
		) }
	/>
);

//Form
export const formIcon = ( color = '#2C3338') => (
	<Icon
		icon={ () => (
			<svg width="12" height="14" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M11.3333 13.6668H0.666667C0.29848 13.6668 0 13.3684 0 13.0002V1.00016C0 0.631976 0.29848 0.333496 0.666667 0.333496H11.3333C11.7015 0.333496 12 0.631976 12 1.00016V13.0002C12 13.3684 11.7015 13.6668 11.3333 13.6668ZM10.6667 12.3335V1.66683H1.33333V12.3335H10.6667ZM3.33333 3.66683H8.66667V5.00016H3.33333V3.66683ZM3.33333 6.3335H8.66667V7.66683H3.33333V6.3335ZM3.33333 9.00016H6.66667V10.3335H3.33333V9.00016Z" fill={ color } />
			</svg>
		) }
	/>
);

//List
export const listIcon = ( color = '#2C3338') => (
	<Icon
		icon={ () => (
			<svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M3.33333 0.666829H12V2.00016H3.33333V0.666829ZM1 2.3335C0.447713 2.3335 0 1.88578 0 1.3335C0 0.781209 0.447713 0.333496 1 0.333496C1.55229 0.333496 2 0.781209 2 1.3335C2 1.88578 1.55229 2.3335 1 2.3335ZM1 7.00016C0.447713 7.00016 0 6.55243 0 6.00016C0 5.4479 0.447713 5.00016 1 5.00016C1.55229 5.00016 2 5.4479 2 6.00016C2 6.55243 1.55229 7.00016 1 7.00016ZM1 11.6002C0.447713 11.6002 0 11.1524 0 10.6002C0 10.0479 0.447713 9.60016 1 9.60016C1.55229 9.60016 2 10.0479 2 10.6002C2 11.1524 1.55229 11.6002 1 11.6002ZM3.33333 5.3335H12V6.66683H3.33333V5.3335ZM3.33333 10.0002H12V11.3335H3.33333V10.0002Z" fill={ color } />
			</svg>
		) }
	/>
);

//Calenter ok
export const calenderCheckIcon = ( color = '#2C3338') => (
	<Icon
		icon={ () => (
			<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M5.99992 0.666504V1.99984H9.99992V0.666504H11.3333V1.99984H13.9999C14.3681 1.99984 14.6666 2.29832 14.6666 2.6665V13.3332C14.6666 13.7014 14.3681 13.9998 13.9999 13.9998H1.99992C1.63173 13.9998 1.33325 13.7014 1.33325 13.3332V2.6665C1.33325 2.29832 1.63173 1.99984 1.99992 1.99984H4.66658V0.666504H5.99992ZM13.3333 6.6665H2.66659V12.6665H13.3333V6.6665ZM10.0236 7.42384L10.9664 8.3667L7.66658 11.6665L5.30957 9.3095L6.25237 8.3667L7.66658 9.7809L10.0236 7.42384ZM4.66658 3.33317H2.66659V5.33317H13.3333V3.33317H11.3333V3.99984H9.99992V3.33317H5.99992V3.99984H4.66658V3.33317Z" fill={ color }/>
			</svg>
		) }
	/>
);

//List
export const calenderEditedIcon = ( color = '#2C3338') => (
	<Icon
		icon={ () => (
			<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M4.99992 0.666504V1.99984H8.99992V0.666504H10.3333V1.99984H12.9999C13.3681 1.99984 13.6666 2.29832 13.6666 2.6665V13.3332C13.6666 13.7014 13.3681 13.9998 12.9999 13.9998H0.999919C0.631732 13.9998 0.333252 13.7014 0.333252 13.3332V2.6665C0.333252 2.29832 0.631732 1.99984 0.999919 1.99984H3.66658V0.666504H4.99992ZM12.3333 7.33317H1.66659V12.6665H12.3333V7.33317ZM4.33325 8.6665V9.99984H2.99992V8.6665H4.33325ZM7.66658 8.6665V9.99984H6.33325V8.6665H7.66658ZM10.9999 8.6665V9.99984H9.66658V8.6665H10.9999ZM3.66658 3.33317H1.66659V5.99984H12.3333V3.33317H10.3333V4.6665H8.99992V3.33317H4.99992V4.6665H3.66658V3.33317Z" fill={ color }/>
			</svg>
		) }
	/>
);

//List
export const userIcon = ( color = '#2C3338') => (
	<Icon
		icon={ () => (
			<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M13.3334 14.6665H12.0001V13.3332C12.0001 12.2286 11.1047 11.3332 10.0001 11.3332H6.00008C4.89551 11.3332 4.00008 12.2286 4.00008 13.3332V14.6665H2.66675V13.3332C2.66675 11.4922 4.15913 9.99984 6.00008 9.99984H10.0001C11.841 9.99984 13.3334 11.4922 13.3334 13.3332V14.6665ZM8.00008 8.6665C5.79094 8.6665 4.00008 6.87564 4.00008 4.6665C4.00008 2.45736 5.79094 0.666504 8.00008 0.666504C10.2092 0.666504 12.0001 2.45736 12.0001 4.6665C12.0001 6.87564 10.2092 8.6665 8.00008 8.6665ZM8.00008 7.33317C9.47282 7.33317 10.6667 6.13926 10.6667 4.6665C10.6667 3.19374 9.47282 1.99984 8.00008 1.99984C6.52732 1.99984 5.33341 3.19374 5.33341 4.6665C5.33341 6.13926 6.52732 7.33317 8.00008 7.33317Z" fill={ color }/>
			</svg>
		) }
	/>
);

//List
export const desktopIcon = ( color = '#2C3338') => (
	<Icon
		icon={ () => (
			<svg width="14" height="13" viewBox="0 0 14 13" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M1.66659 8.66667H12.3333V1.33333H1.66659V8.66667ZM7.66658 10V11.3333H10.3333V12.6667H3.66658V11.3333H6.33325V10H0.994452C0.629285 10 0.333252 9.70073 0.333252 9.32833V0.671653C0.333252 0.300713 0.636792 0 0.994452 0H13.0054C13.3706 0 13.6666 0.29928 13.6666 0.671653V9.32833C13.6666 9.69927 13.3631 10 13.0054 10H7.66658Z" fill={ color } />
			</svg>
		) }
	/>
);

//Delete 
export const trashIcon = ( color = '#50575E') => (
	<Icon
		icon={ () => (
			<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M10.3333 3.00016H13.6667V4.3335H12.3333V13.0002C12.3333 13.3684 12.0349 13.6668 11.6667 13.6668H2.33333C1.96514 13.6668 1.66666 13.3684 1.66666 13.0002V4.3335H0.333328V3.00016H3.66666V1.00016C3.66666 0.631976 3.96514 0.333496 4.33333 0.333496H9.66666C10.0349 0.333496 10.3333 0.631976 10.3333 1.00016V3.00016ZM11 4.3335H2.99999V12.3335H11V4.3335ZM4.99999 1.66683V3.00016H8.99999V1.66683H4.99999Z" fill={ color } />
			</svg>
		) }
	/>
);

//Right arrow box 
export const rightArrowBox = ( color = '#2C3338') => (
	<Icon
		icon={ () => (
			<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<rect x="0.5" y="0.5" width="23" height="23" rx="4.5" fill="white"/>
			<path d="M15.1287 11.2502L11.1057 7.22716L12.1663 6.1665L18 12.0002L12.1663 17.8337L11.1057 16.7731L15.1287 12.7502H6V11.2502H15.1287Z" fill={ color }/>
			<rect x="0.5" y="0.5" width="23" height="23" rx="4.5" stroke={ color }/>
			</svg>
		) }
	/>
);

//left arrow box 
export const leftArrowBox = ( color = '#2C3338') => (
	<Icon
		icon={ () => (
			<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<rect x="-0.5" y="0.5" width="23" height="23" rx="4.5" transform="matrix(-1 0 0 1 23 0)" fill="white"/>
			<path d="M8.8713 11.2502L12.8943 7.22716L11.8337 6.1665L6 12.0002L11.8337 17.8337L12.8943 16.7731L8.8713 12.7502H18V11.2502H8.8713Z" fill={ color } />
			<rect x="-0.5" y="0.5" width="23" height="23" rx="4.5" transform="matrix(-1 0 0 1 23 0)" stroke={ color }/>
			</svg>
		) }
	/>
);