<?php

/**
 * Plugin Name: RnB Lite
 * Plugin URI: http://demo.redq.io/rnb/
 * Description: WooCommerce based rental & plugin. You can create any date or date range based booking with this plugin.
 * Version: 2.0
 * Author: RedQ Team
 * Author URI: https://redq.io/
 * License: http : //www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * Text Domain: rnb-lite
 * Domain Path: /languages
 * Requires at least: 5.0
 * Tested up to: 5.8
 * WC requires at least: 3.0.0
 * WC tested up to: latest
 */

if (!defined('ABSPATH')) {
    exit;
}

$active_plugins   = apply_filters('active_plugins', get_option('active_plugins'));
$required_plugins = ['woocommerce/woocommerce.php'];

if (count(array_intersect($required_plugins, $active_plugins)) !== count($required_plugins)) {
    add_action('admin_notices', 'rnb_lite_notice');
    function rnb_lite_notice()
    {
        $woocommerce_link = '<a href="https://woocommerce.com/" target="_blank">WooCommerce</a>';

        echo '<div class="error"><p><strong>' . sprintf(esc_html__('RnB Lite requires both WooCommerce to be installed and active. You can download %s from here.', 'rnb-lite'), $woocommerce_link) . '</strong></p></div>';
    }
    return;
}

class RnB_Lite
{

    /**
     * Plugin data from get_plugins()
     *
     * @since 1.0
     * @var object
     */
    public $plugin_data;

    /**
     * Includes to load
     *
     * @since 1.0
     * @var array
     */
    public $includes;

    /**
     * Plugin Action and Filter Hooks
     *
     * @since 1.0.0
     * @return null
     */
    public function __construct()
    {
        add_action('plugins_loaded', array($this, 'rnb_lite_set_plugins_data'), 1);
        add_action('plugins_loaded', array($this, 'rnb_lite_define_constants'), 1);
        add_action('plugins_loaded', array($this, 'rnb_lite_set_includes'), 1);
        add_action('plugins_loaded', array($this, 'rnb_lite_load_includes'), 1);
        add_action('wp_enqueue_scripts', array($this, 'rnb_lite_front_assets'));
        add_action('admin_enqueue_scripts', array($this, 'rnb_lite_admin_assets'));
        add_action('woocommerce_redq_rental_add_to_cart', array($this, 'rnb_lite_add_to_cart'), 30);
        add_action('plugins_loaded', array($this, 'rnb_lite_textdomain'));
        add_filter('plugin_action_links_' . plugin_basename(__FILE__), array($this, 'rnb_lite_links'), 1);
    }

    public function rnb_lite_links($links)
    {
        $links[] = '<a href="https://codecanyon.net/item/rnb-woocommerce-rental-booking-system/14835145?irgwc=1&clickid=VxRToeRsAxyOWpQwUx0Mo3QwUki1nYSZq16kV80&iradid=275988&irpid=1309180&iradtype=ONLINE_TRACKING_LINK&irmptype=mediapartner&mp_value1=&utm_campaign=af_impact_radius_1309180&utm_medium=affiliate&utm_source=impact_radius" target="_blank">Premium Version</a>';
        $links[] = '<a href="https://codecanyon.net/item/reactive-pro-advanced-wordpress-search-filtering-grid/17425763?irgwc=1&clickid=VxRToeRsAxyOWpQwUx0Mo3QwUki1nYSZq16kV80&iradid=275988&irpid=1309180&iradtype=ONLINE_TRACKING_LINK&irmptype=mediapartner&mp_value1=&utm_campaign=af_impact_radius_1309180&utm_medium=affiliate&utm_source=impact_radius" target="_blank">Searching & Filtering</a>';
        $links[] = '<a href="https://codecanyon.net/user/redqteam/portfolio?irgwc=1&clickid=VxRToeRsAxyOWpQwUx0Mo3QwUki1nYSZq16kV80&iradid=275988&irpid=1309180&iradtype=ONLINE_TRACKING_LINK&irmptype=mediapartner&mp_value1=&utm_campaign=af_impact_radius_1309180&utm_medium=affiliate&utm_source=impact_radius" target="_blank">Portfolio</a>';
        return $links;
    }

    public function rnb_lite_set_plugins_data()
    {
        if (!function_exists('get_plugins')) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        $plugin_dir = plugin_basename(dirname(__FILE__));
        $plugin_data = current(get_plugins('/' . $plugin_dir));
        $this->plugin_data = apply_filters('redq_plugin_data', $plugin_data);
    }


    /**
     * Plugin constant define
     *
     * @since 1.0.0
     * @return null
     */
    public function rnb_lite_define_constants()
    {
        define('RNB_LITE_VERSION', $this->plugin_data['Version']);                    // plugin version
        define('RNB_LITE_FILE', __FILE__);                                            // plugin's main file path
        define('RNB_LITE_DIR', dirname(plugin_basename(RNB_LITE_FILE)));            // plugin's directory
        define('RNB_LITE_PATH', untrailingslashit(plugin_dir_path(RNB_LITE_FILE)));    // plugin's directory path
        define('RNB_LITE_URL', untrailingslashit(plugin_dir_url(RNB_LITE_FILE)));    // plugin's directory URL

        define('RNB_LITE_INC_DIR',        'includes');    // includes directory
        define('RNB_LITE_ASSETS_DIR',         'assets');        // assets directory
        define('RNB_LITE_LANG_DIR',     'languages');    // languages directory
        define('REDQ_ROOT_URL', untrailingslashit(plugins_url(basename(plugin_dir_path(__FILE__)), basename(__FILE__))));
        define('REDQ_PACKAGE_TEMPLATE_PATH', untrailingslashit(plugin_dir_path(__FILE__)) . '/templates/');
    }


    /**
     * Plugin includes files
     *
     * @since 1.0.0
     * @return null
     */
    public function rnb_lite_set_includes()
    {
        $this->includes = apply_filters('redq_rental', array(
            'admin' => array(
                RNB_LITE_INC_DIR . '/admin/class-rnb-lite-meta-boxes.php',
                RNB_LITE_INC_DIR . '/admin/class-rnb-lite-menu.php',
            ),
            'frontends' => array(
                RNB_LITE_INC_DIR . '/class-rnb-lite-redq_rental.php',
                RNB_LITE_INC_DIR . '/class-rnb-lite-cart.php',
            )
        ));
    }


    /**
     * Plugin includes files
     *
     * @since 1.0.0
     * @return null
     */
    public function rnb_lite_load_includes()
    {
        $includes = $this->includes;

        foreach ($includes as $condition => $files) {
            $do_includes = false;
            switch ($condition) {
                case 'admin':
                    if (is_admin()) {
                        $do_includes = true;
                    }
                    break;
                case 'frontend':
                    if (!is_admin()) {
                        $do_includes = true;
                    }
                    break;
                default:
                    $do_includes = true;
                    break;
            }

            if ($do_includes) {
                foreach ($files as $file) {
                    require_once trailingslashit(RNB_LITE_PATH) . $file;
                }
            }
        }
    }


    /**
     * Plugin enqueues admin stylesheet and scripts
     *
     * @since 1.0.0
     * @return null
     */
    public function rnb_lite_admin_assets()
    {

        global $post, $woocommerce, $wp_scripts;

        wp_enqueue_style('font-awesome', '//cdnjs.cloudflare.com/ajax/libs/font-awesome/4.1.0/css/font-awesome.min.css');

        wp_register_style('redq-admin', REDQ_ROOT_URL . '/assets/css/redq-admin.css', array(), $ver = false, $media = 'all');
        wp_enqueue_style('redq-admin');

        wp_register_script('icon-picker', REDQ_ROOT_URL . '/assets/js/icon-picker.js', array('jquery'), $ver = true, true);
        wp_enqueue_script('icon-picker');

        wp_register_script('rnb_lite_writepanel_js', REDQ_ROOT_URL . '/assets/js/writepanel.js', array('jquery', 'jquery-ui-datepicker'), true);
        wp_enqueue_script('rnb_lite_writepanel_js');

        wp_enqueue_script('jquery-ui-datepicker');

        $params = array(
            'post'           => isset($post->ID) ? $post->ID : '',
            'plugin_url'     => $woocommerce->plugin_url(),
            'ajax_url'       => admin_url('admin-ajax.php'),
            'calendar_image' => $woocommerce->plugin_url() . '/assets/images/calendar.png',
            'all_data'       => $this->reqd_all_booking_data(),
        );

        wp_localize_script('rnb_lite_writepanel_js', 'rnb_lite_writepanel_js_params', $params);
    }


    /**
     * Frontend enqueues front-end stylesheet and scripts
     *
     * @since 1.0.0
     * @return null
     */
    public function rnb_lite_front_assets()
    {
        wp_register_script('jquery.datetimepicker.full', REDQ_ROOT_URL . '/assets/js/jquery.datetimepicker.full.js', array('jquery'), true);
        wp_enqueue_script('jquery.datetimepicker.full');

        wp_register_script('sweetalert.min', REDQ_ROOT_URL . '/assets/js/sweetalert.min.js', array('jquery'), true);
        wp_enqueue_script('sweetalert.min');

        wp_register_script('chosen.jquery', REDQ_ROOT_URL . '/assets/js/chosen.jquery.js', array('jquery'), true);
        wp_enqueue_script('chosen.jquery');

        wp_enqueue_style('font-awesome', '//cdnjs.cloudflare.com/ajax/libs/font-awesome/4.1.0/css/font-awesome.min.css');

        wp_register_style('sweetalert', REDQ_ROOT_URL . '/assets/css/sweetalert.css', array(), $ver = false, $media = 'all');
        wp_enqueue_style('sweetalert');

        wp_register_style('chosen', REDQ_ROOT_URL . '/assets/css/chosen.css', array(), $ver = false, $media = 'all');
        wp_enqueue_style('chosen');

        wp_register_style('rental-style-two', REDQ_ROOT_URL . '/assets/css/rental-style-two.css', array(), $ver = false, $media = 'all');
        wp_enqueue_style('rental-style-two');

        wp_register_script('date', REDQ_ROOT_URL . '/assets/js/date.js', array('jquery'), true);
        wp_enqueue_script('date');

        wp_register_script('accounting', REDQ_ROOT_URL . '/assets/js/accounting.js', array('jquery'), true);
        wp_enqueue_script('accounting');

        wp_register_script('jquery.flip', REDQ_ROOT_URL . '/assets/js/jquery.flip.js', array('jquery'), true);
        wp_enqueue_script('jquery.flip');

        wp_register_script('front-end-scripts', REDQ_ROOT_URL . '/assets/js/main-script.js', array('jquery'), true);
        wp_enqueue_script('front-end-scripts');

        wp_register_script('cost-handle', REDQ_ROOT_URL . '/assets/js/cost-handle.js', array('jquery'), true);
        wp_enqueue_script('cost-handle');

        $block_dates = $this->calculate_block_dates();
        $this->redq_update_prices();

        wp_localize_script('cost-handle', 'BOOKING_DATA', array(
            'all_data' => $this->reqd_all_booking_data(),
            'block_dates' => $block_dates
        ));

        wp_localize_script('front-end-scripts', 'BOOKING_DATA', array(
            'all_data' => $this->reqd_all_booking_data(),
            'block_dates' => $block_dates
        ));

        wp_register_style('jquery.datetimepicker', REDQ_ROOT_URL . '/assets/css/jquery.datetimepicker.css', array(), $ver = false, $media = 'all');
        wp_enqueue_style('jquery.datetimepicker');
    }


    /**
     * Localize all booking data
     *
     * @since 1.0.0
     * @return object
     */
    public function reqd_all_booking_data()
    {
        return get_post_meta(get_the_ID(), 'redq_all_data', true);
    }


    /**
     * Calculate Block Dates
     *
     * @since 1.0.0
     * @return object
     */
    public function calculate_block_dates()
    {
        $block_dates = array();
        $block_dates_final = array();
        $all_data = get_post_meta(get_the_ID(), 'redq_all_data', true);
        $output_date_format  = 'm/d/Y';
        $rental_availability = get_post_meta(get_the_ID(), 'rnb_lite_availability', true);

        $rental_block = 'yes';

        if (isset($rental_block) && $rental_block === 'yes') {
            if (isset($rental_availability) && !empty($rental_availability)) {
                foreach ($rental_availability as $key => $value) {
                    $all_dates = $this->manage_all_dates($value['from'], $value['to'], 'no', $output_date_format);
                    $block_dates[] = $all_dates;
                }
            }

            foreach ($block_dates as $block_date) {
                foreach ($block_date as $key => $value) {
                    $block_dates_final[] = $value;
                }
            }
        }

        return $block_dates_final;
    }


    /**
     * Manage all Block Dates
     *
     * @since 1.0.0
     * @return object
     */
    public function manage_all_dates($start_dates, $end_dates, $choose_euro_format, $output_format, $step = '+1 day')
    {

        $dates = array();

        if ($choose_euro_format === 'no') {
            $current = strtotime($start_dates);
            $last = strtotime($end_dates);
        } else {
            $start  = date('Y/m/d', strtotime(str_replace('/', '-', $start_dates)));
            $end = date('Y/m/d', strtotime(str_replace('/', '-', $end_dates)));
            $current = strtotime($start);
            $last = strtotime($end);
        }

        while ($current <= $last) {

            $dates[] = date($output_format, $current);
            $current = strtotime($step, $current);
        }

        return $dates;
    }


    /**
     * Add to cart page show in front-end
     *
     * @since 1.0.0
     * @return null
     */
    public function rnb_lite_add_to_cart()
    {
        wc_get_template('single-product/add-to-cart/redq_rental.php', $args = array(), $template_path = '', REDQ_PACKAGE_TEMPLATE_PATH);
    }


    /**
     * Update price according to pircing type
     *
     * @since 1.0.0
     * @return null
     */
    public function redq_update_prices()
    {
        $post_id = get_the_ID();
        $pricing_type = get_post_meta(get_the_ID(), 'pricing_type', true);

        if ($pricing_type == 'general_pricing') {
            $general_pricing = get_post_meta($post_id, 'general_price', true);
            update_post_meta($post_id, '_price', $general_pricing);
        }
    }


    /**
     * Support languages
     *
     * @since 1.0.0
     * @return null
     */
    public function rnb_lite_textdomain()
    {
        load_plugin_textdomain('rnb-lite', false, dirname(plugin_basename(__FILE__)) . '/languages/');
    }
}

new RnB_Lite();
