<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Beehive\Google\Service\Analytics;

class RealtimeDataProfileInfo extends \Beehive\Google\Model
{
    /**
     * @var string
     */
    public $accountId;
    /**
     * @var string
     */
    public $internalWebPropertyId;
    /**
     * @var string
     */
    public $profileId;
    /**
     * @var string
     */
    public $profileName;
    /**
     * @var string
     */
    public $tableId;
    /**
     * @var string
     */
    public $webPropertyId;
    /**
     * @param string
     */
    public function setAccountId($accountId)
    {
        $this->accountId = $accountId;
    }
    /**
     * @return string
     */
    public function getAccountId()
    {
        return $this->accountId;
    }
    /**
     * @param string
     */
    public function setInternalWebPropertyId($internalWebPropertyId)
    {
        $this->internalWebPropertyId = $internalWebPropertyId;
    }
    /**
     * @return string
     */
    public function getInternalWebPropertyId()
    {
        return $this->internalWebPropertyId;
    }
    /**
     * @param string
     */
    public function setProfileId($profileId)
    {
        $this->profileId = $profileId;
    }
    /**
     * @return string
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * @param string
     */
    public function setProfileName($profileName)
    {
        $this->profileName = $profileName;
    }
    /**
     * @return string
     */
    public function getProfileName()
    {
        return $this->profileName;
    }
    /**
     * @param string
     */
    public function setTableId($tableId)
    {
        $this->tableId = $tableId;
    }
    /**
     * @return string
     */
    public function getTableId()
    {
        return $this->tableId;
    }
    /**
     * @param string
     */
    public function setWebPropertyId($webPropertyId)
    {
        $this->webPropertyId = $webPropertyId;
    }
    /**
     * @return string
     */
    public function getWebPropertyId()
    {
        return $this->webPropertyId;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(RealtimeDataProfileInfo::class, 'Beehive\\Google_Service_Analytics_RealtimeDataProfileInfo');