<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Beehive\Google\Service\Analytics;

class CustomDimension extends \Beehive\Google\Model
{
    /**
     * @var string
     */
    public $accountId;
    /**
     * @var bool
     */
    public $active;
    /**
     * @var string
     */
    public $created;
    /**
     * @var string
     */
    public $id;
    /**
     * @var int
     */
    public $index;
    /**
     * @var string
     */
    public $kind;
    /**
     * @var string
     */
    public $name;
    protected $parentLinkType = CustomDimensionParentLink::class;
    protected $parentLinkDataType = '';
    public $parentLink;
    /**
     * @var string
     */
    public $scope;
    /**
     * @var string
     */
    public $selfLink;
    /**
     * @var string
     */
    public $updated;
    /**
     * @var string
     */
    public $webPropertyId;
    /**
     * @param string
     */
    public function setAccountId($accountId)
    {
        $this->accountId = $accountId;
    }
    /**
     * @return string
     */
    public function getAccountId()
    {
        return $this->accountId;
    }
    /**
     * @param bool
     */
    public function setActive($active)
    {
        $this->active = $active;
    }
    /**
     * @return bool
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * @param string
     */
    public function setCreated($created)
    {
        $this->created = $created;
    }
    /**
     * @return string
     */
    public function getCreated()
    {
        return $this->created;
    }
    /**
     * @param string
     */
    public function setId($id)
    {
        $this->id = $id;
    }
    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * @param int
     */
    public function setIndex($index)
    {
        $this->index = $index;
    }
    /**
     * @return int
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * @param string
     */
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    /**
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * @param string
     */
    public function setName($name)
    {
        $this->name = $name;
    }
    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * @param CustomDimensionParentLink
     */
    public function setParentLink(CustomDimensionParentLink $parentLink)
    {
        $this->parentLink = $parentLink;
    }
    /**
     * @return CustomDimensionParentLink
     */
    public function getParentLink()
    {
        return $this->parentLink;
    }
    /**
     * @param string
     */
    public function setScope($scope)
    {
        $this->scope = $scope;
    }
    /**
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }
    /**
     * @param string
     */
    public function setSelfLink($selfLink)
    {
        $this->selfLink = $selfLink;
    }
    /**
     * @return string
     */
    public function getSelfLink()
    {
        return $this->selfLink;
    }
    /**
     * @param string
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
    }
    /**
     * @return string
     */
    public function getUpdated()
    {
        return $this->updated;
    }
    /**
     * @param string
     */
    public function setWebPropertyId($webPropertyId)
    {
        $this->webPropertyId = $webPropertyId;
    }
    /**
     * @return string
     */
    public function getWebPropertyId()
    {
        return $this->webPropertyId;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(CustomDimension::class, 'Beehive\\Google_Service_Analytics_CustomDimension');