"use strict";
(self["webpackChunkpixfort_core"] = self["webpackChunkpixfort_core"] || []).push([["dev_builder_components_fields_multifields_js"],{

/***/ "./dev/builder/components/fields/multifields.js":
/*!******************************************************!*\
  !*** ./dev/builder/components/fields/multifields.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
    value: true
}));

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _react = __webpack_require__(/*! react */ "./node_modules/react/index.js");

var _react2 = _interopRequireDefault(_react);

var _reactBeautifulDnd = __webpack_require__(/*! react-beautiful-dnd */ "./node_modules/react-beautiful-dnd/dist/react-beautiful-dnd.esm.js");

var _uuid = __webpack_require__(/*! uuid */ "./node_modules/uuid/dist/esm-browser/index.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// fake data generator
var getItems = function getItems(count) {
    return Array.from({ length: count }, function (v, k) {
        return k;
    }).map(function (k) {
        return {
            id: 'item-' + k,
            content: 'item ' + k
        };
    });
};

// a little function to help us with reordering the result
var reorder = function reorder(list, startIndex, endIndex) {
    var result = Array.from(list);

    var _result$splice = result.splice(startIndex, 1),
        _result$splice2 = _slicedToArray(_result$splice, 1),
        removed = _result$splice2[0];

    result.splice(endIndex, 0, removed);

    return result;
};

var grid = 8;

var getItemStyle = function getItemStyle(isDragging, draggableStyle) {
    return _extends({
        // some basic styles to make the items look a bit nicer
        userSelect: 'none',
        padding: grid * 2,
        margin: '0 0 ' + grid + 'px 0',

        // change background colour if dragging
        background: isDragging ? '#e3fff3' : '#fff'

    }, draggableStyle);
};

var getListStyle = function getListStyle(isDraggingOver) {
    return {
        background: isDraggingOver ? '#eee' : '#f4f4f4',
        padding: 10,
        display: 'inline-block',
        borderRadius: 10
        // width: 420
    };
};

var MultifieldsArea = function (_React$Component) {
    _inherits(MultifieldsArea, _React$Component);

    function MultifieldsArea(props) {
        _classCallCheck(this, MultifieldsArea);

        var _this = _possibleConstructorReturn(this, (MultifieldsArea.__proto__ || Object.getPrototypeOf(MultifieldsArea)).call(this, props));

        _this.handleInputChange = function (e) {
            var newValue = e.target.value;
            // this.setState({
            //     value: newValue
            // });
            _this.props.onChange({
                value: newValue,
                id: _this.props.id
            });
        };

        _this.handleItemChange = function (e, type, index) {
            var newValue = e.target.value;
            var data = _this.state.items;
            if (type === 'title') {
                data[index].title = newValue;
            } else if (type === 'value') {
                data[index].value = newValue;
            }
            _this.setState({
                items: data
            });
            _this.setState({
                value: JSON.stringify(data)
            });
            _this.props.onChange({
                value: JSON.stringify(data),
                id: _this.props.id
            });
        };

        _this.handleItemDelete = function (e, index) {
            e.preventDefault();
            var data = _this.state.items;
            data.splice(index, 1);
            _this.setState({
                items: data
            });
            _this.setState({
                value: JSON.stringify(data)
            });
            _this.props.onChange({
                value: JSON.stringify(data),
                id: _this.props.id
            });
            return false;
        };

        _this.handleItemAdd = function (e, index) {
            e.preventDefault();
            var data = _this.state.items;
            if (Array.isArray(data)) {
                var count = data.length;
                count++;
                data.push({
                    id: (0, _uuid.v4)(),
                    title: '',
                    value: ''
                });
            } else {
                data = [{
                    id: (0, _uuid.v4)(),
                    title: '',
                    value: ''
                }];
            }
            _this.setState({
                items: data
            });
            _this.setState({
                value: JSON.stringify(data)
            });
            _this.props.onChange({
                value: JSON.stringify(data),
                id: _this.props.id
            });
            return false;
        };

        if (_this.props.value) {
            _this.state = {
                value: _this.props.value,
                items: []
            };
        } else {
            _this.state = {
                value: '',
                items: []
            };
        }
        _this.onDragEnd = _this.onDragEnd.bind(_this);
        return _this;
    }

    _createClass(MultifieldsArea, [{
        key: 'setItems',
        value: function setItems() {
            var data = JSON.parse(this.state.value);
            var result = [];
            if (Array.isArray(data)) {
                data.forEach(function (element, index) {
                    result.push({
                        id: (0, _uuid.v4)(),
                        title: element.title ? element.title : '',
                        value: element.value ? element.value : ''
                    });
                });
            }
            this.setState({
                items: result
            });
        }
    }, {
        key: 'onDragEnd',
        value: function onDragEnd(result) {
            // dropped outside the list
            if (!result.destination) {
                return;
            }
            var items = reorder(this.state.items, result.source.index, result.destination.index);
            this.setState({
                items: items
            });
            this.setState({
                value: JSON.stringify(items)
            });
            this.props.onChange({
                value: JSON.stringify(items),
                id: this.props.id
            });
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.setItems();
        }
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate() {}
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            return _react2.default.createElement(
                'div',
                { id: 'element-' + this.props.id, className: 'pix-opt-field pix-opt-multi-field' },
                _react2.default.createElement(
                    'label',
                    { className: 'mb-2' },
                    this.props.label
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'pix-multifields-meta' },
                    _react2.default.createElement(
                        'div',
                        { className: 'pix-multi-fields-input' },
                        _react2.default.createElement(
                            _reactBeautifulDnd.DragDropContext,
                            { onDragEnd: this.onDragEnd },
                            _react2.default.createElement(
                                _reactBeautifulDnd.Droppable,
                                { droppableId: 'droppable' },
                                function (provided, snapshot) {
                                    return _react2.default.createElement(
                                        'div',
                                        _extends({}, provided.droppableProps, { className: 'w-full', ref: provided.innerRef, style: getListStyle(snapshot.isDraggingOver) }),
                                        _this2.state.items.map(function (item, index) {
                                            return _react2.default.createElement(
                                                _reactBeautifulDnd.Draggable,
                                                { key: item.id, draggableId: item.id, index: index },
                                                function (provided, snapshot) {
                                                    return _react2.default.createElement(
                                                        'div',
                                                        _extends({ className: 'pix-multifields-item w-[49.99%]', ref: provided.innerRef }, provided.draggableProps, provided.dragHandleProps, { style: getItemStyle(snapshot.isDragging, provided.draggableProps.style) }),
                                                        _react2.default.createElement('input', { onChange: function onChange(e) {
                                                                return _this2.handleItemChange(e, 'title', index);
                                                            }, className: 'pix_item_title pix_fields_field', type: 'text', placeholder: 'Title', value: item.title }),
                                                        _react2.default.createElement('input', { onChange: function onChange(e) {
                                                                return _this2.handleItemChange(e, 'value', index);
                                                            }, className: 'pix_item_value pix_fields_field', type: 'text', placeholder: 'Value', value: item.value }),
                                                        _react2.default.createElement(
                                                            'a',
                                                            { href: '#', onClick: function onClick(e) {
                                                                    return _this2.handleItemDelete(e, index);
                                                                }, className: 'pix_field_remove' },
                                                            'Delete'
                                                        )
                                                    );
                                                }
                                            );
                                        }),
                                        provided.placeholder
                                    );
                                }
                            )
                        )
                    ),
                    _react2.default.createElement(
                        'button',
                        { onClick: this.handleItemAdd, className: 'pix-multi-fields-add button button-primary' },
                        'Add field'
                    )
                ),
                _react2.default.createElement('input', { type: 'hidden', onChange: this.handleInputChange, value: this.state.value, name: this.props.id, id: this.props.id })
            );
        }
    }]);

    return MultifieldsArea;
}(_react2.default.Component);

MultifieldsArea.defaultProps = {
    label: 'Textarea Input',
    value: '',
    onChange: function onChange() {}
};
exports["default"] = MultifieldsArea;

/***/ })

}]);
//# sourceMappingURL=dev_builder_components_fields_multifields_js.bundle.js.map