<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Beehive\Google\Service\PeopleService;

class Source extends \Beehive\Google\Model
{
    /**
     * @var string
     */
    public $etag;
    /**
     * @var string
     */
    public $id;
    protected $profileMetadataType = ProfileMetadata::class;
    protected $profileMetadataDataType = '';
    public $profileMetadata;
    /**
     * @var string
     */
    public $type;
    /**
     * @var string
     */
    public $updateTime;
    /**
     * @param string
     */
    public function setEtag($etag)
    {
        $this->etag = $etag;
    }
    /**
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }
    /**
     * @param string
     */
    public function setId($id)
    {
        $this->id = $id;
    }
    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * @param ProfileMetadata
     */
    public function setProfileMetadata(ProfileMetadata $profileMetadata)
    {
        $this->profileMetadata = $profileMetadata;
    }
    /**
     * @return ProfileMetadata
     */
    public function getProfileMetadata()
    {
        return $this->profileMetadata;
    }
    /**
     * @param string
     */
    public function setType($type)
    {
        $this->type = $type;
    }
    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * @param string
     */
    public function setUpdateTime($updateTime)
    {
        $this->updateTime = $updateTime;
    }
    /**
     * @return string
     */
    public function getUpdateTime()
    {
        return $this->updateTime;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(Source::class, 'Beehive\\Google_Service_PeopleService_Source');