<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Beehive\Google\Service\AnalyticsReporting;

class Report extends \Beehive\Google\Model
{
    protected $columnHeaderType = ColumnHeader::class;
    protected $columnHeaderDataType = '';
    public $columnHeader;
    protected $dataType = ReportData::class;
    protected $dataDataType = '';
    public $data;
    /**
     * @var string
     */
    public $nextPageToken;
    /**
     * @param ColumnHeader
     */
    public function setColumnHeader(ColumnHeader $columnHeader)
    {
        $this->columnHeader = $columnHeader;
    }
    /**
     * @return ColumnHeader
     */
    public function getColumnHeader()
    {
        return $this->columnHeader;
    }
    /**
     * @param ReportData
     */
    public function setData(ReportData $data)
    {
        $this->data = $data;
    }
    /**
     * @return ReportData
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * @param string
     */
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    /**
     * @return string
     */
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(Report::class, 'Beehive\\Google_Service_AnalyticsReporting_Report');