<?php

function dokan_child_custom_logo_setup() {
	$defaults = array(
		'flex-height'          => true,
		'flex-width'           => true,
		'header-text'          => array( 'site-title', 'site-description' ),
		'unlink-homepage-logo' => true,
	);
	add_theme_support( 'custom-logo', $defaults );

	add_theme_support( 'woocommerce' );
}

add_action( 'after_setup_theme', 'dokan_child_custom_logo_setup' );


add_action( 'wp_enqueue_scripts', 'rf_remove_resources', 999 );
function rf_remove_resources() {

	wp_register_style(
		'childe-style',
		get_stylesheet_directory_uri() . '/style.css'
	);
	wp_enqueue_style( 'childe-style' );
}


//set diffrent product types in dokan
// add_filter( 'dokan_product_types', 'set_default_product_types_to_dokan', 11 );
function set_default_product_types_to_dokan( $product_types ) {
	$product_types = array(
		'simple'                => __( 'Simple', 'dokan' ),
		'variable'              => __( 'Variable', 'dokan' ),
		'external'              => __( 'External/Affiliate product', 'dokan' ),
		'redq_rental'           => __( 'Rental Product', 'dokan' ),
		'subscription'          => __( 'Simple Subscription', 'dokan' ),
		'variable-subscription' => __( 'Variable Subscription', 'dokan' ),

	);

	if ( version_compare( WC_VERSION, '2.7', '>' ) ) {
		$product_types['grouped'] = __( 'Group Product', 'dokan' );
	}

	return $product_types;
}


// set diffrent product add template to dokan
add_filter( 'dokan_after_listing_product', 'add_new_to_dokan', 20 );
function add_new_to_dokan() {
	dokan_get_template_part( 'products/tmpl-add-product-popup' );
}

/**
 * Create roles and capabilities.
 */
function create_roles_ct() {
	global $wp_roles;

	if ( ! class_exists( 'WP_Roles' ) ) {
		return;
	}

	if ( ! isset( $wp_roles ) ) {
		$wp_roles = new WP_Roles(); // @codingStandardsIgnoreLine
	}


	// Product Subscriber role.
	add_role(
		'product_subscriber',
		'Product Subscriber',
		array(
			'read' => true,
		)
	);
}

add_action( 'init', 'create_roles_ct' );


/* Custom Code By eMonster*/

// $inc_dir     = dirname( __FILE__ ) . '/includes/';

// require $inc_dir . 'wc-template.php';
// require_once( get_stylesheet_directory() . '/includes/wc-template.php' );

function has_woocommerce_subscription( $the_user_id, $the_product_id, $the_status ) {
	$current_user = wp_get_current_user();
	if ( empty( $the_user_id ) ) {
		$the_user_id = $current_user->ID;
	}
	if ( WC_Subscriptions_Manager::user_has_subscription( $the_user_id, $the_product_id, $the_status ) ) {
		return true;
	}
}


remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
//remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
//remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );


//add_action( 'single_product_woocommerce_calender', 'woocommerce_template_single_add_to_cart' );


//function replace_bookings_text( $bookingtext ) {
//	$str     = str_replace( 'Booking cost', 'Rent cost', $bookingtext );
//	$new_str = htmlspecialchars_decode( $str );
//
//	return $new_str;
//}

//add_filter( 'woocommerce_bookings_booking_cost_string', 'replace_bookings_text', 10, 2 );
//
//function replace_booking_single_add_to_cart_text( $buttonText ) {
//	$str     = str_replace( 'Book now', 'Rent now', $buttonText );
//	$new_str = htmlspecialchars_decode( $str );
//
//	return $new_str;
//}

add_filter( 'woocommerce_booking_single_add_to_cart_text', 'replace_booking_single_add_to_cart_text', 10, 2 );

add_filter( 'woocommerce_product_tabs', 'woo_remove_product_tabs', 98 );

function woo_remove_product_tabs( $tabs ) {

	unset( $tabs['more_seller_product'] );        // Remove the description tab

	return $tabs;
}

add_filter( 'use_widgets_block_editor', '__return_false' );
add_filter( 'use_block_editor_for_post', '__return_false' );


add_filter( 'woocommerce_product_tabs', 'new_product_tab' );

function new_product_tab( $tabs ) {
	/* Adds the new tab */
	$tabs['test_tab'] = array(
		'title'    => __( 'Sizing', 'woocommerce' ),
		'priority' => 100,
		'callback' => 'new_tab_sizing'
	);

	return $tabs;  /* Return all  tabs including the new New Custom Product Tab  to display */
}

function new_tab_sizing() { ?>

    <table class="table">
        <thead>
        <tr>
            <th scope="col">STANDARD SIZE</th>
            <th scope="col"> S</th>
            <th scope="col">M</th>
            <th scope="col">L</th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <th>BUST</th>
            <td>76-90 CM</td>
            <td>80-96 CM</td>
            <td>88-104 CM</td>
        </tr>
        <tr>
            <th>WAIST</th>
            <td>60-76 CM</td>
            <td>64-80 CM</td>
            <td>68-84 CM</td>
        </tr>
        <tr>
            <th>HIPS</th>
            <td>80-106CM</td>
            <td>84-110 CM</td>
            <td>88-114CM</td>
        </tr>

        </tbody>
    </table>

    <br>

    <table class="table">
        <thead>
        <tr>
            <th scope="col">CHILD SIZE</th>
            <th scope="col">12M</th>
            <th scope="col">18M</th>
            <th scope="col">2T</th>
            <th scope="col">3T</th>
            <th scope="col">4T</th>
            <th scope="col">5T</th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <th>BUST</th>
            <td>52 CM</td>
            <td>54 CM</td>
            <td>56 CM</td>
            <td>58 CM</td>
            <td>60 CM</td>
            <td>64 CM</td>
        </tr>
        <tr>
            <th>WAIST</th>
            <td>50 CM</td>
            <td>52 CM</td>
            <td>54 CM</td>
            <td>56 CM</td>
            <td>57 CM</td>
            <td>60 CM</td>
        </tr>
        <tr>
            <th>LENGTH</th>
            <td>45 CM</td>
            <td>49 CM</td>
            <td>53 CM</td>
            <td>57 CM</td>
            <td>60 CM</td>
            <td>65 CM</td>
        </tr>
        <tr>
            <th>SHOULDER</th>
            <td>20 CM</td>
            <td>21 CM</td>
            <td>22 CM</td>
            <td>23 CM</td>
            <td>24 CM</td>
            <td>25 CM</td>
        </tr>

        </tbody>
    </table>
	<?php
}


add_action( 'woocommerce_before_calculate_totals', 'add_custom_price' );
function add_custom_price( $cart_object ) {
	if ( ! has_woocommerce_subscription( '', '', 'active' ) ) {
		return;
	}

	$user_id = get_current_user_id();
	$boxes   = get_user_meta( $user_id, 'boxes', true );

	foreach ( $boxes as $box ) {
		foreach ( $box->items ?? [] as $cart_id => $item_id ) {
			if ( isset( $cart_object->cart_contents[ $cart_id ] ) ) {
				$value = $cart_object->cart_contents[ $cart_id ];
				$value['data']->set_price( 0 );
			}
		}
	}

	//this is for during cart page user changes the rent length and stuff
//    foreach ($cart_object->cart_contents as $cart_item_key => $data) {
//        if (isset($data['start_date_to_add'])) {
//            $start = new DateTime($data['start_date_to_add']);
//        }
//        if (isset($data['end_date_to_add'])) {
//            $end = new DateTime($data['end_date_to_add']);
//        }
//        $days_diff = $start->diff($end)->days;
//
//
//		if ( $days_diff == 5 ) {
//	        $value['data']->set_price( get_product_price_by_blocks($booking->get_product_id(), 1) );
//		} else if ( $days_diff == 10 ) {
//	        $value['data']->set_price( get_product_price_by_blocks($booking->get_product_id(), 2) );
//		}
//	}
}

// **********************************************************************************************************************

/**
 * June 9, 2023
 *    - Box object
 *    - Meta Data
 */
class Box {

	/**
	 * Map of key => cart id, value => {start_date_to_add, end_date_to_add}
	 */
	public $items = [];

	/**
	 * max number of items allowed in box
	 */
	public $box_limit = 0;

	/**
	 * 'present' = not shipped
	 * 'shipped' = shipped
	 * 'pending' = pending shippment
	 */
	public $box_status = '';

	/**
	 * @var string box id -> [$subscription_id]-[$box_number]
	 */
	public $box_id = '';

	public $order_id = '';

	public function __construct( $box_limit, $box_status, $box_id ) {
		$this->box_limit  = $box_limit;
		$this->box_status = $box_status;
		$this->box_id     = $box_id;
	}

	/**
	 * get the remaining number of items
	 */
	public function items_remaining( $cart_item_key = "none" ) {
		if ( $this->box_status == 'shipped' || $this->box_status == 'pending' ) {
			return 0;
		}

		$total = 0;

		foreach ( $this->items ?? [] as $cart_id => $data ) {
			if ( $cart_id != $cart_item_key ) {
				$total += $data['quantity'];
			}
		}

		return $this->box_limit - $total;
	}

	public function items_in_box() {
		$total = 0;

		foreach ( $this->items ?? [] as $cart_id => $data ) {
			$total += $data['quantity'];
		}

		return $total;
	}

	public function check_items() {
		$cart = WC()->cart->get_cart();

		foreach ( $this->items as $cart_id => $item_id ) {
			if ( ( $this->box_status == 'present' ) && ! isset( $cart[ $cart_id ] ) ) {
				unset( $this->items[ $cart_id ] );
			}
		}
	}
}

function register_account_add_initial_user_metadata( $user_id ) {
	add_user_meta( $user_id, 'subscription_id', '' );
	add_user_meta( $user_id, 'boxes', [] );
	add_user_meta( $user_id, 'has_subscription', false );
}

add_action( 'user_register', 'register_account_add_initial_user_metadata' );

function check_and_add_initial_user_metadata($user_login, $user) {
	$user_id = $user->ID;

	if ( ! get_user_meta( $user_id, 'boxes', true ) ) {
		add_user_meta( $user_id, 'subscription_id', '' );
		add_user_meta( $user_id, 'boxes', [] );
		add_user_meta( $user_id, 'has_subscription', false );
	}

}

add_action('wp_login', 'check_and_add_initial_user_metadata', 10, 2);

function purchase_subscription_alter_user_metadata( $subscription ) {

	$user_id = get_current_user_id();

	$items     = $subscription->get_items();
	$item      = reset( $items );  //grab the first element
	$product   = $item->get_product();
	$num_box   = $product->get_attribute( 'boxes' );
	$box_limit = $product->get_attribute( 'items' );
	$boxes     = [];

	for ( $i = 1; $i <= $num_box; $i ++ ) {
		$box = new Box( $box_limit, 'present', $subscription->get_id() . '-' . $i );
		array_push( $boxes, $box );
	}

	update_user_meta( $user_id, 'boxes', $boxes );
	update_user_meta( $user_id, 'subscription_id', $subscription->get_id() );
	update_user_meta( $user_id, 'has_subscription', true );
}

add_action( 'woocommerce_subscription_payment_complete', 'purchase_subscription_alter_user_metadata' );

/**
 * add the items that are chosen with the box into the box list
 * check if has enough room in boxes -> if not, pop error
 * @return void
 */
function add_to_cart_action_subscription( $cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data ) {
	if ( is_user_logged_in() == false ) {
		return;
	}

	// must breakpoint after this line
	$product = wc_get_product( $product_id );
	$user_id = get_current_user_id();
	$boxes   = get_user_meta( $user_id, 'boxes', true );

	check_metadata_matches_cart( $user_id, $boxes );

	if ( WC_Subscriptions_Product::is_subscription( $product_id ) ) {
		return;
	}
	if ( $_POST['isBoxed'] == "false" ) {
		return;
	}

	// add the time checking and stuff here
	$end_date_to_add = rent_item_with_subscription( $cart_item_key, $product_id, $quantity, $variation_id, ); //the end to add to into database -> add this data into the box
	$cart            = WC()->cart;

	for ( $i = 0; $i < count( $boxes ); $i ++ ) {
		$box          = $boxes[ $i ];
		$variation_id = $cart->get_cart_contents()[ $cart_item_key ]['variation_id'];
		if ( $box->items_remaining() >= $quantity && $box->box_status == 'present' ) {
			for ( $j = 0; $j < $quantity; $j ++ ) { //fill the box entries with the duplicate item
				$box->items[ $cart_item_key ] = [
					'start_date_to_add' => date( "Y-m-d" ),
					'end_date_to_add'   => $end_date_to_add,
					'quantity'          => $quantity,
				];
			}
			$boxes[ $i ] = $box;
			update_user_meta( $user_id, 'boxes', $boxes );
			$test = get_user_meta( $user_id, 'boxes', true );

			return;
		}
	}
}

add_action( 'woocommerce_add_to_cart', 'add_to_cart_action_subscription', 100, 6 );

/**
 * @param $product_id
 * gets called after this item has been added to the cart
 *
 * @return void
 */
function rent_item_with_subscription( $cart_item_key, $product_id, $quantity_needed, $variation_id ) {
	global $wpdb;
	$min_date = strtotime( 'midnight' );
	$end_date = date( "Y-m-d", strtotime( '+2 year', $min_date ) ); //default end date

	$rental_stock        = get_post_meta( $variation_id, '_wcrp_rental_products_rental_stock', true );
	$return_day_threhold = (int) sanitize_text_field( $_POST['wcrp_rental_products_return_days_threshold'] ) + 1;
	$rented_dates        = $wpdb->get_results(
		$wpdb->prepare(
			"SELECT
              `{$wpdb->prefix}wcrp_rental_products_rentals`.`reserved_date`,
              SUM(`{$wpdb->prefix}wcrp_rental_products_rentals`.`quantity`) AS `quantity`
            FROM
              `{$wpdb->prefix}wcrp_rental_products_rentals`
            INNER JOIN (
                SELECT order_item_id, group_concat(meta_key) AS qualities 
                FROM `{$wpdb->prefix}woocommerce_order_itemmeta`
                GROUP BY order_item_id
                HAVING qualities NOT LIKE '%wcrp_rental_products_returned%'
            ) `{$wpdb->prefix}woocommerce_order_itemmeta` ON  `{$wpdb->prefix}wcrp_rental_products_rentals`.`order_item_id` = `{$wpdb->prefix}woocommerce_order_itemmeta`.`order_item_id`
            WHERE
              `product_id` = %d AND reserved_date >= CURDATE()
            GROUP BY
              `{$wpdb->prefix}wcrp_rental_products_rentals`.`reserved_date`
            ORDER BY
              `{$wpdb->prefix}wcrp_rental_products_rentals`.`reserved_date` ASC;",
			$variation_id
		)
	);

	//check is there is a booking after the today
	foreach ( $rented_dates as $rented_date ) {
		if ( $rented_date->reserved_date > $end_date ) {
			break;
		} else if ( $rental_stock - $rented_date->quantity < $quantity_needed ) {
			$end_date = date( "Y-m-d", strtotime( $rented_date->reserved_date . " - $return_day_threhold days" ) );
		}
	}

	$cart_contents                                                     = WC()->cart->get_cart_contents();
	$cart_contents[ $cart_item_key ]['wcrp_rental_products_rent_to']   = $end_date;
	$cart_contents[ $cart_item_key ]['wcrp_rental_products_rent_from'] = date( "Y-m-d" );

	WC()->cart->set_cart_contents( $cart_contents );
	$cart_session = new WC_Cart_Session( WC()->cart );
	$cart_session->set_session();

	return $end_date;
}

//unecessary
function remove_from_cart_alter_metadata( $cart_item_key, $cart ) {
	if ( is_user_logged_in() == false ) {
		return;
	}

	$product_id                 = $cart->get_cart_contents()[ $cart_item_key ]['product_id'];
	$is_subscription            = WC_Subscriptions_Product::is_subscription( $product_id );
	$cart_contains_subscription = WC_Subscriptions_Cart::cart_contains_subscription();

	// an automatic check done by wordpress to check if subscription and item are in cart at the same time
	if ( $is_subscription && ! $cart_contains_subscription && ! WC()->cart->is_empty() ) {
		return;
	}

	$user_id = get_current_user_id();
	$boxes   = get_user_meta( $user_id, 'boxes', true );

	check_metadata_matches_cart( $user_id, $boxes );
}

add_action( 'woocommerce_cart_item_removed', 'remove_from_cart_alter_metadata', 100, 2 );

function remove_product_after_payment_complete( $order_id, $transaction_id ) {
	global $wpdb;
	$cart        = WC()->cart;
	$cart_items  = $cart->get_cart();
	$user_id     = get_current_user_id();
	$boxes       = get_user_meta( $user_id, 'boxes', true );
	$order_items = wc_get_order( $order_id )->get_items();

	//box status to pending
	foreach ( $cart_items as $cart_id => $values ) {
		$is_in_box = false;
		foreach ( $boxes as $box ) {
			if ( array_key_exists( $cart_id, $box->items ) ) {
				$box->box_status = 'pending';
				$box->order_id   = $order_id;

				//get the data from the box data and insert it into the database
				$data      = $box->items[ $cart_id ];
				$start     = new DateTime( $data['start_date_to_add'] );
				$end       = new DateTime( $data['end_date_to_add'] );
				$quantity  = $data['quantity'];
				$days_diff = $start->diff( $end )->days;
				$order_item_data;


				//need this to verify if the cart order matches the order item -> some order items may be duplicate
				foreach ( $order_items as $order_item ) {
					if ( $order_item->get_variation_id() == $values['variation_id'] && $quantity == $order_item->get_quantity() ) {
						$order_item_data = $order_item;
						break;
					}
				}

				//modifying the database
				for ( $i = 0; $i < $days_diff; $i ++ ) {
					$wpdb->insert(
						$wpdb->prefix . 'wcrp_rental_products_rentals',
						array(
							'reserved_date' => $start->modify( '+' . $i . ' day' )->format( 'Y-m-d' ),
							'order_id'      => $order_id,
							'order_item_id' => $order_item_data->get_id(),
							'product_id'    => $order_item_data->get_variation_id(),
							'quantity'      => $order_item_data->get_quantity(),
						)
					);
				}
			}
			update_user_meta( $user_id, 'boxes', $boxes );
		}
	}

	$cart_contents   = $cart->get_cart_contents();
	$boxes_new_items = array(array());
	foreach ( $order_items as $order_item ) {
		if ( $order_item['data']['subtotal'] == 0 ) {
			//check which box this boxes item belongs to
			for ( $i = 0; $i < count( $boxes ); $i ++ ) {
				foreach ( $boxes[ $i ]->items as $cart_item_id => $data ) {

					//order item matches that of the cart item
					if ( $cart_contents[ $cart_item_id ]['variation_id'] == $order_item->get_variation_id() && $data['quantity'] == $order_item->get_quantity() ) {
						//delete from box
						unset( $boxes[ $i ]->items[ $cart_item_id ] );
						$boxes_new_items[ $i ][$order_item->get_id()] = array(
							'start_date_to_add' => $data['start_date_to_add'],
							'end_date_to_add'   => $data['end_date_to_add'],
							'quantity'          => $data['quantity'],
						);
						break;
					}
				}
				update_user_meta( $user_id, 'boxes', $boxes );
			}
		}
	}

	for ( $i = 0; $i < count( $boxes ); $i ++ ) {
		$boxes[ $i ]->items = $boxes_new_items[ $i ];
	}
	update_user_meta( $user_id, 'boxes', $boxes );

	$test = get_user_meta( $user_id, 'boxes', true );
}

add_action( 'woocommerce_payment_complete', 'remove_product_after_payment_complete', 100, 2 );

function cart_page_show_notice() {
	if ( is_user_logged_in() == false ) {
		return;
	}

	$user_id  = get_current_user_id();
	$boxes    = get_user_meta( $user_id, 'boxes', true );
	$min_date = strtotime( 'midnight' );
	$index    = 1;

	// find the earliest return date for all products
	foreach ( $boxes as $box ) {
		$earliest_ret_date = ( new DateTime() )->modify( '+2 years' );

		if ( $box->box_status == 'pending' || $box->box_status == 'shipped' || empty( $box->items ) ) {
			$index ++;
			continue;
		}

		foreach ( $box->items as $cart_id => $data ) {

			//get the data from the box data and insert it into the database
			$start      = new DateTime( $data['start_date_to_add'] );
			$end        = new DateTime( $data['end_date_to_add'] );
			$quantity   = $data['quantity'];
			$days_diff  = $start->diff( $end )->days;
			$years_diff = $start->diff( $end )->y;

			if ( $years_diff < 2 ) {
				//there is onetime product after this product
				if ( $end < $earliest_ret_date ) {
					$earliest_ret_date = $end;
				}
			}
		}

		if ( $earliest_ret_date <= new DateTime( 'now' ) ) {
			continue;
		} else if ( $earliest_ret_date < ( new DateTime() )->modify( '+1 years' ) ) {
			wc_add_notice( "Please return <strong>Box#" . $index . " </strong>no later than<strong> " . $earliest_ret_date->format( 'F d Y' ) . "</strong>", 'notice' );
		} else {
			wc_add_notice( "Please return <strong>Box#" . $index . "</strong> before your next order", 'notice' );

		}
		$index ++;
	}
	wc_print_notices();

}

add_action( 'woocommerce_before_cart', 'cart_page_show_notice' );

function cart_icon_change_price( $price, $cart_object ) {
	if ( ! has_woocommerce_subscription( '', '', 'active' ) ) {
		return $price;
	}

	$user_id = get_current_user_id();
	$boxes   = get_user_meta( $user_id, 'boxes', true );

	foreach ( $boxes ?? [] as $box ) {
		foreach ( $box->items ?? [] as $cart_id => $item_id ) {
			if ( $cart_object['key'] == $cart_id ) {
				return '$0.00';
			}
		}
	}

//    $booking_id = $cart_object['booking']['_booking_id'];
//    $booking = get_wc_booking( $booking_id);
//    $end_date_time = new DateTime($booking->get_end_date());
//    $start_date_time = new DateTime($booking->get_start_date());
//    $rent_days = $end_date_time->diff($start_date_time)->format("%a");
//
//    if ($rent_days == 5) {
//        return '$' . number_format(get_product_price_by_blocks($booking->get_product_id(), 1), 2, '.', '');
//    } else if ($rent_days == 10) {
//	    return '$' . number_format(get_product_price_by_blocks($booking->get_product_id(), 2), 2, '.', '');
//    }

	return $price;
}

add_filter( 'woocommerce_cart_item_price', 'cart_icon_change_price', 100, 2 );

function reset_box( $user_id ) {
	$boxes = get_user_meta( $user_id, 'boxes', true );

	if ( ! $boxes ) {
		return;
	}

//	foreach ( $boxes as $box ) {
//		$box->items      = array();
//		$box->box_status = 'present';
//        $box->box_limit = 0;
//        $box->box_id = '';
//        $box->order_id = '';
//	}

	update_user_meta( $user_id, 'boxes', [] );
	update_user_meta( $user_id, 'subscription_id', '' );
	update_user_meta( $user_id, 'has_subscription', false );
}

function check_metadata_matches_cart( $user_id, &$boxes ) {
	// perform routine checks to make sure the user-meta-data is up to date
	foreach ( $boxes as $box ) {
		$box->check_items();
	}
	update_user_meta( $user_id, 'boxes', $boxes );
}

function cart_checkbox_ajax_handler() {
	global $wpdb;
	$user_id            = get_current_user_id();
	$boxes              = get_user_meta( $user_id, 'boxes', true );
	$cart_id            = $_POST['checkBoxId'];
	$selected_box_index = (int) $_POST['checkboxValue'];
	$selected_box       = $boxes[ $selected_box_index ];
	$cart_contents      = WC()->cart->get_cart_contents();
	$variation_id       = $cart_contents[ $cart_id ]['variation_id'];
	$product_id         = $cart_contents[ $cart_id ]['product_id'];

	check_metadata_matches_cart( $user_id, $boxes );

	$rental_stock = get_post_meta( $variation_id, '_wcrp_rental_products_rental_stock', true );
	$rented_dates = $wpdb->get_results(
		$wpdb->prepare(
			"SELECT
              `{$wpdb->prefix}wcrp_rental_products_rentals`.`reserved_date`,
              SUM(`{$wpdb->prefix}wcrp_rental_products_rentals`.`quantity`) AS `quantity`
            FROM
              `{$wpdb->prefix}wcrp_rental_products_rentals`
            INNER JOIN (
                SELECT order_item_id, group_concat(meta_key) AS qualities 
                FROM `{$wpdb->prefix}woocommerce_order_itemmeta`
                GROUP BY order_item_id
                HAVING qualities NOT LIKE '%wcrp_rental_products_returned%'
            ) `{$wpdb->prefix}woocommerce_order_itemmeta` ON  `{$wpdb->prefix}wcrp_rental_products_rentals`.`order_item_id` = `{$wpdb->prefix}woocommerce_order_itemmeta`.`order_item_id`
            WHERE
              `product_id` = %d AND reserved_date >= CURDATE()
            GROUP BY
              `{$wpdb->prefix}wcrp_rental_products_rentals`.`reserved_date`
            ORDER BY
              `{$wpdb->prefix}wcrp_rental_products_rentals`.`reserved_date` ASC;",
			$variation_id
		)
	);

	if ( $_POST['isChecked'] == 'true' ) { //just been checked

		if ( reset( $rented_dates )->reserved_date == date( 'Y-m-d' ) &&
		     $rental_stock - reset( $rented_dates )->quantity - $cart_contents[ $cart_id ]['quantity'] < 0 ) { // there are products being rented today resulting there not being enough product to rent
			echo 'Error: Cannot add order to box.';
			wc_add_notice( 'Cannot move  item( <strong>' . wc_get_product( $product_id )->get_name() . '</strong> ) to box due to insufficient inventory. Please try again another time', 'error' );
			die();
		} else if ( $cart_contents[ $cart_id ]['quantity'] > $selected_box->items_remaining() ) { //when the items cannot fit within the box but there are enough quantity available
			echo 'Error: Cannot add order to box.';
			$display_num = $selected_box_index + 1;
			wc_add_notice( 'Warning: <strong>Box#' . $display_num . '</strong> is full. Please remove current item or upgrade subscription', 'error' );
			die();
		}


		$end_date_to_add = rent_item_with_subscription( $cart_id, $product_id, $cart_contents[ $cart_id ]['quantity'], $cart_contents[ $cart_id ]['variation_id'] );

		//remove item from box -> if we are switching boxes
		foreach ( $boxes as $box ) {
			if ( $box->items[ $cart_id ] ) {
				unset( $box->items[ $cart_id ] );
			}
		}
		//add to new box
		$boxes[ $selected_box_index ]->items[ $cart_id ] = [
			'start_date_to_add' => date( "Y-m-d" ),
			'end_date_to_add'   => $end_date_to_add,
			'quantity'          => $cart_contents[ $cart_id ]['quantity'],
		];
		update_user_meta( $user_id, 'boxes', $boxes );

		WC()->cart->calculate_totals();

		echo ( count( $boxes ) == 2 && $boxes[0]->box_status == 'present' && $boxes[1]->box_status == 'present' ) ? "checked " . $cart_id . "Please uncheckOther" : "checked " . $cart_id;
	} else {
		//remove from box
		foreach ( $boxes as $box ) {
			if ( $box->items[ $cart_id ] ) {
				unset( $box->items[ $cart_id ] );
			}
		}

		//remove from cart
		WC()->cart->remove_cart_item( $cart_id );

		//add a notice
		wc_add_notice( 'Item( <strong>' . wc_get_product( $product_id )->get_name() . '</strong> ) was removed from box', 'notice' );

	}
	die();
}

add_action( 'wp_ajax_nopriv_checkbox_change', 'cart_checkbox_ajax_handler' );
add_action( 'wp_ajax_checkbox_change', 'cart_checkbox_ajax_handler' );

function cart_checkmark_ajax_script() {
	?>

    <script id='checkbox_ajax' type="text/javascript">
        let checkbox;

        function openPopup() {
            let popup = document.getElementById("popup");
            let overlay = document.getElementById("cart_page_overlay");
            popup.style.display = 'block';
            overlay.style.display = 'block';
        }

        jQuery(document).on("change", "input[type=checkbox]", (event) => {
            let doc = jQuery;
            checkbox = doc(event.currentTarget);
            let isChecked = checkbox.is(":checked");
            let checkboxValue = checkbox.val();
            let checkboxId = checkbox.attr('id');
            console.log("isChecked: " + isChecked);
            console.log("checkboxValue: " + checkboxValue);
            console.log("checkboxId: " + checkboxId);
            console.log(event);

            let popup_checkboxNumber = document.getElementById('checkbox_number');
            let popup_checkboxId = document.getElementById('cart_id');
            popup_checkboxNumber.value = checkboxValue;
            popup_checkboxId.value = checkboxId;

            let checkbox_alt = doc('input[type="checkbox"][id="' + checkboxId + '"][value="' + ((checkboxValue == '0') ? '1' : '0') + '"]');
            // if (!isChecked && !checkbox_alt.is(':checked')) {
            //     openPopup();
            //     console.log("both unchecked");
            // } else {
            checkbox_alt.prop('checked', false);
            // Perform AJAX request
            doc.ajax({
                url: '/wp-admin/admin-ajax.php',
                type: 'POST',
                data: {
                    action: 'checkbox_change',
                    checkBoxId: checkboxId,
                    checkboxValue: checkboxValue,
                    isChecked: isChecked
                },
                success: function (response) {
                    // Handle the AJAX response here
                    if (response === "uncheckOther") {
                        var checkbox_alt = doc('input[type="checkbox"][id="' + checkboxId + '"][value="' + ((checkboxValue == '0') ? '1' : '0') + '"]');
                        checkbox_alt.prop('checked', false);
                    } else if (response === 'Error: Cannot add order to box.') {
                        var checkbox = doc('input[type="checkbox"][id="' + checkboxId + '"]');
                        checkbox.prop('checked', false);
                    }

                    doc('#update_cart').disabled = false;
                    doc('#update_cart').click();
                    console.log(response);
                },
                error: function (xhr, status, error) {
                    // Handle AJAX errors here
                    console.error(error);
                }
            });
            // }
            event.stopImmediatePropagation(); //prevent bubbling up
        });
    </script>
	<?php
}

add_action( 'cart_content_javascript', 'cart_checkmark_ajax_script' );

function popup_ajax_script() {
	?>
    <div id="popup" class="popup" style="display: none;
     position: fixed;
      top: 50%; left: 50%;
       transform: translate(-50%, -50%);
        background-color: #fff;
         padding: 20px;
          border: 1px solid #ccc;
            z-index: 9999;">
        <p style="font-size: 20px; color: black; padding-bottom: 20px;">Select which rental option you want</p>
        <input type="hidden" id="cart_id" value="blank">
        <input type="hidden" id="checkbox_number" value="blank">
        <select id="dropdown">
            <option value="5">5-Days</option>
            <option value="10">10-Days</option>
            <option value="cancel">Keep in the Box</option>
        </select>
        <button onclick="submitForm()" style="float: right;">Submit</button>
    </div>

    <div id="cart_page_overlay" style="display: none;
     position: fixed;
      top: 0;
       left: 0;
        width: 100%;
         height: 100%;
          background-color: rgba(0, 0, 0, 0.5);
           z-index: 9998;">
    </div>
    <script>
        function submitForm() {
            console.log("form submitted");
            let popup = document.getElementById("popup");
            let overlay = document.getElementById("cart_page_overlay");
            popup.style.display = 'none';
            overlay.style.display = 'none';

            let selected = document.getElementById("dropdown").value;
            // var selected = dropdown.options[dropdown.selectedIndex].value;
            let cart_id = document.getElementById("cart_id").value;
            let checkbox_number = document.getElementById("checkbox_number").value;

            if (selected != 'cancel') {
                jQuery.ajax({
                    url: '/wp-admin/admin-ajax.php',
                    type: 'POST',
                    data: {
                        action: 'unchecked_item_prompt',
                        selectedOption: selected,
                        cart_id: cart_id,
                        checkbox_number: checkbox_number,
                    },
                    success: function (response) {
                        // Handle the AJAX response here
                        if (response === 'item removed from box through prompt') {
                            checkbox.prop('checked', true);
                        }

                        jQuery('#update_cart').disabled = false;
                        jQuery('#update_cart').click();
                        console.log(response);
                    },
                    error: function (xhr, status, error) {
                        // Handle AJAX errors here
                        console.error(error);
                    }
                });
            } else {
                checkbox.prop('checked', true);
            }
        }
    </script>
	<?php
}

add_action( 'woocommerce_before_cart', 'popup_ajax_script' );

function pop_up_ajax_handler() {
	$checkbox_number = $_POST['checkbox_number'];
	$user_id         = get_current_user_id();
	$boxes           = get_user_meta( $user_id, 'boxes', true );
	$cart_item_key   = $_POST['cart_id'];
	$selectedOption  = $_POST['selectedOption'];

	//change the end date of the booking
	$cart_contents                                                   = WC()->cart->get_cart_contents();
	$end_date_time                                                   = strtotime( $cart_contents[ $cart_item_key ]['wcrp_rental_products_rent_from'] . '+' . $selectedOption . ' day' );
	$end_date                                                        = date( 'Y-m-d', $end_date_time );
	$cart_contents[ $cart_item_key ]['wcrp_rental_products_rent_to'] = $end_date;

	WC()->cart->set_cart_contents( $cart_contents );
	$cart_session = new WC_Cart_Session( WC()->cart );
	$cart_session->set_session();

	//remove item from box
	foreach ( $boxes as $box ) {
		if ( $box->items[ $cart_item_key ] ) {
			unset( $box->items[ $cart_item_key ] );
			break;
		}
	}

	update_user_meta( $user_id, 'boxes', $boxes );

	echo 'item removed from box through prompt';
}

add_action( 'wp_ajax_nopriv_unchecked_item_prompt', 'pop_up_ajax_handler' );
add_action( 'wp_ajax_unchecked_item_prompt', 'pop_up_ajax_handler' );

function admin_subscription_ajax_script() {
	echo <<< 'EOT'
        <script id="ret_box_ajax" type="text/javascript">
            jQuery(document).ready(function($) {
                $('.ret_subscription_value' ).on('click', function(event) {
                    var doc = jQuery;
                    var link = doc(event.target)
                    
                    var attr = link.attr('title').split(' ');
                    var user_id = attr[0];
                    var boxNum = attr[1];
                    console.log(boxNum);
                    console.log(user_id);

                    // Perform AJAX request
                    $.post(
                    '/wp-admin/admin-ajax.php',
                    {
                        action: 'returned_box',
                        box_num: boxNum,
                        user_id: user_id,
                    },
                   function(response) {
                        // Handle the AJAX response
                        location.reload(); 
                        console.log(response);
                   },
                );
            });
            });
        </script>
        EOT;
}

add_action( 'admin_print_scripts', 'admin_subscription_ajax_script', 1688 );

/**
 * @throws Exception
 */
function admin_subscription_return_ajax_handler() {
	global $wpdb;
	$user_id  = $_POST['user_id'];
	$box_num  = $_POST['box_num'];
	$boxes    = get_user_meta( $user_id, 'boxes', true );
	$box      = $boxes[ $box_num ];
	$order_id = $boxes[ $box_num ]->order_id;

	$order = wc_get_order( $order_id );
	$order->update_status( 'completed' );

	foreach ( $box->items as $returned_order_item_id => $data ) {
		if ( empty( wc_get_order_item_meta( $returned_order_item_id, 'wcrp_rental_products_returned', true ) ) ) {

			wc_add_order_item_meta( $returned_order_item_id, 'wcrp_rental_products_returned', 'yes', true );

		}

		WCRP_Rental_Products_Order_Save::rentals_add_update( $order_id );

		// custom query -> add 3 days after item is returned
		$date       = date( 'Y-m-d' );
		$product_id = $order->get_items()[ $returned_order_item_id ]->get_data()['product_id'];
		if ( wc_get_product( $product_id )->is_type( 'variable' ) ) {
			$product_id = $order->get_items()[ $returned_order_item_id ]->get_data()['variation_id'];
		}
		$quantity = $order->get_items()[ $returned_order_item_id ]->get_data()['quantity'];

		//3 days intermission
		for ( $i = 0; $i < 3; $i ++ ) {
			$wpdb->query(
				$wpdb->prepare(
					"INSERT INTO `{$wpdb->prefix}wcrp_rental_products_rentals` (reserved_date, order_id, order_item_id, product_id, quantity) VALUES (%s, 0, 0, %d, %d);",
					$date,
					$product_id,
					$quantity,
				)
			);
			//rent the current day as well -> may need to change later
			$date = date( 'Y-m-d', strtotime( $date . ' +1 day' ) );
		}
	}

	// reset the box
	$boxes[ $box_num ]->items      = [];
	$boxes[ $box_num ]->box_status = 'present';
	$boxes[ $box_num ]->order_id   = '';

	update_user_meta( $user_id, 'boxes', $boxes );

	echo 'Returned box ' . $box_num . ' for user ' . $user_id;
}

add_action( 'wp_ajax_nopriv_returned_box', 'admin_subscription_return_ajax_handler' );
add_action( 'wp_ajax_returned_box', 'admin_subscription_return_ajax_handler' );

function order_complete_change_box_metadata( $order_id, $old_status, $new_status ) {
	if ( $new_status == 'completed' && $old_status != 'completed' ) {
		$order   = wc_get_order( $order_id );
		$user_id = $order->get_user_id();
		$boxes   = get_user_meta( $user_id, 'boxes', true );

		foreach ( $boxes as $box ) {
			if ( $box->box_status == 'pending' && $box->order_id == $order_id ) {
				$box->box_status = 'shipped';
			}
		}

		update_user_meta( $user_id, 'boxes', $boxes );
	}
}

add_action( 'woocommerce_order_status_changed', 'order_complete_change_box_metadata', 10, 3 );

function check_num_of_subscriptions( $valid, $product_id ) {
	$product_to_add = wc_get_product( $product_id );

	if ( $product_to_add instanceof WC_Product_Subscription || $product_to_add instanceof WC_Product_Variable_Subscription ) {
		$user_id = get_current_user_id();
		$boxes   = get_user_meta( $user_id, 'boxes', true );
		$ret_box = [];
		$index   = 1;

		foreach ( $boxes as $box ) {
			if ( $box->box_status == 'shipped' ) {
				array_push( $ret_box, $index );
				$index ++;
			}
		}
		// alternative use: $has_sub = wcs_user_has_subscription( '', '', 'active' );
		if ( has_active_subscription() ) {
			// cart validation must fail, because user is not allowed to have multiple subscriptions
			if ( count( $ret_box ) == 1 ) {
				wc_add_notice( 'Please return Box#' . $ret_box[0] . ' then cancel the current subscription before subscribing to a new one', 'error' );
				wc_print_notices();
			} else if ( count( $ret_box ) == 2 ) {
				wc_add_notice( 'Please return Box#' . $ret_box[0] . ' and Box#' . $ret_box[1] . 'then cancel the current subscription before subscribing to a new one', 'error' );
				wc_print_notices();
			} else {
				wc_add_notice( 'Please cancel the current subscription before subscribing to a new one', 'error' );
				wc_print_notices();
			}

			return false;
		} else {
			return true;
		}
	}

	return $valid;
}

add_filter( 'woocommerce_add_to_cart_validation', 'check_num_of_subscriptions', 10, 2 );

function has_active_subscription() {

	$user_id = get_current_user_id();

	$active_subscriptions = get_posts( array(
		'numberposts' => - 1,
		'meta_key'    => '_customer_user',
		'meta_value'  => $user_id,
		'post_type'   => 'shop_subscription',
		'post_status' => 'wc-active'

	) );
	if ( ! empty( $active_subscriptions ) ) {
		return true;
	} else {
		return false;
	}
}

function cancel_subscription_check_boxes_returned( $can_cancel ) {
	$user_id = get_current_user_id();
	$boxes   = get_user_meta( $user_id, 'boxes', true );

	foreach ( $boxes as $box ) {
		if ( $box->box_status == 'shipped' ) {
			return false;
		}
	}

	return $can_cancel;
}

add_filter( 'can_cancel_subscription', 'cancel_subscription_check_boxes_returned' );

function cancelled_subscription_change_box_metadata( $new_status, $old_status ) {
	if ( $new_status == 'cancelled' && $old_status != 'cancelled' ) {
		$user_id = get_current_user_id();
		$boxes   = get_user_meta( $user_id, 'boxes', true );

		//removed boxed items from the cart
		foreach ( $boxes as $box ) {
			foreach ( array_keys( $box->items ) as $cart_id ) {
				WC()->cart->remove_cart_item( $cart_id );
			}
		}

		update_user_meta( $user_id, 'boxes', [] );
		update_user_meta( $user_id, 'subscription_id', '' );
		update_user_meta( $user_id, 'has_subscription', false );
	}
}

add_action( 'manual_cancelled_subscription', 'cancelled_subscription_change_box_metadata', 10, 3 );

function admin_bookings_return_one_time_action( $actions, $booking ) {
	$user_id = $booking->get_customer_id();
	$boxes   = get_user_meta( $user_id, 'boxes', true );

	// if the booking is a subscription booking, don't add the return action
	foreach ( $boxes as $box ) {
		if ( array_search( $booking->get_id(), $box->items ) !== false ) {
			return $actions;
		}
	}

	if ( $booking->get_order()->get_status() != 'completed' || $booking->get_status() == 'complete' ) {
		return $actions;
	}

	$actions['return'] = array(
		'url'    => '#',
		'name'   => 'Return Item',
		'action' => "return_one_time_booking",
		'tip'    => $booking->get_id(),
	);

	return $actions;
}

add_filter( 'woocommerce_admin_booking_actions', 'admin_bookings_return_one_time_action', 10, 2 );

function admin_return_item_ajax_script() {
	echo <<< 'EOT'
        <script id="ret_one_time_item_ajax" type="text/javascript">
            jQuery(document).ready(function($) {
                $('.return_one_time_booking' ).on('click', function(event) {
                    var doc = jQuery;
                    var btn = doc(event.target)

                    var booking_id = btn.text();
                    console.log(booking_id);

                    // Perform AJAX request
                    $.post(
                    '/wp-admin/admin-ajax.php',
                    {
                        action: 'returned_item_one_time',
                        booking_id: booking_id,
                    },
                   function(response) {
                        // Handle the AJAX response
                        location.reload(); 
                        console.log(response);
                   },
                );
            });
            });
        </script>
        EOT;
}

add_action( 'admin_print_scripts', 'admin_return_item_ajax_script', 1688 );

function admin_return_item_ajax_handler() {
	$booking_id = $_POST['booking_id'];
	$booking    = new WC_Booking( $booking_id );

	$today = strtotime( 'midnight' );
	$booking->set_end( $today );
	$booking->set_status( 'complete' );

	//set the start date to today if the start date was in the future
	if ( $booking->get_start() > $today ) {
		$booking->set_start( $today );
	}

	// updating the booking
	$booking_data_store = new WC_Booking_Data_Store();
	$booking_data_store->update( $booking );

	$test = new WC_Booking( $booking_id );

	echo 'Returned item ' . $booking->get_product()->get_name() . ' successfully';
	die();
}

add_action( 'wp_ajax_nopriv_returned_item_one_time', 'admin_return_item_ajax_handler' );
add_action( 'wp_ajax_returned_item_one_time', 'admin_return_item_ajax_handler' );


function update_product_duration_and_unit() {
	global $wpdb;
	$products   = wc_get_products( array( 'type' => 'variable', 'limit' => - 1 ) );
	$change_ids = $_POST['ids'];
    if (isset($change_ids)) {
        $change_ids = explode(',', $change_ids);
        $change_ids = array_map('intval', $change_ids);

        // Now use $ids for further processing
        // $ids is an array of integers
    }
	foreach ( $products as $product ) {

		if ( $change_ids == null || in_array($product->get_id(),$change_ids)) {
            //allowing the attributes to be used in variations
			$product->get_id();
			$variations = $product->get_available_variations();
			$attr_list  = get_post_meta( $product->get_id(), '_product_attributes', true );

			foreach ( $attr_list as $name => $attr ) {
				$attr['is_variation'] = 1;
				$attr_list[ $name ]   = $attr;
			}

			update_post_meta( $product->get_id(), '_product_attributes', $attr_list );

			//adding the price change
			$data = array(
				'days'    => array(
					0 => "5"
				),
				'percent' => array(
					0 => "-20.5882"
				)
			);

			//when element price tier is not set
			if ( get_post_meta( $product->get_id(), '_wcrp_rental_products_pricing_tiers_data', true ) == "" ) {
				// adding the discount when 10 days rental
				$wpdb->query(
					$wpdb->prepare(
						"INSERT INTO `{$wpdb->prefix}postmeta` (post_id, meta_key, meta_value) VALUES (%d, '_wcrp_rental_products_pricing_tiers_data', %s)",
						$product->get_id(),
						serialize( $data ),
					)
				);
			} else if ( get_post_meta( $product->get_id(), '_wcrp_rental_products_pricing_tiers_data', true ) != $data ) { //when element price tier is set but not what we want
				$wpdb->query(
					$wpdb->prepare(
						"UPDATE `{$wpdb->prefix}postmeta` SET meta_value = %s WHERE post_id = %d AND meta_key = '_wcrp_rental_products_pricing_tiers_data'",
						serialize( $data ),
						$product->get_id(),
					)
				);
			}
		}
	}

	echo "done changing products";
}

add_action( 'wp_ajax_nopriv_update_product_duration', 'update_product_duration_and_unit' );
add_action( 'wp_ajax_update_product_duration', 'update_product_duration_and_unit' );

function clear_everything() {
	$products = wc_get_products( array( 'type' => 'booking', 'limit' => - 1 ) );

	// delete all bookings
	foreach ( $products as $product ) {
		$bookings = WC_Booking_Data_Store::get_bookings_for_product( $product->get_id(), array(
			'complete',
			'confirmed',
			'paid',
			'pending confirmation',
			'in_cart',
			'in-cart'
		) );
		foreach ( $bookings as $booking ) {
			$data_store = new WC_Booking_Data_Store();
			$data_store->delete( $booking );
		}
	}

	// reset all boxes AND delete all subscriptions
	$users = get_users();
	foreach ( $users as $user ) {
		$user_id = $user->ID;
		reset_box( $user_id );
		$subscriptions = wcs_get_users_subscriptions( $user_id );
		foreach ( $subscriptions as $subscription ) {
			$subscription->delete( true );
		}
	}

	echo "done";
}

add_action( 'wp_ajax_nopriv_clear_everything', 'clear_everything' );
add_action( 'wp_ajax_clear_everything', 'clear_everything' );

function cart_page_change_duration_reminders( $item_data, $cart_item ) {
	$user_id   = get_current_user_id();
	$boxes     = get_user_meta( $user_id, 'boxes', true );
	$box_index = - 1;
	$index     = 0;

	foreach ( $boxes as $box ) {
		if ( isset( $box->items[ $cart_item['key'] ] ) ) {
			$box_index = $index;
			break;
		}
		$index ++;
	}

	$index         = 0;
	$item_data_DTO = $item_data;

	if ( $box_index != - 1 ) {
		foreach ( $item_data as $item_datum ) {
			if ( $item_datum['key'] == "Rent to" || $item_datum['key'] == "Rental return within" ) {
				unset( $item_data_DTO[ $index ] );
			}
			$index ++;
		}

		$box_index       = $box_index + 1; //during printing, the index is 1 less
		$item_data_DTO[] = array(
			'key'     => 'Reminder',
			'value'   => 'Please return this item with <strong>Box#' . $box_index . '</strong>',
			'display' => "",
		);
	}

	return $item_data_DTO;
}

add_filter( 'woocommerce_get_item_data', 'cart_page_change_duration_reminders', 100, 2 );

function my_account_page_css() {
	?>
    <style>
        @media (max-width: 600px) {
            .woocommerce-MyAccount-navigation {
                width: 100% !important;
            }
        }

        @media (min-width: 1200px) {
            .woocommerce-MyAccount-navigation {
                width: 25% !important;
            }
        }
    </style>
	<?php
}

add_action( 'woocommerce_account_navigation', 'my_account_page_css', 100 );

function cart_icon_css() {
	?>
    <style id="cart_icon_css">
        @media (max-width: 600px) {
            .empty-cart {
                left: -190px !important;
            }

            .filled-cart {
                left: -270px !important;
            }
        }

        @media (min-width: 1200px) {
            .empty-cart {
                left: -190px !important;
            }

            .filled-cart {
                left: -300px !important;
            }
        }
    </style>
	<?php
}

add_action( 'load_cart_icon_css', 'cart_icon_css', 100 );

function thank_you_page_css() {
	?>
    <style>
        @media (max-width: 600px) {
            .woocommerce-thankyou-order-details li {
                width: 100% !important;
            }

            .woocommerce-thankyou-order-details {
                display: block !important;
            }

            .wc-booking-summary-list {
                padding-left: 0px !important;
            }

        }

        @media (min-width: 1200px) {

        }
    </style>
	<?php
}

add_action( 'woocommerce_before_thankyou', 'thank_you_page_css', 100 );

function checkout_return_policy_confirmation() {
	?>
    <div class="return-policy-confirmation">
        <p>Please return the items by the end of the rental period, or you will be charged 80% of the retail price.</p>
        <input type="checkbox" id="return-policy-checkbox" name="return-policy-checkbox"
               value="return-policy-checkbox">
        <label for="return-policy-checkbox">I acknowledge the above statement</label>
    </div>
    <script>
        jQuery(document).ready(function ($) {
            $('#return-policy-checkbox').change(function () {
                if ($(this).is(':checked')) {
                    $('#place_order').prop('disabled', false);
                } else {
                    $('#place_order').prop('disabled', true);
                }
            });
        });
    </script>
	<?php
}

add_action( 'woocommerce_review_order_before_submit', 'checkout_return_policy_confirmation', 100 );

function testing() {
	global $wpdb;
	$product_id = 2203;
	$product    = wc_get_product( $product_id );
	$date       = "2023 - 07 - 28";
	$end_date   = "2023 - 07 - 31";
	$quantity   = 88;
	$table_name = $wpdb->prefix . 'wcrp_rental_products_rentals';


	$wpdb->query(
		$wpdb->prepare(
			"INSERT INTO `{$wpdb->prefix}wcrp_rental_products_rentals` ( reserved_date, order_id, order_item_id, product_id, quantity) VALUES(%s, 0, 0, %d, %d);",
			$date,
			$product_id,
			$quantity,
		)
	);

	$data = array(
		'reserved_date' => $date,
		'order_id'      => 0,
		'order_item_id' => 0,
		'product_id'    => $product_id,
		'quantity'      => $quantity,
	);

// Insert the data into the database using $wpdb->insert()
//	$wpdb->insert($table_name, $data);

	//write the above in wpdb->insert format


	echo 'done';

//	$disabled_dates  = $wpdb->get_results(
//		$wpdb->prepare(
//			"SELECT reserved_date, SUM( quantity ) as quantity FROM `{$wpdb->prefix}wcrp_rental_products_rentals` WHERE `product_id` = %d GROUP BY reserved_date ORDER BY reserved_date ASC;",
//			$product_id
//		)
//	);
//	$quantity_needed = (int) sanitize_text_field( $_POST['qty'] );
//	$rental_stock    = get_post_meta( $product_id, '_wcrp_rental_products_rental_stock', true );
//
//
//	$doop = wcrp_rental_products_rental_form_first_day();
//
//	$_POST['wcrp_rental_products_availability_checker_rent_from'] = $start_date;
//	$_POST['wcrp_rental_products_availability_checker_rent_to']   = $end_date;
//	$_POST['wcrp_rental_products_availability_checker_nonce']     = wp_create_nonce();
//	$data                                                         = wcrp_rental_products_availability_checker_data();
//
//	$data['rent_from'] = sanitize_text_field( $_POST['wcrp_rental_products_availability_checker_rent_from'] );
//
//	$product->get_available_variations();
//	$get_variations = count( $product->get_children() ) <= apply_filters( 'woocommerce_ajax_variation_threshold', 30, $product );
//	$product->get_available_variations();
//	$product->get_variation_attributes();
//	$product->get_default_attributes();
}

add_action( 'wp_ajax_nopriv_test', 'testing' );
add_action( 'wp_ajax_test', 'testing' );

//add_action('woocommerce_before_variations_form', 'single_product_remove_calender');

add_action( 'woocommerce_single_product_summary', 'single_product_rent_with_membership_button_script' );
function single_product_rent_with_membership_button_script() {
	?>
    <script>
        jQuery(document).ready(function ($) {
            $('#rent-with-membership-single-product').on('click', function (event) {
                const variation_id = $('input[name="variation_id"]')[0].value;
                if (!variation_id || variation_id == 0) {
                    alert("Please select option first . ")
                    return false;
                }
				<?php
				global $product;
				$rental_form_id = $_POST['rental_form_id'];
				$in_person_pick_up_return_allowed = get_post_meta( $product->get_id(), '_wcrp_rental_products_in_person_pick_up_return', true );
				$currentDate = date( "Y - m - d" );
				//need to be 5 days since then the product won't pass the validation
				$futureDate = date( "Y - m - d", strtotime( " + 4 day", strtotime( $currentDate ) ) );

				$user_id = get_current_user_id();
				$box1_remaining = 0;
				$box2_remaining = 0;
				if ( $user_id != 0) {
					$boxes          = get_user_meta( $user_id, 'boxes', true );
					if ($boxes != false) {
						$box1_remaining = reset( $boxes )->items_remaining() != null ? reset( $boxes )->items_remaining() : 0;
						$box2_remaining = end( $boxes )->items_remaining() != null ? end( $boxes )->items_remaining() : 0;
					}
				}
				?>
                const quantity = $('.qty').val();

                if (<?php echo $user_id?> !=
                0 && quantity > <?php echo $box1_remaining ?> && quantity > <?php echo $box2_remaining ?>)
                {
                    alert('You do not have enough box space to rent this many at once product');
                    return;
                }

                const isBoxed = true;
                $('#isBoxed_form_input').val(isBoxed);
                //change start and end date
                $('#wcrp-rental-products-rent-from-<?php echo esc_html( $rental_form_id ) ?>').val('<?php echo $currentDate; ?>');
                $('#wcrp-rental-products-rent-to-<?php echo esc_html( $rental_form_id ) ?>').val('<?php echo $futureDate; ?>');

                //remaking the verification string
                var cartItemValidationString = $('#wcrp-rental-products-cart-item-timestamp-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-cart-item-price-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-rent-from-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-rent-to-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-start-days-threshold-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-return-days-threshold-<?php echo esc_html( $rental_form_id ) ?>').val();
				<?php
				if ( $in_person_pick_up_return_allowed != "no") { //copy paste from the original template
				?>
                cartItemValidationString += $('#wcrp-rental-products-in-person-pick-up-return-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-in-person-pick-up-date-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-in-person-pick-up-time-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-in-person-pick-up-fee-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-in-person-return-date-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-in-person-return-date-type-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-in-person-return-time-<?php echo esc_html( $rental_form_id ) ?>').val();
                cartItemValidationString += $('#wcrp-rental-products-in-person-return-fee-<?php echo esc_html( $rental_form_id ) ?>').val();
				<?php
				}
				?>
                const validation = btoa(cartItemValidationString);

                // save new verification string
                $('#wcrp-rental-products-cart-item-validation-<?php echo $rental_form_id ?>').val(validation);

                //send the ajax
                $('#add_to_cart_form_button').trigger('click');
            });
            $('#retail-purchase-single-product').on('click', function (event) {
                const variation_id = $('input[name="variation_id"]')[0].value;
                if (!variation_id || variation_id == 0) {
                    alert("Please select option first . ")
                    return;
                }
                console.log('click')
                $('input[name="wcrp_rental_products_rental_dates"]')[0].remove();
                $('input[name="wcrp_rental_products_cart_item_validation"]')[0].remove();
                $('input[name="wcrp_rental_products_cart_item_timestamp"]')[0].remove();
                $('input[name="wcrp_rental_products_cart_item_price"]')[0].remove();
                $('input[name="wcrp_rental_products_rent_from"]')[0].remove();
                $('input[name="wcrp_rental_products_rent_to"]')[0].remove();
                $('input[name="wcrp_rental_products_start_days_threshold"]')[0].remove();
                $('input[name="wcrp_rental_products_return_days_threshold"]')[0].remove();
                $('input[name="wcrp_rental_products_rental_form_nonce"]')[0].remove();
                const referer = $('input[name="_wp_http_referer"]')[0];
                referer.value = referer.value.replace('rent=1', '');
                const submit_button = $('#add_to_cart_form_button');
                submit_button.prop('disabled', false);
                submit_button.trigger('click');
            });
        });
    </script>
	<?php
}

add_action( 'woocommerce_update_cart_action_cart_updated', 'update_cart_update_boxes', 10, 1 );
function update_cart_update_boxes( $cart_updated ) {
	$user_id = get_current_user_id();
	$boxes   = get_user_meta( $user_id, 'boxes', true );

	check_metadata_matches_cart( $user_id, $boxes );

	// cart needs to be updated to change box metadata
	if ( $cart_updated ) {
		$new_cart = $_POST['cart'];

		foreach ( $new_cart as $new_cart_item_key => $new_cart_item_value ) {
			foreach ( $boxes as $box ) {
				//find the box that contains the item
				if ( isset( $box->items[ $new_cart_item_key ] ) ) {
					//if quantity was changed then update the box
					if ( isset( $new_cart_item_value['qty'] ) ) {
						$box->items[ $new_cart_item_key ]['quantity'] = $new_cart_item_value['qty'];
					}
				}
			}
			update_user_meta( $user_id, 'boxes', $boxes );
		}
	}
}

add_filter( 'woocommerce_order_item_get_formatted_meta_data', 'thank_you_page_item_information_change', 10, 2 );

function thank_you_page_item_information_change( $formatted_meta, $order_item ) {
	$user_id = get_current_user_id();
	$boxes   = get_user_meta( $user_id, 'boxes', true );
	$index   = 1;

	foreach ( $boxes as $box ) {
		if ( $box->order_id == $order_item->get_order_id() && isset( $box->items[ $order_item->get_id() ] ) ) {
			foreach ( $formatted_meta as $key => $meta ) {
				if ( $meta->display_key == 'Rent to' ) {
					unset( $formatted_meta[ $key ] );
				} else if ( $meta->display_key == 'Rental return within' ) {
					$meta->key           = 'is_boxed_item';
					$meta->value         = 'true';
					$meta->display_key   = 'Reminder';
					$meta->display_value = '<p>Please return this item with <strong>Box#' . $index . '</strong></p>';
				}
			}
			break;
		}
		$index ++;
	}

	return $formatted_meta;
}

add_filter( 'woocommerce_cart_item_permalink', 'change_link_to_rental', 10, 3 );
function change_link_to_rental( $permalink, $cart_item, $cart_item_key ) {
	if ( WC_Subscriptions_Product::is_subscription( $cart_item['product_id'] ) ) {
		return $permalink;
	}

	if ( strpos( $permalink, '?' ) !== false ) {
		// If the link has a query string, use '&' to append the new parameter
		return $permalink . '&' . 'rent=1';
	} else {
		// If the link doesn't have a query string, use '?' to start the query parameters
		return $permalink . '?' . 'rent=1';
	}
}

add_filter( 'woocommerce_cart_item_subtotal', 'change_cart_product_subtotal', 10, 3 );

function change_cart_product_subtotal( $product_subtotal, $cart_item, $cart_item_key ) {
	$user_id = get_current_user_id();
	$isBoxed = false;

	if ( $user_id != 0 ) {
		$boxes = get_user_meta( $user_id, 'boxes', true );
		foreach ( $boxes as $box ) {
			if ( isset( $box->items[ $cart_item_key ] ) ) {
				$isBoxed = true;
				break;
			}
		}
	}

	return $isBoxed ? '<span class="woocommerce - Price - amount amount"><bdi><span class="woocommerce - Price - currencySymbol">&#36;</span>0.00</bdi></span>' : $product_subtotal;
}

add_action( 'woocommerce_before_variations_form', 'single_product_page_css' );

/**
 * @return void
 * make the product pricing pop-up correct color
 */
function single_product_page_css() {
	?>
    <style>
        .wcrp-rental-products-rental-totals .woocommerce .woocommerce-info::before, .woocommerce-page .woocommerce-info::before {
            color: #000000;
        }

        .wcrp-rental-products-rental-totals.wcrp-rental-products-notice.woocommerce-info {
            border-top: 3px solid #000000 !important;
        }
    </style>
	<?php
}

add_filter('woocommerce_quantity_input_classes', 'add_class_quantity_selector', 10, 1);

function add_class_quantity_selector($classes) {
	$classes[] = 'quantity-selector';
	return $classes;
}

add_filter('the_permalink', 'change_search_permalink', 10, 2);

function change_search_permalink($permalink, $post) {
	//is a search result
	if ($_GET['s'] != null && $post == 0) {
		if ( strpos( $permalink, '?' ) !== false ) {
			// If the link has a query string, use '&' to append the new parameter
			return $permalink . '&' . 'rent=1';
		} else {
			// If the link doesn't have a query string, use '?' to start the query parameters
			return $permalink . '?' . 'rent=1';
		}
	}
	return $permalink;
}

add_action('custom_css_product_loop', 'custom_css_product_loop');

function custom_css_product_loop() {
	?>
    <style>
        @media (max-width: 600px) {
            #loop_title {
                line-height: 1.0 !important;
                padding: 0px !important;
            }
        }
    </style>
	<?php
}

add_action('wp_head', 'buy_now_back_to_refresh');

function buy_now_back_to_refresh(){
	?>
    <script>
        window.addEventListener( "pageshow", function ( event ) {
            var perfEntries = performance.getEntriesByType("navigation");
            var currentURL = window.location.href;
            var historyTraversal = event.persisted ||
                ( typeof window.performance != "undefined" &&
                    perfEntries[0]['type'] === "back_forward");
            if ( historyTraversal && currentURL.includes("rent=1")) {
                // Handle page restore.
                window.location.reload();
            }
        });
    </script>
	<?php
}

add_action('user_register', 'allow_only_customer_registration', 10, 1);

function allow_only_customer_registration($user_id) {
    $user = new WP_User($user_id);
    
    // Check if 'customer' is the only role assigned to the new user.
    if (count($user->roles) !== 1 || !in_array('customer', $user->roles)) {
        $current_user = wp_get_current_user();
        if (!in_array('administrator', $current_user->roles)) {
            wp_delete_user($user_id);
            wp_die('You are not allowed to create users.');
        }
    }
}

add_action( 'wp_enqueue_scripts', 'custom_enqueue_wc_cart_fragments' );
function custom_enqueue_wc_cart_fragments() {
    wp_enqueue_script( 'wc-cart-fragments' );
}