<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'WCRP_Rental_Products_Product_WC_Product' ) ) {

	class WCRP_Rental_Products_Product_WC_Product {

		public function __construct() {

			add_filter( 'woocommerce_product_is_in_stock', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );
			add_filter( 'woocommerce_product_variation_is_in_stock', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );

			add_filter( 'woocommerce_product_get_stock_quantity', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );
			add_filter( 'woocommerce_product_variation_get_stock_quantity', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );

			add_filter( 'woocommerce_product_get_manage_stock', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );
			add_filter( 'woocommerce_product_variation_get_manage_stock', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );

			add_filter( 'woocommerce_product_get_tax_status', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );
			add_filter( 'woocommerce_product_variation_get_tax_status', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );

			add_filter( 'woocommerce_product_get_tax_class', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );
			add_filter( 'woocommerce_product_variation_get_tax_class', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );

			add_filter( 'woocommerce_product_get_shipping_class_id', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );
			add_filter( 'woocommerce_product_variation_get_shipping_class_id', array( $this, 'return_changes' ), PHP_INT_MAX, 2 );

		}

		public function return_changes( $value, $product ) {

			// If a rental product and meets specific conditions for rentals change WC_Product based return values conditionally, this is mostly used to ensure the correct stock changes occur for both purchasable and rental stocks depending on the rental type and stock management options used

			if ( !empty( $product ) ) {

				$product_id = $product->get_id();
				$product_type = $product->get_type();

				$rental_stock = get_post_meta( $product_id, '_wcrp_rental_products_rental_stock', true );

				if ( 'variation' == $product_type ) {

					$parent_product_id = $product->get_parent_id();

				} else {

					$parent_product_id = false;

				}				

				if ( wcrp_rental_products_is_rental_only( ( 'variation' !== $product_type ? $product_id : $parent_product_id ) ) ) {

					// Stock based returns

					if ( '' == $rental_stock ) {

						$is_in_stock = true;
						$stock_quantity = PHP_INT_MAX;

					} else {

						if ( (int) $rental_stock > 0 ) {

							$is_in_stock = true;
							$stock_quantity = PHP_INT_MAX;

						} else {

							$is_in_stock = false;
							$stock_quantity = 0;

						}

					}

					$manage_stock = false;

				} elseif ( wcrp_rental_products_is_rental_purchase( ( 'variation' !== $product_type ? $product_id : $parent_product_id ) ) ) {

					if ( isset( $_GET['rent'] ) || ( isset( $_POST['wcrp_rental_products_rental_form_nonce'] ) && wp_verify_nonce( sanitize_key( $_POST['wcrp_rental_products_rental_form_nonce'] ), 'wcrp_rental_products_rental_form' ) ) ) { // Nonce condition used to ensure the product is deemed in stock when adding to cart (as that is passed to the cart and therefore on reload of product page/redirect to cart that condition will trigger)

						if ( '1' == ( isset( $_GET['rent'] ) ? sanitize_text_field( $_GET['rent'] ) : '' ) || isset( $_POST['wcrp_rental_products_rent_from'] ) ) { // Ternary used as $_GET['rent'] may not be set depending on OR conditions above and would cause a PHP notice

							// Stock based returns

							if ( '' == $rental_stock ) {

								$is_in_stock = true;
								$stock_quantity = PHP_INT_MAX;

							} else {

								if ( (int) $rental_stock > 0 ) {

									$is_in_stock = true;
									$stock_quantity = PHP_INT_MAX;

								} else {

									$is_in_stock = false;
									$stock_quantity = 0;

								}
								
							}

							$manage_stock = false;

							// Rental or purchase rental override returns

							$rental_purchase_rental_tax_override = get_post_meta( ( 'variation' !== $product_type ? $product_id : $parent_product_id ), '_wcrp_rental_products_rental_purchase_rental_tax_override', true );
							$rental_purchase_rental_shipping_override = get_post_meta( ( 'variation' !== $product_type ? $product_id : $parent_product_id ), '_wcrp_rental_products_rental_purchase_rental_shipping_override', true );

							if ( 'yes' == $rental_purchase_rental_tax_override ) {

								$tax_status = get_post_meta( ( 'variation' !== $product_type ? $product_id : $parent_product_id ), '_wcrp_rental_products_rental_purchase_rental_tax_override_status', true );
								$tax_class = get_post_meta( ( 'variation' !== $product_type ? $product_id : $parent_product_id ), '_wcrp_rental_products_rental_purchase_rental_tax_override_class', true );

							}

							if ( 'yes' == $rental_purchase_rental_shipping_override ) {

								$shipping_class_id = get_post_meta( ( 'variation' !== $product_type ? $product_id : $parent_product_id ), '_wcrp_rental_products_rental_purchase_rental_shipping_override_class', true ); // Also means get_shipping_class will return correctly too as that calls get_shipping_class_id

							}

						}

					}

					if ( is_cart() || is_checkout() ) { // This still works for the new WooCommerce cart and checkout blocks even if they are not set as the cart/checkout pages in WooCommerce settings

						// Ensures that on cart/checkout if any of the WC_Product returns are requested (e.g. by WooCommerce core code looking up the product object) these amended returns are sent, without these you may get a "Sorry, xxx is not in stock. Please edit your basket and try again. We apologise for any inconvenience caused." notice. e.g. this could happen if attempting to order the rental of a rental or purchase product and the purchasable stock level is 0, it wouldn't allow the product to be purchased as it would deem the stock to be 0

						global $woocommerce;
						$items = $woocommerce->cart->get_cart();

						if ( !empty( $items ) ) {

							foreach ( $items as $item ) {

								if ( $product_id == $item['product_id'] || $product_id == $item['variation_id'] ) { // If the product return values being requested by cart/checkout core functions match this product in the cart

									if ( isset( $item['wcrp_rental_products_rent_from'] ) ) { // If it's a rental - it does not matter about multiple line items with this product id being in here because there can only be a rental or not rental and not both (see WCRP_Rental_Products_Cart_Checks::add_to_cart_validation), if this meta exists we know it is a rental and return the values below. If it's a rental or purchase product we know all products in the cart with this product id are rentals due to the add to cart validation and they all get the same values returned below

										// Stock based returns

										if ( '' == $rental_stock ) {

											$is_in_stock = true;
											$stock_quantity = PHP_INT_MAX;

										} else {

											if ( (int) $rental_stock > 0 ) {

												$is_in_stock = true;
												$stock_quantity = PHP_INT_MAX;

											} else {

												$is_in_stock = false;
												$stock_quantity = 0;

											}
											
										}

										$manage_stock = false;

										// Rental or purchase rental override returns do not need to occur here as the rental or purchase override values in the conditions before this "is_cart() || is_checkout()" code block result in the cart item having the correct override data as they are got at the time of adding to cart and the overrides are then set on the product object in the cart item object used by the cart/checkout (the stock based returns above are different and get checked for availability during cart/checkout)

									}

								}

							}

						}

					}

				}

			}

			if ( ( 'woocommerce_product_is_in_stock' == current_filter() || 'woocommerce_product_variation_is_in_stock' == current_filter() ) && isset( $is_in_stock ) ) {

				return $is_in_stock;

			} elseif ( ( 'woocommerce_product_get_stock_quantity' == current_filter() || 'woocommerce_product_variation_get_stock_quantity' == current_filter() ) && isset( $stock_quantity ) ) {

				return $stock_quantity;

			} elseif ( ( 'woocommerce_product_get_manage_stock' == current_filter() || 'woocommerce_product_variation_get_manage_stock' == current_filter() ) && isset( $manage_stock ) ) {

				return $manage_stock;

			} elseif ( ( 'woocommerce_product_get_tax_status' == current_filter() || 'woocommerce_product_variation_get_tax_status' == current_filter() ) && isset( $tax_status ) ) {

				return $tax_status;

			} elseif ( ( 'woocommerce_product_get_tax_class' == current_filter() || 'woocommerce_product_variation_get_tax_class' == current_filter() ) && isset( $tax_class ) ) {

				return $tax_class;

			} elseif ( ( 'woocommerce_product_get_shipping_class_id' == current_filter() || 'woocommerce_product_variation_get_shipping_class_id' == current_filter() ) && isset( $shipping_class_id ) ) {

				return $shipping_class_id;

			} else {

				return $value;

			}

		}

	}

}
