<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'WCRP_Rental_Products_Product_Search' ) ) {

	class WCRP_Rental_Products_Product_Search {

		public function __construct() {

			add_filter( 'woocommerce_json_search_found_products', array( $this, 'json_product_search_restrictions' ) );

		}

		public function json_product_search_restrictions( $products ) {

			// This function restricts the product search results used by WooCommerce when adding or editing an order in the dashboard and it removes rental only products from the results. In the context of the add/edit order screen this is used by the core "Add product(s)" functionality, the rental only products are removed from the results as if they were included it would add rental products without the neccessary order item meta, availability would have not been checked, and the pricing wouldn't be correct. For rental only products or the rental part of rental or purchase products then the "Add rental product(s)" functionality is used instead to add the product to an order. Rental or purchase based products are not excluded from these searches as these can be added to an order - as a means of adding the purchase part of the product (this is referenced in the alert which appears when adding a rental product)

			if ( is_admin() ) {

				$referer = wp_get_referer();

				if ( !empty( $referer ) ) {

					$maybe_remove_rentals = false;

					if ( WCRP_Rental_Products_Misc::string_contains( $referer, 'post=' ) ) { // If an existing post

						$post_id = explode( 'post=', $referer );
						$post_id = explode( '&', $post_id[1] );
						$post_id = $post_id[0];

						if ( 'shop_order' == get_post_type( $post_id ) ) { // If editing an order

							$maybe_remove_rentals = true;

						}

					} elseif ( WCRP_Rental_Products_Misc::string_contains( $referer, 'post-new.php' ) ) { // If a new post

						if ( WCRP_Rental_Products_Misc::string_contains( $referer, 'post_type=shop_order' ) ) { // If a new shop order

							$maybe_remove_rentals = true;

						}

					}

					if ( true == $maybe_remove_rentals ) {

						if ( !empty( $products ) ) {

							foreach ( $products as $product_id => $product ) {

								if ( wcrp_rental_products_is_rental_only( $product_id ) ) {

									unset( $products[$product_id] );

								}

							}

						}

					}

				}

			}

			return $products;

		}

	}

}
