<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'WCRP_Rental_Products_Enqueues_Assets' ) ) {

	class WCRP_Rental_Products_Enqueues_Assets {

		public static function css_admin() {

			wp_enqueue_style(
				'wcrp-rental-products-admin',
				plugins_url( 'assets/css/admin.min.css', __DIR__ ),
				array(),
				WCRP_RENTAL_PRODUCTS_VERSION,
				'all'
			);

		}

		public static function css_public() {

			wp_enqueue_style(
				'wcrp-rental-products-public',
				plugins_url( 'assets/css/public.min.css', __DIR__ ),
				array(),
				WCRP_RENTAL_PRODUCTS_VERSION,
				'all'
			);

		}

		public static function js_admin() {

			wp_enqueue_script(
				'wcrp-rental-products-admin',
				plugins_url( 'assets/js/admin.min.js', __DIR__ ),
				array(
					'jquery',
					'wp-i18n',
				),
				WCRP_RENTAL_PRODUCTS_VERSION,
				true
			);

		}

		// Libraries

		public static function datatables() {

			wp_enqueue_script(
				'wcrp-rental-products-datatables',
				plugins_url( 'libraries/DataTables/datatables.min.js', __DIR__ ),
				array( 'jquery' ),
				WCRP_RENTAL_PRODUCTS_VERSION,
				true
			);

			add_action( 'admin_footer', function() {

				?>

				<script>
					jQuery( document ).ready( function( $ ) {

						$( '.wcrp-rental-products-datatable' ).DataTable({
							'dom': '<"top"fiplB>rt<"bottom"fiplB>',
							'pageLength': 25,
							'order': [ 0, 'asc' ],
							'drawCallback': function() {
								$( '.dataTables_paginate a' ).addClass( 'button' );
								$( '.dataTables_paginate a.current' ).addClass( 'button-primary' );
							},
							'buttons': [
								{
									'extend': 'print',
									'text': "<?php esc_html_e( 'Print', 'wcrp-rental-products' ); ?>",
									'className': 'button',
									'exportOptions': {
										'columns': ':visible'
									}
								},
								{
									'extend': 'csvHtml5',
									'text': "<?php esc_html_e( 'Export', 'wcrp-rental-products' ); ?>",
									'className': 'button',
									'exportOptions': {
										'columns': ':visible'
									}
								}
							],
							<?php if ( isset( $_GET['tab'] ) && 'inventory' == $_GET['tab'] ) { // DataTables is only enqueued currently on the rentals dashboard, so we just check for the tab within that and add the column definitions if it is the inventory tab, in future if DataTables is enqueued elsewhere to the rentals dashboard this condition and the earlier condition in WCRP_Rental_Products_Enqueues_Admin may need amending to be more targeted ?>
								'columnDefs': [
									// Remember hidden columns when setting targets
									{
										'targets': [ 0 ],
										'render': function ( data, type, row, meta ) {

											if ( type === 'display' ) {

												if ( row[ 2 ] == '0' ) {

													var postId = row[ 1 ];

												} else {

													var postId = row[ 2 ];

												}

												data = '<a href="post.php?post=' + encodeURIComponent( postId ) + '&action=edit" target="_blank">' + data + '</a>';

											}

											return data;

										},
									},
									{
										'targets': [ 2 ], // Parent id (hidden)
										'visible': false,
										'searchable': false,
									},
									{
										'targets': [ 4, 5 ], // Ensures sorting of rental stock total and rental stock in columns work correctly due to unlimited text use with the numbers, rental stock out does not matter because it is always a number and therefore is not targeted here
										'render': function ( data, type, row ) {

											if ( type === 'type' || type === 'sort' ) {

												if ( data === "<?php esc_html_e( 'Unlimited', 'wcrp-rental-products' ); ?>" ) {

													return <?php echo esc_html( PHP_INT_MAX ); ?>; // Highest number

												}

												return data; // Numeric value

											}

											return data; // All other types

										}
									},
								],
							<?php } ?>
							'language': {
								'decimal': 			'',
								'emptyTable':		"<?php esc_html_e( 'No data available', 'wcrp-rental-products' ); ?>",
								<?php // translators: %1$s: start, %2$s: end, %3$s: total ?>
								'info':				"<?php echo sprintf( esc_html__( 'Showing %1$s to %2$s of %3$s', 'wcrp-rental-products' ), '_START_', '_END_', '_TOTAL_' ); ?>",
								'infoEmpty':		"<?php esc_html_e( 'Showing 0 to 0 of 0', 'wcrp-rental-products' ); ?>",
								<?php // translators: %s: total ?>
								'infoFiltered':		"<?php echo sprintf( esc_html__( '(filtered from %s)', 'wcrp-rental-products' ), '_MAX_' ); ?>",
								'infoPostFix':		'',
								'thousands':		'',
								<?php // translators: %s: select field ?>
								'lengthMenu':		"<?php echo sprintf( esc_html__( 'Show %s', 'wcrp-rental-products' ), '_MENU_' ); ?>",
								'loadingRecords':	"<?php esc_html_e( 'Loading...', 'wcrp-rental-products' ); ?>",
								'processing':		"<?php esc_html_e( 'Processing...', 'wcrp-rental-products' ); ?>",
								'search':			"<?php esc_html_e( 'Search', 'wcrp-rental-products' ); ?>",
								'zeroRecords':		"<?php esc_html_e( 'No matching rental products found.', 'wcrp-rental-products' ); ?>",
								'paginate': {
									'first':	"<?php esc_html_e( 'First', 'wcrp-rental-products' ); ?>",
									'last':		"<?php esc_html_e( 'Last', 'wcrp-rental-products' ); ?>",
									'next':		"<?php esc_html_e( 'Next', 'wcrp-rental-products' ); ?>",
									'previous': "<?php esc_html_e( 'Previous', 'wcrp-rental-products' ); ?>"
								},
								'aria': {
									'sortAscending':	"<?php esc_html_e( ':', 'wcrp-rental-products' ); ?> <?php esc_html_e( 'activate to sort column ascending', 'wcrp-rental-products' ); ?>",
									'sortDescending':	"<?php esc_html_e( ':', 'wcrp-rental-products' ); ?> <?php esc_html_e( 'activate to sort column descending', 'wcrp-rental-products' ); ?>"
								}
							},
						});

					});
				</script>

				<?php

			} );

		}

		public static function datepicker() {

			wp_enqueue_style(
				'jquery-ui-style',
				WC()->plugin_url() . '/assets/css/jquery-ui/jquery-ui.min.css', // Styles for datepicker are not included with only wp_enqueue_script( 'jquery-ui-datepicker' ), so we enqueue them here from WooCommerce's jQuery UI library, we don't want to include jQuery UI as an asset purely for this purpose when WooCommerce already has it, WooCommerce does already enqueue this on WooCommerce admin pages and is used, however we need to enqueue using this method as we have non-WooCommerce pages such as the rentals dashboard that do not enqueue it and the datepicker is used in the rentals dashboard so needs it 
				array(),
				WC_VERSION,
				'all'
			);

			wp_enqueue_script( 'jquery-ui-datepicker' );

		}

		public static function fullcalendar() {

			wp_enqueue_script(
				'wcrp-rental-products-fullcalendar',
				plugins_url( 'libraries/fullcalendar/lib/main.min.js', __DIR__ ),
				array(),
				WCRP_RENTAL_PRODUCTS_VERSION,
				true
			);

			wp_enqueue_script(
				'wcrp-rental-products-fullcalendar-locales',
				plugins_url( 'libraries/fullcalendar/lib/locales-all.min.js', __DIR__ ),
				array(),
				WCRP_RENTAL_PRODUCTS_VERSION,
				true
			);

			wp_enqueue_style(
				'wcrp-rental-products-fullcalendar',
				plugins_url( 'libraries/fullcalendar/lib/main.min.css', __DIR__ ),
				array(),
				WCRP_RENTAL_PRODUCTS_VERSION,
				'all'
			);

		}

		public static function litepicker() {

			wp_enqueue_script(
				'wcrp-rental-products-litepicker',
				plugins_url( 'libraries/litepicker/litepicker.js', __DIR__ ),
				array(),
				WCRP_RENTAL_PRODUCTS_VERSION,
				true
			);

			wp_enqueue_script(
				'wcrp-rental-products-litepicker-mobile-friendly',
				plugins_url( 'libraries/litepicker/plugins/mobilefriendly.js', __DIR__ ),
				array(),
				WCRP_RENTAL_PRODUCTS_VERSION,
				true
			);

		}

		public static function select2() {

			wp_enqueue_script(
				'wcrp-rental-products-select2',
				plugins_url( 'libraries/select2/dist/js/select2.min.js', __DIR__ ),
				array( 'jquery' ),
				WCRP_RENTAL_PRODUCTS_VERSION,
				true
			);

			wp_enqueue_style(
				'wcrp-rental-products-select2',
				plugins_url( 'libraries/select2/dist/css/select2.min.css', __DIR__ ),
				array(),
				WCRP_RENTAL_PRODUCTS_VERSION,
				'all'
			);

			add_action( 'admin_footer', function() {

				?>

				<script>
					jQuery( document ).ready( function( $ ) {

						$( '.wcrp-rental-products-select2' ).select2();

					});
				</script>

				<?php

			} );

		}

		public static function thickbox() {

			add_thickbox();

		}

	}

}
