<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'WCRP_Rental_Products_Checkout_Stock' ) ) {

	class WCRP_Rental_Products_Checkout_Stock {

		public function __construct() {

			add_filter( 'option_woocommerce_hold_stock_minutes', array( $this, 'restrict_stock_reservation' ) );

		}

		public function restrict_stock_reservation( $value ) {

			// In some scenarios the core WooCommerce stock reservation can cause an error during checkout of "Not enough units of xxx are available in stock to fulfil this order.", this has been observed to occur when, for example, a variable product is set to rental or purchase with stock management enabled and zero purchasable stock applied at parent level then stock management enabled at variation level with rental stock available it won't let you checkout the rental. This appears to be because (but might not be limited to) WooCommerce's reserve_stock_for_order() function gets the product object for values like $product->get_managing_stock that in turn calls $product->get_manage_stock() and returns as parent which then attempts to get the value from the parent, but in doing this it doesn't seem to take into account Rental Product's WC_Product return changes, there doesn't seem to be any specific issue causing this to not take those into account, therefore if rental products are included in cart we filter the woocommerce_hold_stock_minutes option to return 0 to bypass any reservation to ensure rental products can successfully go through checkout

			// Not that this has no effect on option updates, e.g. if user updates this option via dashboard, this functionality is not going to filter it and get saved with this value upon saving of settings, it's just filtering the option after database lookup

			$cart = WC()->cart;

			if ( !empty( $cart ) ) {

				if ( isset( $cart->cart_contents ) ) {

					if ( !empty( $cart->cart_contents ) ) {

						foreach ( $cart->cart_contents as $cart_content_key => $cart_content_value ) {

							if ( isset( $cart_content_value['wcrp_rental_products_rent_from'] ) ) {

								$value = 0;

								break;

							}

						}

					}

				}

			}

			return $value;

		}

	}

}
