<?php
$add_ons = [
    [
        'title'       => esc_html__('RnB Seasonal Pricing (Add-ons)', 'redq-rental'),
        'url'         => 'https://1.envato.market/RXrPX',
        'image_url'   => 'https://s3.amazonaws.com/redqteam.com/TF/seasonal-pricing-addons-banner.png',
        'subtitle'    => __('Extension of <strong>WooCommerce Rental & Booking Plugin</strong>', 'redq-rental'),
        'description' => __('The Seasonal pricing add-on allows you to charge promotional/seasonal pricing for specific date range of any rental product. This enables admin to configure pricing very easily based on different criteria. This is a simple and easy to use add-on perfect for your business if your price changes for peak and off-peak season.', 'redq-rental'),
        'demo_url'    => 'https://redqteam.com/rnb/shop/seasonal-pricing/'
    ],
    [
        'title'       => esc_html__('RnB Backend Booking (Add-ons)', 'redq-rental'),
        'url'         => 'https://1.envato.market/ORnzaK',
        'image_url'   => 'https://s3.amazonaws.com/redqteam.com/TF/rnb-backend-booking.png',
        'subtitle'    => __('Extension of <strong>WooCommerce Rental & Booking Plugin</strong>', 'redq-rental'),
        'description' => __('R&B Backend Booking is an extension of WooCommerce and WooCommerce Rental & Booking plugin. It allows admin to create a rental order from WordPress admin. It provides all the features that is available in RnB front-end booking plugin. This plugin will help admin to create both online and offline booking business.', 'redq-rental'),
        'demo_url'    => 'https://preview.redq.io/rnb/rnb-backend-booking/'

    ],
    [
        'title'       => esc_html__('Cartsy - WooCommerce WordPress Theme', 'redq-rental'),
        'url'         => 'https://redq.io/cartsy',
        'image_url'   => 'https://s3.amazonaws.com/redqteam.com/TF/cartsy-addons-banner.png',
        'subtitle'    => __('WordPress Theme build on the top of <strong>WooCommerce</strong>', 'redq-rental'),
        'description' => __('Create your online shop with our fully functional WordPress E-commerce. Cartsy is a highly intuitive WooCommerce theme that will handle all your online business needs. Start selling anything and everything today.', 'redq-rental'),
        'demo_url'    => 'https://redq.io/cartsy'
    ],
    [
        'title'       => esc_html__('Turbo - WooCommerce Rental & Booking Theme', 'redq-rental'),
        'url'         => 'https://1.envato.market/NKzXeP',
        'image_url'   => 'https://s3.amazonaws.com/redqteam.com/TF/cartsy-addons-banner.png',
        'subtitle'    => __('WordPress Theme Build on the top of <strong>WooCommerce Rental & Booking Plugin', 'redq-rental'),
        'description' => __('Turbo is an user-friendly car booking WordPress theme alternatively, car rental WordPress theme crafted with , WooCommerce booking plugin, visual composer, and multilingual.This theme allows you to book or rent your date-based or time-based car booking. It creates a new product type to your WooCommerce site. Perfect for those wanting to offer rental or booking.', 'redq-rental'),
        'demo_url'    => 'https://redq.io/turbowp'
    ]
]
?>

<div class="wrap woocommerce wc_addons_wrap rnb_addons_wrap">
    <div class="addons-banner-block">
        <h1><?php echo esc_html__('Extend Your Booking Features With RnB Add-ons', 'redq-rental'); ?></h1>
        <p></p>

        <div class="addons-banner-block-items">
            <?php foreach ($add_ons as $key => $add_on) : ?>
                <div class="storefront rnb-addon rnb-addon-<?php echo esc_attr($key + 1); ?>">
                    <a href="<?php echo esc_url($add_on['url']); ?>" target="_blank">
                        <img src="<?php echo esc_url($add_on['image_url']); ?>" alt="RnB Seasonal Pricing">
                    </a>
                    <h2><?php echo wp_kses($add_on['title'], wp_kses_allowed_html()); ?></h2>
                    <p><?php echo wp_kses($add_on['subtitle'], wp_kses_allowed_html()); ?></p>
                    <p><?php echo wp_kses($add_on['description'], wp_kses_allowed_html()); ?></p>
                    <p>
                        <a href="<?php echo esc_url($add_on['demo_url']); ?>" target="_blank" class="button"><?php echo esc_html__('Live Preview', 'redq-rental'); ?></a>
                        <a href="<?php echo esc_url($add_on['url']); ?>" target="_blank" class="button button-primary"><?php echo esc_html__('Buy Now', 'redq-rental'); ?></a>
                    </p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>